/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.configtransformer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.io.StringReader;
import java.io.Writer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.provider.ConfigurationData;
import se.ericsson.wcdma.rbs.bem.application.applications.exportdelete.provider.ExportConfigDataProvider;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.configtransformer.ConfigTransformException;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.configtransformer.OutputWriter;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.configtransformer.SimpleFormatterException;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.control.MigrateRbsController;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.util.MigrateRbsUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRbsLocalCell;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlTransformer {
    private static final String XSLT_PATH = "/se/ericsson/wcdma/rbs/bem/application/applications/migraterbs/configtransformer/xsl/";
    private static final String UTF8_ENCODING = "UTF-8";
    private static final String GIGABIT_ETHERNET_PORT_XSL = "gePort.xsl";
    private static final String IP_SYNCH_REF_SYNCH_PORT_XSL = "ipSynchRefSynchPort.xsl";
    private static final String STEERED_HS_ALLOCATION_XSL = "steeredHsAllocation.xsl";
    private List<ConfigurationData> configData;
    private TransformerFactory transformerFactory;
    private DocumentBuilder documentBuilder;
    private OutputWriter formatter;
    private WrappingExceptionHandler errHandler = new WrappingExceptionHandler();
    private String fileParsed = null;
    MigrateRbsUtil migrateRbsUtil = null;

    public XmlTransformer(boolean bl, MigrateRbsUtil migrateRbsUtil) throws ConfigTransformException {
        this.migrateRbsUtil = migrateRbsUtil;
        try {
            this.transformerFactory = TransformerFactory.newInstance();
            this.formatter = OutputWriter.newInstance(bl);
            this.documentBuilder = this.initDocumentBuilder();
            this.documentBuilder.setErrorHandler(this.errHandler);
            this.transformerFactory.setErrorListener(this.errHandler);
        }
        catch (ParserConfigurationException parserConfigurationException) {
            this.errHandler.handle(parserConfigurationException);
        }
    }

    private DocumentBuilder initDocumentBuilder() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        documentBuilderFactory.setValidating(true);
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        documentBuilder.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
                return new InputSource(new StringReader(""));
            }
        });
        return documentBuilder;
    }

    private void configureTransformer(Transformer transformer, Document document, String string) {
        transformer.setErrorListener(this.errHandler);
        String string2 = document.getDoctype().getSystemId();
        String string3 = document.getDoctype().getPublicId();
        if (string2 != null) {
            transformer.setOutputProperty("doctype-system", string2);
        }
        if (string3 != null) {
            transformer.setOutputProperty("doctype-public", string3);
        }
        transformer.setOutputProperty("encoding", string);
    }

    public List<ConfigurationData> getConfigdata() {
        return this.configData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ConfigurationData> transform(String string, InputStream inputStream, InputStream inputStream2, String string2, ExportConfigDataProvider.TYPE_OF_CONFIG tYPE_OF_CONFIG, String string3, boolean bl, boolean bl2) throws ConfigTransformException {
        Writer writer = null;
        this.configData = new ArrayList<ConfigurationData>();
        try {
            Object object;
            this.setValidatingSource(inputStream, inputStream2);
            this.fileParsed = string;
            Document document = this.documentBuilder.parse(inputStream);
            DOMSource dOMSource = new DOMSource(document);
            ByteArrayInputStream byteArrayInputStream = this.createByteArrayInputStream(XSLT_PATH + string2);
            StreamSource streamSource = new StreamSource(byteArrayInputStream);
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            String string4 = document.getXmlEncoding();
            string4 = string4 != null ? string4 : UTF8_ENCODING;
            Transformer transformer = this.transformerFactory.newTransformer(streamSource);
            this.configureTransformer(transformer, document, string4);
            transformer.transform(dOMSource, new StreamResult(charArrayWriter));
            char[] cArray = charArrayWriter.toCharArray();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            writer = new OutputStreamWriter(byteArrayOutputStream);
            this.formatter.write(writer, cArray);
            writer.flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray);
            ConfigurationData configurationData = new ConfigurationData(string3, byteArrayInputStream2, tYPE_OF_CONFIG, null);
            if (configurationData.getFileName().equals(MigrateRbsController.outputFileNameMap.get((Object)ExportConfigDataProvider.TYPE_OF_CONFIG.OAM)) && bl2) {
                object = configurationData.getInputStream();
                configurationData = this.updateConfigurationData((InputStream)object, inputStream2, string3, tYPE_OF_CONFIG, IP_SYNCH_REF_SYNCH_PORT_XSL);
            }
            object = new ConfigurationData(string2, byteArrayInputStream, ExportConfigDataProvider.TYPE_OF_CONFIG.XSL, null);
            if (configurationData.getFileName().equals(MigrateRbsController.outputFileNameMap.get((Object)ExportConfigDataProvider.TYPE_OF_CONFIG.SITE))) {
                if (this.migrateRbsUtil.isMultiCarrier()) {
                    InputStream inputStream3 = configurationData.getInputStream();
                    configurationData = this.updateSiteConfigurationData(inputStream3, inputStream2, string3, tYPE_OF_CONFIG, STEERED_HS_ALLOCATION_XSL);
                } else {
                    InputStream inputStream4 = configurationData.getInputStream();
                    Document document2 = this.convertByteArrayInputStreamToDoc(inputStream4, inputStream2);
                    this.convertDocToByteArrayInputStream(document2);
                    document2 = this.transformHsCodeResourceIds(document2);
                    configurationData = new ConfigurationData(string3, this.convertDocToByteArrayInputStream(document2), tYPE_OF_CONFIG, null);
                }
            }
            this.configData.add((ConfigurationData)object);
            this.configData.add(configurationData);
            byteArrayInputStream2.reset();
            inputStream2.reset();
            this.fileParsed = string3;
            this.documentBuilder.parse(byteArrayInputStream2);
        }
        catch (SimpleFormatterException simpleFormatterException) {
            this.errHandler.handle(simpleFormatterException);
        }
        catch (SAXParseException sAXParseException) {
            this.errHandler.handle(sAXParseException);
        }
        catch (SAXException sAXException) {
            this.errHandler.handle(sAXException);
        }
        catch (IOException iOException) {
            this.errHandler.handle(iOException);
        }
        catch (TransformerException transformerException) {
            this.errHandler.handle(transformerException);
        }
        catch (BemException bemException) {
            this.errHandler.handle(bemException);
        }
        catch (TransformerFactoryConfigurationError transformerFactoryConfigurationError) {
            this.errHandler.handle(new BemException(transformerFactoryConfigurationError));
        }
        finally {
            try {
                if (writer != null) {
                    writer.flush();
                    writer.close();
                }
            }
            catch (IOException iOException) {
                this.errHandler.handle(iOException);
            }
        }
        return this.configData;
    }

    private Document transformHsCodeResourceIds(Document document) throws SAXException, IOException, TransformerFactoryConfigurationError, TransformerException, BemException {
        int n;
        Node node;
        NamedNodeMap namedNodeMap;
        Node node2;
        int n2;
        Rbs rbs = this.migrateRbsUtil.getRbs();
        RadioEquipmentProvider radioEquipmentProvider = rbs.getRadioEquipmentProvider();
        NodeList nodeList = document.getElementsByTagName("Cell");
        NodeList nodeList2 = document.getElementsByTagName("HsdpaSlot");
        int n3 = radioEquipmentProvider.getNumberOfDuwSlots();
        int[] nArray = new int[n3];
        int[] nArray2 = new int[nodeList.getLength()];
        int[] nArray3 = new int[nodeList.getLength()];
        int[] nArray4 = new int[nodeList.getLength()];
        int[][] nArrayArray = new int[n3][];
        int[][][] nArrayArray2 = new int[n3][][];
        int[] nArray5 = new int[n3];
        int[][] nArrayArray3 = new int[n3][];
        boolean bl = false;
        for (n2 = 0; n2 < nArray4.length; ++n2) {
            nArray4[n2] = 0;
        }
        for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
            node2 = nodeList.item(n2);
            namedNodeMap = node2.getAttributes();
            node = namedNodeMap.getNamedItem("hsCodeResourceId");
            if (node == null) continue;
            nArray2[n2] = Integer.parseInt(node.getNodeValue());
        }
        for (n2 = 0; n2 < nodeList2.getLength(); ++n2) {
            node2 = nodeList2.item(n2);
            namedNodeMap = node2.getAttributes();
            node = null;
            if (namedNodeMap != null) {
                node = namedNodeMap.getNamedItem("numHsCodeResources");
            }
            Node node3 = null;
            if (node != null) {
                node3 = namedNodeMap.getNamedItem("slot");
            }
            if (node3 == null || node == null) continue;
            n = Integer.parseInt(node3.getNodeValue()) - 1;
            nArray[n] = Integer.parseInt(node.getNodeValue());
        }
        for (n2 = 0; n2 < n3; ++n2) {
            nArray5[n2] = 1;
            nArrayArray3[n2] = new int[nArray[n2] + 1];
            for (int i = 1; i <= nArray[n2]; ++i) {
                nArrayArray3[n2][i] = 6;
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            nArrayArray[n2] = radioEquipmentProvider.getEquippedSectors(n2);
        }
        for (n2 = 0; n2 < n3; ++n2) {
            nArrayArray2[n2] = new int[nArrayArray[n2].length][];
            for (int i = 0; i < nArrayArray[n2].length; ++i) {
                int n4 = nArrayArray[n2][i];
                nArrayArray2[n2][i] = radioEquipmentProvider.getCarriersInSector(n2, n4);
                if (nArrayArray2[n2][i] == null) continue;
                for (int j = 0; j < nArrayArray2[n2][i].length; ++j) {
                    bl = false;
                    int n5 = nArrayArray2[n2][i][j];
                    for (n = 0; n < nodeList.getLength() && !bl; ++n) {
                        Node node4 = nodeList.item(n);
                        NamedNodeMap namedNodeMap2 = node4.getParentNode().getAttributes();
                        int n6 = Integer.parseInt(namedNodeMap2.getNamedItem("sectorNumber").getNodeValue());
                        NamedNodeMap namedNodeMap3 = nodeList.item(n).getAttributes();
                        int n7 = Integer.parseInt(namedNodeMap3.getNamedItem("cellNumber").getNodeValue());
                        if (n4 != n6 || n5 != n7) continue;
                        nArray3[n] = n2;
                        bl = true;
                    }
                }
            }
        }
        for (n2 = 0; n2 < n3; ++n2) {
            for (int i = 6; i > 0; --i) {
                for (int j = 1; j <= MimRbsLocalCell.MAX_HSCODERESOURCEID; ++j) {
                    int n8;
                    int n9;
                    int n10 = 0;
                    for (n9 = 0; n9 < nArray2.length; ++n9) {
                        if (nArray2[n9] != j || nArray3[n9] != n2) continue;
                        ++n10;
                    }
                    if (n10 != i) continue;
                    bl = false;
                    for (n9 = 0; n9 < nArray[n2] && !bl; ++n9) {
                        if (nArrayArray3[n2][nArray5[n2]] >= i) {
                            for (n8 = 0; n8 < nArray2.length; ++n8) {
                                if (nArray2[n8] != j || nArray3[n8] != n2) continue;
                                nArray4[n8] = nArray5[n2];
                            }
                            int[] nArray6 = nArrayArray3[n2];
                            int n11 = nArray5[n2];
                            nArray6[n11] = nArray6[n11] - i;
                            bl = true;
                        }
                        nArray5[n2] = nArray5[n2] % nArray[n2] + 1;
                    }
                    if (bl) continue;
                    n8 = i;
                    for (n9 = 0; n9 < nArray[n2] && !bl; ++n9) {
                        if (nArrayArray3[n2][nArray5[n2]] > 0) {
                            for (n = 0; n < nArray2.length && nArrayArray3[n2][nArray5[n2]] > 0; ++n) {
                                if (nArray2[n] != j || nArray3[n] != n2 || nArray4[n] != 0) continue;
                                nArray4[n] = nArray5[n2];
                                int[] nArray7 = nArrayArray3[n2];
                                int n12 = nArray5[n2];
                                nArray7[n12] = nArray7[n12] - 1;
                                --n8;
                            }
                            if (n8 == 0) {
                                bl = true;
                            }
                        }
                        nArray5[n2] = nArray5[n2] % nArray[n2] + 1;
                    }
                    if (bl) continue;
                    StringBuffer stringBuffer = new StringBuffer("{");
                    for (int k = 0; k < nArray2.length; ++k) {
                        stringBuffer.append(nArray2[k]);
                        stringBuffer.append(k != nArray2.length - 1 ? "," : "}");
                    }
                    throw new BemException("Could not convert hsCodeResourceId \nA possible workaround is to turn off steeredHsAllocation before migration\nValues before migration:\nnumHsCodeResources: " + nArray + " hsCodeResourceId: " + stringBuffer.toString());
                }
            }
        }
        for (n2 = 0; n2 < nodeList.getLength(); ++n2) {
            Node node5 = nodeList.item(n2);
            NamedNodeMap namedNodeMap4 = node5.getAttributes();
            Node node6 = null;
            if (namedNodeMap4 == null || (node6 = namedNodeMap4.getNamedItem("hsCodeResourceId")) == null) continue;
            node6.setNodeValue(String.valueOf(nArray4[n2]));
        }
        return document;
    }

    private Document convertByteArrayInputStreamToDoc(InputStream inputStream, InputStream inputStream2) throws SAXException, IOException {
        inputStream.reset();
        inputStream2.reset();
        Document document = this.documentBuilder.parse(inputStream);
        return document;
    }

    private ByteArrayInputStream convertDocToByteArrayInputStream(Document document) throws TransformerFactoryConfigurationError, TransformerException, IOException, SimpleFormatterException {
        DOMSource dOMSource = new DOMSource(document);
        String string = document.getXmlEncoding();
        string = string != null ? string : UTF8_ENCODING;
        CharArrayWriter charArrayWriter = new CharArrayWriter();
        Transformer transformer = this.transformerFactory.newTransformer();
        this.configureTransformer(transformer, document, string);
        transformer.transform(dOMSource, new StreamResult(charArrayWriter));
        char[] cArray = charArrayWriter.toCharArray();
        OutputStreamWriter outputStreamWriter = null;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
        this.formatter.write(outputStreamWriter, cArray);
        ((Writer)outputStreamWriter).flush();
        return new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
    }

    ConfigurationData updateConfigurationData(InputStream inputStream, InputStream inputStream2, String string, ExportConfigDataProvider.TYPE_OF_CONFIG tYPE_OF_CONFIG, String string2) throws ConfigTransformException {
        ConfigurationData configurationData = null;
        try {
            inputStream.reset();
            inputStream2.reset();
            Document document = this.documentBuilder.parse(inputStream);
            DOMSource dOMSource = new DOMSource(document);
            ByteArrayInputStream byteArrayInputStream = null;
            if (string2.equals(IP_SYNCH_REF_SYNCH_PORT_XSL)) {
                byteArrayInputStream = this.createByteArrayInputStream("/se/ericsson/wcdma/rbs/bem/application/applications/migraterbs/configtransformer/xsl/ipSynchRefSynchPort.xsl");
            } else if (string2.equals(GIGABIT_ETHERNET_PORT_XSL)) {
                byteArrayInputStream = this.createByteArrayInputStream("/se/ericsson/wcdma/rbs/bem/application/applications/migraterbs/configtransformer/xsl/gePort.xsl");
            }
            StreamSource streamSource = new StreamSource(byteArrayInputStream);
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            String string3 = document.getXmlEncoding();
            string3 = string3 != null ? string3 : UTF8_ENCODING;
            Transformer transformer = this.transformerFactory.newTransformer(streamSource);
            this.configureTransformer(transformer, document, string3);
            transformer.transform(dOMSource, new StreamResult(charArrayWriter));
            char[] cArray = charArrayWriter.toCharArray();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
            this.formatter.write(outputStreamWriter, cArray);
            ((Writer)outputStreamWriter).flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray);
            configurationData = new ConfigurationData(string, byteArrayInputStream2, tYPE_OF_CONFIG, null);
        }
        catch (SimpleFormatterException simpleFormatterException) {
            this.errHandler.handle(simpleFormatterException);
        }
        catch (SAXParseException sAXParseException) {
            this.errHandler.handle(sAXParseException);
        }
        catch (SAXException sAXException) {
            this.errHandler.handle(sAXException);
        }
        catch (IOException iOException) {
            this.errHandler.handle(iOException);
        }
        catch (TransformerException transformerException) {
            this.errHandler.handle(transformerException);
        }
        return configurationData;
    }

    ConfigurationData updateSiteConfigurationData(InputStream inputStream, InputStream inputStream2, String string, ExportConfigDataProvider.TYPE_OF_CONFIG tYPE_OF_CONFIG, String string2) throws ConfigTransformException {
        ConfigurationData configurationData = null;
        try {
            inputStream.reset();
            inputStream2.reset();
            Document document = this.documentBuilder.parse(inputStream);
            DOMSource dOMSource = new DOMSource(document);
            ByteArrayInputStream byteArrayInputStream = null;
            byteArrayInputStream = this.createByteArrayInputStream("/se/ericsson/wcdma/rbs/bem/application/applications/migraterbs/configtransformer/xsl/steeredHsAllocation.xsl");
            StreamSource streamSource = new StreamSource(byteArrayInputStream);
            CharArrayWriter charArrayWriter = new CharArrayWriter();
            String string3 = document.getXmlEncoding();
            string3 = string3 != null ? string3 : UTF8_ENCODING;
            Transformer transformer = this.transformerFactory.newTransformer(streamSource);
            this.configureTransformer(transformer, document, string3);
            transformer.transform(dOMSource, new StreamResult(charArrayWriter));
            char[] cArray = charArrayWriter.toCharArray();
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            OutputStreamWriter outputStreamWriter = new OutputStreamWriter(byteArrayOutputStream);
            this.formatter.write(outputStreamWriter, cArray);
            ((Writer)outputStreamWriter).flush();
            byte[] byArray = byteArrayOutputStream.toByteArray();
            ByteArrayInputStream byteArrayInputStream2 = new ByteArrayInputStream(byArray);
            configurationData = new ConfigurationData(string, byteArrayInputStream2, tYPE_OF_CONFIG, null);
        }
        catch (SimpleFormatterException simpleFormatterException) {
            this.errHandler.handle(simpleFormatterException);
        }
        catch (SAXParseException sAXParseException) {
            this.errHandler.handle(sAXParseException);
        }
        catch (SAXException sAXException) {
            this.errHandler.handle(sAXException);
        }
        catch (IOException iOException) {
            this.errHandler.handle(iOException);
        }
        catch (TransformerException transformerException) {
            this.errHandler.handle(transformerException);
        }
        return configurationData;
    }

    private void setValidatingSource(InputStream inputStream, final InputStream inputStream2) {
        if (inputStream2 != null) {
            this.documentBuilder.setEntityResolver(new EntityResolver(){

                public InputSource resolveEntity(String string, String string2) throws SAXException, IOException {
                    return new InputSource(inputStream2);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ByteArrayInputStream createByteArrayInputStream(String string) throws IOException {
        ByteArrayInputStream byteArrayInputStream = null;
        InputStream inputStream = null;
        try {
            URL uRL = ByteArrayInputStream.class.getResource(string);
            if (uRL == null) {
                ByteArrayInputStream byteArrayInputStream2 = null;
                return byteArrayInputStream2;
            }
            inputStream = uRL.openStream();
            byte[] byArray = new byte[inputStream.available()];
            inputStream.read(byArray);
            byteArrayInputStream = new ByteArrayInputStream(byArray);
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return byteArrayInputStream;
    }

    public String getFileParsed() {
        return this.fileParsed;
    }

    protected static class WrappingExceptionHandler
    implements ErrorListener,
    ErrorHandler {
        protected WrappingExceptionHandler() {
        }

        public void warning(TransformerException transformerException) throws TransformerException {
        }

        public void error(TransformerException transformerException) throws TransformerException {
            throw transformerException;
        }

        public void fatalError(TransformerException transformerException) throws TransformerException {
            throw transformerException;
        }

        public void warning(SAXParseException sAXParseException) throws SAXParseException {
        }

        public void error(SAXParseException sAXParseException) throws SAXParseException {
            throw sAXParseException;
        }

        public void fatalError(SAXParseException sAXParseException) throws SAXParseException {
            throw sAXParseException;
        }

        public void handle(Exception exception) throws ConfigTransformException {
            throw new ConfigTransformException(exception);
        }
    }
}

