/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.sitecomplete.prepareAndConvert;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import se.ericsson.cello.mimparser.MimModel;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.sitecomplete.prepareAndConvert.data.MoData;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.sitecomplete.prepareAndConvert.data.Template;
import se.ericsson.wcdma.rbs.bem.application.applications.migraterbs.sitecomplete.prepareAndConvert.filter.MoFilter;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.script.BemScriptUtil;
import se.ericsson.wcdma.rbs.bem.common.script.impl.client.BemScriptUtilImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSiteComplete {
    private final Rbs rbs;
    private final MimModel mimModel;
    private final MoHandler moHandler;
    private final List<Template> listOfTemplates;
    private final List<MoData> listOfMoData;
    private final BemScriptUtil bemScriptUtil;
    private final PrintWriter pwProcedure;
    private final PrintWriter pwStep;
    private BemMo rootMo;
    protected String NAME = null;
    protected String PROCEDURE_NAME = "node_specific_Procedure";
    protected String STEP_NAME = "node_specific_Step";

    public AbstractSiteComplete(Rbs rbs, MimModel mimModel, PrintWriter printWriter, PrintWriter printWriter2) {
        this.rbs = rbs;
        this.mimModel = mimModel;
        this.moHandler = rbs.getMoHandler();
        this.listOfTemplates = new ArrayList<Template>();
        this.listOfMoData = new ArrayList<MoData>();
        this.bemScriptUtil = new BemScriptUtilImpl();
        this.pwProcedure = printWriter;
        this.pwStep = printWriter2;
    }

    protected Rbs getRbs() {
        return this.rbs;
    }

    protected MimModel getMimModel() {
        return this.mimModel;
    }

    protected List<Template> getTemplates() throws BemException {
        return this.listOfTemplates;
    }

    protected List<MoData> getMoData() {
        return this.listOfMoData;
    }

    public void generateMoScript() throws BemException {
        this.createTemplates();
        this.filterTemplates();
        this.createMoData();
        this.readMoData();
        this.convertMoData();
        this.createMoScript();
    }

    protected abstract void createTemplates() throws BemException;

    protected void filterTemplates() throws BemException {
        for (Template template : this.getTemplates()) {
            template.filtrate(this.getMimModel());
        }
    }

    protected void createMoData() throws BemException {
        for (Template template : this.getTemplates()) {
            String string = template.getMoType();
            BemMo[] bemMoArray = this.getChildren(this.getRoot(), -1, string, "");
            MoFilter moFilter = template.getMoFilter();
            ArrayList<BemMo> arrayList = new ArrayList<BemMo>();
            for (BemMo bemMo : bemMoArray) {
                if (moFilter != null) {
                    BemMo bemMo2 = moFilter.filterOnMo(bemMo);
                    if (bemMo2 == null) continue;
                    arrayList.add(bemMo2);
                    continue;
                }
                arrayList.add(bemMo);
            }
            for (BemMo bemMo : arrayList) {
                MoData moData = new MoData(bemMo, template);
                List<MoData> list = this.getMoData();
                list.add(moData);
            }
        }
    }

    protected void readMoData() throws BemException {
        for (MoData moData : this.listOfMoData) {
            moData.read();
        }
    }

    protected void convertMoData() throws BemException {
        for (MoData moData : this.listOfMoData) {
            moData.convert();
        }
    }

    protected void createMoScript() throws BemException {
        this.initiateBemScriptUtil();
        for (MoData moData : this.listOfMoData) {
            moData.createMoScriptForAttributes(this.moHandler, this.bemScriptUtil);
        }
        for (MoData moData : this.listOfMoData) {
            moData.createMoScriptForActions(this.moHandler, this.bemScriptUtil);
        }
    }

    private void initiateBemScriptUtil() {
        this.bemScriptUtil.scriptStartConfigurationProcedure(this.PROCEDURE_NAME, this.pwProcedure);
        this.bemScriptUtil.scriptStartConfigurationStep(this.STEP_NAME, this.pwStep);
    }

    protected final BemMo getRoot() throws BemException {
        if (this.rootMo != null) {
            return this.rootMo;
        }
        try {
            BemLog.log(7, this.NAME + " getRoot()");
            this.rootMo = this.moHandler.getRoot();
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            throw bemException;
        }
        return this.rootMo;
    }

    protected final BemMo[] getChildren(BemMo bemMo, int n, String string, String string2) throws BemException {
        BemMo[] bemMoArray = null;
        try {
            BemLog.log(7, this.NAME + " getChildren()");
            bemMoArray = this.moHandler.getChildren(bemMo, n, string, string2);
        }
        catch (MoHandlerException moHandlerException) {
            BemException bemException = new BemException(moHandlerException);
            throw bemException;
        }
        return bemMoArray;
    }
}

