/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.client.clients.cli.control;

import java.util.ArrayList;
import se.ericsson.wcdma.rbs.bem.client.clients.cli.function.AbstractFunction;
import se.ericsson.wcdma.rbs.bem.client.clients.cli.function.ElementManager;
import se.ericsson.wcdma.rbs.bem.client.clients.cli.function.FunctionFactory;
import se.ericsson.wcdma.rbs.bem.client.clients.cli.function.FunctionUtil;
import se.ericsson.wcdma.rbs.bem.client.clients.cli.util.CliLog;
import se.ericsson.wcdma.rbs.bem.client.clients.cli.xml.XmlEntity;
import se.ericsson.wcdma.rbs.bem.common.RbsEmPropertiesFileHandler;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.util.BemLanguageHelp;
import se.ericsson.wcdma.rbs.bem.common.util.RegressionTestInDesigntestUtils;
import se.ericsson.wcdma.rbs.bem.common.util.Silent;
import se.ericsson.wcdma.rbs.bem.common.util.SilentMode;
import se.ericsson.wcdma.rbs.bem.common.util.WebServerUtil;

public class CliController
implements Silent,
Runnable {
    private XmlEntity xmlOutput = new XmlEntity();
    private AbstractFunction functionToExecute = null;
    private boolean emRunning = false;
    private int bem_cli_timeout = 900000;

    public static void main(String[] stringArray) {
        String string = "Unexpected termination!";
        try {
            CliController cliController = new CliController();
            string = cliController.handleCommand(stringArray);
        }
        catch (Throwable throwable) {
            String string2 = "Problems running BEMCLI.\nException=" + throwable.toString() + "\n";
            string = "\nresult=ERROR\ndetails=\"" + string2 + "\"\n";
        }
        System.out.println(string);
    }

    public String handleCommand(String[] stringArray) {
        String string = null;
        try {
            SilentMode.setSilentMode(true);
            SilentMode.setErrorMsgReceiver(this);
            String[] stringArray2 = this.extractTaggedArguments(stringArray);
            this.handleTaggedArguments(stringArray2);
            stringArray = this.removeRbs_PropArguments(stringArray);
            if (stringArray.length <= 0) {
                string = "Command not correctly entered. Expected first parameter to be host name or ip address\n" + this.prepareUsageString();
                return string;
            }
            String string2 = stringArray[0];
            boolean bl = false;
            if (string2.equals("localhost")) {
                bl = true;
                BemLanguageHelp.setEnvironment(1);
            }
            CliLog.setup();
            CliController.logCommandLineArgs(stringArray);
            if (!RegressionTestInDesigntestUtils.getRegressionTest()) {
                if (bl) {
                    Nal.connectToMib(System.getProperty("user.home") + "/rbs.mib");
                } else {
                    Nal.connectToMib(string2);
                }
            }
            this.functionToExecute = FunctionFactory.createFunction(stringArray, this);
            this.startThread();
            if (this.functionToExecute.getClass().getName().equals(ElementManager.class.getName())) {
                this.emRunning = true;
            } else {
                string = this.xmlOutput.getXmlResult();
            }
        }
        catch (Exception exception) {
            string = "Exception " + exception.toString();
            this.xmlOutput = new XmlEntity("Exception");
            try {
                this.xmlOutput.beginApplication("Exception");
                this.xmlOutput.addErrorMessage(string, exception);
                this.xmlOutput.endApplication();
                string = this.xmlOutput.getXmlResult();
            }
            catch (BemException bemException) {
                string = "";
            }
        }
        return string;
    }

    public Boolean getForceExit() {
        return !this.emRunning;
    }

    public String getUrlPref() {
        return WebServerUtil.getUrlPref();
    }

    public XmlEntity getXmlEntity() {
        return this.xmlOutput;
    }

    private void startThread() throws Exception {
        Thread thread = new Thread(this);
        thread.setName("BEMCLI Function executor: " + this.functionToExecute.getClass().getName());
        thread.start();
        BemCliTimeout bemCliTimeout = new BemCliTimeout(Thread.currentThread(), this.bem_cli_timeout);
        Thread thread2 = new Thread(bemCliTimeout);
        thread2.setName("BEMCLI Timeout");
        thread2.start();
        try {
            thread.join();
            thread2.interrupt();
        }
        catch (InterruptedException interruptedException) {
            throw new Exception("Interupted exception when executing BEMCLI, Possible Reasons: Lost contact with node or Execution has exceeded the BEM_CLI_TIMEOUT of: " + this.bem_cli_timeout, interruptedException);
        }
    }

    public void run() {
        if (this.functionToExecute != null) {
            this.functionToExecute.execute();
        }
    }

    public void setErrorMessage(String string) {
        this.xmlOutput.addErrorMessage(string);
    }

    public void setErrorMessage(String string, Throwable throwable) {
        this.xmlOutput.addErrorMessage(string, throwable);
    }

    private static void logCommandLineArgs(String[] stringArray) {
        StringBuffer stringBuffer = new StringBuffer("Command line arguments: ");
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]);
            stringBuffer.append(" ");
        }
        CliLog.log(stringBuffer.toString());
    }

    private String[] extractTaggedArguments(String[] stringArray) throws BemException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (!string.startsWith("-")) continue;
                if (stringArray.length > i + 1) {
                    string = string + " " + stringArray[++i];
                    arrayList.add(string);
                    continue;
                }
                String string2 = "Command not supported, parameter " + string + " is missing a value\n" + this.prepareUsageString();
                throw new BemException(string2);
            }
        }
        String[] stringArray2 = arrayList.toArray(new String[0]);
        return stringArray2;
    }

    private String[] removeRbs_PropArguments(String[] stringArray) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string = stringArray[i];
                if (!string.startsWith("-rbs_prop")) {
                    arrayList.add(string);
                    continue;
                }
                if (stringArray.length <= i + 1) continue;
                ++i;
            }
        }
        String[] stringArray2 = arrayList.toArray(new String[0]);
        return stringArray2;
    }

    private void handleTaggedArguments(String[] stringArray) throws BemException {
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                String string;
                int n;
                String string2 = stringArray[i];
                if (string2.startsWith("-timeout")) {
                    n = string2.indexOf(" ");
                    if (n > 0) {
                        string = string2.substring(n + 1);
                        this.bem_cli_timeout = Integer.valueOf(string);
                    } else {
                        string = "Command not supported\n" + this.prepareUsageString();
                        throw new BemException(string);
                    }
                }
                if (!string2.startsWith("-rbs_prop")) continue;
                n = string2.indexOf(" ");
                if (n > 0) {
                    string = string2.substring(n + 1);
                    RbsEmPropertiesFileHandler.getInstance().setFilePath(string);
                    continue;
                }
                string = "Command not supported\n" + this.prepareUsageString();
                throw new BemException(string);
            }
        }
    }

    private String prepareUsageString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < FunctionUtil.getCommandSuageStringsLength(); ++i) {
            stringBuffer.append(FunctionUtil.getCommandSuageStringsStringByIndex(i)).append('\n');
        }
        stringBuffer.append("\n\n");
        return stringBuffer.toString();
    }

    static class BemCliTimeout
    implements Runnable {
        private Thread threadToKill;
        private int timeout_ms;

        BemCliTimeout(Thread thread, int n) {
            this.threadToKill = thread;
            this.timeout_ms = n;
        }

        public void run() {
            try {
                Thread.sleep(this.timeout_ms);
                this.threadToKill.interrupt();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

