/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.client.clients.cli.function;

import se.ericsson.wcdma.rbs.bem.client.clients.cli.control.CliController;
import se.ericsson.wcdma.rbs.bem.client.clients.cli.function.AbstractFunction;
import se.ericsson.wcdma.rbs.bem.client.clients.cli.util.CliLog;
import se.ericsson.wcdma.rbs.bem.client.clients.cli.xml.XmlEntity;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.hook.application.ExportDeleteHook;

public class ExportApplication
extends AbstractFunction {
    public ExportApplication(String[] stringArray, CliController cliController) {
        super(stringArray, cliController);
    }

    public void execute() {
        String string = null;
        XmlEntity xmlEntity = null;
        CliLog.log("ExportApplication.execute()");
        try {
            ExportDeleteHook exportDeleteHook = new ExportDeleteHook();
            xmlEntity = this.getCliController().getXmlEntity();
            string = this.handleExportCabinet(exportDeleteHook, xmlEntity);
            string = this.handleExportSite(exportDeleteHook, xmlEntity);
            string = this.handleExportMib(exportDeleteHook, xmlEntity);
        }
        catch (BemException bemException) {
            xmlEntity.addErrorMessage(string + bemException.toString(), bemException);
            xmlEntity.endApplication();
        }
    }

    private String handleExportCabinet(ExportDeleteHook exportDeleteHook, XmlEntity xmlEntity) throws BemException {
        String string = null;
        xmlEntity.beginApplication(this.getFunctionName() + " Export Cabinet");
        if (this.getArgument(2) != null) {
            CliLog.log("ExportApplication.handleExportCabinet(), file name=" + this.getArgument(2));
            string = exportDeleteHook.exportConfigDataCabinet(this.getArgument(2));
        }
        if (string != null) {
            xmlEntity.addErrorMessage(string);
        }
        xmlEntity.endApplication();
        return string;
    }

    private String handleExportSite(ExportDeleteHook exportDeleteHook, XmlEntity xmlEntity) throws BemException {
        String string = null;
        xmlEntity.beginApplication(this.getFunctionName() + " Export Site");
        if (this.getArgument(3) != null) {
            CliLog.log("ExportApplication.handleExportSite(), file name=" + this.getArgument(3));
            string = exportDeleteHook.exportConfigDataSite(this.getArgument(3));
        }
        if (string != null) {
            xmlEntity.addErrorMessage(string);
        }
        xmlEntity.endApplication();
        return string;
    }

    private String handleExportMib(ExportDeleteHook exportDeleteHook, XmlEntity xmlEntity) throws BemException {
        String string = null;
        xmlEntity.beginApplication(this.getFunctionName() + " Export Mib");
        if (this.getArgument(4) != null) {
            CliLog.log("ExportApplication.handleExportMib(), file name=" + this.getArgument(4));
            string = exportDeleteHook.exportMOToXML(this.getArgument(4));
        }
        if (string != null) {
            xmlEntity.addErrorMessage(string);
        }
        xmlEntity.endApplication();
        return string;
    }
}

