/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimWantedPositionStruct;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class SiteDataRI
extends AbstractResourceItem {
    public static final String name = "SiteData";
    private static final String[] myInstallationPhases = new String[]{"GenericSettingsPhase"};
    private final String ldn;

    public SiteDataRI(Rbs rbs, String string) {
        super(name, rbs, myInstallationPhases);
        this.ldn = string;
    }

    public boolean isInstalled() throws BemException {
        return super.isExisting(this.ldn);
    }

    public void install(String string) throws BemException {
        if (super.containsPhase(myInstallationPhases, string)) {
            Object object;
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject("siteName");
            String string2 = (String)customerParameterServer.getValueMom();
            if (customerParameterServer.hasValueChanged()) {
                vector.add(Nal.getFactory().getNameValue("site", string2));
            }
            customerParameterServer = this.rbs.getCustomerParameterServerObject("logicalName");
            String string3 = (String)customerParameterServer.getValueMom();
            if (customerParameterServer.hasValueChanged()) {
                vector.add(Nal.getFactory().getNameValue("logicalName", string3));
            }
            if (vector.size() > 0) {
                object = this.getMo(this.ldn);
                this.setAttributes((BemMo)object, vector);
            }
            if ((customerParameterServer = this.rbs.getCustomerParameterServerObject("lmtPorts")).hasValueChanged()) {
                object = this.rbs.getMoiRefs().getRbsConfigurationMoi().getLdn();
                BemMo bemMo = this.getMo((String)object);
                this.setAttribute(bemMo, customerParameterServer.getAttributeName(), customerParameterServer.getValueMom());
            }
            this.addChangedWantedPositionValues();
        }
    }

    public void setLoadedValues() throws BemException {
        BemMo bemMo = this.getMo(this.ldn);
        BemMo bemMo2 = this.getMo(this.rbs.getMoiRefs().getRbsConfigurationMoi().getLdn());
        CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject("siteName");
        Object object = this.getAttribute(bemMo, "site");
        customerParameterServer.setLoadedValue(object);
        customerParameterServer = this.rbs.getCustomerParameterServerObject("logicalName");
        object = this.getAttribute(bemMo, "logicalName");
        customerParameterServer.setLoadedValue(object);
        customerParameterServer = this.rbs.getCustomerParameterServerObject("lmtPorts");
        object = this.getAttribute(bemMo2, "lmtPortsDisableFunction");
        customerParameterServer.setLoadedValue(object);
        this.setLoadedValuesForWantedPosition(bemMo2);
    }

    private void addChangedWantedPositionValues() throws BemException {
        StringParameter stringParameter = (StringParameter)this.rbs.getCustomerParameterServerObject("altitude");
        StringParameter stringParameter2 = (StringParameter)this.rbs.getCustomerParameterServerObject("latitude");
        StringParameter stringParameter3 = (StringParameter)this.rbs.getCustomerParameterServerObject("longitude");
        IntegerParameter integerParameter = (IntegerParameter)this.rbs.getCustomerParameterServerObject("tolerance");
        if (stringParameter.hasValueChanged() || stringParameter2.hasValueChanged() || stringParameter3.hasValueChanged() || integerParameter.hasValueChanged()) {
            String string = this.rbs.getMoiRefs().getRbsConfigurationMoi().getLdn();
            BemMo bemMo = this.getMo(string);
            NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("altitude", stringParameter.getValue()), Nal.getFactory().getNameValue("latitude", stringParameter2.getValue()), Nal.getFactory().getNameValue("longitude", stringParameter3.getValue()), Nal.getFactory().getNameValue("tolerance", new Integer(Integer.parseInt(integerParameter.getValue())))};
            this.setAttribute(bemMo, "wantedPosition", (Object)Nal.getFactory().getStruct(nalNameValueArray));
        }
    }

    private void setLoadedValuesForWantedPosition(BemMo bemMo) throws BemException {
        NalStruct nalStruct = (NalStruct)this.getAttribute(bemMo, "wantedPosition");
        try {
            Object object;
            Object object2;
            Object object3;
            Object object4;
            if (nalStruct != null && nalStruct.getSize() > 0) {
                object4 = nalStruct.getMemberValue("altitude");
                object3 = nalStruct.getMemberValue("latitude");
                object2 = nalStruct.getMemberValue("longitude");
                object = nalStruct.getMemberValue("tolerance");
            } else {
                Nal.getLog().nalTrace(2, this.getClass(), "The wanted position does not contain the required attributes. Setting default value for wanted position");
                object4 = MimWantedPositionStruct.DEFAULT_ALTITUDE;
                object3 = MimWantedPositionStruct.DEFAULT_LATITUDE;
                object2 = MimWantedPositionStruct.DEFAULT_LONGITUDE;
                object = MimWantedPositionStruct.DEFAULT_TOLERANCE;
            }
            CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject("altitude");
            customerParameterServer.setLoadedValue(object4);
            customerParameterServer = this.rbs.getCustomerParameterServerObject("latitude");
            customerParameterServer.setLoadedValue(object3);
            customerParameterServer = this.rbs.getCustomerParameterServerObject("longitude");
            customerParameterServer.setLoadedValue(object2);
            customerParameterServer = this.rbs.getCustomerParameterServerObject("tolerance");
            customerParameterServer.setLoadedValue(object);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new BemException(noSuchFieldException);
        }
    }

    public String getLdn() {
        return this.ldn;
    }

    public String getDisplayName() {
        return name;
    }
}

