/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.AbstractAntennaSystemCI;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class TmaRI
extends AbstractResourceItem {
    public static final String name = "ExternalTma";
    private static final String[] myInstallationPhases = new String[]{"AuxPlugInUnitCreationPhase", "AuxUnitDbControlledDeletionPhase"};
    private final String ldn;
    private final String prefix;
    private int antNo;
    private String[] pseudosAnt = null;
    private String[] attributeNames = new String[]{"internalPower", "dcVoltage", "dlAttenuation", "ulGain", "dlTrafficDelayA", "dlTrafficDelayB", "ulTrafficDelayA", "ulTrafficDelayB", "tmaDegradedSupported", "currentLowLimA", "currentLowLimB", "currentHighLimA", "currentHighLimB"};

    public TmaRI(Rbs rbs, String string, String string2, int n) {
        super(name, rbs, myInstallationPhases);
        this.ldn = string2;
        this.prefix = string;
        this.antNo = n;
        this.pseudosAnt = new String[]{BemUtil.getCustomerParameterName("", "internalPower", this.antNo), BemUtil.getCustomerParameterName("", "dcVoltage", this.antNo), BemUtil.getCustomerParameterName("", "dlAttenuation", this.antNo), BemUtil.getCustomerParameterName("", "ulGain", this.antNo), BemUtil.getCustomerParameterNameWithBranchType("", "dlTrafficDelay", this.getBranchTypeForConnectorA(this.antNo)), BemUtil.getCustomerParameterNameWithBranchType("", "dlTrafficDelay", this.getBranchTypeForConnectorB(this.antNo)), BemUtil.getCustomerParameterNameWithBranchType("", "ulTrafficDelay", this.getBranchTypeForConnectorA(this.antNo)), BemUtil.getCustomerParameterNameWithBranchType("", "ulTrafficDelay", this.getBranchTypeForConnectorB(this.antNo)), BemUtil.getCustomerParameterName("", "tmaDegradedSupported", this.antNo), BemUtil.getCustomerParameterNameWithBranchType("", "currentLowLim", this.getBranchTypeForConnectorA(this.antNo)), BemUtil.getCustomerParameterNameWithBranchType("", "currentLowLim", this.getBranchTypeForConnectorB(this.antNo)), BemUtil.getCustomerParameterNameWithBranchType("", "currentHighLim", this.getBranchTypeForConnectorA(this.antNo)), BemUtil.getCustomerParameterNameWithBranchType("", "currentHighLim", this.getBranchTypeForConnectorB(this.antNo))};
    }

    public boolean isInstalled() throws BemException {
        return super.isExisting(this.ldn);
    }

    public void install(String string) throws BemException {
        if (super.containsPhase(myInstallationPhases, string)) {
            boolean bl = false;
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            BemMo bemMo = this.getMo(this.ldn);
            BemMo bemMo2 = bemMo.getParent();
            if (bemMo2.isExisting()) {
                if (bemMo.isExisting()) {
                    bl = true;
                }
                CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(BemUtil.getCustomerParameterName(this.prefix, "internalPower", this.antNo));
                Integer n = (Integer)customerParameterServer.getValueMom();
                if (!bl || customerParameterServer.hasValueChanged()) {
                    vector.add(Nal.getFactory().getNameValue("internalPower", n));
                }
                customerParameterServer = this.rbs.getCustomerParameterServerObject(BemUtil.getCustomerParameterName(this.prefix, "dcVoltage", this.antNo));
                Integer n2 = (Integer)customerParameterServer.getValueMom();
                if (n != 0 && (!bl || customerParameterServer.hasValueChanged())) {
                    vector.add(Nal.getFactory().getNameValue("dcVoltage", n2));
                }
                customerParameterServer = this.rbs.getCustomerParameterServerObject(BemUtil.getCustomerParameterName(this.prefix, "dlAttenuation", this.antNo));
                Integer n3 = Integer.valueOf((String)customerParameterServer.getValueMom());
                if (!bl || customerParameterServer.hasValueChanged()) {
                    vector.add(Nal.getFactory().getNameValue("dlAttenuation", n3));
                }
                customerParameterServer = this.rbs.getCustomerParameterServerObject(BemUtil.getCustomerParameterName(this.prefix, "ulGain", this.antNo));
                Integer n4 = Integer.valueOf((String)customerParameterServer.getValueMom());
                if (!bl || customerParameterServer.hasValueChanged()) {
                    vector.add(Nal.getFactory().getNameValue("ulGain", n4));
                }
                customerParameterServer = this.rbs.getCustomerParameterServerObject(BemUtil.getCustomerParameterNameWithBranchType(this.prefix, "dlTrafficDelay", this.getBranchTypeForConnectorA(this.antNo)));
                Integer n5 = Integer.valueOf((String)customerParameterServer.getValueMom());
                if (!bl || customerParameterServer.hasValueChanged()) {
                    vector.add(Nal.getFactory().getNameValue("dlTrafficDelayA", n5));
                }
                customerParameterServer = this.rbs.getCustomerParameterServerObject(BemUtil.getCustomerParameterNameWithBranchType(this.prefix, "dlTrafficDelay", this.getBranchTypeForConnectorB(this.antNo)));
                Integer n6 = Integer.valueOf((String)customerParameterServer.getValueMom());
                if (!bl || customerParameterServer.hasValueChanged()) {
                    vector.add(Nal.getFactory().getNameValue("dlTrafficDelayB", n6));
                }
                customerParameterServer = this.rbs.getCustomerParameterServerObject(BemUtil.getCustomerParameterNameWithBranchType(this.prefix, "ulTrafficDelay", this.getBranchTypeForConnectorA(this.antNo)));
                Integer n7 = Integer.valueOf((String)customerParameterServer.getValueMom());
                if (!bl || customerParameterServer.hasValueChanged()) {
                    vector.add(Nal.getFactory().getNameValue("ulTrafficDelayA", n7));
                }
                customerParameterServer = this.rbs.getCustomerParameterServerObject(BemUtil.getCustomerParameterNameWithBranchType(this.prefix, "ulTrafficDelay", this.getBranchTypeForConnectorB(this.antNo)));
                Integer n8 = Integer.valueOf((String)customerParameterServer.getValueMom());
                if (!bl || customerParameterServer.hasValueChanged()) {
                    vector.add(Nal.getFactory().getNameValue("ulTrafficDelayB", n8));
                }
                customerParameterServer = this.rbs.getCustomerParameterServerObject(BemUtil.getCustomerParameterName(this.prefix, "tmaDegradedSupported", this.antNo));
                Integer n9 = Integer.valueOf(customerParameterServer.getValueMom().toString());
                if (!bl || customerParameterServer.hasValueChanged()) {
                    vector.add(Nal.getFactory().getNameValue("tmaDegradedSupported", n9));
                }
                customerParameterServer = this.rbs.getCustomerParameterServerObject(BemUtil.getCustomerParameterNameWithBranchType(this.prefix, "currentLowLim", this.getBranchTypeForConnectorA(this.antNo)));
                Integer n10 = Integer.valueOf((String)customerParameterServer.getValueMom());
                if (!bl || customerParameterServer.hasValueChanged()) {
                    vector.add(Nal.getFactory().getNameValue("currentLowLimA", n10));
                }
                customerParameterServer = this.rbs.getCustomerParameterServerObject(BemUtil.getCustomerParameterNameWithBranchType(this.prefix, "currentLowLim", this.getBranchTypeForConnectorB(this.antNo)));
                Integer n11 = Integer.valueOf((String)customerParameterServer.getValueMom());
                if (!bl || customerParameterServer.hasValueChanged()) {
                    vector.add(Nal.getFactory().getNameValue("currentLowLimB", n11));
                }
                customerParameterServer = this.rbs.getCustomerParameterServerObject(BemUtil.getCustomerParameterNameWithBranchType(this.prefix, "currentHighLim", this.getBranchTypeForConnectorA(this.antNo)));
                Integer n12 = Integer.valueOf((String)customerParameterServer.getValueMom());
                if (!bl || customerParameterServer.hasValueChanged()) {
                    vector.add(Nal.getFactory().getNameValue("currentHighLimA", n12));
                }
                customerParameterServer = this.rbs.getCustomerParameterServerObject(BemUtil.getCustomerParameterNameWithBranchType(this.prefix, "currentHighLim", this.getBranchTypeForConnectorB(this.antNo)));
                Integer n13 = Integer.valueOf((String)customerParameterServer.getValueMom());
                if (!bl || customerParameterServer.hasValueChanged()) {
                    vector.add(Nal.getFactory().getNameValue("currentHighLimB", n13));
                }
                if (vector.size() > 0) {
                    if (bl) {
                        this.setAttributes(bemMo, vector);
                    } else {
                        this.createMoIfNotExisting(this.ldn, vector);
                    }
                }
            }
        }
    }

    public void uninstall(String string) throws BemException {
        if (string.equals("AuxUnitDbControlledDeletionPhase")) {
            this.deleteMoIfNotExisting(this.ldn);
        }
    }

    public void setLoadedValues() throws BemException {
        BemMo bemMo = this.getMo(this.ldn);
        if (bemMo.isExisting()) {
            for (int i = 0; i < this.pseudosAnt.length; ++i) {
                String string = this.prefix + this.pseudosAnt[i];
                CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string);
                Object object = this.getAttribute(bemMo, this.attributeNames[i]);
                customerParameterServer.setLoadedValue(object);
            }
        }
    }

    public String getLdn() {
        return this.ldn;
    }

    public String getDisplayName() {
        return "ExternalTma: " + this.getLdn();
    }

    private String getBranchTypeForConnectorA(int n) {
        return AbstractAntennaSystemCI.getBranchType((n - 1) * 2);
    }

    private String getBranchTypeForConnectorB(int n) {
        return AbstractAntennaSystemCI.getBranchType((n - 1) * 2 + 1);
    }
}

