/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.antennasystem.resource;

import java.text.MessageFormat;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractDbControlledAuxillaryUnitRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class AtmauRI
extends AbstractDbControlledAuxillaryUnitRI {
    public static final String name = "AtmauDeviceGroup";
    public static final String piuTypeProductName = "ATMAU";
    private static final String[] myInstallationPhases = new String[]{"AuxUnitDbControlledCreationPhase", "AuxUnitReconfigureProgramPreparePhase", "UnlockAllUnitsPhase", "AuxUnitDbControlledDeletionPhase", "LockPhase", "UnlockPhase", "AuxPlugInUnitCreationPhase", "AuxUnitDbControlledDeletionPhase", "AtmauSettingPhase"};
    private final String deviceGroupLdn;
    private final String tmaDeviceSetLdn;
    private final String prefix;
    private int antNo;

    public AtmauRI(Rbs rbs, String string, String string2, String string3, String string4, int n, int n2) {
        super(name, rbs, 17, piuTypeProductName, myInstallationPhases, string4);
        this.setSwLoadable(false);
        this.deviceGroupLdn = string2;
        this.tmaDeviceSetLdn = string3;
        this.prefix = string;
        this.antNo = n2;
    }

    public boolean isInstalled() throws BemException {
        return super.isExisting(this.deviceGroupLdn);
    }

    public String getLdn() {
        return this.deviceGroupLdn;
    }

    public String getDisplayName() {
        return "AtmauDeviceGroup: " + this.getLdn();
    }

    protected static String getSectorPrefix(int n) {
        String string = MessageFormat.format("S{0}_", new Integer(n));
        return string;
    }

    public void install(String string) throws BemException {
        super.install(string);
        if (super.containsPhase(this.getInstallationPhases(), string) && string.equals("AtmauSettingPhase")) {
            BemMo bemMo = this.getMo(this.tmaDeviceSetLdn);
            CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(this.prefix + "bandsOfAtma" + (this.antNo > 1 ? "" + this.antNo : ""));
            int[] nArray = (int[])customerParameterServer.getValueMom();
            if (customerParameterServer.hasValueChanged()) {
                this.setAttribute(bemMo, "bandsOfAtma", (Object)nArray);
            }
            boolean bl = true;
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] != 0) {
                    bl = false;
                    break;
                }
                bl = true;
            }
            if (bl) {
                CustomerParameterServer customerParameterServer2 = this.rbs.getCustomerParameterServerObject(this.prefix + "dlAttenuation_ATMA" + (this.antNo > 1 ? "" + this.antNo : ""));
                Integer n = Integer.valueOf((String)customerParameterServer2.getValueMom());
                CustomerParameterServer customerParameterServer3 = this.rbs.getCustomerParameterServerObject(this.prefix + "dlTrafficDelay" + (this.antNo > 1 ? "" + this.antNo : ""));
                Integer n2 = Integer.valueOf((String)customerParameterServer3.getValueMom());
                CustomerParameterServer customerParameterServer4 = this.rbs.getCustomerParameterServerObject(this.prefix + "ulTrafficDelay" + (this.antNo > 1 ? "" + this.antNo : ""));
                Integer n3 = Integer.valueOf((String)customerParameterServer4.getValueMom());
                if (customerParameterServer2.hasValueChanged() || customerParameterServer3.hasValueChanged() || customerParameterServer4.hasValueChanged()) {
                    this.setAttribute(bemMo, "dlAttenuation", (Object)n);
                    this.setAttribute(bemMo, "dlTrafficDelay", (Object)n2);
                    this.setAttribute(bemMo, "ulTrafficDelay", (Object)n3);
                }
            } else {
                CustomerParameterServer customerParameterServer5 = this.rbs.getCustomerParameterServerObject(this.prefix + "dlAttenuationPerBand" + (this.antNo > 1 ? "" + this.antNo : ""));
                int[] nArray2 = (int[])customerParameterServer5.getValueMom();
                CustomerParameterServer customerParameterServer6 = this.rbs.getCustomerParameterServerObject(this.prefix + "dlTrafficDelayPerBand" + (this.antNo > 1 ? "" + this.antNo : ""));
                int[] nArray3 = (int[])customerParameterServer6.getValueMom();
                CustomerParameterServer customerParameterServer7 = this.rbs.getCustomerParameterServerObject(this.prefix + "ulTrafficDelayPerBand" + (this.antNo > 1 ? "" + this.antNo : ""));
                int[] nArray4 = (int[])customerParameterServer7.getValueMom();
                if (customerParameterServer5.hasValueChanged() || customerParameterServer6.hasValueChanged() || customerParameterServer7.hasValueChanged()) {
                    this.setAttribute(bemMo, "dlAttenuationPerBand", (Object)nArray2);
                    this.setAttribute(bemMo, "dlTrafficDelayPerBand", (Object)nArray3);
                    this.setAttribute(bemMo, "ulTrafficDelayPerBand", (Object)nArray4);
                }
            }
        }
    }

    public void setLoadedValues() throws BemException {
        BemMo bemMo = this.getMo(this.tmaDeviceSetLdn);
        if (bemMo.isExisting()) {
            CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(this.prefix + "dlAttenuation_ATMA" + (this.antNo > 1 ? "" + this.antNo : ""));
            Object object = this.getAttribute(bemMo, "dlAttenuation");
            customerParameterServer.setLoadedValue(object);
            CustomerParameterServer customerParameterServer2 = this.rbs.getCustomerParameterServerObject(this.prefix + "dlTrafficDelay" + (this.antNo > 1 ? "" + this.antNo : ""));
            Object object2 = this.getAttribute(bemMo, "dlTrafficDelay");
            customerParameterServer2.setLoadedValue(object2);
            CustomerParameterServer customerParameterServer3 = this.rbs.getCustomerParameterServerObject(this.prefix + "ulTrafficDelay" + (this.antNo > 1 ? "" + this.antNo : ""));
            Object object3 = this.getAttribute(bemMo, "ulTrafficDelay");
            customerParameterServer3.setLoadedValue(object3);
            CustomerParameterServer customerParameterServer4 = this.rbs.getCustomerParameterServerObject(this.prefix + "bandsOfAtma" + (this.antNo > 1 ? "" + this.antNo : ""));
            Object object4 = this.getAttribute(bemMo, "bandsOfAtma");
            customerParameterServer4.setLoadedValue(object4);
            CustomerParameterServer customerParameterServer5 = this.rbs.getCustomerParameterServerObject(this.prefix + "dlAttenuationPerBand" + (this.antNo > 1 ? "" + this.antNo : ""));
            Object object5 = this.getAttribute(bemMo, "dlAttenuationPerBand");
            customerParameterServer5.setLoadedValue(object5);
            CustomerParameterServer customerParameterServer6 = this.rbs.getCustomerParameterServerObject(this.prefix + "dlTrafficDelayPerBand" + (this.antNo > 1 ? "" + this.antNo : ""));
            Object object6 = this.getAttribute(bemMo, "dlTrafficDelayPerBand");
            customerParameterServer6.setLoadedValue(object6);
            CustomerParameterServer customerParameterServer7 = this.rbs.getCustomerParameterServerObject(this.prefix + "ulTrafficDelayPerBand" + (this.antNo > 1 ? "" + this.antNo : ""));
            Object object7 = this.getAttribute(bemMo, "ulTrafficDelayPerBand");
            customerParameterServer7.setLoadedValue(object7);
        }
    }
}

