/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam;

import java.util.ArrayList;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;

public class StandardParameter
extends Enumeration
implements CustomerParameterListener {
    private static final String RESTRICTION_REASON = "Not allowed Standard Parameter";
    private ParameterRestriction aRestriction = null;

    public StandardParameter(String string, ArrayList arrayList) throws BemException {
        super(string, arrayList);
        this.createDefaultRestriction();
    }

    public StandardParameter(String string, String[] stringArray) throws BemException {
        super(string, stringArray);
        this.createDefaultRestriction();
    }

    private void createDefaultRestriction() {
        this.aRestriction = new ParameterRestriction(RESTRICTION_REASON, super.getSupportedValueRange(), true);
        super.addRestriction(this.aRestriction);
        this.aRestriction.setActive(true);
    }

    public ParameterRestriction getRestriction() {
        return this.aRestriction;
    }

    public void setRangeInRestriction(ParameterRange parameterRange, boolean bl) {
        this.aRestriction.setRange(parameterRange, bl);
        this.aRestriction.setActive(true);
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        if (parameterEvent.isRangeChanged()) {
            ParameterRange parameterRange = customerParameter.getEnabledValueRange();
            this.getRestriction().setRange(parameterRange, true);
        }
        if (parameterEvent.isValueChanged()) {
            this.setValue(customerParameter.getValue());
        }
    }
}

