/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.mapping;

import java.util.ArrayList;
import java.util.Iterator;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.mapping.Mapping;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.mapping.MappingInfo;
import se.ericsson.wcdma.rbs.bem.common.mim.MimOs155SpiTtp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSts3CspeTtp;
import se.ericsson.wcdma.rbs.bem.common.mim.MimVc4Ttp;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class DuwEtm4Mapping
extends Mapping {
    private static final String[] ALL_TERMINATION_TYPES = new String[]{"STM1_ETSI", "STM1_TTC", "OC3"};
    private static final String[] ALL_STANDARDS = new String[]{"ETSI", "ANSI", "TTC"};

    public static int getAllTerminationTypesLength() {
        return ALL_TERMINATION_TYPES.length;
    }

    public static String getAllTerminationTypesByIndex(int n) {
        return ALL_TERMINATION_TYPES[n];
    }

    public static String[] getAllTerminationTypes() {
        String[] stringArray = ALL_TERMINATION_TYPES;
        return stringArray;
    }

    public static String[] getAllStandards() {
        String[] stringArray = ALL_STANDARDS;
        return stringArray;
    }

    public static int getAllStandsLength() {
        return ALL_STANDARDS.length;
    }

    public static String getAllStandsByIndex(int n) {
        return ALL_STANDARDS[n];
    }

    public DuwEtm4Mapping() {
        ArrayList arrayList = DuwEtm4Mapping.createMappingInfo();
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.addMappingInfo((MappingInfo)iterator.next());
        }
    }

    protected static ArrayList createMappingInfo() {
        ArrayList<MappingInfo> arrayList = new ArrayList<MappingInfo>();
        arrayList.add(new MappingInfo("STM1_ETSI", "ETSI", MimOs155SpiTtp.MOTYPENAME, "lineNo", MAX_PCR_STM1, MAX_PCR_STM1, MIN_LINE_NO_STM1_DUW, MAX_LINE_NO_STM1_DUW, MAX_NO_OF_LINES_STM1_DUW, false, false, false, null));
        arrayList.add(new MappingInfo("STM1_TTC", "TTC", MimOs155SpiTtp.MOTYPENAME, "lineNo", MAX_PCR_STM1, MAX_PCR_STM1, MIN_LINE_NO_STM1_DUW, MAX_LINE_NO_STM1_DUW, MAX_NO_OF_LINES_STM1_DUW, false, false, false, null));
        arrayList.add(new MappingInfo("OC3", "ANSI", MimOs155SpiTtp.MOTYPENAME, "lineNo", MAX_PCR_OC3, MAX_PCR_OC3, MIN_LINE_NO_OC3_DUW, MAX_LINE_NO_OC3_DUW, MAX_NO_OF_LINES_OC3_DUW, false, false, false, null));
        return arrayList;
    }

    public String[] getSupportedTerminationTypes() {
        return ALL_TERMINATION_TYPES;
    }

    public String[] getSupportedStandards() {
        return ALL_STANDARDS;
    }

    public String getTerminationType(String string, BemMo bemMo) throws MoHandlerException {
        String string2 = null;
        if (string.equals(MimSts3CspeTtp.MOTYPENAME)) {
            string2 = "OC3";
        } else if (string.equals(MimVc4Ttp.MOTYPENAME)) {
            MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
            BemMo bemMo2 = moHandlerImpl.getParent(bemMo);
            Integer n = (Integer)moHandlerImpl.getAttribute(bemMo2, "standardMode");
            int n2 = n;
            if (n2 == 2) {
                string2 = "STM1_TTC";
            } else if (n2 == 1) {
                string2 = "STM1_ETSI";
            }
        }
        return string2;
    }

    public boolean supportsMoType(String string) {
        return string.equals(MimVc4Ttp.MOTYPENAME) || string.equals(MimSts3CspeTtp.MOTYPENAME);
    }
}

