/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractSwHandlingRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNodeConnectionListener;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemLanguageHelp;

public class AtmRepertoireRI
extends AbstractSwHandlingRI {
    private static final String NAME = "AtmRepertoire";
    private static final String[] myInstallationPhases = new String[]{"AddRepertoireForMigrationFromSTM1ToIpPhase", "AtmRepertoireLoadingPhase", "UpdateConfigurationPhase", "AtmPortDeletionPhase"};
    private static final String[] GIGABITETHERNET_REPERTOIRE = new String[]{"CPP_IP_Transport_CBM_R6K"};
    private static final String[] OC3STM1_REPERTOIRES = new String[]{"CPP_Basic_DU_noIP_R6K", "CPP_ATM_Transport_CBM3_STM1_R6K", "CPP_ATM_Transport_STM1_R6K"};
    private static final String[] NO_OC3STM1_REPERTOIRES = new String[]{"CPP_ATM_Transport_CBM3_noSTM1_R6K", "CPP_IP_Transport_CBM_R6K", "CPP_Basic_DU_noSTM1_R6K", "CPP_ATM_Transport_noSTM1_R6K"};
    private static final int ATTEMP_TIMES = 30;
    private static final int RETRY_INTERVAL_MS = 60000;

    public AtmRepertoireRI(Rbs rbs) {
        super(NAME, rbs, myInstallationPhases);
        this.setRoleForSwAllocation("Main_DUW");
    }

    public void install(String string) throws BemException {
        block22: {
            try {
                String string2;
                if (string.equals("AddRepertoireForMigrationFromSTM1ToIpPhase")) {
                    if (this.checkIfMigrationFromSTM1ToIp()) {
                        this.repertoiresToInstall = new Vector();
                        for (int i = 0; i < GIGABITETHERNET_REPERTOIRE.length; ++i) {
                            super.addRepertoiresToInstall(GIGABITETHERNET_REPERTOIRE[i]);
                        }
                        super.addRepToSwAllocationIfExisting();
                    }
                    break block22;
                }
                if (string.equals("AtmRepertoireLoadingPhase")) {
                    if (this.isLmSwapNeeded()) {
                        super.addRepToSwAllocationIfExisting();
                        super.deleteRepFromSwAllocationIfExisting();
                    }
                    break block22;
                }
                if (string.equals("UpdateConfigurationPhase") || string.equals("UpdateConfigurationForMigrationFromSTM1ToIpPhase")) {
                    String string3;
                    BemMo bemMo;
                    String[] stringArray;
                    if ((!string.equals("UpdateConfigurationPhase") || !this.checkIfLmSwapNeeded()) && (!string.equals("UpdateConfigurationForMigrationFromSTM1ToIpPhase") || !this.checkIfMigrationFromSTM1ToIp()) || (stringArray = (String[])(bemMo = this.rbs.getMoHandler().getRoot()).getAttribute(string3 = "faultTolerantCoreStates")).length <= 0) break block22;
                    for (int i = 0; i < 30; ++i) {
                        if (!DuwUtil.hasDualDuws() || DuwUtil.hasDualDuws() && (stringArray[0].indexOf("PassiveReady") != -1 || stringArray[1].indexOf("PassiveReady") != -1)) {
                            BemMo bemMo2 = this.rbs.getMoHandler().getMo(DuwUtil.getPrimaryDuwSlotLdn());
                            this.action(bemMo2, "updateConfiguration", new NalNameValue[0], false);
                            break block22;
                        }
                        try {
                            Nal.getFactory().sleep(120000L);
                        }
                        catch (InterruptedException interruptedException) {
                            throw new BemException("Sleep interrupted when waiting for reconnection.");
                        }
                        stringArray = (String[])bemMo.getAttribute(string3);
                        if (i != 30) continue;
                        throw new BemException("Wait for slot=1 or slot=2 to be PassiveReady. Time out for 30 miuntes!");
                    }
                    break block22;
                }
                if (string.equals("WaitForConnectionLostAndRestorePhase") || string.equals("WaitConnectLostAndRestore4MigSTM1ToIpPhase")) {
                    if (string.equals("WaitConnectLostAndRestore4MigSTM1ToIpPhase") && this.checkIfMigrationFromSTM1ToIp() || string.equals("WaitForConnectionLostAndRestorePhase") && this.checkIfLmSwapNeeded() && !this.isTransportOptionChanged() && !this.isEthernetLinkIpAddressChange()) {
                        try {
                            int n = 600;
                            ConnectionHandler connectionHandler = new ConnectionHandler(n);
                            Nal.getFactory().addConnectionListener(connectionHandler);
                            connectionHandler.waitForConnectionLost();
                            connectionHandler.waitForConnectionRestored();
                            Nal.getFactory().removeConnectionListener(connectionHandler);
                        }
                        catch (InterruptedException interruptedException) {
                            Nal.getLog().nalTrace(6, this.getClass(), " interupted by user");
                        }
                    }
                    break block22;
                }
                if (!string.equals("UpdateConfigurationSlot2Phase") && !string.equals("UpdateConfigurationSlot2ForMigrationFromSTM1ToIpPhase") || !DuwUtil.hasDualDuws() || (!string.equals("UpdateConfigurationSlot2Phase") || !this.checkIfLmSwapNeeded()) && (!string.equals("UpdateConfigurationSlot2ForMigrationFromSTM1ToIpPhase") || !this.checkIfMigrationFromSTM1ToIp())) break block22;
                BemMo bemMo = this.rbs.getMoHandler().getMo("ManagedElement=1,Equipment=1,Subrack=1,Slot=2");
                BemMo bemMo3 = this.rbs.getMoHandler().getRoot();
                String[] stringArray = (String[])bemMo3.getAttribute(string2 = "faultTolerantCoreStates");
                if (stringArray.length <= 0) break block22;
                for (int i = 0; i < 30; ++i) {
                    if (stringArray[0].indexOf("PassiveReady") != -1 || stringArray[1].indexOf("PassiveReady") != -1) {
                        this.action(bemMo, "updateConfiguration", new NalNameValue[0], true);
                        try {
                            Nal.getFactory().sleep(60000L);
                        }
                        catch (InterruptedException interruptedException) {
                            throw new BemException("Sleep interrupted when waiting for reconnection.");
                        }
                        return;
                    }
                    try {
                        Nal.getFactory().sleep(60000L);
                    }
                    catch (InterruptedException interruptedException) {
                        throw new BemException("Sleep interrupted when waiting for reconnection.");
                    }
                    stringArray = (String[])bemMo3.getAttribute(string2);
                }
                throw new BemException("Wait for slot=1 or slot=2 to be PassiveReady. Time out for 30 miuntes!");
            }
            catch (MoHandlerException moHandlerException) {
                throw new BemException("Get ManagedElement MO failure!");
            }
        }
    }

    public void uninstall(String string) throws BemException {
    }

    public String getDisplayName() {
        return NAME;
    }

    public String getLdn() {
        return null;
    }

    public boolean checkIfMigrationFromSTM1ToIp() throws BemException {
        if (!DuwUtil.hasDuw()) {
            return false;
        }
        String string = "IPoverGigabitEthernet_transportOption";
        String string2 = "firstOAMatm_terminationType";
        if (!this.rbs.isParameterSupported(string) || !this.rbs.isParameterSupported(string2)) {
            return false;
        }
        String string3 = this.rbs.getCustomerParameterObject(string).getValue();
        String string4 = this.rbs.getCustomerParameterServerObject(string).getLoadedValue();
        boolean bl = string4.equals("ipV4");
        boolean bl2 = string3.equals("ipV4");
        String string5 = this.rbs.getCustomerParameterServerObject(string2).getLoadedValue();
        boolean bl3 = !bl && (string5.indexOf("STM") != -1 || string5.indexOf("OC3") != -1);
        Nal.getLog().nalTrace(6, this.getClass(), " isOC3STM = " + bl3 + ", toIPv4 = " + bl2);
        return bl3 && bl2;
    }

    public boolean isLmSwapNeeded() throws BemException {
        boolean bl = false;
        if (DuwUtil.hasDuw()) {
            String string = "IPoverGigabitEthernet_transportOption";
            String string2 = "firstOAMatm_terminationType";
            if (this.rbs.isParameterSupported(string)) {
                String string3 = this.rbs.getCustomerParameterObject(string).getValue();
                String string4 = this.rbs.getCustomerParameterServerObject(string).getLoadedValue();
                boolean bl2 = string4.equals("ipV4");
                boolean bl3 = string3.equals("ipV4");
                if (this.rbs.isParameterSupported(string2)) {
                    boolean bl4;
                    String string5 = this.rbs.getCustomerParameterServerObject(string2).getLoadedValue();
                    String string6 = this.rbs.getCustomerParameterObject(string2).getValue();
                    boolean bl5 = !bl2 && (string5.indexOf("STM") != -1 || string5.indexOf("OC3") != -1);
                    boolean bl6 = bl4 = !bl3 && (string6.indexOf("STM") != -1 || string6.indexOf("OC3") != -1);
                    if (!(!bl5 && !bl4 || bl5 && bl4)) {
                        this.repertoiresToInstall = new Vector();
                        this.repertoiresToUninstall = new Vector();
                        if (bl4) {
                            int n;
                            for (n = 0; n < OC3STM1_REPERTOIRES.length; ++n) {
                                super.addRepertoiresToInstall(OC3STM1_REPERTOIRES[n]);
                            }
                            for (n = 0; n < NO_OC3STM1_REPERTOIRES.length; ++n) {
                                super.addRepertoiresToUninstall(NO_OC3STM1_REPERTOIRES[n]);
                            }
                        } else {
                            int n;
                            for (n = 0; n < NO_OC3STM1_REPERTOIRES.length; ++n) {
                                super.addRepertoiresToInstall(NO_OC3STM1_REPERTOIRES[n]);
                            }
                            for (n = 0; n < OC3STM1_REPERTOIRES.length; ++n) {
                                super.addRepertoiresToUninstall(OC3STM1_REPERTOIRES[n]);
                            }
                        }
                        bl = true;
                    }
                }
            }
        }
        Nal.getLog().nalTrace(6, this.getClass(), " Is LM swap needed = " + bl);
        return bl;
    }

    public boolean checkIfLmSwapNeeded() throws BemException {
        boolean bl = false;
        if (DuwUtil.hasDuw()) {
            String string = "IPoverGigabitEthernet_transportOption";
            String string2 = "firstOAMatm_terminationType";
            if (this.rbs.isParameterSupported(string)) {
                String string3 = this.rbs.getCustomerParameterObject(string).getValue();
                String string4 = this.rbs.getCustomerParameterServerObject(string).getLoadedValue();
                boolean bl2 = string4.equals("ipV4");
                boolean bl3 = string3.equals("ipV4");
                if (this.rbs.isParameterSupported(string2)) {
                    boolean bl4;
                    String string5 = this.rbs.getCustomerParameterServerObject(string2).getLoadedValue();
                    String string6 = this.rbs.getCustomerParameterObject(string2).getValue();
                    boolean bl5 = !bl2 && (string5.indexOf("STM") != -1 || string5.indexOf("OC3") != -1);
                    boolean bl6 = bl4 = !bl3 && (string6.indexOf("STM") != -1 || string6.indexOf("OC3") != -1);
                    if (!(!bl5 && !bl4 || bl5 && bl4)) {
                        bl = true;
                    }
                }
            }
        }
        Nal.getLog().nalTrace(6, this.getClass(), " LM swap is needed = " + bl);
        return bl;
    }

    private boolean isTransportOptionChanged() throws BemException {
        String string;
        String string2;
        boolean bl = false;
        String string3 = "IPoverGigabitEthernet_transportOption";
        if (this.rbs.isParameterSupported(string3) && !(string2 = this.rbs.getCustomerParameterObject(string3).getValue()).equals(string = this.rbs.getCustomerParameterServerObject(string3).getLoadedValue())) {
            bl = true;
        }
        return bl;
    }

    private boolean isEthernetLinkIpAddressChange() throws BemException {
        String string = "ipAddress";
        if (this.rbs.isParameterSupported(string)) {
            String string2 = this.rbs.getCustomerParameterObject(string).getValue();
            String string3 = this.rbs.getCustomerParameterServerObject(string).getLoadedValue();
            Nal.getLog().nalTrace(6, this.getClass(), "newIpAddress: " + string2 + ",  loadedIpAddress" + string3);
            if (!string2.equals(string3)) {
                return true;
            }
        }
        return false;
    }

    public static class ConnectionHandler
    implements NalNodeConnectionListener {
        private boolean connectionLost = false;
        private int timeoutInSeconds;

        public ConnectionHandler(int n) {
            this.timeoutInSeconds = n;
        }

        public void waitForConnectionLost() throws InterruptedException, BemException {
            int n = 0;
            while (!this.connectionLost && BemLanguageHelp.getEnvironment() != 1) {
                if (n >= this.timeoutInSeconds) {
                    throw new BemException("Timeout waiting for connectionLost after " + this.timeoutInSeconds + " seconds.");
                }
                if (n % 60 == 0) {
                    Nal.getLog().nalTrace(6, this.getClass(), " Waited for connectionLost for " + n + " seconds.");
                }
                Nal.getFactory().sleep(1000L);
                ++n;
            }
        }

        public void waitForConnectionRestored() throws InterruptedException, BemException {
            int n = 0;
            while (this.connectionLost && BemLanguageHelp.getEnvironment() != 1) {
                if (n >= this.timeoutInSeconds) {
                    throw new BemException("Timeout waiting for connectionRestored after " + this.timeoutInSeconds + " seconds.");
                }
                if (n % 60 == 0) {
                    Nal.getLog().nalTrace(6, this.getClass(), " Waited for connectionRestore for " + n + " seconds.");
                }
                Nal.getFactory().sleep(1000L);
                ++n;
            }
        }

        public void connectionLost() {
            this.connectionLost = true;
        }

        public void connectionRestored() {
            this.connectionLost = false;
        }
    }
}

