/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource;

import java.util.ArrayList;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.TerminationParameterList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.TerminationTypeParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.TimeSlotsInFractionParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.mapping.Mapping;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.AbstractTerminationRI;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDs0Bundle;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class FractionalRI
extends AbstractResourceItem {
    private static final String NAME = "Ds0Bundle";
    private static final String DS0BUNDLE_LDN = "," + MimDs0Bundle.MOTYPENAME + "=1";
    private static final String[] myInstallationPhases = new String[]{"FractionalAndImaTermCreationPhase", "FractionalAndImaTermDeletionPhase"};
    public static final String RESERVEDBY = "reservedBy";
    private AbstractTerminationRI terminationRI = null;
    private String loadedLdn = null;
    private TerminationTypeParameter terminationTypeParameter = null;
    private TimeSlotsInFractionParameter timeSlotsParameter = null;
    private MoHandler theMoHandler = null;
    private boolean isToBeInstalled = true;

    public FractionalRI(Rbs rbs, String string, TerminationParameterList terminationParameterList) {
        super(NAME, rbs, myInstallationPhases);
        this.loadedLdn = string;
        this.terminationTypeParameter = terminationParameterList.getTerminationTypeParameter();
        this.timeSlotsParameter = terminationParameterList.getTimeSlotsInFractionParameter();
        this.theMoHandler = rbs.getMoHandler();
    }

    public void setTerminationRI(AbstractTerminationRI abstractTerminationRI) {
        this.terminationRI = abstractTerminationRI;
    }

    public void install(String string) throws BemException {
        if (string.equals("FractionalAndImaTermCreationPhase")) {
            if (this.terminationRI != null) {
                Mapping mapping;
                boolean bl;
                if (this.isToBeInstalled() && (bl = (mapping = this.terminationRI.getMapping()).isFractional(this.getSelectedTerminationType()))) {
                    this.createDs0Bundle();
                }
            } else {
                throw new BemException(this.getClass().getName() + " install()");
            }
        }
    }

    private void createDs0Bundle() throws BemException {
        String[] stringArray = this.getSelectedTimeSlotsInFraction();
        int[] nArray = BemUtil.convertStringArrayToIntArray(stringArray);
        Vector<NalNameValue> vector = new Vector<NalNameValue>(0, 1);
        NalNameValue nalNameValue = Nal.getFactory().getNameValue("listOfTimeSlots", nArray);
        vector.add(nalNameValue);
        NalNameValue nalNameValue2 = Nal.getFactory().getNameValue("tdmMode", false);
        vector.add(nalNameValue2);
        String string = this.getFractionalLdn();
        this.createMoIfNotExisting(string, vector);
    }

    public void uninstall(String string) throws BemException {
        if (string.equals("FractionalAndImaTermDeletionPhase")) {
            if (this.terminationRI != null) {
                Mapping mapping;
                boolean bl;
                if (this.isToBeUnInstalled() && (bl = (mapping = this.terminationRI.getMapping()).isFractional(this.getSelectedTerminationType()))) {
                    this.deleteDs0Bundle();
                }
            } else {
                throw new BemException(this.getClass().getName() + " uninstall()");
            }
        }
    }

    private void deleteDs0Bundle() throws BemException {
        ArrayList arrayList = this.getReferencesToOtherMOs(this.loadedLdn);
        if (arrayList.isEmpty()) {
            this.deleteMoIfNotExisting(this.loadedLdn);
        }
    }

    private ArrayList getReferencesToOtherMOs(String string) throws BemException {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (string != null) {
            BemMo bemMo = this.theMoHandler.getMo(string);
            try {
                Object object = this.theMoHandler.getAttribute(bemMo, RESERVEDBY);
                if (object != null && object instanceof BemMo[]) {
                    BemMo[] bemMoArray = (BemMo[])object;
                    for (int i = 0; i < bemMoArray.length; ++i) {
                        if (bemMoArray[i].getDN() == null) continue;
                        arrayList.add(bemMoArray[i].getDN());
                    }
                }
            }
            catch (MoHandlerException moHandlerException) {
                // empty catch block
            }
        }
        return arrayList;
    }

    public boolean isToBeInstalled() {
        return this.isToBeInstalled;
    }

    public boolean isToBeUnInstalled() {
        return !this.isToBeInstalled;
    }

    public void setToBeInstalled() {
        this.isToBeInstalled = true;
    }

    public void setToBeUnInstalled() {
        this.isToBeInstalled = false;
    }

    protected String[] getSelectedTimeSlotsInFraction() {
        return this.timeSlotsParameter.getAllTimeSlots();
    }

    protected String getSelectedTerminationType() {
        return this.terminationTypeParameter.getValue();
    }

    public String getDisplayName() {
        return this.getName();
    }

    public String getFractionalLdn() throws BemException {
        String[] stringArray;
        String string = "";
        if (this.loadedLdn != null) {
            string = this.loadedLdn;
        } else if (this.terminationRI != null && (stringArray = this.terminationRI.getTerminationLdns()) != null && stringArray.length > 0) {
            string = stringArray[0] + DS0BUNDLE_LDN;
        }
        return string;
    }

    public String getLdn() {
        return "";
    }
}

