/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.duwterminationutil;

import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.mapping.DuwEtmc1Mapping;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.mapping.Mapping;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.AbstractTerminationRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.DuwTerminationRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.duwterminationutil.DuwTerminationHandler;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.resource.util.Etmc1TerminationUtil;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;

public class DuwEtmc1TerminationHandler
implements DuwTerminationHandler {
    private DuwTerminationRI terminationRi;
    private Mapping mapping;
    public static final String TERMINATION_TYPE_E1 = "E1";
    public static final String TERMINATION_TYPE_E1_FRACTIONAL = "fractional_E1";
    public static final String TERMINATION_TYPE_E1_IMA = "IMA_E1";
    public static final String TERMINATION_TYPE_J1 = "J1";
    public static final String TERMINATION_TYPE_J1_FRACTIONAL = "fractional_J1";
    public static final String TERMINATION_TYPE_J1_IMA = "IMA_J1";
    public static final String TERMINATION_TYPE_T1 = "T1";
    public static final String TERMINATION_TYPE_T1_FRACTIONAL = "fractional_T1";
    public static final String TERMINATION_TYPE_T1_IMA = "IMA_T1";
    public static final String TERMINATION_TYPE_STM1_ETSI = "STM1_ETSI";
    public static final String TERMINATION_TYPE_STM1_TTC = "STM1_TTC";
    public static final String TERMINATION_TYPE_OC3 = "OC3";
    private final String[] ALL_TERMINATION_TYPES = new String[]{"E1", "IMA_E1", "J1", "IMA_J1", "T1", "IMA_T1"};

    public DuwEtmc1TerminationHandler(DuwTerminationRI duwTerminationRI) {
        this.terminationRi = duwTerminationRI;
        this.mapping = new DuwEtmc1Mapping();
    }

    public void createTermination() throws BemException {
        Etmc1TerminationUtil.createTermination(this.terminationRi, this.getMapping());
    }

    public void deleteTermination() throws BemException {
        Etmc1TerminationUtil.deleteTermination(this.terminationRi);
    }

    public String[] getTerminationLdns() {
        return Etmc1TerminationUtil.getTerminationLdns(this.terminationRi, this.getMapping());
    }

    public String generateTerminationLdn(String string) {
        return Etmc1TerminationUtil.generateTerminationLdn(this.terminationRi, string, this.getMapping());
    }

    public String[] getSupportedTerminationTypes() {
        return this.ALL_TERMINATION_TYPES;
    }

    public String generateSynchTerminationLdn(String string) throws BemException {
        String string2 = ((AbstractTerminationRI)this.terminationRi).generateSynchTerminationLdn(string);
        return string2;
    }

    public String getLineId() throws BemException {
        String string = this.terminationRi.getLineIdFromBaseClass();
        return string;
    }

    public String getSubLineId() throws BemException {
        String string = this.terminationRi.getSubLineIdFromBaseClass();
        return string;
    }

    public String getSynchTerminationMoType() throws BemException {
        String string = this.terminationRi.getSynchTerminationMoTypeFromBaseClass();
        return string;
    }

    public String[] getSynchTerminations(String[] stringArray) throws BemException {
        String[] stringArray2 = this.terminationRi.getSynchTerminationsFromBaseClass(stringArray);
        return stringArray2;
    }

    public Mapping getMapping() {
        return this.mapping;
    }
}

