/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic;

import java.text.MessageFormat;
import java.util.ArrayList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.AbstractConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.DefaultRouterParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.IpRoutingRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.custparam.CabinetIpAddressParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.custparam.IpHostLinkIpAddressConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.custparam.TransportOptionParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.resource.EthernetLinkRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.resource.IpHostLinkRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.resource.IpRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.resource.ReconnectRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.IntegerConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.custparam.BooleanConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.custparam.DiffieHellmanGroupConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.custparam.EncryptionAlgorithmConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.custparam.IntegrityAlgorithmConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.custparam.IpSecTunnelEncryptionAlgorithmConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.custparam.IpSecTunnelIntergrityAlgorithmConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.custparam.OwnIdTypeConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.custparam.PeerIdTypeConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.custparam.ProtocolTypeConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.custparam.PseudoRandomFunctionConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.custparam.StringConversion;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.resource.DnsResolverRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.resource.IkePeerRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.resource.IpSecRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.resource.IpSecTunnelRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.resource.VpnInterfaceRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ipovergigabitethernet.util.IpSecUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.IpOverGigabitEthernetProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DualStackUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.BooleanCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.FQDNParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.FQDNRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IpAddressParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IpAddressRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.MomConverter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.OutOfRangeException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRestriction;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.StringRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.SubnetMaskParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.TrueFalseCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.URLParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.URLRange;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsSteps;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIkePeer;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpSec;
import se.ericsson.wcdma.rbs.bem.common.mim.MimIpSecTunnel;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceValue;

public class IpOamCI
extends AbstractConfigurationItem
implements CustomerParameterListener {
    public static final String name = "IpOamCI";
    private boolean isOpen = false;
    private IpRI ipRI;
    private IpHostLinkRI ipHostLinkRI;
    private EthernetLinkRI ethernetLinkRI;
    private IpRoutingRI ipRoutingRI;
    private ReconnectRI reconnectRI;
    private VpnInterfaceRI vpnInterfaceRI;
    private IpHostLinkRI ipHostLinkIpSecRI;
    private IkePeerRI ikePeerRI;
    private IpSecTunnelRI ipSecTunnelRI;
    public static final String NOIPSEC = "NON_IPSEC";
    public static final String IPSECB = "IPSEC_SINGLE_LINK";
    public static final String IPSECC = "IPSEC_DUAL_LINK";
    public static final Integer MIN_NODE_ID_VALUE_LENGTH = new Integer(0);
    public static final Integer MAX_NODE_ID_VALUE_LENGTH = new Integer(200);
    private CabinetIpAddressParameter ethernetLinkIpAddressCustParam;
    private IpAddressParameter ipHostLinkIpAddressCustParam;
    private SubnetMaskParameter subnetMaskCustParam;
    private DefaultRouterParameter defaultRouterCustParam;
    private TransportOptionParameter transportOptionParameter;
    private String loadedNodeIpAddress;
    private BooleanCustomerParameter dnsAutoConfigCustParam;
    private final ParameterRestriction restrictionOptional = new ParameterRestriction("Optional", 2);
    private IpOverGigabitEthernetProvider ipOverGigabitEthernetProvider;
    private static final String CLIENT_IDENTIFIER_TYPE_MANUAL = "MANUAL";

    public IpOamCI(Rbs rbs) {
        super(rbs);
    }

    public void checkConsistency() throws BemException {
        super.checkConsistency();
        if (!(this.rbs.getRbsStep().equals("STEP_CABINET") || DuwUtil.isMicroRbsDuw() && RbsSteps.isIntegrateStep(this.rbs.getRbsStep()) || this.transportOptionParameter.isValidValue())) {
            this.throwCustomerParameterException(this.transportOptionParameter, "Invalid CustomerParam: " + this.transportOptionParameter.getName() + " (cont):" + "\n   RBS class=" + this.rbs.getClass().getName() + "\n       maxNoOfSectors=" + this.rbs.getMaxNumberOfSectors() + "\n   Checked ConfigurationItem=" + this.getName() + "\n   ParameterNames=" + this.getParameterNames() + "\n  ");
        }
        if (this.isDhcpOamCpsNeedChecked()) {
            if (this.transportOptionParameter.getValue().equals("ipV4") && !this.ipOverGigabitEthernetProvider.isIpHostLinkIpInterfaceConfigByDHCP() && !this.ipHostLinkIpAddressCustParam.isValidValue()) {
                this.throwCustomerParameterException(this.ipHostLinkIpAddressCustParam, "Invalid CustomerParam: " + this.ipHostLinkIpAddressCustParam.getName() + " (cont):" + "\n   RBS class=" + this.rbs.getClass().getName() + "\n   Checked ConfigurationItem=" + this.getName() + "\n   ParameterNames=" + this.getParameterNames() + "\n  ");
            }
            if (!this.ipOverGigabitEthernetProvider.isIpHostLinkIpInterfaceConfigByDHCP() && this.dnsAutoConfigCustParam.getBooleanValue()) {
                this.throwCustomerParameterException(this.dnsAutoConfigCustParam, "Invalid CustomerParam: " + this.dnsAutoConfigCustParam.getName() + " (cont):" + "\n   RBS class=" + this.rbs.getClass().getName() + "\n   Checked ConfigurationItem=" + this.getName() + "\n   ParameterNames=" + this.getParameterNames() + "\n  ");
            }
            this.checkDhcpOamConsistency();
        }
        IpSecUtil.checkIpsec(this.rbs, "OamIpHost_");
    }

    private boolean isDhcpOamCpsNeedChecked() throws BemException {
        boolean bl;
        boolean bl2 = bl = !DualStackUtil.isDualStackNode() || this.rbs.getRbsStep().equals("STEP_EXPANSION");
        if (bl) {
            boolean bl3 = this.rbs.getRbsStep().equals("STEP_INT_OAM") || this.rbs.getRbsStep().equals("STEP_OAM");
            return bl3;
        }
        return bl;
    }

    private void checkDhcpOamConsistency() throws BemException {
        Object object;
        if (DuwUtil.isPureDuwV2()) {
            if (this.ipOverGigabitEthernetProvider.isIpHostLinkIpInterfaceConfigByDHCP()) {
                if (this.ipHostLinkIpAddressCustParam.isValidValue()) {
                    this.throwCustomerParameterException(this.ipHostLinkIpAddressCustParam, "Invalid CustomerParam: " + this.ipHostLinkIpAddressCustParam.getName() + " (cont):" + "\n   RBS class=" + this.rbs.getClass().getName() + "\n   Checked ConfigurationItem=" + this.getName() + "\n   ParameterNames=" + this.getParameterNames() + "\n  ");
                }
                if (this.ipOverGigabitEthernetProvider.getClientIdentifierType().getValue().equals(CLIENT_IDENTIFIER_TYPE_MANUAL) && (this.ipOverGigabitEthernetProvider.getClientIdentifier().getValue() == null || this.ipOverGigabitEthernetProvider.getClientIdentifier().getValue().equals("") || this.ipOverGigabitEthernetProvider.getClientIdentifier().getValue().equals("##UNDEFINED"))) {
                    this.throwCustomerParameterException(this.ipOverGigabitEthernetProvider.getClientIdentifier(), "Invalid CustomerParam: ClientIdentifier must be set when ClientIdentifierType is set to MANUAL!");
                }
            }
        } else if (this.ipOverGigabitEthernetProvider.isIpHostLinkIpInterfaceConfigByDHCP()) {
            object = this.ipOverGigabitEthernetProvider.getIpHostLinkConfigurationMode();
            this.throwCustomerParameterException((CustomerParameter)object, "Invalid CustomerParam: " + object.getName() + " (cont):" + "\n   RBS class=" + this.rbs.getClass().getName() + "\n   Checked ConfigurationItem=" + this.getName() + "\n   ParameterNames=" + this.getParameterNames() + "\n  ");
        }
        if ((object = this.ipOverGigabitEthernetProvider.getOamDnsResolverRI()) != null) {
            CustomerParameterImpl customerParameterImpl = (CustomerParameterImpl)this.rbs.getCustomerParameterObject("OamIpHost_IkePeer_peerIpAddress");
            String string = customerParameterImpl.getValue();
            FQDNRange fQDNRange = (FQDNRange)customerParameterImpl.getEnabledValueRange();
            if (fQDNRange.isValidDomainName(string) && !((DnsResolverRI)object).shouldRiBeInstalled()) {
                String string2 = "Checked ConfigurationItem=" + this.getName() + ":\n" + "PeerIpAddress of oamIkePeer is a domain but dnsResolver is not configured.\n";
                throw new BemException(string2);
            }
        }
    }

    public boolean open() throws BemException {
        if (this.isOpen) {
            throw new BemException("IpOamCIopen() Already open");
        }
        this.setupProviders();
        this.createCustomerParameters();
        this.createAllResourceItems();
        this.initialiseCustomerParameters();
        this.initTransportOptionCp();
        this.loadedNodeIpAddress = this.determineNodeIpAddress();
        this.ipRI.setRestrictedTransportOption();
        this.isOpen = true;
        return this.isOpen;
    }

    private void createCustomerParameters() throws BemException {
        this.ipHostLinkIpAddressCustParam = new IpAddressParameter("OamIpHost_oamIpAddress", new IpAddressRange());
        IpHostLinkIpAddressConversion ipHostLinkIpAddressConversion = new IpHostLinkIpAddressConversion();
        this.ipHostLinkIpAddressCustParam.setMomConverter(ipHostLinkIpAddressConversion);
        this.addParameter(this.ipHostLinkIpAddressCustParam);
        String[] stringArray = new String[]{"atm", "ipV4"};
        this.transportOptionParameter = new TransportOptionParameter("IPoverGigabitEthernet_transportOption", stringArray);
        this.addParameter(this.transportOptionParameter);
        String[] stringArray2 = new String[]{"FALSE", "TRUE"};
        this.dnsAutoConfigCustParam = new BooleanCustomerParameter("OamIpHost_dnsAutoConfig", new EnumeratedRange(stringArray2), "FALSE", "TRUE");
        this.dnsAutoConfigCustParam.addCustomerParameterListener(this);
        this.addParameter(this.dnsAutoConfigCustParam);
        String[] stringArray3 = new String[]{"EMPTY", "FDN", "IP_Address", "HWID"};
        Enumeration enumeration = new Enumeration("nodeIdType", stringArray3);
        this.addParameter(enumeration);
        StringParameter stringParameter = new StringParameter("nodeIdValue", new StringRange(MIN_NODE_ID_VALUE_LENGTH, MAX_NODE_ID_VALUE_LENGTH));
        this.addParameter(stringParameter);
        this.createIpSecCustomerParameters();
        this.createIpSecTunnelCustomerParameters();
        this.createIkePeerCustomerParameters();
    }

    private void setupProviders() throws BemException {
        if (this.ipOverGigabitEthernetProvider == null) {
            this.ipOverGigabitEthernetProvider = (IpOverGigabitEthernetProvider)this.getRbs().getProvider(IpOverGigabitEthernetProvider.class);
            if (this.ipOverGigabitEthernetProvider != null) {
                CustomerParameter customerParameter = this.ipOverGigabitEthernetProvider.getEtxSlotParameter();
                if (customerParameter != null) {
                    customerParameter.addCustomerParameterListener(this);
                }
            } else {
                throw new BemException("IpOamCI.setupProviders() cannot setup ipOverGigabitEthernetProvider");
            }
        }
    }

    private void createIpSecCustomerParameters() throws BemException {
        if (!this.ipOverGigabitEthernetProvider.isIpSecCpCreated()) {
            URLParameter uRLParameter = new URLParameter("IpSec_autoUpdateCertEnrollmentServer", new URLRange(new String[]{"http://", "https://"}, MimIpSec.MINLEN_AUTOUPDATECERTENROLLMENTSERVER, MimIpSec.MAXLEN_AUTOUPDATECERTENROLLMENTSERVER));
            StringConversion stringConversion = new StringConversion(MimIpSec.MOTYPENAME, "autoUpdateCertEnrollmentServer");
            uRLParameter.setMomConverter(stringConversion);
            uRLParameter.setDefaultValue(MimIpSec.DEFAULT_AUTOUPDATECERTENROLLMENTSERVER);
            uRLParameter.addRestriction(this.restrictionOptional);
            this.addParameter(uRLParameter);
            String[] stringArray = new String[]{NOIPSEC, IPSECB, IPSECC};
            Enumeration enumeration = new Enumeration("IpSec_configType", stringArray);
            enumeration.setDefaultValue(NOIPSEC);
            this.addParameter(enumeration);
        }
    }

    private void createIpSecTunnelCustomerParameters() {
        String string = null;
        String string2 = null;
        string2 = "OamIpHost_";
        string = string2 + "IpSecTunnel_protocolType";
        CustomerParameterImpl customerParameterImpl = new Enumeration(string, new EnumeratedRange(new String[]{"ANY", "ICMP", "TCP", "UDP", "SCTP", "RAWIP"}));
        Object object = new ProtocolTypeConversion(MimIpSecTunnel.MOTYPENAME, "tsProtocols");
        customerParameterImpl.setMomConverter((MomConverter)object);
        this.addParameter(customerParameterImpl);
        string = string2 + "IpSecTunnel_tsLocalIpAddress";
        customerParameterImpl = new IpAddressParameter(string, new IpAddressRange());
        object = new StringConversion(MimIpSecTunnel.MOTYPENAME, "IpSecTunnel_tsLocalIpAddress");
        customerParameterImpl.setMomConverter((MomConverter)object);
        this.addParameter(customerParameterImpl);
        string = string2 + "IpSecTunnel_tsLocalIpAddressMask";
        customerParameterImpl = new IntegerParameter(string, new IntegerRange(0, 32));
        object = new IntegerConversion(MimIpSecTunnel.MOTYPENAME, "IpSecTunnel_tsLocalIpAddressMask");
        customerParameterImpl.setMomConverter((MomConverter)object);
        this.addParameter(customerParameterImpl);
        string = string2 + "IpSecTunnel_tsRemoteIpAddress";
        customerParameterImpl = new IpAddressParameter(string, new IpAddressRange());
        object = new StringConversion(MimIpSecTunnel.MOTYPENAME, "IpSecTunnel_tsRemoteIpAddress");
        customerParameterImpl.setMomConverter((MomConverter)object);
        this.addParameter(customerParameterImpl);
        string = string2 + "IpSecTunnel_tsRemoteIpAddressMask";
        customerParameterImpl = new IntegerParameter(string, new IntegerRange(0, 32));
        object = new IntegerConversion(MimIpSecTunnel.MOTYPENAME, "IpSecTunnel_tsRemoteIpAddressMask");
        customerParameterImpl.setMomConverter((MomConverter)object);
        this.addParameter(customerParameterImpl);
        string = string2 + "IpSecTunnel_pfs";
        customerParameterImpl = new TrueFalseCustomerParameter(string);
        customerParameterImpl.setMomConverter(new BooleanConversion(MimIpSecTunnel.MOTYPENAME, "IpSecTunnel_pfs"));
        this.addParameter(customerParameterImpl);
        for (int i = 0; i < 11; ++i) {
            string = MessageFormat.format(string2 + "IpSecTunnel_ChildSaTf_{0}_encryptionAlgorithm", new Integer(i + 1));
            object = new Enumeration(string, new EnumeratedRange(new String[]{"NULL", "AES_CBC_128", "AES_CBC_256", "ALG_3DES_CBC", "AES_128_GCM_128", "AES_256_GCM_128"}));
            IpSecTunnelEncryptionAlgorithmConversion ipSecTunnelEncryptionAlgorithmConversion = new IpSecTunnelEncryptionAlgorithmConversion(MimIpSecTunnel.MOTYPENAME, "encryptionAlgorithm");
            ((CustomerParameterImpl)object).setMomConverter(ipSecTunnelEncryptionAlgorithmConversion);
            this.addParameter((CustomerParameter)object);
            string = MessageFormat.format(string2 + "IpSecTunnel_ChildSaTf_{0}_integrityAlgorithm", new Integer(i + 1));
            Enumeration enumeration = new Enumeration(string, new EnumeratedRange(new String[]{"AES_XCBC_MAC_96", "HMAC_SHA_1_96", "HMAC_MD5_96", "HMAC_SHA2_256_128", "AES_GCM"}));
            IpSecTunnelIntergrityAlgorithmConversion ipSecTunnelIntergrityAlgorithmConversion = new IpSecTunnelIntergrityAlgorithmConversion(MimIpSecTunnel.MOTYPENAME, "integrityAlgorithm");
            enumeration.setMomConverter(ipSecTunnelIntergrityAlgorithmConversion);
            this.addParameter(enumeration);
        }
    }

    private void createIkePeerCustomerParameters() {
        CustomerParameterImpl customerParameterImpl;
        CustomerParameterImpl customerParameterImpl2;
        Object object;
        Object object2;
        String string = "OamIpHost_";
        EnumeratedRange enumeratedRange = new EnumeratedRange(new String[]{"GROUP_2", "GROUP_14", "GROUP_19", "GROUP_20"});
        EnumeratedRange enumeratedRange2 = new EnumeratedRange(new String[]{"AES_CBC_128", "AES_CBC_256", "ALG_3DES_CBC", "AES_128_GCM_128", "AES_256_GCM_128"});
        EnumeratedRange enumeratedRange3 = new EnumeratedRange(new String[]{"AES_XCBC_MAC_96", "HMAC_MD5_96", "HMAC_SHA_1_96", "HMAC_SHA2_256_128", "AES_GCM"});
        EnumeratedRange enumeratedRange4 = new EnumeratedRange(new String[]{"AES_XCBC_PRF128", "HMAC_SHA1", "HMAC_MD5", "HMAC_SHA2_256"});
        for (int i = 0; i < 6; ++i) {
            object2 = new Enumeration(MessageFormat.format(string + "IkePeer_IkeSaTf_{0}_diffieHellmanGroup", String.valueOf(i + 1)), enumeratedRange);
            ((CustomerParameterImpl)object2).setMomConverter(new DiffieHellmanGroupConversion());
            super.addParameter((CustomerParameter)object2);
            object = new Enumeration(MessageFormat.format(string + "IkePeer_IkeSaTf_{0}_encryptionAlgorithm", String.valueOf(i + 1)), enumeratedRange2);
            ((CustomerParameterImpl)object).setMomConverter(new EncryptionAlgorithmConversion());
            super.addParameter((CustomerParameter)object);
            customerParameterImpl2 = new Enumeration(MessageFormat.format(string + "IkePeer_IkeSaTf_{0}_integrityAlgorithm", String.valueOf(i + 1)), enumeratedRange3);
            customerParameterImpl2.setMomConverter(new IntegrityAlgorithmConversion());
            super.addParameter(customerParameterImpl2);
            customerParameterImpl = new Enumeration(MessageFormat.format(string + "IkePeer_IkeSaTf_{0}_pseudoRandomFunction", String.valueOf(i + 1)), enumeratedRange4);
            customerParameterImpl.setMomConverter(new PseudoRandomFunctionConversion());
            super.addParameter(customerParameterImpl);
        }
        EnumeratedRange enumeratedRange5 = new EnumeratedRange(new String[]{"ANY", "IP_V4_ADDRESS", "FQDN", "AUTOMATIC"});
        object2 = new EnumeratedRange(new String[]{"AUTOMATIC", "IP_V4_ADDRESS", "FQDN", "AUTOMATIC_DN"});
        object = new StringRange(new Integer(1), new Integer(256));
        customerParameterImpl2 = new FQDNParameter(string + "IkePeer_peerIpAddress", new FQDNRange(new Integer(1), new Integer(254)));
        customerParameterImpl2.setMomConverter(new StringConversion(MimIkePeer.MOTYPENAME, "peerIpAddress"));
        this.addParameter(customerParameterImpl2);
        customerParameterImpl = new StringParameter(string + "IkePeer_peerIdFqdn", (StringRange)object);
        customerParameterImpl.setMomConverter(new StringConversion(MimIkePeer.MOTYPENAME, "idFqdn"));
        this.addParameter(customerParameterImpl);
        Enumeration enumeration = new Enumeration(string + "IkePeer_peerIdType", enumeratedRange5);
        enumeration.setMomConverter(new PeerIdTypeConversion());
        this.addParameter(enumeration);
        IpAddressParameter ipAddressParameter = new IpAddressParameter(string + "IkePeer_peerIpv4Address", new IpAddressRange());
        ipAddressParameter.setMomConverter(new StringConversion(MimIkePeer.MOTYPENAME, "ipv4Address"));
        this.addParameter(ipAddressParameter);
        StringParameter stringParameter = new StringParameter(string + "IkePeer_ownIdFqdn", (StringRange)object);
        stringParameter.setMomConverter(new StringConversion(MimIkePeer.MOTYPENAME, "idFqdn"));
        this.addParameter(stringParameter);
        Enumeration enumeration2 = new Enumeration(string + "IkePeer_ownIdType", (EnumeratedRange)object2);
        enumeration2.setMomConverter(new OwnIdTypeConversion());
        this.addParameter(enumeration2);
        IpAddressParameter ipAddressParameter2 = new IpAddressParameter(string + "IkePeer_ownIpv4Address", new IpAddressRange());
        ipAddressParameter2.setMomConverter(new StringConversion(MimIkePeer.MOTYPENAME, "ipv4Address"));
        this.addParameter(ipAddressParameter2);
    }

    private void createAllResourceItems() throws BemException {
        if (!this.getRbs().getRbsStep().equals("STEP_CABINET")) {
            this.ipHostLinkRI = new IpHostLinkRI(this.getRbs(), this.ipOverGigabitEthernetProvider);
            IpSecRI ipSecRI = new IpSecRI(this.getRbs());
            this.vpnInterfaceRI = new VpnInterfaceRI(this.getRbs(), null, true);
            this.ipHostLinkIpSecRI = new IpHostLinkRI(this.getRbs(), this.ipOverGigabitEthernetProvider, this.vpnInterfaceRI.getMoi());
            this.ikePeerRI = new IkePeerRI(this.getRbs(), ipSecRI.getMoi(), 2);
            this.ipSecTunnelRI = new IpSecTunnelRI(this.getRbs(), this.ikePeerRI.getMoi(), this.vpnInterfaceRI.getMoi(), 2);
        }
        this.reconnectRI = new ReconnectRI(this.getRbs());
        this.ipRI = new IpRI(this.getRbs());
        this.ethernetLinkRI = new EthernetLinkRI(this.getRbs());
        this.ipRoutingRI = new IpRoutingRI(this.getRbs());
    }

    public String getName() {
        return name;
    }

    public ArrayList getNeededRIs() throws BemException {
        Object object;
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        String string = NOIPSEC;
        if (!this.getRbs().getRbsStep().equals("STEP_CABINET")) {
            string = this.getRbs().getCustomerParameter("IpSec_configType");
        }
        this.changeIpAddressifNeeded();
        if (!this.ipOverGigabitEthernetProvider.isIpHostLinkIpInterfaceConfigByDHCP()) {
            object = this.determineNodeIpAddress();
            this.reconnectRI.setNewNodeIpAddress((String)object);
            if (this.isReconnectNeeded((String)object)) {
                arrayList.add(this.reconnectRI);
            }
        } else {
            this.reconnectRI.setNodeIpAddressConfiguredByDHCP(true);
            arrayList.add(this.reconnectRI);
        }
        if (this.ethernetLinkRI.shouldRiBeInstalled()) {
            arrayList.add(this.ethernetLinkRI);
        }
        if (string.equals(NOIPSEC)) {
            object = null;
            if (!this.ipHostLinkIpAddressCustParam.getValue().equals("##UNDEFINED") && this.ipHostLinkRI.shouldRiBeInstalled()) {
                object = this.ipOverGigabitEthernetProvider.getOamIpInterface();
                this.ipHostLinkRI.setIpInterface((MoInstance)object);
                arrayList.add(this.ipHostLinkRI);
            }
            if (this.ipOverGigabitEthernetProvider.isIpHostLinkIpInterfaceConfigByDHCP()) {
                object = this.ipOverGigabitEthernetProvider.getOamIpInterface();
                if (this.dnsAutoConfigCustParam.getBooleanValue()) {
                    this.ipRI.setIpInterface((MoInstance)object);
                }
                if (this.ipHostLinkRI.shouldRiBeInstalled()) {
                    this.ipHostLinkRI.setIpInterface((MoInstance)object);
                    arrayList.add(this.ipHostLinkRI);
                }
            }
        } else {
            if (!this.ipHostLinkIpAddressCustParam.getValue().equals("##UNDEFINED") && this.ipHostLinkIpSecRI.getRiBeInstalled()) {
                arrayList.add(this.ipHostLinkIpSecRI);
            }
            if (this.vpnInterfaceRI.shouldRiBeInstalled()) {
                object = this.ipOverGigabitEthernetProvider.getIpAccessHostEtRefOamVpnInterface();
                this.vpnInterfaceRI.setIpAccessHostEtMoi((MoInstance)object);
                arrayList.add(this.vpnInterfaceRI);
            }
            if (this.ikePeerRI.shouldRiBeInstalled()) {
                arrayList.add(this.ikePeerRI);
            }
            if (this.ipSecTunnelRI.shouldRiBeInstalled()) {
                arrayList.add(this.ipSecTunnelRI);
            }
        }
        if (this.ipRI.shouldRiBeInstalled()) {
            arrayList.add(this.ipRI);
        }
        arrayList.add(this.ipRoutingRI);
        return arrayList;
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setCustomerParameters(ServiceValue serviceValue) throws OutOfRangeException, CustomerParameterException, BemException {
        String string;
        String[] stringArray = this.getAllCustomerParameterNames();
        String string2 = serviceValue.getValue("OamIpHost_oamIpAddress");
        if (string2 != null || this.ipOverGigabitEthernetProvider.isIpHostLinkIpInterfaceConfigByDHCP()) {
            this.transportOptionParameter.setValue("ipV4");
        }
        if ((string = serviceValue.getValue("firstOAMatm_atmIpAddress")) != null) {
            this.transportOptionParameter.setValue("atm");
        }
        super.setCustomerParametersFromSV(stringArray, serviceValue);
    }

    private void initialiseCustomerParameters() throws BemException {
        String string = null;
        String string2 = null;
        this.ethernetLinkIpAddressCustParam = new CabinetIpAddressParameter();
        this.subnetMaskCustParam = new SubnetMaskParameter();
        if (this.ethernetLinkRI.isInstalled()) {
            string = this.ethernetLinkRI.getLoadedValue("ipAddress");
            string2 = this.ethernetLinkRI.getLoadedValue("subnetMask");
            this.ethernetLinkIpAddressCustParam.setLoadedValue(string);
            this.subnetMaskCustParam.setLoadedValue(string2);
        } else {
            this.ethernetLinkIpAddressCustParam.setDefaultValue("169.254.1.1");
            this.subnetMaskCustParam.setDefaultValue("255.255.0.0");
        }
        String string3 = null;
        this.defaultRouterCustParam = new DefaultRouterParameter();
        if (this.ipRoutingRI.isInstalled() && this.ipRoutingRI.getDefaultRouterEntry() != null) {
            try {
                string3 = (String)this.ipRoutingRI.getDefaultRouterEntry().getMemberValue("nextHopIpAddr");
                this.defaultRouterCustParam.setLoadedValue(string3);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                throw new BemException(this.getClass().getName(), "initialiseCustomerParameters()", null, "\tCould not find field innextHopIpAddr", noSuchFieldException);
            }
        }
        super.addParameter(this.ethernetLinkIpAddressCustParam);
        super.addParameter(this.subnetMaskCustParam);
        super.addParameter(this.defaultRouterCustParam);
        this.ethernetLinkIpAddressCustParam.addRestriction(this.restrictionOptional);
        this.subnetMaskCustParam.addRestriction(this.restrictionOptional);
        this.defaultRouterCustParam.addRestriction(this.restrictionOptional);
        this.ethernetLinkRI.registerCustomerParameter(this.ethernetLinkIpAddressCustParam);
        this.ethernetLinkRI.registerCustomerParameter(this.subnetMaskCustParam);
        this.ipRoutingRI.registerCustomerParameter(this.defaultRouterCustParam);
    }

    private String determineNodeIpAddress() {
        String string = this.transportOptionParameter.getValue();
        String string2 = string.equals("ipV4") ? this.ipHostLinkIpAddressCustParam.getValue() : this.ethernetLinkIpAddressCustParam.getValue();
        return string2;
    }

    private void changeIpAddressifNeeded() throws BemException {
        String string = this.transportOptionParameter.getValue();
        String string2 = this.ethernetLinkIpAddressCustParam.getValue();
        String string3 = this.ipHostLinkIpAddressCustParam.getValue();
        if (string.equals("ipV4") && this.transportOptionParameter.hasValueChanged()) {
            this.ethernetLinkRI.setShouldBeReset(true);
            if (string2.equals(string3)) {
                this.ethernetLinkIpAddressCustParam.setValue("169.254.1.1");
                this.subnetMaskCustParam.setValue("255.255.0.0");
            }
        } else if (string.equals("atm") && this.transportOptionParameter.hasValueChanged()) {
            CustomerParameter customerParameter = this.ipOverGigabitEthernetProvider.getOamSubnetMask();
            this.subnetMaskCustParam.setValue(customerParameter.getValue());
            this.ethernetLinkIpAddressCustParam.setValue(string3);
            this.ipHostLinkRI.setShouldBeDeleted(true);
        }
    }

    private boolean isReconnectNeeded(String string) {
        boolean bl = false;
        if (!this.loadedNodeIpAddress.equals(string) && !this.isConfigurationFromBasicCV()) {
            bl = true;
        }
        if (this.transportOptionParameter.hasValueChanged()) {
            bl = true;
        }
        return bl;
    }

    private boolean isConfigurationFromBasicCV() {
        boolean bl = this.rbs.getRbsStep().equals("STEP_CABINET");
        boolean bl2 = true;
        try {
            if (this.ethernetLinkRI != null && !this.ethernetLinkRI.isInstalled()) {
                bl2 = false;
            }
        }
        catch (BemException bemException) {
            bl2 = false;
        }
        return bl && !bl2;
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        String string = customerParameter.getName();
        if (string.equals("IPoverGigabitEthernet_etIPSynchSlot")) {
            try {
                this.initTransportOptionCp();
            }
            catch (BemException bemException) {
                Nal.getLog().nalTrace(1, this.getClass(), "Failed to init transport option customer parameter", bemException);
            }
        }
    }

    private void initTransportOptionCp() throws BemException {
        boolean bl = this.ipOverGigabitEthernetProvider.isIpCapable();
        if (!bl) {
            EnumeratedRange enumeratedRange = Enumeration.newEnumeratedValueRange(new String[]{"atm"});
            this.transportOptionParameter.getRestriction().setRange(enumeratedRange, true);
        } else if (bl) {
            if (DuwUtil.hasDuw() && !DuwUtil.isAtmSupported()) {
                EnumeratedRange enumeratedRange = Enumeration.newEnumeratedValueRange(new String[]{"ipV4"});
                this.transportOptionParameter.getRestriction().setRange(enumeratedRange, true);
            } else {
                EnumeratedRange enumeratedRange = Enumeration.newEnumeratedValueRange(new String[]{"atm", "ipV4"});
                this.transportOptionParameter.getRestriction().setRange(enumeratedRange, true);
            }
        }
    }
}

