/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.ExternalNodeRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.SupportSystemAvailableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource.SupportSystemControlRI;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEquipmentSupportFunction;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class SupportSystemManager {
    private final Rbs rbs;
    private final MoInstance[] equipmentSupportFunctionMoi = new MoInstance[2];
    private SupportSystemAvailableRI supportSystemAvailableRI;
    private SupportSystemControlRI[] supportSystemControlRIs = new SupportSystemControlRI[2];
    private final boolean supportSystemAvailable;
    private final boolean configureSupportSystemMandatory;
    private final int defaultNumberOfExternalNodesIfSecondary;
    private List externalNodeRis = new ArrayList();

    public SupportSystemManager(Rbs rbs, boolean bl, boolean bl2, int n) {
        this.rbs = rbs;
        this.supportSystemAvailable = bl;
        this.configureSupportSystemMandatory = bl2;
        for (int i = 0; i < 2; ++i) {
            this.equipmentSupportFunctionMoi[i] = new FixedRdnMoi(rbs.getRootMoi(), MimEquipmentSupportFunction.MOTYPENAME, String.valueOf(i + 1));
        }
        this.defaultNumberOfExternalNodesIfSecondary = n;
    }

    public void createAllRIs() throws BemException {
        int n;
        this.supportSystemAvailableRI = new SupportSystemAvailableRI(this.rbs, this.supportSystemAvailable);
        for (n = 0; n < 2; ++n) {
            this.supportSystemControlRIs[n] = new SupportSystemControlRI(this.rbs, this.equipmentSupportFunctionMoi[n]);
        }
        for (n = 0; n < this.defaultNumberOfExternalNodesIfSecondary; ++n) {
            ExternalNodeRI externalNodeRI = new ExternalNodeRI(this.rbs, n + 1);
            this.externalNodeRis.add(externalNodeRI);
        }
    }

    public ArrayList getRIsToBeInstalled() throws BemException {
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        arrayList.add(this.supportSystemAvailableRI);
        arrayList.add(this.supportSystemControlRIs[0]);
        arrayList.add(this.supportSystemControlRIs[1]);
        this.addExternalNodeRisIfNeeded(arrayList);
        return arrayList;
    }

    public ArrayList getRIsToUninstall() throws BemException {
        ArrayList<SupportSystemControlRI> arrayList = new ArrayList<SupportSystemControlRI>();
        this.addExternalNodeRisToDelete(arrayList);
        for (int i = 0; i < 2; ++i) {
            if (this.supportSystemControlRIs[i] == null) continue;
            arrayList.add(this.supportSystemControlRIs[i]);
        }
        return arrayList;
    }

    public String getLoadedValue(int n) throws BemException {
        String string = "TRUE";
        String string2 = this.equipmentSupportFunctionMoi[n - 1].getLdn();
        MoHandler moHandler = this.rbs.getMoHandler();
        BemMo bemMo = moHandler.getMo(string2);
        try {
            if (bemMo.isExisting()) {
                Boolean bl = (Boolean)moHandler.getAttribute(bemMo, "supportSystemControl");
                if (bl != null) {
                    string = bl.booleanValue() ? "TRUE" : "FALSE";
                }
            } else if (n == 2) {
                string = "##UNDEFINED";
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(moHandlerException.toString());
        }
        catch (NalCmException nalCmException) {
            throw new BemException(nalCmException.toString());
        }
        return string;
    }

    public boolean isConfigureSupportSystemMandatory() {
        return this.configureSupportSystemMandatory;
    }

    protected boolean isSupportSystemControlInstalled(int n) throws BemException {
        return this.supportSystemControlRIs[n - 1].isInstalled();
    }

    public boolean isSupportSystemAvailable() {
        return this.supportSystemAvailable;
    }

    private void addExternalNodeRisIfNeeded(List list) throws BemException {
        if (this.defaultNumberOfExternalNodesIfSecondary > 0 && this.supportSystemControlRIs[0].getConfiguredSupportSystemControlValue().equals("FALSE") && (this.rbs.getRbsStep().equals("STEP_CABINET") || this.rbs.getRbsStep().equals("STEP_EXPANSION"))) {
            list.addAll(this.externalNodeRis);
        }
    }

    private void addExternalNodeRisToDelete(List list) throws BemException {
        CustomerParameter customerParameter;
        if (this.defaultNumberOfExternalNodesIfSecondary > 0 && this.rbs.getRbsStep().equals("STEP_EXPANSION") && (customerParameter = this.rbs.getCustomerParameterObject("supportSystemControl")).hasValueChanged() && customerParameter.getValue().equals("TRUE")) {
            list.addAll(this.externalNodeRis);
        }
    }
}

