/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.resource;

import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimExternalNode;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class ExternalNodeRI
extends AbstractResourceItem {
    public static final String moName = MimExternalNode.MOTYPENAME;
    private static final String[] installationPhases = new String[]{"SupportSystemControlPhase", "ExternalNodeCreationPhase"};
    private String unitNumber;
    private final String ldn;

    public ExternalNodeRI(Rbs rbs, int n) throws BemException {
        super(moName, rbs, installationPhases);
        this.unitNumber = Integer.toString(n);
        MoInstance moInstance = this.rbs.getEquipmentMoi();
        FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(moInstance, moName, this.unitNumber);
        this.ldn = fixedRdnMoi.getLdn();
    }

    public String getDisplayName() {
        return moName + ": " + this.getLdn();
    }

    public String getLdn() {
        return this.ldn;
    }

    public void install(String string) throws BemException {
        CustomerParameter customerParameter;
        if (string.equals(installationPhases[0])) {
            String string2 = "informationOnly";
            Boolean bl = Boolean.TRUE;
            if (super.isExisting(this.ldn)) {
                super.setAttribute(this.ldn, string2, (Object)bl);
            } else {
                NalNameValue nalNameValue = Nal.getFactory().getNameValue(string2, bl);
                NalNameValue[] nalNameValueArray = new NalNameValue[]{nalNameValue};
                super.createMoIfNotExisting(this.ldn, nalNameValueArray);
            }
        } else if (string.equals(installationPhases[1]) && this.rbs.isParameterSupported("supportSystemControl") && this.rbs.getRbsData().isRbs6000() && (customerParameter = this.rbs.getCustomerParameterObject("supportSystemControl")).getValue().equalsIgnoreCase("FALSE")) {
            boolean bl = false;
            MoHandler moHandler = this.rbs.getMoHandler();
            bl = moHandler.getMo(this.ldn).isExisting();
            if (BemUtil.hasInciConnectorConfigChanged(this.rbs, this.unitNumber)) {
                Vector<NalNameValue> vector = new Vector<NalNameValue>();
                String string3 = BemUtil.getInciConnectorPrefix(Integer.parseInt(this.unitNumber));
                CustomerParameterServer customerParameterServer = this.rbs.getCustomerParameterServerObject(string3 + "unitType");
                CustomerParameterServer customerParameterServer2 = this.rbs.getCustomerParameterServerObject(string3 + "sectorNumber");
                CustomerParameterServer customerParameterServer3 = this.rbs.getCustomerParameterServerObject(string3 + "unitNumber");
                CustomerParameterServer customerParameterServer4 = this.rbs.getCustomerParameterServerObject(string3 + "equipmentSupportFunctionId");
                vector.add(Nal.getFactory().getNameValue("inciConnectorRef", BemUtil.getInciConnectorMo(this.rbs, customerParameterServer.getValueMom().toString(), Integer.parseInt(customerParameterServer3.getValueMom().toString()), Integer.parseInt(customerParameterServer2.getValueMom().toString()))));
                if (customerParameterServer4.hasValueChanged()) {
                    vector.add(Nal.getFactory().getNameValue("equipmentSupportFunctionRef", BemUtil.getEquipmentSupportFunctionMo(this.rbs, customerParameterServer4.getValueMom().toString())));
                }
                if (!bl) {
                    super.createMoIfNotExisting(this.ldn, vector);
                    bl = true;
                } else {
                    super.setAttributes(moHandler.getMo(this.ldn), vector);
                }
            }
        }
    }

    public void uninstall(String string) throws BemException {
        if (string.equals("ExternalNodeDeletionPhase")) {
            super.deleteMoIfExisting(this.ldn);
        }
    }
}

