/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.ethernetswitch.resource;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EthernetSwitchProvider;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEthernetSwitchingAdm;
import se.ericsson.wcdma.rbs.bem.common.mim.MimLag;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.RootMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class LagRI
extends AbstractResourceItem {
    private static final String NAME = "LagRI";
    private static final String[] PHASES = new String[]{"LagCreationPhase", "LagDeletionPhase", "EthernetSwitchingAdmCreationPhase"};
    private final EthernetSwitchProvider ethernetSwitchProvider;
    private MoInstance ethernetSwitchMoi;
    private final List pseudoList = new ArrayList();

    public LagRI(Rbs rbs) {
        super(NAME, rbs, PHASES);
        this.ethernetSwitchProvider = (EthernetSwitchProvider)this.rbs.getProvider(EthernetSwitchProvider.class);
    }

    public void addPseudo(String string) {
        this.pseudoList.add(string);
    }

    public void initiateCPWithNodeValues() throws BemException {
        BemMo bemMo;
        if (this.ethernetSwitchMoi != null && (bemMo = this.getMo(this.ethernetSwitchMoi.getLdn())).isExisting()) {
            BemMo[] bemMoArray = this.getChildren(bemMo, 1, MimLag.MOTYPENAME, "");
            for (int i = 0; i < bemMoArray.length; ++i) {
                String string = BemUtil.extractRdnId(bemMoArray[i].getDN(), MimLag.MOTYPENAME);
                String string2 = MessageFormat.format("linkAggregationGroup_{0}_lagId", string);
                this.ethernetSwitchProvider.createCP(string2, string);
                String string3 = MessageFormat.format("linkAggregationGroup_{0}_action", string);
                this.ethernetSwitchProvider.createCP(string3, "ADD_MODIFY");
            }
        }
    }

    public void install(String string) throws BemException {
        if (string.equals("LagCreationPhase")) {
            this.createLag();
        } else if (string.equals("LagDeletionPhase")) {
            this.deleteLag();
        } else if (string.equals("EthernetSwitchingAdmCreationPhase")) {
            this.createEthernetSwitchingAdm();
        }
    }

    private void createLag() throws BemException {
        Collections.sort(this.pseudoList);
        Iterator iterator = this.pseudoList.iterator();
        while (iterator.hasNext()) {
            boolean bl = false;
            String string = (String)iterator.next();
            String string2 = this.rbs.getCustomerParameter(string);
            if (string2.equals("ADD_MODIFY")) {
                bl = true;
            } else if (string2.equals("DELETE")) {
                bl = false;
            }
            if (!iterator.hasNext()) continue;
            string = (String)iterator.next();
            if (!bl) continue;
            string2 = this.rbs.getCustomerParameter(string);
            FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(this.ethernetSwitchMoi, MimLag.MOTYPENAME, string2);
            Vector<NalNameValue> vector = new Vector<NalNameValue>();
            vector.add(Nal.getFactory().getNameValue("lacpMode", new Integer(0)));
            this.createMoIfNotExisting(fixedRdnMoi.getLdn(), vector);
        }
    }

    private void deleteLag() throws BemException {
        Collections.sort(this.pseudoList);
        Iterator iterator = this.pseudoList.iterator();
        while (iterator.hasNext()) {
            boolean bl = false;
            String string = (String)iterator.next();
            String string2 = this.rbs.getCustomerParameter(string);
            if (string2.equals("ADD_MODIFY")) {
                bl = false;
            } else if (string2.equals("DELETE")) {
                bl = true;
            }
            if (!iterator.hasNext()) continue;
            string = (String)iterator.next();
            if (!bl) continue;
            string2 = this.rbs.getCustomerParameter(string);
            FixedRdnMoi fixedRdnMoi = new FixedRdnMoi(this.ethernetSwitchMoi, MimLag.MOTYPENAME, string2);
            this.deleteMoIfExisting(fixedRdnMoi.getLdn());
        }
    }

    private void createEthernetSwitchingAdm() throws BemException {
        BemMo bemMo;
        BemMo[] bemMoArray;
        SingleChildMoi singleChildMoi = new SingleChildMoi(new RootMoi(), MimEthernetSwitchingAdm.MOTYPENAME, "1");
        String string = singleChildMoi.getLdn();
        if (!super.isExisting(string) && (bemMoArray = super.getChildren(bemMo = super.getMo(this.ethernetSwitchMoi.getLdn()), 1, MimLag.MOTYPENAME, "")).length > 0) {
            super.createMoIfNotExisting(string);
        }
    }

    public String getDisplayName() {
        return NAME;
    }

    public String getLdn() {
        return null;
    }

    public void setEthernetSwitch(MoInstance moInstance) {
        this.ethernetSwitchMoi = moInstance;
    }
}

