/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs4;

import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractRbsSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRbsSlot;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRbsSubrack;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.FixedRdnMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class AbstractPsSubrackRI
extends AbstractRbsSubrackRI {
    public static final String NAME = "PowerSupplySubrack";
    protected int numberOfSlots;
    private String ldn = null;
    private MoInstance psSubrackMoi;
    private MoInstance[] rbsSlotMoi;
    private static final String AUTO_CREATED_RDNID_1 = "PS1";
    private static final String[] AUTO_CREATED_SLOT_RDNID = new String[]{"1", "2", "3", "4", "5", "6", "7", "8"};

    public AbstractPsSubrackRI(Rbs rbs, String string, MoInstance moInstance, String string2, String string3, int n) throws BemException {
        super(NAME, rbs, n, string2, string3);
        this.numberOfSlots = n;
        this.setupMoi(moInstance);
    }

    public void setupMoi(MoInstance moInstance) throws BemException {
        this.psSubrackMoi = new FixedRdnMoi(moInstance, MimRbsSubrack.MOTYPENAME, AUTO_CREATED_RDNID_1);
        this.rbsSlotMoi = new MoInstance[this.numberOfSlots];
        for (int i = 0; i < this.numberOfSlots; ++i) {
            this.rbsSlotMoi[i] = new FixedRdnMoi(this.psSubrackMoi, MimRbsSlot.MOTYPENAME, AUTO_CREATED_SLOT_RDNID[i]);
        }
        this.ldn = this.psSubrackMoi.getLdn();
    }

    public MoInstance getMoiPsSubrack() {
        return this.psSubrackMoi;
    }

    public MoInstance getMoiSlot(int n) {
        return this.rbsSlotMoi[n - 1];
    }

    public boolean isInstalled() throws BemException {
        String string = this.getLdn();
        boolean bl = super.isExisting(string);
        try {
            if (bl) {
                Rbs rbs = this.getRbs();
                MoHandler moHandler = rbs.getMoHandler();
                BemMo bemMo = moHandler.getMo(string);
                String string2 = (String)moHandler.getAttribute(bemMo, "cabinetPosition");
                String string3 = (String)moHandler.getAttribute(bemMo, "subrackPosition");
                if (!string2.equals(this.getCabinetPosition()) || !string3.equals(this.getSubrackPosition())) {
                    bl = false;
                }
            }
        }
        catch (MoHandlerException moHandlerException) {
            String string4 = moHandlerException.getAction();
            String string5 = moHandlerException.getLdn();
            String string6 = moHandlerException.getAdditionalInfo();
            throw new BemException(string4, "RbsSubrack isInstalled()", string5, string6, moHandlerException);
        }
        return bl;
    }

    public Object getAttributeValue(String string) throws BemException {
        String string2 = "Pseudo=" + string;
        string2 = string2 + " PsSubrackRI.getAttributeValue() is not supported by this resource for attribute=" + string;
        throw new BemException(string2);
    }

    public ResourceItem getContainedRi(String string, int n) {
        return null;
    }

    public String getLdn() {
        return this.ldn;
    }

    public String getDisplayName() {
        return "PowerSupplySubrack: " + this.getLdn();
    }
}

