/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment;

import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RuwRI;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractRbsSubrackRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.RbsSubrackMoi;

public class Ruw8USubrackRI
extends AbstractRbsSubrackRI {
    private static final String name = "Ruw8USubrack";
    private RuwRI[] boards;
    private MoInstance moi;
    private String ldn;
    private int firstPositionSlot;

    public Ruw8USubrackRI(Rbs rbs, int n, String string, String string2, int n2) throws BemException {
        super(name, rbs, n, string, string2);
        this.boards = new RuwRI[n];
        this.moi = new RbsSubrackMoi(new String[]{MimDeviceGroup.MOTYPENAME}, "RUW2", true);
        this.ldn = this.moi.getLdn();
        this.firstPositionSlot = n2;
        for (int i = n2; i <= n; ++i) {
            this.createSlot(i, new RuwRI(rbs, this.moi, i));
        }
    }

    public Ruw8USubrackRI(Rbs rbs, int n, String string, String string2, int n2, boolean bl) throws BemException {
        super(name, rbs, n, string, string2);
        this.boards = new RuwRI[n];
        this.moi = new RbsSubrackMoi(new String[]{MimDeviceGroup.MOTYPENAME}, "RUW2");
        this.ldn = this.moi.getLdn();
        this.firstPositionSlot = n2;
        for (int i = n2; i <= n; ++i) {
            this.createSlot(i, new RuwRI(rbs, this.moi, i));
        }
    }

    public String getLdn() {
        return this.ldn;
    }

    public String getDisplayName() {
        return "Ruw8USubrack:" + this.ldn;
    }

    public RuwRI[] getSubRIs() {
        RuwRI[] ruwRIArray = new RuwRI[this.boards.length - (this.firstPositionSlot - 1)];
        for (int i = 0; i < ruwRIArray.length; ++i) {
            ruwRIArray[i] = this.boards[i + (this.firstPositionSlot - 1)];
        }
        return ruwRIArray;
    }

    public RuwRI getSlot(int n) throws BemException {
        if (n < this.firstPositionSlot || n > this.getNoOfSlots()) {
            throw new BemException("RuwSubrack.getSlot() slot number out of range: " + n);
        }
        return this.boards[n - 1];
    }

    private void createSlot(int n, RuwRI ruwRI) {
        this.boards[n - 1] = ruwRI;
    }
}

