/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.modifymgmt;

import java.util.HashMap;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.SectorRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.AbstractDuwRadioEquipmentCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.modifymgmt.ModifyManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.AbstractRbb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.scpm.SectorCustomerParameterManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;

public abstract class ModifyHandler {
    private ModifyManager modifyManager;
    protected int startingSectorNumber;

    public ModifyHandler(ModifyManager modifyManager) {
        this(modifyManager, 1);
    }

    public ModifyHandler(ModifyManager modifyManager, int n) {
        this.startingSectorNumber = n;
        this.modifyManager = modifyManager;
    }

    public abstract List getAllCpPseudoNames();

    public abstract void checkConsistency() throws BemException;

    public abstract void updateScpmIfAppropriate(SectorCustomerParameterManager var1) throws BemException;

    public abstract HashMap getRIsToUninstall() throws BemException;

    public abstract void doModification() throws BemException;

    protected void requestResetSector(int n) throws BemException {
        int n2 = SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber);
        int n3 = 0;
        if (this.getRbs().isPantherHybridRbs() && this.startingSectorNumber == 7) {
            n3 = 1;
        }
        this.getRbs().getAntennaSystemProvider(n3).requestUninitAllBranches(n2);
        this.getRbs().getCellAndCarrierProvider(n3).requestUninitiateSector(n2, this);
        this.getRbs().getCellAndCarrierProvider(n3).requestInitiateSector(n2, this);
    }

    protected ModifyManager getModifyManager() {
        return this.modifyManager;
    }

    protected Rbs getRbs() {
        return this.modifyManager.getRadioCI().getRbs();
    }

    protected boolean isSectorExisting(int n) throws BemException {
        return this.getSectorRI(n).isInstalled();
    }

    protected int getMaxNoOfSectors() {
        if (this.getRbs().isPantherHybridRbs()) {
            return this.getRbs().getMaxNumberOfSectors() / 2;
        }
        return this.getRbs().getMaxNumberOfSectors();
    }

    protected int getMaxNoOfCarriers() {
        return this.getRbs().getMaxNumberOfCarriers();
    }

    protected SectorCustomerParameterManager getScpm() {
        return this.modifyManager.getScpm();
    }

    protected SectorRI getSectorRI(int n) {
        return this.modifyManager.getRadioCI().getSectorRis()[n];
    }

    protected AbstractRbb getLoadedRbb(int n) {
        return this.modifyManager.getRbbManager().getLoadedRadioBuildingBlock(SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber));
    }

    protected AbstractRbb getRbb(int n) {
        return this.modifyManager.getRbbManager().getRadioBuildingBlock(SectorUtil.getSectorNumberFromSectorIndex(n, this.startingSectorNumber));
    }

    protected AbstractDuwRadioEquipmentCI getRadioCI() {
        return this.modifyManager.getRadioCI();
    }
}

