/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt;

import java.text.MessageFormat;
import java.util.Locale;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.AbstractRbb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.DigitalCableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RbbDynamicMetaData;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RbbManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RbbStaticMetaData;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RfCableDuwRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.scpm.SectorCustomerParameterManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.util.DuwConnectorUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.util.DuwPortUtil;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.AuUnitType;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractRuRI;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEquipment;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSlot;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSubrack;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public final class RbbHandler {
    private static final int DC_ELECTRICAL_DELAY_IS_MEASURED_BY_RBS = -1;
    private static final String CABLE_OBJECTA_CONNECTOR_DATA_2 = "DATA_2";
    private static final String RF_CABLE_OBJECT_A_CONNECTOR_NAME_RXA_IO = "RXA_IO";
    private static final String RF_CABLE_OBJECT_A_CONNECTOR_NAME_RXA_OUT = "RXA_OUT";
    private static final int NOT_USED = -1;
    private static final int NO_ALLOCATE_RBSSLOT = -1;
    private static final String UNDERLINE_IN_KEY = "_";
    private RbbDynamicMetaData dynamicMetaData;
    private RbbStaticMetaData staticMetaData;
    private AbstractRuRI ruToSectorCascadePrimaryCpriLinkFrom = null;
    private AbstractRuRI ruToSectorCascadeSecondaryCpriLinkFrom = null;

    public RbbHandler(RbbDynamicMetaData rbbDynamicMetaData, RbbStaticMetaData rbbStaticMetaData) {
        this.dynamicMetaData = rbbDynamicMetaData;
        this.staticMetaData = rbbStaticMetaData;
    }

    public static String getKeyForStaticDataMap(String string, String string2) {
        String string3 = string.toLowerCase(Locale.ENGLISH) + UNDERLINE_IN_KEY + string2.toLowerCase(Locale.ENGLISH);
        return string3;
    }

    private DigitalCableRI createSectorCascadeRadioToRadioDigitalCable(RbbManager rbbManager, AbstractRuRI abstractRuRI, int n) throws BemException {
        Object object;
        String string;
        int n2 = this.dynamicMetaData.getSectorNumber();
        String string2 = null;
        String string3 = null;
        SectorCustomerParameterManager sectorCustomerParameterManager = this.dynamicMetaData.getScpm();
        String string4 = CABLE_OBJECTA_CONNECTOR_DATA_2;
        AbstractRbb abstractRbb = rbbManager.getRuForSectorCascading(n2, sectorCustomerParameterManager);
        AbstractRuRI abstractRuRI2 = (AbstractRuRI)abstractRbb.getRuForSectorCascade(n);
        String string5 = abstractRbb.getAuUnitType();
        String string6 = abstractRuRI2.getLdn();
        String string7 = BemUtil.extractRdnId(string6, MimAuxPlugInUnit.MOTYPENAME);
        MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
        BemMo bemMo = moHandlerImpl.getMo(string6).getParent();
        String string8 = "" + rbbManager.getPreviousSectorInCascadeChain(n2, sectorCustomerParameterManager);
        String string9 = sectorCustomerParameterManager.getAuUnitTypeForSector(Integer.parseInt(string8));
        if (bemMo.getParent().getType().equals(MimEquipment.MOTYPENAME) && string9.equals("RRUWRRUS")) {
            string = bemMo.getLastRDN();
            object = string.substring(string.lastIndexOf("=") + 1, string.length());
            string3 = this.formatCableRdn((String)object, string4);
        } else {
            string2 = this.getInternalSequenceNumber(string7, string5);
            string3 = this.formatCableRdn(string8, string2, string4);
        }
        string = abstractRuRI.getLdn();
        object = this.createDigitalCableRI(string6, 8, string, 1, string3);
        return object;
    }

    private DigitalCableRI createDigitalCableRI(String string, int n, String string2, int n2, String string3) throws BemException {
        DigitalCableRI digitalCableRI = new DigitalCableRI(this.dynamicMetaData.getRbs(), string, n, string2, n2, -1, string3);
        return digitalCableRI;
    }

    private String formatCableRdn(String string, String string2) {
        return string + UNDERLINE_IN_KEY + string2;
    }

    private String formatCableRdn(String string, String string2, String string3) {
        return string + UNDERLINE_IN_KEY + string2 + UNDERLINE_IN_KEY + string3;
    }

    private String formatCableRdn(String string, String string2, String string3, String string4) {
        return string + UNDERLINE_IN_KEY + string2 + UNDERLINE_IN_KEY + string3 + UNDERLINE_IN_KEY + string4;
    }

    private String getInternalSequenceNumber(String string, String string2) throws BemException {
        String string3 = null;
        String string4 = null;
        if ("RRUWRRUS".equals(string2) || "RRU22".equals(string2)) {
            string4 = "RRUW-";
        } else if ("AIR".equals(string2)) {
            string4 = "AIR-";
        } else if ("RUWRUS".equals(string2)) {
            string4 = "RUW-";
        } else if ("IRU".equals(string2)) {
            string4 = "IRU-";
        }
        int n = string.indexOf(string4);
        if (n == -1) {
            throw new BemException("createSectorCascadeRadioToRadioDigitalCable() can not determine internal RU index for" + this.getAuType(string2) + string);
        }
        n = string.lastIndexOf("-") + 1;
        string3 = string.substring(n);
        try {
            Integer.valueOf(string3);
        }
        catch (Exception exception) {
            throw new BemException("createSectorCascadeRadioToRadioDigitalCable() can not determine internal RU index for" + this.getAuType(string2) + string);
        }
        return string3;
    }

    private DigitalCableRI createDuwToRadioDigitalCable(AbstractRuRI abstractRuRI, int n) throws BemException {
        DigitalCableRI digitalCableRI = null;
        if (n == 1) {
            String string = this.dynamicMetaData.getPrimaryPortId();
            digitalCableRI = this.createDuwToRadioDigitalCable(abstractRuRI, string);
        } else if (n == 2) {
            String string = this.dynamicMetaData.getSecondaryPortId();
            digitalCableRI = this.createDuwToRadioDigitalCable(abstractRuRI, string);
        }
        return digitalCableRI;
    }

    private DigitalCableRI createDuwToRadioDigitalCable(AbstractRuRI abstractRuRI, String string) throws BemException {
        Object object;
        Object object2;
        String string2;
        String string3 = DuwConnectorUtil.getConnectorNameFromPortId(string);
        String string4 = DuwPortUtil.getDuwSlotNumberFromPortId(string);
        String string5 = DuwUtil.getDuwPiuLdn(string4);
        String string6 = BemUtil.extractRdnId(string5, MimSubrack.MOTYPENAME);
        boolean bl = this.dynamicMetaData.getScpm().needRuPositionAllocation(this.dynamicMetaData.getSectorNumber());
        String string7 = "" + this.dynamicMetaData.getSectorNumber();
        if (bl) {
            string2 = this.formatCableRdn(string6, string4, string3);
        } else {
            string2 = this.formatCableRdn(string7, string4, string3);
            object2 = new MoHandlerImpl();
            object = object2.getMo(abstractRuRI.getAuxPiuLdn());
            if (object.getParent().getType().equals(MimEquipment.MOTYPENAME) && abstractRuRI.getAuType() == 20) {
                string2 = this.formatCableRdn(string4, string3);
            }
        }
        object2 = abstractRuRI.getLdn();
        object = this.createDigitalCableRI(string5, DuwConnectorUtil.getConnectorFromPortId(string), (String)object2, 1, string2);
        return object;
    }

    public DigitalCableRI createInternalCascadeDigitalCable(AbstractRuRI abstractRuRI, AbstractRuRI abstractRuRI2, int n) throws BemException {
        return this.createInternalCascadeDigitalCable(AbstractRbb.HAS_NOT_RUW_SUBRACK_RDN, abstractRuRI, abstractRuRI2, -1, n);
    }

    public DigitalCableRI createInternalCascadeDigitalCable(String string, AbstractRuRI abstractRuRI, AbstractRuRI abstractRuRI2, int n, int n2) throws BemException {
        String string2;
        String string3;
        String string4;
        MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
        BemMo bemMo = moHandlerImpl.getMo(abstractRuRI.getAuxPiuLdn());
        if (bemMo.getParent().getType().equals(MimEquipment.MOTYPENAME) && abstractRuRI.getAuType() == 20) {
            string4 = bemMo.getLastRDN();
            string3 = string4.substring(string4.lastIndexOf("=") + 1, string4.length());
            string2 = this.formatCableRdn(string3, CABLE_OBJECTA_CONNECTOR_DATA_2);
        } else {
            string2 = this.getCableRdn(string, abstractRuRI, n, n2);
        }
        string4 = abstractRuRI.getLdn();
        string3 = abstractRuRI2.getLdn();
        DigitalCableRI digitalCableRI = this.createDigitalCableRI(string4, 8, string3, 1, string2);
        return digitalCableRI;
    }

    private String getCableRdn(String string, AbstractRuRI abstractRuRI, int n, int n2) throws BemException {
        Rbs rbs = this.dynamicMetaData.getRbs();
        int n3 = this.dynamicMetaData.getSectorNumber();
        boolean bl = this.dynamicMetaData.getScpm().needRuPositionAllocation(n3);
        String string2 = MessageFormat.format("S{0}_", new Integer(n3));
        CustomerParameter customerParameter = rbs.getCustomerParameterObject(string2 + "needRuPositionAllocation");
        String string3 = CABLE_OBJECTA_CONNECTOR_DATA_2;
        String string4 = String.valueOf(n);
        String string5 = null;
        boolean bl2 = AuUnitType.isMacroAuUnitType(this.dynamicMetaData.getScpm().getAuUnitTypeForSector(n3));
        string5 = bl ? (rbs.isModifyWiz() && bl2 && customerParameter.hasValueChanged() ? (null != string ? this.formatCableRdn(string, string4, string3) : this.formatCableRdn(String.valueOf(n3), String.valueOf(n2), string3)) : this.formatCableRdn(string, string4, string3)) : (rbs.isModifyWiz() && customerParameter.hasValueChanged() ? (null != string ? this.formatCableRdn(string, string4, string3) : this.formatCableRdn(String.valueOf(n3), String.valueOf(n2), string3)) : this.formatCableRdn(String.valueOf(n3), String.valueOf(n2), string3));
        return string5;
    }

    public DigitalCableRI createIncomingDigitalCable(RbbManager rbbManager, int n, AbstractRuRI abstractRuRI) throws BemException {
        DigitalCableRI digitalCableRI = null;
        if (n > this.staticMetaData.getNumberOfCpriLinks()) {
            throw new BemException("RBB does not support " + n + " number of CPRI links");
        }
        if (n == 1 || n == 2) {
            digitalCableRI = this.dynamicMetaData.getSectorSequence().equals("1") ? this.createDuwToRadioDigitalCable(abstractRuRI, n) : this.createSectorCascadeRadioToRadioDigitalCable(rbbManager, abstractRuRI, n);
        }
        return digitalCableRI;
    }

    public RfCableDuwRI createRfCable(String string, String string2, String string3, String string4, String string5, int n, int n2) throws BemException {
        NalNameValue[] nalNameValueArray;
        String string6;
        String string7 = this.getObjectAConnectorName(n);
        if (string == null) {
            string6 = this.formatCableRdn(this.getAuType(this.dynamicMetaData.getAuUnitType()), String.valueOf(this.dynamicMetaData.getSectorNumber()), string2, string7);
        } else {
            nalNameValueArray = BemUtil.extractRdnId(string3, MimSlot.MOTYPENAME);
            string6 = this.formatCableRdn(string, (String)nalNameValueArray, string7);
        }
        nalNameValueArray = null;
        int n3 = this.convertFrequencyBand(string5);
        if (this.staticMetaData.getCableSet() != null && !this.dynamicMetaData.getRbs().isCabinetWiz() && !this.dynamicMetaData.getRbs().isOamWiz() && n3 != -1) {
            nalNameValueArray = this.staticMetaData.getCableSet().getRxACableAttributes(n3);
        }
        RfCableDuwRI rfCableDuwRI = new RfCableDuwRI(this.dynamicMetaData.getRbs(), string3, n, string4, n2, nalNameValueArray, string6);
        return rfCableDuwRI;
    }

    private String getObjectAConnectorName(int n) throws BemException {
        String string = null;
        if (n == 12) {
            string = RF_CABLE_OBJECT_A_CONNECTOR_NAME_RXA_IO;
        } else if (n == 13) {
            string = RF_CABLE_OBJECT_A_CONNECTOR_NAME_RXA_OUT;
        } else {
            throw new BemException("AbstractRbb, incorrect objectAConnector called in getObjectAConnectorName. objectAConnector = " + n);
        }
        return string;
    }

    private int convertFrequencyBand(String string) throws BemException {
        int n = -1;
        try {
            if (string != null && !string.equals("0") && !string.equals("##UNDEFINED")) {
                n = Integer.parseInt(string);
            }
        }
        catch (Exception exception) {
            throw new BemException("Can not interprete frequency operatingBand for sector =" + this.dynamicMetaData.getSectorNumber(), (Throwable)exception);
        }
        if ((n > 21 || n < 19 && n > 14 || n < 1) && n != -1) {
            throw new BemException("Can not interprete frequency operatingBand for sector =" + this.dynamicMetaData.getSectorNumber());
        }
        return n;
    }

    public ResourceItem getRuForSectorCascade(int n) {
        AbstractRuRI abstractRuRI = this.ruToSectorCascadePrimaryCpriLinkFrom;
        if (n == 2) {
            abstractRuRI = this.ruToSectorCascadeSecondaryCpriLinkFrom;
        }
        return abstractRuRI;
    }

    public void setRuForSectorCascade(int n, ResourceItem resourceItem) {
        if (n == 1) {
            this.ruToSectorCascadePrimaryCpriLinkFrom = (AbstractRuRI)resourceItem;
        } else {
            this.ruToSectorCascadeSecondaryCpriLinkFrom = (AbstractRuRI)resourceItem;
        }
    }

    private String getAuType(String string) {
        String string2 = null;
        if ("RRUWRRUS".equals(string)) {
            string2 = "RRUW";
        } else if ("RUWRUS".equals(string)) {
            string2 = "RUW";
        } else if ("AIR".equals(string)) {
            string2 = "AIR";
        } else if ("RRU22".equals(string)) {
            string2 = "RRU";
        } else if ("IRU".equals(string)) {
            string2 = "IRU";
        }
        return string2;
    }
}

