/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt;

import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProviderWithRbb;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractRuRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimAuxPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRruDeviceGroup;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSectorAntenna;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemLdn;

public class RruwRI
extends AbstractRuRI {
    public static final String name = "RRUW";
    public static final String WIZARD_SWALLOC_ROLE_RRUW = "RBS_RRUW";
    public static final String WIZARD_REPERTOIRE_RRUW = "RBS_RRUW";
    public static final String piuTypeProductName = "RRUW";
    private String auxPiuLdn;
    private String auxPiuId;
    private final String deviceGroupLdn;
    private static final String RRU_DEVICE_GROUP_ID = "1";
    private static final int MAX_AUXPIU_RRUW_LDN_NUMBER = 40;
    public static final String AU_TYPE_RRUW = "RRUW";
    public static final String RRUW_RDN_PREFIX = "RRUW-";

    public RruwRI(Rbs rbs, String string, int n, int n2, int n3) {
        this(rbs, string, n, n2, n3, 1);
    }

    public RruwRI(Rbs rbs, String string, int n, int n2, int n3, int n4) {
        this(rbs, string, n3, n, n2, n4, false);
    }

    public RruwRI(Rbs rbs, String string, int n, int n2, int n3, boolean bl) {
        this(rbs, string, n, n2, n3, 0, bl);
    }

    public RruwRI(Rbs rbs, String string, int n, int n2, int n3, int n4, boolean bl) {
        super("RRUW", rbs, 20, "RRUW", string, n, n2, n3);
        this.setSwLoadable(true);
        this.setRoleForSwAllocation("RBS_RRUW");
        this.addRepertoiresToInstall("RBS_RRUW");
        if (!bl) {
            this.auxPiuId = RRUW_RDN_PREFIX + n3;
            this.auxPiuLdn = n4 > 0 ? BemLdn.LDN_EQUIPMENT + "," + MimSectorAntenna.MOTYPENAME + "=" + n2 + "-" + n4 + "," + MimAuxPlugInUnit.MOTYPENAME + "=" + this.auxPiuId : BemLdn.LDN_EQUIPMENT + "," + MimSectorAntenna.MOTYPENAME + "=" + n2 + "," + MimAuxPlugInUnit.MOTYPENAME + "=" + this.auxPiuId;
        } else {
            this.auxPiuLdn = this.generateLdnForRruwUnderEquipment(n2, n3);
        }
        this.deviceGroupLdn = this.auxPiuLdn + "," + MimRruDeviceGroup.MOTYPENAME + "=" + RRU_DEVICE_GROUP_ID;
    }

    public void install(String string) throws BemException {
        super.install(string);
    }

    public boolean isInstalled() throws BemException {
        return super.isExisting(this.auxPiuLdn);
    }

    public String getLdn() {
        return this.deviceGroupLdn;
    }

    public String getAuxPiuLdn() {
        return this.auxPiuLdn;
    }

    protected BemMo getAuxPiuMo() throws BemException {
        return this.getMo(this.auxPiuLdn);
    }

    public String getDisplayName() {
        return this.auxPiuId + ": " + this.getLdn();
    }

    public int getSlotNumber() {
        return 0;
    }

    private String generateLdnForRruwUnderEquipment(int n, int n2) {
        RadioEquipmentProviderWithRbb radioEquipmentProviderWithRbb = (RadioEquipmentProviderWithRbb)this.rbs.getProvider(RadioEquipmentProviderWithRbb.class);
        String[] stringArray = radioEquipmentProviderWithRbb == null ? (String[])SectorUtil.getLoadedRruLdnUnderEquipmentBySector(this.rbs, n).toArray() : radioEquipmentProviderWithRbb.getAllRruLdnUnderEquipmentBySector(n);
        if (stringArray == null) {
            String[] stringArray2;
            if (radioEquipmentProviderWithRbb == null) {
                stringArray2 = SectorUtil.getAllLoadedRruAuxPiuLdn(this.rbs);
            } else {
                if (radioEquipmentProviderWithRbb.isRadioSharedSector(n)) {
                    String[] stringArray3 = radioEquipmentProviderWithRbb.getRruLdnByRadioSharedEquippedSector(n);
                    this.auxPiuLdn = stringArray3[n2 - 1];
                    return this.auxPiuLdn;
                }
                stringArray2 = radioEquipmentProviderWithRbb.getAllRruLdnUnderEquipmentByEquippedSector();
            }
            int n3 = stringArray2.length;
            if (n3 > 0) {
                for (int i = 1; i < 40; ++i) {
                    boolean bl = false;
                    for (int j = 0; j < n3; ++j) {
                        int n4 = stringArray2[j].indexOf(RRUW_RDN_PREFIX) + RRUW_RDN_PREFIX.length();
                        String string = stringArray2[j].substring(n4);
                        if (Integer.parseInt(string) != i) continue;
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    this.auxPiuId = RRUW_RDN_PREFIX + (i + n2 - 1);
                    break;
                }
            } else {
                this.auxPiuId = RRUW_RDN_PREFIX + n2;
            }
            this.auxPiuLdn = BemLdn.LDN_EQUIPMENT + "," + MimAuxPlugInUnit.MOTYPENAME + "=" + this.auxPiuId;
        } else {
            this.auxPiuLdn = stringArray[n2 - 1];
        }
        return this.auxPiuLdn;
    }
}

