/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.scpm;

import java.text.MessageFormat;
import java.util.ArrayList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.SectorRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.AbstractDuwRadioEquipmentCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.rbbmgmt.RbbManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;

public class CreateSectorParameterManager {
    private int maxSectorNumber;
    private int startingSectorNumber;
    private YesNoCustomerParameter[] createSectorParameters;
    private AbstractDuwRadioEquipmentCI radioCi;
    private RbbManager rbbManager;
    boolean[] createSector;

    public CreateSectorParameterManager(AbstractDuwRadioEquipmentCI abstractDuwRadioEquipmentCI, RbbManager rbbManager, int n, int n2) throws BemException {
        this.maxSectorNumber = n;
        this.startingSectorNumber = n2;
        this.radioCi = abstractDuwRadioEquipmentCI;
        this.rbbManager = rbbManager;
        this.createCustomerParameter();
        this.initiateCustomerParameter();
        this.updateLoadedSectors();
    }

    private void createCustomerParameter() {
        this.createSectorParameters = new YesNoCustomerParameter[this.maxSectorNumber];
        this.createSector = new boolean[this.maxSectorNumber];
        for (int i = 0; i < this.maxSectorNumber; ++i) {
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            String string = MessageFormat.format("S{0}_", new Integer(n));
            String string2 = string + "createSector";
            this.createSectorParameters[i] = new YesNoCustomerParameter(string2);
            this.radioCi.addParameter(this.createSectorParameters[i]);
            this.createSector[i] = false;
        }
    }

    private void initiateCustomerParameter() {
        this.setDefaultValues();
        this.addParameterListeners();
    }

    private void setDefaultValues() {
        for (int i = 0; i < this.maxSectorNumber; ++i) {
            this.createSectorParameters[i].setDefaultValue("NO");
        }
    }

    private void addParameterListeners() {
        for (int i = 0; i < this.maxSectorNumber; ++i) {
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            this.createSectorParameters[i].addCustomerParameterListener(new CreateSectorListener(n));
        }
    }

    private void updateLoadedSectors() throws BemException {
        SectorRI[] sectorRIArray = this.radioCi.getSectorRis();
        for (int i = 0; i < this.maxSectorNumber; ++i) {
            if (sectorRIArray == null || !sectorRIArray[i].isInstalled()) continue;
            this.createSectorParameters[i].setValue("YES");
        }
    }

    public void updateCreateSector(int n) {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        YesNoCustomerParameter yesNoCustomerParameter = this.createSectorParameters[n2];
        boolean bl = false;
        bl = yesNoCustomerParameter.getBooleanValue();
        if (bl) {
            if (this.rbbManager.getRadioBuildingBlock(n) == null) {
                this.createSector[n2] = true;
            }
        } else {
            this.createSector[n2] = false;
        }
    }

    public ArrayList getAllCpPseudoNames() {
        String string = null;
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < this.maxSectorNumber; ++i) {
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, this.startingSectorNumber);
            String string2 = MessageFormat.format("S{0}_", new Integer(n));
            string = string2 + "createSector";
            arrayList.add(string);
        }
        return arrayList;
    }

    public boolean getCreateSector(int n) {
        int n2 = SectorUtil.getSectorIndexFromSectorNumber(n, this.startingSectorNumber);
        return this.createSector[n2];
    }

    private class CreateSectorListener
    implements CustomerParameterListener {
        int sector;

        public CreateSectorListener(int n) {
            this.sector = n;
        }

        public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
            if (parameterEvent.isValueChanged()) {
                int n = customerParameter.getAccessLevel();
                if (n == 0) {
                    return;
                }
                CreateSectorParameterManager.this.updateCreateSector(this.sector);
            }
        }
    }
}

