/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.duwrbb.util;

import java.text.MessageFormat;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;

public class AIRUtil {
    private static AIRUtil theInstance = null;
    private Rbs rbs;
    Enumeration[] radioBuildingBlockParameters;
    Enumeration[] auUnitTypeParameters;

    private AIRUtil(Rbs rbs) {
        this.rbs = rbs;
        this.updateRbbAndUnitTypeCp();
    }

    public static synchronized AIRUtil getInstance(Rbs rbs) {
        if (theInstance == null || AIRUtil.theInstance.rbs != rbs) {
            theInstance = new AIRUtil(rbs);
        }
        return theInstance;
    }

    private void updateRbbAndUnitTypeCp() {
        int n = this.rbs.getMaxNumberOfSectors();
        this.radioBuildingBlockParameters = new Enumeration[n];
        this.auUnitTypeParameters = new Enumeration[n];
        try {
            for (int i = 0; i < n; ++i) {
                String string;
                int n2 = SectorUtil.getSectorNumberFromSectorIndex(i, 1);
                String string2 = MessageFormat.format("S{0}_", new Integer(n2));
                String string3 = string2 + "radioBuildingBlock";
                if (this.rbs.isParameterSupported(string3)) {
                    this.radioBuildingBlockParameters[i] = (Enumeration)this.rbs.getCustomerParameterServerObject(string3);
                }
                if (!this.rbs.isParameterSupported(string = string2 + "auUnitType")) continue;
                this.auUnitTypeParameters[i] = (Enumeration)this.rbs.getCustomerParameterServerObject(string);
            }
        }
        catch (BemException bemException) {
            BemLog.exceptionRaised(bemException);
        }
    }

    public boolean isAirConfigured(int n) {
        boolean bl = false;
        try {
            if (this.rbs.getRadioEquipmentProvider().getAuUnitType(n) != null && this.rbs.getRadioEquipmentProvider().getAuUnitType(n).equals("AIR")) {
                bl = true;
            }
        }
        catch (BemException bemException) {
            BemLog.exceptionRaised(bemException);
        }
        return bl;
    }

    public boolean isNodeConfiguredWithAir(int n) {
        boolean bl = false;
        try {
            if (this.rbs.getRadioEquipmentProvider().getLoadedAuUnitType(n) != null && this.rbs.getRadioEquipmentProvider().getLoadedAuUnitType(n).equals("AIR")) {
                bl = true;
            }
        }
        catch (BemException bemException) {
            BemLog.exceptionRaised(bemException);
        }
        return bl;
    }

    public boolean isAllSectorsConfiguredWithAir() {
        boolean bl = false;
        this.updateRbbAndUnitTypeCp();
        for (int i = 0; i < this.radioBuildingBlockParameters.length; ++i) {
            if (this.radioBuildingBlockParameters[i] == null || this.radioBuildingBlockParameters[i].getValue().equals("")) continue;
            int n = SectorUtil.getSectorNumberFromSectorIndex(i, 1);
            if (this.isAirConfigured(n) || this.isAir2488(n, false)) {
                bl = true;
                continue;
            }
            return false;
        }
        return bl;
    }

    public boolean isAntFeederPageSkipped() {
        return this.isAllSectorsConfiguredWithAir() && !this.isSpecialRbbContained("RBB11_1A");
    }

    public boolean isRbb111AWithAir(int n) {
        boolean bl = false;
        this.updateRbbAndUnitTypeCp();
        if (this.isAirConfigured(n) && this.radioBuildingBlockParameters[n - 1].getValue().equals("RBB11_1A")) {
            bl = true;
        }
        return bl;
    }

    public boolean isAir32(int n) {
        boolean bl = false;
        this.updateRbbAndUnitTypeCp();
        if (this.isAirConfigured(n) && this.radioBuildingBlockParameters[n - 1].getValue().equals("RBB44_1D")) {
            bl = true;
        }
        return bl;
    }

    private boolean isSpecialRbbContained(String string) {
        this.updateRbbAndUnitTypeCp();
        for (int i = 0; i < this.radioBuildingBlockParameters.length; ++i) {
            if (!this.radioBuildingBlockParameters[i].getValue().equals(string)) continue;
            return true;
        }
        return false;
    }

    public boolean isRbb241aForAir(int n, boolean bl) {
        this.updateRbbAndUnitTypeCp();
        if (bl) {
            return this.isNodeConfiguredWithAir(n) && this.radioBuildingBlockParameters[n - 1].getLoadedValue().equals("RBB24_1A");
        }
        return this.isAirConfigured(n) && this.radioBuildingBlockParameters[n - 1].getValue().equals("RBB24_1A");
    }

    private boolean isAir2488(int n, boolean bl) {
        if (bl) {
            return this.radioBuildingBlockParameters[n - 1] != null && this.radioBuildingBlockParameters[n - 1].getLoadedValue().equals("RBB24_1C");
        }
        return this.radioBuildingBlockParameters[n - 1] != null && this.radioBuildingBlockParameters[n - 1].getValue().equals("RBB24_1C");
    }

    public boolean isAir4SectorAntenna(int n, boolean bl) {
        if (bl) {
            return this.isNodeConfiguredWithAir(n) || this.isAir2488(n, bl);
        }
        return this.isAirConfigured(n) || this.isAir2488(n, bl);
    }
}

