/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations;

import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.DigitalCableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.FreeConnectorRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.FuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RadioInterfaceBoard;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.ReservedConnectorRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RfCableRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RuRI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.cableutil.AbstractCableSet;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.AbstractRadioBuildingBlock;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.rbs4.configurations.RadioBuildingBlock;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimDigitalCable;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRfCable;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class RB1
extends AbstractRadioBuildingBlock {
    public static final String name = "RB1";
    private static final int NOT_USED = -1;
    private static final int NO_OF_CARRIERS = 1;
    private static final int NO_OF_RUS = 1;
    private static final int NO_OF_TX_BRANCHES = 1;
    private Rbs rbs;
    private List ris = new ArrayList();
    private DigitalCableRI digitalCable = null;
    private RfCableRI txRfCable = null;
    private RfCableRI rxARfCable = null;
    private RfCableRI rxBRfCable = null;
    private FuRI fu = null;
    private RuRI ru = null;
    private int dcElectricalDelay;
    private int rfElectricalUlDelay;
    private int rfElectricalDlDelay;
    private int rfUlAttenuation;
    private int rfDlAttenuation;
    private String allocationMode;
    private boolean secondary;
    List freeConnectors;
    ReservedConnectorRI[] reservedConnectors;

    public int[] getCarriersInBasebandPool(int n) {
        return super.getCarriersInBasebandPool(n);
    }

    public RB1(Rbs rbs, int n, FuRI fuRI, RuRI ruRI, RadioInterfaceBoard radioInterfaceBoard, int n2, int n3, int n4, int n5, int n6, String string, boolean bl) throws BemException {
        super(name, n, 1, 1, 1, new RadioInterfaceBoard[]{radioInterfaceBoard});
        this.rbs = rbs;
        this.allocationMode = string;
        this.secondary = bl;
        this.ru = ruRI;
        this.fu = fuRI;
        this.dcElectricalDelay = n2;
        this.rfElectricalUlDelay = n3;
        this.rfElectricalDlDelay = n4;
        this.rfUlAttenuation = n5;
        this.rfDlAttenuation = n6;
        this.createResourceItems(radioInterfaceBoard);
    }

    public RB1(Rbs rbs, int n, FuRI fuRI, RuRI ruRI, RadioInterfaceBoard radioInterfaceBoard, int n2, int n3, int n4, int n5, int n6) throws BemException {
        this(rbs, n, fuRI, ruRI, radioInterfaceBoard, n2, n3, n4, n5, n6, "Basic", false);
    }

    public void setRadioIfConnectors(ReservedConnectorRI reservedConnectorRI, ReservedConnectorRI reservedConnectorRI2, ReservedConnectorRI reservedConnectorRI3, ReservedConnectorRI reservedConnectorRI4, ReservedConnectorRI reservedConnectorRI5, ReservedConnectorRI reservedConnectorRI6) {
        this.reservedConnectors = new ReservedConnectorRI[6];
        this.reservedConnectors[0] = reservedConnectorRI6;
        this.reservedConnectors[1] = reservedConnectorRI4;
        this.reservedConnectors[2] = reservedConnectorRI2;
        this.reservedConnectors[3] = reservedConnectorRI5;
        this.reservedConnectors[4] = reservedConnectorRI3;
        this.reservedConnectors[5] = reservedConnectorRI;
    }

    private void createResourceItems(RadioInterfaceBoard radioInterfaceBoard) throws BemException {
        this.ris.add(this.ru);
        this.ris.add(this.fu);
        this.freeConnectors = new ArrayList();
        String string = this.ru.getAuxPiuLdn();
        this.freeConnectors.add(new FreeConnectorRI(this.rbs, string, 2, MimDigitalCable.MOTYPENAME, "objectBConnector"));
        String string2 = this.fu.getAuxPiuLdn();
        this.freeConnectors.add(new FreeConnectorRI(this.rbs, string2, 8, MimRfCable.MOTYPENAME, "objectAConnector"));
        this.digitalCable = new DigitalCableRI(this.rbs, radioInterfaceBoard.getLdn(), this.getDigitalCableConnectorA(), this.ru.getLdn(), 1, this.dcElectricalDelay);
        this.ris.add(this.digitalCable);
        this.txRfCable = new RfCableRI(this.rbs, this.ru.getLdn(), 11, this.fu.getLdn(), 17, -1, this.rfElectricalDlDelay, -1, this.rfDlAttenuation);
        this.ris.add(this.txRfCable);
        this.rxARfCable = new RfCableRI(this.rbs, this.fu.getLdn(), 6, this.ru.getLdn(), 3, this.rfElectricalUlDelay, -1, this.rfUlAttenuation, -1);
        this.ris.add(this.rxARfCable);
        this.rxBRfCable = new RfCableRI(this.rbs, this.fu.getLdn(), 9, this.ru.getLdn(), 4, this.rfElectricalUlDelay, -1, this.rfUlAttenuation, -1);
        this.ris.add(this.rxBRfCable);
    }

    public List getResourceItems() throws BemException {
        this.fu.setSecondAiLocked(false);
        return this.ris;
    }

    public List getAllocatedResources() {
        ArrayList<AbstractResourceItem> arrayList = new ArrayList<AbstractResourceItem>();
        arrayList.add(this.ru);
        arrayList.add(this.fu);
        arrayList.add(this.reservedConnectors[this.getSectorNo() - 1]);
        return arrayList;
    }

    private int getDigitalCableConnectorA() throws BemException {
        int n = 0;
        int n2 = this.allocationMode == "Advanced" && this.secondary ? this.getSectorNo() - 3 : this.getSectorNo();
        int[] nArray = new int[]{6, 4, 2, 5, 3, 1};
        n = nArray[n2 - 1];
        return n;
    }

    public Integer getTerminationConnector(String string) throws BemException {
        Integer n = null;
        if (string.equalsIgnoreCase("A")) {
            n = new Integer(1);
        } else if (string.equalsIgnoreCase("B")) {
            n = new Integer(2);
        } else {
            throw new BemException(this.getClass().getName() + " getAntFeederCableConnectorA(): Antenna branch " + string + " not supported");
        }
        return n;
    }

    public String getTerminationObject(String string) throws BemException {
        return this.fu.getAuxPiuLdn();
    }

    protected List getFreeConnectors() {
        return this.freeConnectors;
    }

    public void updateCableCharacteristics(AbstractCableSet abstractCableSet, int n) throws BemException {
        NalNameValue[] nalNameValueArray = null;
        nalNameValueArray = abstractCableSet.getRxACableAttributes(n);
        this.rxARfCable.setAttributes(nalNameValueArray);
        nalNameValueArray = abstractCableSet.getRxBCableAttributes(n);
        this.rxBRfCable.setAttributes(nalNameValueArray);
        nalNameValueArray = abstractCableSet.getTxCableAttributes(n);
        this.txRfCable.setAttributes(nalNameValueArray);
        nalNameValueArray = abstractCableSet.getData1CableAttributes(n);
        this.digitalCable.setAttributes(nalNameValueArray);
    }

    public int minNumberOfCarriers() {
        return 1;
    }

    public String getCarrierAllocationMode() {
        return this.allocationMode;
    }

    public boolean isEulInTwoBaseBandPoolsSupported() {
        return this.allocationMode.equals("Advanced");
    }

    public List getAtfRoleMapping() {
        ArrayList<RadioBuildingBlock.SlotToBBPools> arrayList = new ArrayList<RadioBuildingBlock.SlotToBBPools>();
        if (this.allocationMode.equals("Advanced")) {
            arrayList.add(new RadioBuildingBlock.SlotToBBPools(this.ru.getSlotNumber(), new int[]{this.getSectorNo() > 3 ? 1 : 0}));
        } else {
            arrayList.add(new RadioBuildingBlock.SlotToBBPools(this.ru.getSlotNumber(), new int[]{0}));
        }
        return arrayList;
    }

    public int[] getSupportedTxDivRange() {
        return new int[]{1};
    }

    public boolean isInstalled() throws BemException {
        boolean bl;
        boolean bl2;
        int n = this.getSectorNo();
        String string = "ManagedElement=1,Equipment=1,SectorAntenna=" + n + "-1";
        String string2 = "ManagedElement=1,Equipment=1,SectorAntenna=" + n + "-2";
        MoHandler moHandler = this.rbs.getMoHandler();
        BemMo bemMo = moHandler.getMo(string);
        BemMo bemMo2 = moHandler.getMo(string2);
        try {
            bl2 = moHandler.isExisting(bemMo);
            bl = moHandler.isExisting(bemMo2);
        }
        catch (MoHandlerException moHandlerException) {
            moHandlerException.printStackTrace();
            bl2 = false;
            bl = false;
        }
        return super.isInstalled() && bl2 && !bl;
    }
}

