/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.custparam;

import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ListRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRange;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class ListParameter
extends CustomerParameterImpl {
    private ParameterRange lengthRange;
    private boolean isDuplicationAllowed = false;
    private boolean areAllLengthsValid = false;

    public ListParameter(String string, ListRange listRange) {
        super(string, listRange);
    }

    public ListParameter(String string, ListRange listRange, int n, int n2, boolean bl, boolean bl2) {
        super(string, listRange);
        this.setLengthRange(n, n2);
        this.isDuplicationAllowed = bl;
        this.areAllLengthsValid = bl2;
    }

    public ListParameter(String string, ListRange listRange, int[] nArray, boolean bl) {
        super(string, listRange);
        this.isDuplicationAllowed = bl;
        this.setLengthRange(nArray);
    }

    public String[] getAllListValues() {
        String string = this.getValue();
        String[] stringArray = this.getValueArray(string);
        return stringArray;
    }

    public String[] getAllLoadedListValue() {
        String string = this.getLoadedValue();
        String[] stringArray = this.getValueArray(string);
        return stringArray;
    }

    public void setValue(String[] stringArray) {
        String string = this.getValueString(stringArray);
        this.setValue(string);
    }

    public void setDefaultValue(String[] stringArray) {
        String string = this.getValueString(stringArray);
        this.setDefaultValue(string);
    }

    public void setLengthRange(int[] nArray) {
        this.lengthRange = new EnumeratedRange(nArray);
        this.queueEvent(new ParameterEvent(2));
    }

    public void setLengthRange(int n, int n2) {
        this.lengthRange = new IntegerRange(n, n2);
        this.queueEvent(new ParameterEvent(2));
    }

    public int getLength() {
        String[] stringArray = this.getAllListValues();
        return stringArray.length;
    }

    public ParameterRange getLengthRange() {
        return this.lengthRange;
    }

    public boolean isValidLength() {
        if (this.lengthRange == null) {
            return true;
        }
        String string = "" + this.getLength();
        if (this.areAllLengthsValid) {
            if (this.lengthRange.isValueInRange(string)) {
                return true;
            }
        } else if (this.lengthRange instanceof IntegerRange) {
            IntegerRange integerRange;
            int n = this.getLength();
            return n == (integerRange = (IntegerRange)this.lengthRange).getMinValue() || n == integerRange.getMaxValue();
        }
        return false;
    }

    protected String[] getValueArray(String string) {
        return BemUtil.getStringArray(string);
    }

    protected String getValueString(String[] stringArray) {
        return BemUtil.getCommaSeparatedValueString(stringArray);
    }

    public boolean isDuplicationValid() {
        String[] stringArray = this.getValueArray(this.getValue());
        return this.isDuplicationValid(stringArray);
    }

    public boolean isDuplicationValid(String[] stringArray) {
        boolean bl = true;
        if (!this.isDuplicationAllowed) {
            block0: for (int i = 0; i < stringArray.length && bl; ++i) {
                for (int j = i + 1; j < stringArray.length; ++j) {
                    if (!stringArray[i].equals(stringArray[j])) continue;
                    bl = false;
                    continue block0;
                }
            }
        }
        return bl;
    }

    public boolean isValidValue(String string) {
        switch (this.getAccessLevel()) {
            case 0: {
                break;
            }
            case 1: {
                break;
            }
            case 2: 
            case 3: {
                if (!this.isValidLength()) {
                    return false;
                }
                if (this.isDuplicationValid()) break;
                return false;
            }
            default: {
                throw new Error("Unrecognised access level" + this.getAccessLevel());
            }
        }
        return super.isValidValue(string);
    }

    public boolean isValueSet(String string) {
        String[] stringArray = this.getAllListValues();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            return true;
        }
        return false;
    }

    protected String getOutOfRangeReason(String string) {
        if (!this.isValidLength()) {
            return "Invalid length: expected length " + this.lengthRange.getDescription();
        }
        if (!this.isDuplicationValid()) {
            return "Invalid value: duplication of values in the list is not allowed";
        }
        return super.getOutOfRangeReason(string);
    }
}

