/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.custparam;

import java.util.StringTokenizer;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRange;

public class SubnetRange
implements ParameterRange {
    public String minRange;
    public String maxRange;

    public SubnetRange(int n, int n2) {
        this.minRange = this.convertPrefixToSubnet(n);
        this.maxRange = this.convertPrefixToSubnet(n2);
    }

    public SubnetRange(Integer n, Integer n2) {
        this.minRange = this.convertPrefixToSubnet(n);
        this.maxRange = this.convertPrefixToSubnet(n2);
    }

    public SubnetRange(String string, String string2) {
        this.minRange = string;
        this.maxRange = string2;
    }

    public String getDescription() {
        return "Subnet range [" + this.minRange + " - " + this.maxRange + ", Valid values [0, 128, 192, 224, 240, 248, 252, 254, 255]";
    }

    public boolean equals(ParameterRange parameterRange) {
        return parameterRange instanceof SubnetRange;
    }

    public boolean isValueInRange(Object object) {
        if (this.isValueValidSubnet(object)) {
            return this.isSubnetInRange(object);
        }
        return false;
    }

    private boolean isValueValidSubnet(Object object) {
        String string = (String)object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        if (stringTokenizer.countTokens() != 7) {
            return false;
        }
        String string2 = stringTokenizer.nextToken();
        if (this.isValidSubnetPart(string2)) {
            if (!this.equalsNumber(string2, 255)) {
                stringTokenizer.nextToken();
                if (this.equalsNumber(stringTokenizer.nextToken(), 0)) {
                    stringTokenizer.nextToken();
                    if (this.equalsNumber(stringTokenizer.nextToken(), 0)) {
                        stringTokenizer.nextToken();
                        if (this.equalsNumber(stringTokenizer.nextToken(), 0)) {
                            return true;
                        }
                    }
                }
                return false;
            }
            stringTokenizer.nextToken();
            string2 = stringTokenizer.nextToken();
            if (this.isValidSubnetPart(string2)) {
                if (!this.equalsNumber(string2, 255)) {
                    stringTokenizer.nextToken();
                    if (this.equalsNumber(stringTokenizer.nextToken(), 0)) {
                        stringTokenizer.nextToken();
                        if (this.equalsNumber(stringTokenizer.nextToken(), 0)) {
                            return true;
                        }
                    }
                    return false;
                }
                stringTokenizer.nextToken();
                string2 = stringTokenizer.nextToken();
                if (this.isValidSubnetPart(string2)) {
                    if (!this.equalsNumber(string2, 255)) {
                        stringTokenizer.nextToken();
                        return this.equalsNumber(stringTokenizer.nextToken(), 0);
                    }
                    stringTokenizer.nextToken();
                    string2 = stringTokenizer.nextToken();
                    if (this.isValidSubnetPart(string2)) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean isSubnetInRange(Object object) {
        String string = (String)object;
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        StringTokenizer stringTokenizer2 = new StringTokenizer(this.minRange, ".", true);
        StringTokenizer stringTokenizer3 = new StringTokenizer(this.maxRange, ".", true);
        int n = Integer.valueOf(stringTokenizer.nextToken());
        int n2 = Integer.valueOf(stringTokenizer2.nextToken());
        int n3 = Integer.valueOf(stringTokenizer3.nextToken());
        if (n >= n2 && n <= n3) {
            stringTokenizer.nextToken();
            stringTokenizer2.nextToken();
            stringTokenizer3.nextToken();
            n = Integer.valueOf(stringTokenizer.nextToken());
            n2 = Integer.valueOf(stringTokenizer2.nextToken());
            n3 = Integer.valueOf(stringTokenizer3.nextToken());
            if (n >= n2 && n <= n3) {
                stringTokenizer.nextToken();
                stringTokenizer2.nextToken();
                stringTokenizer3.nextToken();
                n = Integer.valueOf(stringTokenizer.nextToken());
                n2 = Integer.valueOf(stringTokenizer2.nextToken());
                n3 = Integer.valueOf(stringTokenizer3.nextToken());
                if (n >= n2 && n <= n3) {
                    stringTokenizer.nextToken();
                    stringTokenizer2.nextToken();
                    stringTokenizer3.nextToken();
                    n = Integer.valueOf(stringTokenizer.nextToken());
                    n2 = Integer.valueOf(stringTokenizer2.nextToken());
                    n3 = Integer.valueOf(stringTokenizer3.nextToken());
                    if (n >= n2 && n <= n3) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private boolean isValidSubnetPart(String string) {
        int n = 0;
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return n == 0 || n == 128 || n == 192 || n == 224 || n == 240 || n == 248 || n == 252 || n == 254 || n == 255;
    }

    private boolean equalsNumber(String string, int n) {
        int n2 = 0;
        try {
            n2 = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            return false;
        }
        return n2 == n;
    }

    public ParameterRange copyAndRetainRange(ParameterRange parameterRange) {
        return new SubnetRange("0.0.0.0", "255.255.255.255");
    }

    public ParameterRange copyAndRemove(ParameterRange parameterRange) {
        return new SubnetRange("0.0.0.0", "255.255.255.255");
    }

    public Object convertSubnetToPrefix(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        String string2 = stringTokenizer.nextToken();
        int n = this.getPrefixValue(string2);
        stringTokenizer.nextToken();
        if (string2.equals("255")) {
            string2 = stringTokenizer.nextToken();
            n += this.getPrefixValue(string2);
            stringTokenizer.nextToken();
            if (string2.equals("255")) {
                string2 = stringTokenizer.nextToken();
                n += this.getPrefixValue(string2);
                stringTokenizer.nextToken();
                if (string2.equals("255")) {
                    string2 = stringTokenizer.nextToken();
                    n += this.getPrefixValue(string2);
                }
            }
        }
        return new Integer(n);
    }

    private int getPrefixValue(String string) {
        if (string.equals("255")) {
            return 8;
        }
        if (string.equals("254")) {
            return 7;
        }
        if (string.equals("252")) {
            return 6;
        }
        if (string.equals("248")) {
            return 5;
        }
        if (string.equals("240")) {
            return 4;
        }
        if (string.equals("224")) {
            return 3;
        }
        if (string.equals("192")) {
            return 2;
        }
        if (string.equals("128")) {
            return 1;
        }
        if (string.equals("0")) {
            return 0;
        }
        return 0;
    }

    public String convertPrefixToSubnet(int n) {
        String string = "";
        string = n <= 8 ? this.getSubnetValue(n) + ".0.0.0" : (n <= 16 ? "255." + this.getSubnetValue(n - 8) + ".0.0" : (n <= 24 ? "255.255." + this.getSubnetValue(n - 16) + ".0" : "255.255.255." + this.getSubnetValue(n - 24)));
        return string;
    }

    private String getSubnetValue(int n) {
        if (n == 8) {
            return "255";
        }
        if (n == 7) {
            return "254";
        }
        if (n == 6) {
            return "252";
        }
        if (n == 5) {
            return "248";
        }
        if (n == 4) {
            return "240";
        }
        if (n == 3) {
            return "224";
        }
        if (n == 2) {
            return "192";
        }
        if (n == 1) {
            return "128";
        }
        return "0";
    }

    public String convertSubnetToBinary(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        StringBuffer stringBuffer = new StringBuffer();
        if (stringTokenizer.countTokens() != 7) {
            return null;
        }
        int n = 0;
        while (true) {
            String string2 = stringTokenizer.nextToken();
            int n2 = Integer.parseInt(string2);
            stringBuffer.append(this.intToBinary(n2));
            if (n >= 3) {
                return stringBuffer.toString();
            }
            stringTokenizer.nextToken();
            stringBuffer.append(".");
            ++n;
        }
    }

    private String intToBinary(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        int n2 = 128;
        while (true) {
            if (n >= n2) {
                stringBuffer.append("1");
                n -= n2;
            } else {
                stringBuffer.append("0");
            }
            if (n2 == 1) {
                return stringBuffer.toString();
            }
            n2 /= 2;
        }
    }
}

