/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.rbs.api;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.configurationversion.ConfigurationVersionCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.phase.CabinetPhaseOrder;
import se.ericsson.wcdma.rbs.bem.common.config.phase.OamPhaseOrder;
import se.ericsson.wcdma.rbs.bem.common.config.phase.PhaseOrder;
import se.ericsson.wcdma.rbs.bem.common.config.phase.SitePhaseOrder;
import se.ericsson.wcdma.rbs.bem.common.config.phase.uninstall.UninstallPhaseOrder;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.util.UnlockAllPiusRI;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerImpl;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemLdn;

public final class OpenCIs {
    private static final String CV_NAME_INITIAL = "INITIAL";
    private static final String CV_NAME_OAM = "OAM";
    private static final String CV_NAME_SITE = "SITE";
    private static final String CV_NAME_MODIFY = "Modify";
    private static final String[] allNeededSiteCIs = new String[]{"PowerSystemCI", "RadioEquipmentCI", "CellAndCarrierCI", "AntennaSystemCI", "AlarmCI", "Configuration Version CI", "CabinetBasicCI", "EthernetSwitchCI", "EtmBoardCI", "AtmAndPtCI", "NetworkSyncCI", "FinalizeRbsConfigurationCI"};
    private static final String[] allNeededCabinetCIs = new String[]{"CabinetBasicCI", "EtmBoardCI", "EthernetSwitchCI", "PowerSystemCI", "RadioEquipmentCI", "AlarmCI", "IpOamCI", "Configuration Version CI", "EthernetSwitchCI", "AtmAndPtCI", "NetworkSyncCI", "FinalizeRbsConfigurationCI"};
    private static final String[] allNeededCabinetDuwCIs = new String[]{"CabinetBasicCI", "PowerSystemCI", "RadioEquipmentCI", "AlarmCI", "Configuration Version CI", "IpOamCI", "EthernetSwitchCI", "AtmAndPtCI", "NetworkSyncCI", "FinalizeRbsConfigurationCI"};
    private static final String[] allNeededExportCIs = new String[]{"CabinetBasicCI", "EtmBoardCI", "PowerSystemCI", "RadioEquipmentCI", "CellAndCarrierCI", "AntennaSystemCI", "AlarmCI", "Configuration Version CI", "EthernetSwitchCI", "IpOverGigabitEthernetCI", "AtmAndPtCI", "IpOverAtmCI", "ServerConfigCI", "NetworkSyncCI", "IpOamCI", "IpRoutingCI"};
    private static final String[] allNeededModifyCIs = new String[]{"CabinetBasicCI", "EtmBoardCI", "EthernetSwitchCI", "IpOverGigabitEthernetCI", "AtmAndPtCI", "PowerSystemCI", "RadioEquipmentCI", "CellAndCarrierCI", "AntennaSystemCI", "AlarmCI", "IpOverAtmCI", "NetworkSyncCI", "Configuration Version CI", "IpOamCI", "IpRoutingCI"};
    private static final String[] allNeededOamCIs = new String[]{"CabinetBasicCI", "EtmBoardCI", "EthernetSwitchCI", "IpOverGigabitEthernetCI", "AtmAndPtCI", "IpOverAtmCI", "ServerConfigCI", "NetworkSyncCI", "IpOamCI", "IpRoutingCI", "Configuration Version CI", "FinalizeRbsConfigurationCI"};
    private static final String[] allNeededIubCIs = new String[]{"CabinetBasicCI", "EtmBoardCI", "EthernetSwitchCI", "AtmAndPtCI", "IubCI"};
    private static final String[] allNeededIntegrateRbsBasicCIs = new String[]{"EtmBoardCI", "AutoIntegrationCI"};
    private static final String[] allNeededIntegrateRbsAutomaticCIs = new String[]{"EtmBoardCI", "AutoIntegrationCI", "ServerConfigCI", "EthernetSwitchCI", "IpOverGigabitEthernetCI", "IpOamCI"};
    private static final String[] allNeededIntegrateRbsDhcpCIs = new String[]{"CabinetBasicCI", "ServerConfigCI", "EtmBoardCI", "EthernetSwitchCI", "IpOverGigabitEthernetCI", "IpOamCI"};
    private static final String[] allNeededCbuMigrateCIs = new String[]{"CabinetBasicCI", "EtmBoardCI", "EthernetSwitchCI", "IpOverGigabitEthernetCI", "AtmAndPtCI", "PowerSystemCI", "RadioEquipmentCI", "NetworkSyncCI", "CellAndCarrierCI", "AntennaSystemCI", "AlarmCI", "IpOverAtmCI", "Configuration Version CI", "IpOamCI", "ServerConfigCI", "IpRoutingCI"};
    private static final String[] allNeededDuwMigrateCIs = new String[]{"CabinetBasicCI", "EtmBoardCI", "EthernetSwitchCI", "IpOverGigabitEthernetCI", "AtmAndPtCI", "PowerSystemCI", "RadioEquipmentCI", "CellAndCarrierCI", "AntennaSystemCI", "AlarmCI", "IpOverAtmCI", "Configuration Version CI", "IpOamCI"};

    private static final void openSupportedCIs(Rbs rbs, String[] stringArray) throws BemException {
        OpenCIs.openSupportedCIs(rbs, stringArray, null);
    }

    private static final void openSupportedCIs(Rbs rbs, String[] stringArray, String[] stringArray2) throws BemException {
        boolean bl = false;
        Nal.getLog().nalTraceEnter(OpenCIs.class, "openSupportedCIs()");
        Object[] objectArray = new Object[]{stringArray, stringArray2};
        for (int i = 0; i < 2; ++i) {
            int n;
            if (objectArray[i] == null) continue;
            String[] stringArray3 = (String[])objectArray[i];
            int n2 = 0;
            if (i == 1) {
                n2 = 1;
            }
            for (n = 0; n < stringArray3.length; ++n) {
                bl = rbs.isConfigurationItemSupported(stringArray3[n], n2);
                boolean bl2 = false;
                if (rbs.getConfigItem(stringArray3[n], n2) != null) {
                    bl2 = rbs.getConfigItem(stringArray3[n], n2).isOpen();
                }
                if (!bl || bl2) continue;
                rbs.openConfigurationItem(stringArray3[n], n2);
            }
            for (n = 0; n < stringArray3.length; ++n) {
                ConfigurationItem configurationItem = rbs.getConfigItem(stringArray3[n], n2);
                if (configurationItem == null || !configurationItem.isOpen()) continue;
                configurationItem.afterOpen();
            }
        }
        Nal.getLog().nalTraceReturn(OpenCIs.class, "openSupportedCIs()");
    }

    public static final void openCabinetCIs(Rbs rbs) throws BemException {
        if (rbs.isPantherHybridRbs()) {
            OpenCIs.openCabinetDuwPantherHybridCIs(rbs);
        } else if (DuwUtil.hasDuw()) {
            OpenCIs.openCabinetDuwCIs(rbs);
        } else {
            OpenCIs.openCabinetRbs3AndRbs4CIs(rbs);
        }
    }

    private static final void openCabinetDuwPantherHybridCIs(Rbs rbs) throws BemException {
        CabinetPhaseOrder cabinetPhaseOrder = new CabinetPhaseOrder(OpenCIs.getCurrentPhase(rbs));
        cabinetPhaseOrder.cleanBasedOnStartPhase();
        rbs.setInstallationPhaseOrder(cabinetPhaseOrder);
        ConfigurationVersionCI configurationVersionCI = new ConfigurationVersionCI(rbs, true, CV_NAME_INITIAL, "Generated by Cabinet Equipment Wizard.");
        rbs.registerConfigItem(configurationVersionCI);
        OpenCIs.openSupportedCIs(rbs, allNeededCabinetCIs, allNeededCabinetDuwCIs);
    }

    private static final void openCabinetRbs3AndRbs4CIs(Rbs rbs) throws BemException {
        CabinetPhaseOrder cabinetPhaseOrder = new CabinetPhaseOrder(OpenCIs.getCurrentPhase(rbs));
        cabinetPhaseOrder.cleanBasedOnStartPhase();
        rbs.setInstallationPhaseOrder(cabinetPhaseOrder);
        ConfigurationVersionCI configurationVersionCI = new ConfigurationVersionCI(rbs, true, CV_NAME_INITIAL, "Generated by Cabinet Equipment Wizard.");
        rbs.registerConfigItem(configurationVersionCI);
        OpenCIs.openSupportedCIs(rbs, allNeededCabinetCIs);
    }

    private static final void openCabinetDuwCIs(Rbs rbs) throws BemException {
        CabinetPhaseOrder cabinetPhaseOrder = new CabinetPhaseOrder(OpenCIs.getCurrentPhase(rbs));
        cabinetPhaseOrder.cleanBasedOnStartPhase();
        rbs.setInstallationPhaseOrder(cabinetPhaseOrder);
        ConfigurationVersionCI configurationVersionCI = new ConfigurationVersionCI(rbs, true, CV_NAME_INITIAL, "Generated by Cabinet Equipment Wizard.");
        rbs.registerConfigItem(configurationVersionCI);
        OpenCIs.openSupportedCIs(rbs, allNeededCabinetDuwCIs);
    }

    public static final void openExportXmlCIs(Rbs rbs) throws BemException {
        if (rbs.isPantherHybridRbs()) {
            OpenCIs.openSupportedCIs(rbs, allNeededExportCIs, allNeededExportCIs);
        } else {
            OpenCIs.openSupportedCIs(rbs, allNeededExportCIs);
        }
    }

    private static String getCurrentPhase(Rbs rbs) {
        String string = null;
        try {
            String string2 = rbs.getMoiRefs().getRbsConfigurationMoi().getLdn();
            BemMo bemMo = rbs.getMoHandler().getMo(string2);
            string = (String)rbs.getMoHandler().getAttribute(bemMo, "rbsConfigPhase");
        }
        catch (Throwable throwable) {
            Nal.getLog().nalTraceError(OpenCIs.class, "Could not read rbsConfigPhase", throwable);
        }
        return string;
    }

    public static final void openSiteCIs(Rbs rbs) throws BemException {
        SitePhaseOrder sitePhaseOrder = new SitePhaseOrder(OpenCIs.getCurrentPhase(rbs));
        sitePhaseOrder.cleanBasedOnStartPhase();
        rbs.setInstallationPhaseOrder(sitePhaseOrder);
        ConfigurationVersionCI configurationVersionCI = new ConfigurationVersionCI(rbs, true, CV_NAME_SITE, "Generated by Site Equipment Wizard.");
        rbs.registerConfigItem(configurationVersionCI);
        UnlockAllPiusRI unlockAllPiusRI = new UnlockAllPiusRI(rbs);
        rbs.registerRI(unlockAllPiusRI);
        if (rbs.isPantherHybridRbs()) {
            OpenCIs.openSupportedCIs(rbs, allNeededSiteCIs, allNeededSiteCIs);
        } else {
            OpenCIs.openSupportedCIs(rbs, allNeededSiteCIs);
        }
    }

    public static final void openOamCIs(Rbs rbs) throws BemException {
        Nal.getLog().nalTraceEnter(OpenCIs.class, "openOamCIs()");
        OamPhaseOrder oamPhaseOrder = new OamPhaseOrder(OpenCIs.getCurrentPhase(rbs));
        UninstallPhaseOrder uninstallPhaseOrder = new UninstallPhaseOrder();
        if (OpenCIs.isRobustReconfigurationActivated()) {
            OpenCIs.removeCVPhase(oamPhaseOrder, uninstallPhaseOrder);
        }
        oamPhaseOrder.cleanBasedOnStartPhase();
        rbs.setInstallationPhaseOrder(oamPhaseOrder);
        rbs.setUninstallationPhaseOrder(uninstallPhaseOrder);
        UnlockAllPiusRI unlockAllPiusRI = new UnlockAllPiusRI(rbs);
        rbs.registerRI(unlockAllPiusRI);
        ConfigurationVersionCI configurationVersionCI = new ConfigurationVersionCI(rbs, true, CV_NAME_OAM, "Generated by Oam Wizard.");
        rbs.registerConfigItem(configurationVersionCI);
        OpenCIs.openSupportedCIs(rbs, allNeededOamCIs);
    }

    public static final void openModifyCIs(Rbs rbs) throws BemException {
        Nal.getLog().nalTraceEnter(OpenCIs.class, "openModifyCIs()");
        PhaseOrder phaseOrder = new PhaseOrder(OpenCIs.getCurrentPhase(rbs));
        UninstallPhaseOrder uninstallPhaseOrder = new UninstallPhaseOrder();
        if (OpenCIs.isRobustReconfigurationActivated()) {
            OpenCIs.removeCVPhase(phaseOrder, uninstallPhaseOrder);
        }
        rbs.setInstallationPhaseOrder(phaseOrder);
        rbs.setUninstallationPhaseOrder(uninstallPhaseOrder);
        ConfigurationVersionCI configurationVersionCI = new ConfigurationVersionCI(rbs, true, CV_NAME_MODIFY, "Generated by modify RBS wizard.");
        rbs.registerConfigItem(configurationVersionCI);
        if (rbs.isPantherHybridRbs()) {
            OpenCIs.openSupportedCIs(rbs, allNeededModifyCIs, allNeededModifyCIs);
        } else {
            OpenCIs.openSupportedCIs(rbs, allNeededModifyCIs);
        }
        Nal.getLog().nalTraceReturn(OpenCIs.class, "openModifyCIs()");
    }

    public static final void openIubCIs(Rbs rbs) throws BemException {
        Nal.getLog().nalTraceEnter(OpenCIs.class, "openIubCIs()");
        PhaseOrder phaseOrder = new PhaseOrder(OpenCIs.getCurrentPhase(rbs));
        rbs.setInstallationPhaseOrder(phaseOrder);
        ConfigurationVersionCI configurationVersionCI = new ConfigurationVersionCI(rbs, true, CV_NAME_SITE, "Generated by iub RBS wizard.");
        rbs.registerConfigItem(configurationVersionCI);
        OpenCIs.openSupportedCIs(rbs, allNeededIubCIs);
        Nal.getLog().nalTraceReturn(OpenCIs.class, "openIubCIs()");
    }

    public static final void openIntegrateRbsBasicCIs(Rbs rbs) throws BemException {
        PhaseOrder phaseOrder = new PhaseOrder(OpenCIs.getCurrentPhase(rbs));
        phaseOrder.cleanBasedOnStartPhase();
        rbs.setInstallationPhaseOrder(phaseOrder);
        OpenCIs.openSupportedCIs(rbs, allNeededIntegrateRbsBasicCIs);
    }

    public static final void openIntegrateRbsAutomaticCIs(Rbs rbs) throws BemException {
        PhaseOrder phaseOrder = new PhaseOrder(OpenCIs.getCurrentPhase(rbs));
        phaseOrder.cleanBasedOnStartPhase();
        rbs.setInstallationPhaseOrder(phaseOrder);
        OpenCIs.openSupportedCIs(rbs, allNeededIntegrateRbsAutomaticCIs);
    }

    public static final void openIntegrateRbsDhcpCIs(Rbs rbs) throws BemException {
        PhaseOrder phaseOrder = new PhaseOrder(OpenCIs.getCurrentPhase(rbs));
        rbs.setInstallationPhaseOrder(phaseOrder);
        OpenCIs.openSupportedCIs(rbs, allNeededIntegrateRbsDhcpCIs);
    }

    public static final void openIntegrateRbsCIs(Rbs rbs, boolean bl) throws BemException {
        Nal.getLog().nalTraceEnter(OpenCIs.class, "openIntegrateRbsCIs()");
        PhaseOrder phaseOrder = new PhaseOrder(OpenCIs.getCurrentPhase(rbs));
        rbs.setInstallationPhaseOrder(phaseOrder);
        ArrayList<String> arrayList = new ArrayList<String>();
        List<String> list = Arrays.asList(allNeededOamCIs);
        arrayList.addAll(list);
        List<String> list2 = Arrays.asList(allNeededSiteCIs);
        OpenCIs.addCIsIfNotAdded(arrayList, list2);
        if (bl) {
            arrayList.add("AutoIntegrationCI");
        }
        String[] stringArray = arrayList.toArray(new String[0]);
        UnlockAllPiusRI unlockAllPiusRI = new UnlockAllPiusRI(rbs);
        rbs.registerRI(unlockAllPiusRI);
        ConfigurationVersionCI configurationVersionCI = new ConfigurationVersionCI(rbs, true, CV_NAME_SITE, "Generated by Integrate RBS Application");
        rbs.registerConfigItem(configurationVersionCI);
        OpenCIs.openSupportedCIs(rbs, stringArray);
        Nal.getLog().nalTraceReturn(OpenCIs.class, "openIntegrateRbsCIs()");
    }

    public static final void openMigrateRbsCIs(Rbs rbs, boolean bl) throws BemException {
        PhaseOrder phaseOrder = new PhaseOrder(OpenCIs.getCurrentPhase(rbs));
        rbs.setInstallationPhaseOrder(phaseOrder);
        if (!bl) {
            if (DuwUtil.hasDuw()) {
                OpenCIs.openSupportedCIs(rbs, allNeededDuwMigrateCIs);
            } else {
                OpenCIs.openSupportedCIs(rbs, allNeededCbuMigrateCIs);
            }
        } else {
            ArrayList<String> arrayList = new ArrayList<String>();
            List<String> list = Arrays.asList(allNeededOamCIs);
            arrayList.addAll(list);
            List<String> list2 = Arrays.asList(allNeededSiteCIs);
            OpenCIs.addCIsIfNotAdded(arrayList, list2);
            String[] stringArray = arrayList.toArray(new String[0]);
            UnlockAllPiusRI unlockAllPiusRI = new UnlockAllPiusRI(rbs);
            rbs.registerRI(unlockAllPiusRI);
            ConfigurationVersionCI configurationVersionCI = new ConfigurationVersionCI(rbs, true, "SITE_OAM", "Generated by Migrate RBS Application");
            rbs.registerConfigItem(configurationVersionCI);
            OpenCIs.openSupportedCIs(rbs, stringArray);
        }
    }

    private static final void addCIsIfNotAdded(List list, List list2) {
        for (Object e : list2) {
            if (list.contains(e)) continue;
            list.add(e);
        }
    }

    private static boolean isRobustReconfigurationActivated() throws BemException {
        MoHandlerImpl moHandlerImpl = new MoHandlerImpl();
        BemMo bemMo = moHandlerImpl.getMo(BemLdn.LDN_CONFIGURATION_VERSION);
        NalStruct nalStruct = null;
        try {
            nalStruct = (NalStruct)moHandlerImpl.getAttribute(bemMo, "actionResult");
            if (nalStruct == null || nalStruct.getSize() == 0) {
                return false;
            }
            return (Integer)nalStruct.getMemberValue("invokedAction") == 6 && (Integer)nalStruct.getMemberValue("mainResult") != 2;
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException(moHandlerException);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            throw new BemException(noSuchFieldException);
        }
    }

    private static void removeCVPhase(PhaseOrder phaseOrder, UninstallPhaseOrder uninstallPhaseOrder) {
        uninstallPhaseOrder.removePhase("RollbackCVCreationPhase");
        phaseOrder.removePhase("ConfigurationVersionCreationPhase");
        phaseOrder.removePhase("RollbackCVDeletionPhase");
    }
}

