/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.rbs.rbs6102.configitem;

import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.AbstractPowerSystemCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.BatteryManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.ClimateManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.PowerDistributionManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.PowerSupplyManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.SupportSystemManager;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.ClimateRegulationSystem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.ClimateSystem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.ConfigureBatteryBackupParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.ConfigurePowerSupplyParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.NoOfPduParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.NoOfPsuParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class PowerSupply6102MCI
extends AbstractPowerSystemCI {
    private static final int NUMBER_OF_EXTERNAL_NODES_IF_SECONDARY = 3;
    private static final boolean IS_SUPPORT_SYSTEM_AVAILABLE = true;
    private static final boolean HAS_CLU = false;
    private static final boolean IS_CONFIGURE_SUPPORT_SYSTEM_MANDATORY = false;
    private static final boolean IS_BATTERY_SUPPORTED = true;
    private static final boolean IS_POWER_SUPPLY_SUPPORTED = true;
    private static final boolean IS_POWER_DISTRIBUTION_SUPPORTED = true;
    private static final boolean HAS_SUPPORT_CONTROL_UNIT = true;
    private static final int[] PSU_POSITIONS = new int[]{1, 2, 3, 4, 5};
    private static final int[] PDU_POSITIONS = new int[]{1, 2, 3};
    private static final int[] BFU_POSITIONS = new int[]{1};
    private static final int[] BPA_POSITIONS = new int[]{1};
    private static final IntegerRange PSU_RANGE = new IntegerRange(new Integer(1), new Integer(5));
    private static final IntegerRange PDU_RANGE = new IntegerRange(new Integer(1), new Integer(3));
    private static final IntegerRange BFU_RANGE = new IntegerRange(new Integer(0), new Integer(1));
    private static final IntegerRange BPA_RANGE = new IntegerRange(new Integer(0), new Integer(1));
    private String[] climateRange = new String[]{"Standard", "Extended"};
    private EnumeratedRange CLIMATE_SYSTEM_RANGE = new EnumeratedRange(this.climateRange);
    private String[] climateRegulationSystemRange = new String[]{"NotApplicable"};
    private EnumeratedRange CLIMATE_REGULATION_SYSTEM_RANGE = new EnumeratedRange(this.climateRegulationSystemRange);
    private boolean HAS_NO_SUP = false;

    public PowerSupply6102MCI(Rbs rbs) {
        super(rbs);
    }

    protected void setDefaultParameterValues() {
        this.supportSystemControlCustParam.setDefaultValue("TRUE");
        ((NoOfPsuParameter)this.noOfPsuCustParamMap.get(BemUtil.cabinetWithPDuw)).setDefaultValue("1");
        ((NoOfPduParameter)this.noOfPduCustParamMap.get(BemUtil.cabinetWithPDuw)).setDefaultValue("1");
        ((ConfigurePowerSupplyParameter)this.confPowerSupplyCustParam.get(BemUtil.cabinetWithPDuw)).setDefaultValue("NO");
        ((ConfigureBatteryBackupParameter)this.confBatteryBackupCustParam.get(BemUtil.cabinetWithPDuw)).setDefaultValue("NO");
        ((ClimateSystem)this.climateSystemCustParam.get(BemUtil.cabinetWithPDuw)).setDefaultValue("Standard");
        ((ClimateRegulationSystem)this.climateRegulationSystemCustParamMap.get(BemUtil.cabinetWithPDuw)).setDefaultValue("NotApplicable");
    }

    public boolean hasSupportControlUnit() {
        return true;
    }

    public SupportSystemManager getSupportSystemManager() {
        SupportSystemManager supportSystemManager = new SupportSystemManager(this.rbs, true, false, 3);
        return supportSystemManager;
    }

    public PowerSupplyManager getPowerSupplyManager() {
        PowerSupplyManager powerSupplyManager = new PowerSupplyManager(this.rbs, PSU_POSITIONS, PSU_RANGE, true);
        return powerSupplyManager;
    }

    public PowerDistributionManager getPowerDistributionManager() {
        PowerDistributionManager powerDistributionManager = new PowerDistributionManager(this.rbs, PDU_POSITIONS, PDU_RANGE, true);
        return powerDistributionManager;
    }

    public BatteryManager getBatteryManager() {
        BatteryManager batteryManager = new BatteryManager(this.rbs, BFU_POSITIONS, BPA_POSITIONS, BFU_RANGE, BPA_RANGE, true);
        return batteryManager;
    }

    public ClimateManager getClimateManager() {
        ClimateManager climateManager = new ClimateManager(this.rbs, false, true, this.HAS_NO_SUP, this.CLIMATE_SYSTEM_RANGE, this.CLIMATE_REGULATION_SYSTEM_RANGE);
        return climateManager;
    }
}

