/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.config.resource.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Vector;
import se.ericsson.cello.neal.cm.CmException;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.resource.AbstractResourceItem;
import se.ericsson.wcdma.rbs.bem.common.config.resource.ResourceItem;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimManagedElementData;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalTransaction;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;
import se.ericsson.wcdma.rbs.bem.common.util.BemLdn;

public abstract class AbstractConfigurationVersionRI
extends AbstractResourceItem
implements ResourceItem {
    protected static final String thisLdn = BemLdn.LDN_CONFIGURATION_VERSION;
    private int TRANSACTION_TIMEOUT_LIMIT_MS = 12000000;
    private final BemMo configVersionMo = this.getMo(thisLdn);
    protected String cvName = "";
    protected String identity = "";
    protected int cvType;
    protected String operatorName = "";
    protected String comment = "";

    public AbstractConfigurationVersionRI(String string, Rbs rbs, String[] stringArray) {
        super(string, rbs, stringArray);
    }

    protected void buildCvName(String string) throws BemException {
        StringBuffer stringBuffer = new StringBuffer();
        if (string != null) {
            stringBuffer.append(string);
            stringBuffer.append("_");
        }
        NalStruct nalStruct = this.getUpgradePackageAdministrativeData();
        stringBuffer.append(this.getUpgradePackageProductNumber(nalStruct));
        stringBuffer.append("_");
        stringBuffer.append(this.getUpgradePackageRevision(nalStruct));
        stringBuffer.append("_");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyMMdd'_'HHmmss");
        Date date = this.getDateFromNode();
        stringBuffer.append(simpleDateFormat.format(date));
        String string2 = stringBuffer.toString();
        int n = string2.length();
        if (n > 40) {
            string2 = string2.substring(0, 40);
        }
        this.cvName = string2;
    }

    private NalStruct getUpgradePackageAdministrativeData() throws BemException {
        NalStruct nalStruct = null;
        try {
            BemMo bemMo = (BemMo)this.getAttribute(this.configVersionMo, "currentUpgradePackage");
            nalStruct = (NalStruct)this.getAttribute(bemMo, "administrativeData");
        }
        catch (Exception exception) {
            throw new BemException("Error in getUpgradePackageAdministrativeData()" + exception.toString());
        }
        return nalStruct;
    }

    private String getUpgradePackageProductNumber(NalStruct nalStruct) throws BemException {
        String string = "";
        try {
            string = (String)nalStruct.getMemberValue("productNumber");
        }
        catch (Exception exception) {
            throw new BemException("Error in getUpgradePackageProductNumber()" + exception.toString());
        }
        String string2 = string.replace('/', '_');
        return string2;
    }

    private String getUpgradePackageRevision(NalStruct nalStruct) throws BemException {
        String string = "";
        try {
            string = (String)nalStruct.getMemberValue("productRevision");
        }
        catch (Exception exception) {
            throw new BemException("Error in getUpgradePackageRevision()" + exception.toString());
        }
        String string2 = string.replace('/', '_');
        return string2;
    }

    private Date getDateFromNode() throws BemException {
        Date date = new Date(0L);
        try {
            BemMo bemMo = this.getRoot();
            BemMo[] bemMoArray = this.getChildren(bemMo, 1, MimManagedElementData.MOTYPENAME, "");
            if (bemMoArray != null && bemMoArray.length > 0) {
                BemMo bemMo2 = bemMoArray[0];
                Long l = (Long)this.getAttribute(bemMo2, "nodeUTCTime");
                date = new Date(l);
            }
        }
        catch (Exception exception) {
            throw new BemException("Error in getDateFromNode()" + exception.toString());
        }
        return date;
    }

    protected void createCv() throws BemException {
        NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("configurationVersionName", this.cvName), Nal.getFactory().getNameValue("identity", this.identity), Nal.getFactory().getNameValue("type", new Integer(this.cvType)), Nal.getFactory().getNameValue("operatorName", this.operatorName), Nal.getFactory().getNameValue("comment", this.comment)};
        try {
            this.action(this.configVersionMo, "create", nalNameValueArray);
        }
        catch (Exception exception) {
            throw new BemException("create", this.configVersionMo, nalNameValueArray, (Throwable)exception);
        }
    }

    private void removeCv(String string) throws BemException {
        NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("configurationVersionName", string)};
        try {
            this.action(this.configVersionMo, "delete", nalNameValueArray);
        }
        catch (Exception exception) {
            throw new BemException("Error in removeCv()" + exception.toString());
        }
    }

    protected boolean isCvExisting(String string) throws BemException {
        boolean bl = false;
        try {
            NalStruct[] nalStructArray = (NalStruct[])this.getAttribute(this.configVersionMo, "storedConfigurationVersions");
            if (nalStructArray.length == 0) {
                return false;
            }
            block2: for (int i = 0; i < nalStructArray.length; ++i) {
                NalNameValue[] nalNameValueArray = nalStructArray[i].getNameValueArray();
                for (int j = 0; j < nalNameValueArray.length; ++j) {
                    String string2;
                    String string3 = nalNameValueArray[j].getName();
                    if (string3.equals("name") && (string2 = (String)nalNameValueArray[j].getValue()).equals(string)) {
                        bl = true;
                        continue block2;
                    }
                    if (bl) continue block2;
                }
            }
        }
        catch (Exception exception) {
            throw new BemException("Error in isCvExisting()" + exception.toString());
        }
        return bl;
    }

    public void setCvStartable(String string) throws BemException {
        NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("configurationVersionName", string)};
        this.action(this.configVersionMo, "setStartable", nalNameValueArray);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Object action(BemMo bemMo, String string, NalNameValue[] nalNameValueArray) throws BemException {
        Object object = null;
        boolean bl = false;
        block4: while (true) {
            try {
                while (!bl) {
                    if (super.isInterrupted()) {
                        Nal.getLog().nalTrace(4, this.getClass(), "Action " + string + " on " + bemMo + " interupted by user");
                        throw new BemException("Action Interupted by user");
                    }
                    NalTransaction nalTransaction = Nal.getFactory().createTransaction(this.TRANSACTION_TIMEOUT_LIMIT_MS);
                    try {
                        object = bemMo.action(string, nalNameValueArray, nalTransaction);
                        nalTransaction.commit();
                        bl = true;
                        continue block4;
                    }
                    catch (NalCmException nalCmException) {
                        String string2;
                        bl = false;
                        nalTransaction.rollback("Failed action=" + string + " on mo=" + bemMo.getDN(), nalCmException);
                        Throwable throwable = nalCmException.getCause();
                        String string3 = "";
                        if (throwable instanceof CmException) {
                            string3 = ((CmException)throwable).getRawInfo();
                        }
                        if (-1 != (string2 = nalCmException.toString() + string3).indexOf("ActionNotAllowed")) {
                            Nal.getLog().nalTrace(6, this.getClass(), "Action " + string + " not yet alowed on " + bemMo + ". Retrying ...");
                            Nal.getFactory().sleep(500L);
                            continue;
                        }
                        if (-1 != string2.indexOf("FunctionBusy")) {
                            Nal.getLog().nalTrace(6, this.getClass(), "Action " + string + " blocked by busy " + bemMo + ". Retrying ...");
                            Nal.getFactory().sleep(500L);
                            continue;
                        }
                        if (-1 == string2.indexOf("CELLO_CV_FS_ERROR")) throw nalCmException;
                        Nal.getLog().nalTrace(1, this.getClass(), "Action " + string + " failed, file system is not ready " + bemMo + ". Retrying ...", nalCmException);
                        Nal.getFactory().sleep(500L);
                        continue;
                        return object;
                    }
                }
            }
            catch (Exception exception) {
                throw new BemException(null, "Action->" + string, bemMo.getDN(), this.nameValueArrayToString(nalNameValueArray), exception);
            }
        }
    }

    private String nameValueArrayToString(NalNameValue[] nalNameValueArray) {
        StringBuffer stringBuffer = new StringBuffer();
        if (nalNameValueArray != null) {
            for (int i = 0; i < nalNameValueArray.length; ++i) {
                stringBuffer.append(nalNameValueArray[i]).append(", ");
            }
        }
        return stringBuffer.toString();
    }

    protected void removeExistingCvs(String string) throws BemException {
        try {
            String[] stringArray = this.getExistingCvNames(string);
            for (int i = 0; i < stringArray.length; ++i) {
                String string2 = stringArray[i];
                boolean bl = this.isCvStartable(string2);
                boolean bl2 = this.isCvLoaded(string2);
                boolean bl3 = this.isCvLastCreated(string2);
                if (bl || bl2 || bl3) continue;
                this.removeCvFromRollbackIfExisting(string2);
                this.removeCv(string2);
                if (!string2.equals(this.cvName)) continue;
                this.cvName = null;
            }
        }
        catch (Exception exception) {
            throw new BemException("Error in isCvExisting()" + exception.toString());
        }
    }

    protected String[] getExistingCvNames(String string) throws BemException {
        Object[] objectArray;
        Vector<String> vector = new Vector<String>(1, 0);
        try {
            objectArray = (NalStruct[])this.getAttribute(this.configVersionMo, "storedConfigurationVersions");
            if (objectArray.length != 0) {
                for (int i = 0; i < objectArray.length; ++i) {
                    String string2 = (String)objectArray[i].getMemberValue("name");
                    if (!string2.startsWith(string)) continue;
                    vector.add(string2);
                }
            }
        }
        catch (Exception exception) {
            throw new BemException(exception.toString());
        }
        objectArray = new String[]{};
        if (vector.size() > 0) {
            objectArray = (String[])vector.toArray(objectArray);
        }
        return objectArray;
    }

    protected boolean isCvStartable(String string) throws BemException {
        boolean bl = false;
        try {
            String string2 = (String)this.getAttribute(this.configVersionMo, "startableConfigurationVersion");
            if (string2 != null && string2.equals(string)) {
                bl = true;
            }
        }
        catch (Exception exception) {
            throw new BemException("Error in isCvStartable()" + exception.toString());
        }
        return bl;
    }

    private boolean isCvLoaded(String string) throws BemException {
        boolean bl = false;
        try {
            String string2 = (String)this.getAttribute(this.configVersionMo, "currentLoadedConfigurationVersion");
            if (string2 != null && string2.equals(string)) {
                bl = true;
            }
        }
        catch (Exception exception) {
            throw new BemException("Error in isCvLoaded()" + exception.toString());
        }
        return bl;
    }

    private boolean isCvLastCreated(String string) throws BemException {
        boolean bl = false;
        try {
            String string2 = (String)this.getAttribute(this.configVersionMo, "lastCreatedCv");
            if (string2 != null && string2.equals(string)) {
                bl = true;
            }
        }
        catch (Exception exception) {
            throw new BemException("Error in isCvLastCreated()" + exception.toString());
        }
        return bl;
    }

    private boolean isCvExistingInRollBackList(String string) throws BemException {
        boolean bl = false;
        try {
            String[] stringArray = (String[])this.getAttribute(this.configVersionMo, "rollbackList");
            if (stringArray != null && stringArray.length != 0) {
                for (int i = 0; i < stringArray.length; ++i) {
                    if (!stringArray[i].equals(string)) continue;
                    bl = true;
                }
            }
        }
        catch (Exception exception) {
            throw new BemException("Error in isCvExistingInRollBackList()" + exception.toString());
        }
        return bl;
    }

    private boolean removeCvFromRollbackIfExisting(String string) throws BemException {
        boolean bl = false;
        try {
            bl = this.isCvExistingInRollBackList(string);
            if (bl) {
                NalNameValue[] nalNameValueArray = new NalNameValue[]{Nal.getFactory().getNameValue("configurationVersionName", string)};
                this.action(this.configVersionMo, "removeFromRollbackList", nalNameValueArray);
            }
        }
        catch (Exception exception) {
            throw new BemException("Error in removeCvFromRollbackIfExisting()" + exception.toString());
        }
        return bl;
    }

    public String getCvName() {
        return this.cvName;
    }
}

