/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.EventObject;
import javax.swing.JCheckBox;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;
import javax.swing.table.TableCellRenderer;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.gui.EditorRendererBase;

public class CheckBoxRenderer
extends EditorRendererBase
implements TableCellRenderer,
ActionListener {
    private final JCheckBox editor = new JCheckBox();
    private boolean isCellNotEditable = false;

    public CheckBoxRenderer(CustomerParameter customerParameter) {
        super(customerParameter);
        this.editor.setHorizontalAlignment(0);
        this.editor.addActionListener(this);
    }

    public CheckBoxRenderer(CustomerParameter customerParameter, boolean bl) {
        super(customerParameter);
        this.editor.setHorizontalAlignment(0);
        this.editor.addActionListener(this);
        this.isCellNotEditable = bl;
    }

    public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
        if (object != null && object instanceof YesNoCustomerParameter) {
            YesNoCustomerParameter yesNoCustomerParameter = (YesNoCustomerParameter)object;
            this.arrangeCheckBox(yesNoCustomerParameter);
            if (bl) {
                this.editor.setForeground(jTable.getSelectionForeground());
                this.editor.setBackground(jTable.getSelectionBackground());
            } else {
                this.editor.setForeground(jTable.getForeground());
                this.editor.setBackground(jTable.getBackground());
            }
            if (bl2) {
                Border border = null;
                if (bl) {
                    border = UIManager.getBorder("Table.focusSelectedCellHighlightBorder");
                }
                if (border == null) {
                    border = UIManager.getBorder("Table.focusCellHighlightBorder");
                }
                this.editor.setBorderPainted(true);
                this.editor.setBorder(border);
                if (!bl && jTable.isCellEditable(n, n2)) {
                    Color color = UIManager.getColor("Table.focusCellForeground");
                    if (color != null) {
                        this.editor.setForeground(color);
                    }
                    if ((color = UIManager.getColor("Table.focusCellBackground")) != null) {
                        this.editor.setBackground(color);
                    }
                }
            } else {
                this.editor.setBorderPainted(true);
                this.editor.setBorder(new EmptyBorder(1, 1, 1, 1));
            }
        }
        return this.editor;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        boolean bl = this.editor.isSelected();
        String string = "NO";
        if (bl) {
            string = "YES";
        }
        this.setCustomerParameterValue(string);
    }

    private void arrangeCheckBox(YesNoCustomerParameter yesNoCustomerParameter) {
        boolean bl = this.customerParameter.isValidValue("YES");
        boolean bl2 = this.customerParameter.isValidValue("NO");
        if (!bl || !bl2) {
            if (bl) {
                this.editor.setSelected(true);
            } else {
                this.editor.setSelected(false);
            }
        } else {
            YesNoCustomerParameter yesNoCustomerParameter2 = yesNoCustomerParameter;
            String string = yesNoCustomerParameter2.getValue();
            if (string.equals("YES")) {
                this.editor.setSelected(true);
            } else {
                this.editor.setSelected(false);
            }
        }
    }

    public boolean isCellEditable(EventObject eventObject) {
        if (this.isCellNotEditable) {
            return false;
        }
        boolean bl = super.isCellEditable(eventObject);
        if (bl) {
            boolean bl2 = this.customerParameter.isValidValue("YES");
            boolean bl3 = this.customerParameter.isValidValue("NO");
            bl = bl2 && bl3;
        }
        return bl;
    }
}

