/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JCheckBox;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.BooleanCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.EnumeratedRange;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterComponent;

public class CustomerParameterCheckbox
extends JCheckBox
implements CustomerParameterComponent,
CustomerParameterListener {
    private ActionListener listener;
    private final BooleanCustomerParameter customerParameter;
    private boolean isOneValueRange;
    private final ArrayList stopEditingListener = new ArrayList();

    public CustomerParameterCheckbox(String string, BooleanCustomerParameter booleanCustomerParameter) {
        super(string);
        this.customerParameter = booleanCustomerParameter;
        this.init();
    }

    private void init() {
        if (this.customerParameter == null) {
            System.out.println("Error: Customer parameter is not set for: " + this.getText());
            return;
        }
        this.listener = new InputListener();
        this.addActionListener(this.listener);
        this.updateGui();
        this.customerParameter.addCustomerParameterListener(this);
    }

    public CustomerParameter getCustomerParameter() {
        return this.customerParameter;
    }

    public void removeListeners() {
        this.removeActionListener(this.listener);
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        if (customerParameter != this.customerParameter) {
            return;
        }
        this.updateGui();
    }

    private void updateGui() {
        this.updateGuiRange();
        this.updateGuiValue();
        this.updateGuiAccess();
    }

    private void updateGuiAccess() {
        int n = this.customerParameter.getAccessLevel();
        switch (n) {
            case 1: {
                this.setSelected(false);
                this.setEnabled(false);
                break;
            }
            case 3: {
                if (this.isOneValueRange) {
                    this.setEnabled(false);
                    break;
                }
                this.setEnabled(true);
                break;
            }
            case 2: {
                this.setEnabled(true);
                break;
            }
            case 0: {
                this.setEnabled(false);
                break;
            }
            default: {
                System.out.println("Error: Undefined access level: " + n + " for: " + this.getText());
            }
        }
    }

    private void updateGuiRange() {
        EnumeratedRange enumeratedRange = (EnumeratedRange)this.customerParameter.getEnabledValueRange();
        List list = enumeratedRange.getRangeValues();
        if (list.size() < 2) {
            this.isOneValueRange = true;
            this.setEnabled(false);
            if (list.contains(this.customerParameter.getTrueValue())) {
                this.setSelected(true);
            } else {
                this.setSelected(false);
            }
            this.updateCpValue();
        } else {
            this.isOneValueRange = false;
            this.setEnabled(true);
        }
    }

    private void updateGuiValue() {
        boolean bl = this.customerParameter.getBooleanValue();
        this.setSelected(bl);
    }

    public void updateCpValue() {
        this.customerParameter.setValue(this.isSelected());
    }

    public void addTableStopEditingListener(StopTableEditingListener stopTableEditingListener) {
        this.stopEditingListener.add(stopTableEditingListener);
    }

    public void notifyStopediting() {
        for (StopTableEditingListener stopTableEditingListener : this.stopEditingListener) {
            stopTableEditingListener.stopEdit();
        }
    }

    private class InputListener
    implements ActionListener {
        private InputListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            CustomerParameterCheckbox.this.updateCpValue();
            CustomerParameterCheckbox.this.notifyStopediting();
        }
    }

    public static interface StopTableEditingListener {
        public void stopEdit();
    }
}

