/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.gui;

import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.JPasswordField;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterRange;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterComponent;

public class CustomerParameterPasswordField
extends JPasswordField
implements CustomerParameterListener,
CustomerParameterComponent {
    private FocusListener focusListener;
    private CustomerParameter customerParameter;

    public CustomerParameterPasswordField(CustomerParameter customerParameter) {
        this.init(customerParameter);
    }

    public CustomerParameter getCustomerParameter() {
        return this.customerParameter;
    }

    public void removeListeners() {
        this.removeFocusListener(this.focusListener);
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        if (customerParameter != this.customerParameter) {
            return;
        }
        this.updateValue();
    }

    private void init(CustomerParameter customerParameter) {
        this.customerParameter = customerParameter;
        if (customerParameter == null) {
            System.out.println("Error: Customer parameter not set for: " + this.getClass().getName());
            return;
        }
        this.updateValue();
        this.customerParameter.addCustomerParameterListener(this);
        this.focusListener = new FocusListener();
        this.addFocusListener(this.focusListener);
    }

    private void updateValue() {
        String string = this.customerParameter.getValue();
        if (string.equals("##UNDEFINED")) {
            this.setText("");
        } else {
            this.setText(this.customerParameter.getValue());
        }
        this.updateAccessLevel();
        this.checkValidity();
        this.updateToolTip();
    }

    private void updateToolTip() {
        ParameterRange parameterRange = this.customerParameter.getEnabledValueRange();
        this.setToolTipText(parameterRange.getDescription());
    }

    private void checkValidity() {
        if ("".equals(new String(this.getPassword()))) {
            this.setForeground(null);
            return;
        }
        if (!this.customerParameter.isValidValue()) {
            this.setForeground(Color.red);
        } else {
            this.setForeground(null);
        }
    }

    private void updateAccessLevel() {
        switch (this.customerParameter.getAccessLevel()) {
            case 1: {
                this.setEditable(false);
                this.setText("");
                break;
            }
            case 3: {
                this.setEditable(true);
                break;
            }
            case 2: {
                this.setEditable(true);
                break;
            }
            case 0: {
                this.setEditable(false);
                break;
            }
        }
    }

    private class FocusListener
    extends FocusAdapter {
        private FocusListener() {
        }

        public void focusLost(FocusEvent focusEvent) {
            try {
                CustomerParameterPasswordField.this.customerParameter.setValue(new String(CustomerParameterPasswordField.this.getPassword()));
            }
            catch (Exception exception) {
                // empty catch block
            }
            CustomerParameterPasswordField.this.checkValidity();
        }
    }
}

