/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractApplicationController;

public class ProgressMonitor
extends JDialog {
    private Component parentComponent;
    private AbstractApplicationController parentController;
    private Object totalMessage;
    private Object stepMessage;
    private String totalNote;
    private String stepNote;
    private int min;
    private int max;
    private int lastTotalDisp;
    private int lastStepDisp;
    private int reportDelta;
    private GridBagLayout progressGridBagLayout = new GridBagLayout();
    private JPanel progressPanel;
    private JPanel buttonPanel;
    private JLabel totalProgressLabel;
    private JLabel stepProgressLabel;
    private JProgressBar totalBar;
    private JProgressBar stepBar;
    private String cancelStr = "Cancel";
    private JButton cancelButton;
    private boolean canceled = false;
    private Component comp;
    private int width;
    private int height;
    private static final int DEFAULT_HEIGHT = 200;
    private static final int DEFAULT_WIDTH = 500;

    public ProgressMonitor() {
    }

    public ProgressMonitor(Component component, AbstractApplicationController abstractApplicationController, Object object, Object object2, Object object3, int n, int n2) {
        this(component, abstractApplicationController, object, object2, null, object3, null, n, n2, null);
    }

    public ProgressMonitor(Component component, AbstractApplicationController abstractApplicationController, Object object, int n, int n2) {
        this(component, abstractApplicationController, object, "Overall Progress - ", null, "Step Progress - ", null, n, n2, null);
    }

    private ProgressMonitor(Component component, AbstractApplicationController abstractApplicationController, Object object, Object object2, String string, Object object3, String string2, int n, int n2, ProgressMonitor progressMonitor) {
        super(JOptionPane.getFrameForComponent(component), object.toString());
        this.min = n;
        this.max = n2;
        this.parentComponent = component;
        this.parentController = abstractApplicationController;
        this.reportDelta = (this.max - this.min) / 100;
        if (this.reportDelta < 1) {
            this.reportDelta = 1;
        }
        this.totalMessage = object2;
        this.stepMessage = object3;
        this.totalNote = string;
        this.stepNote = string2;
        this.width = 500;
        this.height = 200;
    }

    public void setProgress(int n, String string) {
        if (string.equals("Total") && n >= this.max) {
            this.close();
        } else if (n >= this.lastTotalDisp || n >= this.lastStepDisp) {
            if (this.progressPanel != null) {
                this.repaintImmediately();
            } else {
                this.createProgressBars();
                this.cancelButton = new JButton(this.cancelStr);
                this.progressPanel = new JPanel();
                this.progressPanel.setLayout(this.progressGridBagLayout);
                GridBagConstraints gridBagConstraints = new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 18, 0, new Insets(5, 5, 0, 5), 0, 0);
                this.progressPanel.add((Component)this.totalProgressLabel, gridBagConstraints);
                gridBagConstraints.fill = 2;
                gridBagConstraints.gridy = 1;
                gridBagConstraints.weightx = 1.0;
                this.progressPanel.add((Component)this.totalBar, gridBagConstraints);
                gridBagConstraints.fill = 0;
                gridBagConstraints.gridy = 2;
                gridBagConstraints.weightx = 0.0;
                this.progressPanel.add((Component)this.stepProgressLabel, gridBagConstraints);
                gridBagConstraints.fill = 2;
                gridBagConstraints.gridy = 3;
                gridBagConstraints.weightx = 1.0;
                this.progressPanel.add((Component)this.stepBar, gridBagConstraints);
                gridBagConstraints.gridy = 4;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.fill = 1;
                this.progressPanel.add((Component)new JPanel(), gridBagConstraints);
                this.buttonPanel = new JPanel();
                this.buttonPanel.setLayout(new FlowLayout());
                gridBagConstraints.gridy = 5;
                gridBagConstraints.weightx = 1.0;
                gridBagConstraints.weighty = 0.0;
                gridBagConstraints.anchor = 10;
                gridBagConstraints.fill = 0;
                this.buttonPanel.add(this.cancelButton);
                this.progressPanel.add((Component)this.cancelButton, gridBagConstraints);
                this.progressPanel.setBorder(BorderFactory.createEmptyBorder());
                this.cancelButton.addActionListener(new CancelButtonListener(this.cancelStr));
                this.setDefaultCloseOperation(2);
                this.getContentPane().add((Component)this.progressPanel, "Center");
                this.getContentPane().add((Component)this.buttonPanel, "South");
                this.setSize(this.width, this.height);
                this.setResizable(false);
                this.setLocationRelativeTo(this.parentComponent);
                this.setVisible(true);
                this.repaintImmediately();
            }
        }
    }

    public void reportTotalProgress(int n, String string) {
        if (this.totalBar != null) {
            this.totalProgressLabel.setText(this.totalMessage + string);
            this.totalBar.setValue(n);
        }
        this.totalNote = string;
        this.lastTotalDisp = n;
        this.setProgress(n, "Total");
    }

    public void reportProgress(int n, String string) {
        if (this.stepBar != null) {
            this.stepBar.setValue(n);
            this.stepProgressLabel.setText(this.stepMessage + string);
        }
        this.stepNote = string;
        this.lastStepDisp = n;
        this.setProgress(n, "Step");
    }

    private void createProgressBars() {
        this.totalProgressLabel = new JLabel(this.totalMessage.toString() + this.totalNote);
        this.totalBar = new JProgressBar();
        this.totalBar.setMinimum(this.min);
        this.totalBar.setMaximum(this.max);
        this.totalBar.setStringPainted(true);
        this.stepProgressLabel = new JLabel(this.stepMessage.toString() + this.stepNote);
        this.stepBar = new JProgressBar();
        this.stepBar.setMinimum(this.min);
        this.stepBar.setMaximum(this.max);
        this.stepBar.setStringPainted(true);
    }

    private void repaintImmediately() {
        this.comp = this.getRootPane();
        if (this.comp instanceof JComponent) {
            if (SwingUtilities.isEventDispatchThread()) {
                this.comp.update(this.comp.getGraphics());
            } else {
                this.comp.repaint();
            }
        } else {
            this.comp.repaint(0, 0, this.comp.getWidth(), this.comp.getHeight());
        }
    }

    public void close() {
        this.setVisible(false);
        this.dispose();
        this.progressPanel = null;
        this.totalProgressLabel = null;
        this.stepProgressLabel = null;
        this.totalBar = null;
        this.stepBar = null;
        this.cancelButton = null;
    }

    public int getMinimum() {
        return this.min;
    }

    public void setMinimum(int n) {
        this.min = n;
    }

    public int getMaximum() {
        return this.max;
    }

    public void setMaximum(int n) {
        this.max = n;
    }

    public boolean isCanceled() {
        if (this.progressPanel == null) {
            return false;
        }
        return this.canceled;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    class CancelButtonListener
    implements ActionListener {
        private String command;

        public CancelButtonListener(String string) {
            this.command = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.command.equalsIgnoreCase(ProgressMonitor.this.cancelStr)) {
                ProgressMonitor.this.canceled = true;
                ProgressMonitor.this.parentController.setCancelled(true);
            }
        }
    }
}

