/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.gui;

import java.awt.Color;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import javax.swing.JTextField;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.gui.IntegerDocument;

public class TextFieldEditor
extends JTextField
implements KeyListener {
    protected CustomerParameter customerParameter = null;
    protected KeyListener keyListener = null;

    public TextFieldEditor(CustomerParameter customerParameter) {
        this.customerParameter = customerParameter;
        if (customerParameter instanceof IntegerParameter) {
            this.setHorizontalAlignment(4);
            this.setDocument(new IntegerDocument());
        }
        this.keyListener = this;
        this.addKeyListener(this.keyListener);
        this.addFocusListener(new FocusListener());
        String string = customerParameter.getValue();
        this.setText(string);
        this.keyReleased(null);
    }

    public void keyReleased(KeyEvent keyEvent) {
        try {
            this.setForeground(Color.black);
            int n = this.customerParameter.getAccessLevel();
            if (n == 1) {
                this.setText("-");
                this.setHorizontalAlignment(0);
            } else {
                if (this.customerParameter instanceof IntegerParameter) {
                    this.setHorizontalAlignment(4);
                }
                String string = this.getText();
                this.customerParameter.setValue(string);
                if (!this.customerParameter.isValidValue()) {
                    this.setForeground(Color.red);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    private class FocusListener
    extends FocusAdapter {
        public void focusLost(FocusEvent focusEvent) {
            TextFieldEditor.this.keyReleased(null);
        }
    }
}

