/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.gui.components;

import java.awt.Color;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Locale;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.gui.components.BemLabelledField;

public abstract class BemEntryField
extends BemLabelledField
implements FocusListener,
KeyListener {
    public JTextField textField = null;
    private ActionListener actionListener = null;
    private String actionCommand = null;
    private String tooltipText = null;
    private String text = null;

    public BemEntryField(String string, String string2, Integer n) {
        super(string, string2);
        BemLog.trace("Constructor()");
        this.textField = new JTextField(n);
        this.textField.setMinimumSize(this.textField.getPreferredSize());
        this.textField.addFocusListener(this);
        this.textField.addKeyListener(this);
        this.add(this.textField);
        this.textField.setToolTipText(this.tooltipText);
        this.toolTipTag = this.getTag();
    }

    public BemEntryField(String string, Integer n) {
        super(string);
        BemLog.trace("EntryField()");
        this.textField = new JTextField(n);
        this.textField.setMinimumSize(this.textField.getPreferredSize());
        this.textField.addFocusListener(this);
        this.textField.addKeyListener(this);
        this.add(this.textField);
        this.textField.setToolTipText(this.tooltipText);
    }

    public void setActionListener(ActionListener actionListener, String string) {
        this.actionListener = actionListener;
        this.actionCommand = string;
    }

    public abstract boolean isCorrectSyntax(String var1);

    abstract boolean fillInValue(String var1);

    abstract String getTag();

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        if (this.isCorrectSyntax("")) {
            this.textField.setForeground(Color.black);
        }
        if (this.actionListener != null && !this.textField.getText().equals(this.text)) {
            this.text = this.textField.getText();
            this.actionListener.actionPerformed(new ActionEvent(this, 0, "ENTRYFIELD_FILLEDIN"));
        }
    }

    public boolean isFilledIn() {
        return !this.textField.getText().equals("") && this.isCorrectSyntax("");
    }

    public void focusGained(FocusEvent focusEvent) {
        this.text = this.textField.getText();
    }

    public void focusLost(FocusEvent focusEvent) {
        BemLog.trace("focusLost()");
        if (!focusEvent.isTemporary()) {
            if (!this.textField.getText().equals("")) {
                if (!this.isCorrectSyntax("")) {
                    this.textField.setForeground(Color.red);
                    SwingUtilities.invokeLater(new Runnable(){

                        public void run() {
                            BemEntryField.this.textField.requestFocus();
                            Toolkit.getDefaultToolkit().beep();
                        }
                    });
                } else {
                    this.textField.setForeground(Color.black);
                    if (this.fillInValue(this.textField.getText()) && this.actionListener != null) {
                        this.actionListener.actionPerformed(new ActionEvent(this, 0, this.actionCommand));
                    }
                }
            } else {
                boolean bl = this.fillInValue("");
                if (bl && this.actionListener != null) {
                    this.actionListener.actionPerformed(new ActionEvent(this, 0, this.actionCommand));
                }
            }
        }
    }

    public Object getFieldComponent() {
        BemLog.trace("getFieldComponent()");
        return this.textField;
    }

    public void updateLocale(Locale locale) {
        super.updateLocale(locale);
        this.translateTooltip(locale);
    }
}

