/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.moi;

import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimPlugInUnit;
import se.ericsson.wcdma.rbs.bem.common.mim.MimSubrack;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandlerException;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class HubSubrackMoi
extends MoInstance {
    MoInstance parentMoi;
    String defaultRdnId = "1";

    public HubSubrackMoi(MoInstance moInstance) {
        this.parentMoi = moInstance;
    }

    protected String getDiscoveredOrDefaultLdn() throws BemException {
        MoHandler moHandler = this.getMoHandler();
        String string = null;
        try {
            String string2 = this.parentMoi.getLdn();
            BemMo bemMo = moHandler.getMo(string2);
            if (moHandler.isExisting(bemMo)) {
                BemMo[] bemMoArray = moHandler.getChildren(bemMo, 1, MimSubrack.MOTYPENAME, "");
                if (bemMoArray != null && bemMoArray.length > 0) {
                    for (int i = 0; i < bemMoArray.length; ++i) {
                        BemMo bemMo2 = bemMoArray[i];
                        boolean bl = this.isHubSubrack(bemMo2);
                        if (!bl) continue;
                        string = bemMo2.getDN();
                        break;
                    }
                } else {
                    throw new BemException("No Subrack found ");
                }
            }
            if (string == null) {
                string = this.generateDefaultLdn(string2, MimSubrack.MOTYPENAME, this.defaultRdnId);
            }
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("MoHandlerException at discovery of MOI", "-", (Throwable)moHandlerException);
        }
        return string;
    }

    private boolean isHubSubrack(BemMo bemMo) throws MoHandlerException {
        boolean bl = false;
        MoHandler moHandler = this.getMoHandler();
        BemMo[] bemMoArray = moHandler.getChildren(bemMo, 2, MimPlugInUnit.MOTYPENAME, "");
        if (bemMoArray != null && bemMoArray.length > 0) {
            for (int i = 0; i < bemMoArray.length; ++i) {
                Integer n;
                BemMo bemMo2 = bemMoArray[i];
                BemMo bemMo3 = (BemMo)bemMo2.getAttribute("piuType");
                if (bemMo3 == null || 1 != (n = (Integer)bemMo3.getAttribute("role"))) continue;
                bl = true;
                break;
            }
        }
        return bl;
    }

    public boolean isExisting() throws BemException {
        boolean bl = false;
        try {
            String string = this.getDiscoveredOrDefaultLdn();
            MoHandler moHandler = this.getMoHandler();
            BemMo bemMo = moHandler.getMo(string);
            bl = moHandler.isExisting(bemMo);
        }
        catch (MoHandlerException moHandlerException) {
            throw new BemException("isExisting", this.toString(), (Throwable)moHandlerException);
        }
        return bl;
    }
}

