/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.moi;

import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.mim.MimEquipment;
import se.ericsson.wcdma.rbs.bem.common.mim.MimRbsSubrack;
import se.ericsson.wcdma.rbs.bem.common.mohandler.MoHandler;
import se.ericsson.wcdma.rbs.bem.common.moi.MoInstance;
import se.ericsson.wcdma.rbs.bem.common.moi.RootMoi;
import se.ericsson.wcdma.rbs.bem.common.moi.SingleChildMoi;
import se.ericsson.wcdma.rbs.bem.common.proxy.BemMo;

public class RbsSubrackMoi
extends MoInstance {
    private final String[] requiredMos;
    private final String defaultRdnId;
    private boolean searchForDefaultRdn;

    public RbsSubrackMoi(String[] stringArray, String string) {
        this.requiredMos = stringArray;
        this.defaultRdnId = string;
        this.searchForDefaultRdn = false;
    }

    public RbsSubrackMoi(String[] stringArray, String string, boolean bl) {
        this(stringArray, string);
        this.searchForDefaultRdn = bl;
    }

    protected String getDiscoveredOrDefaultLdn() throws BemException {
        String string = null;
        try {
            BemMo bemMo;
            RootMoi rootMoi = new RootMoi();
            SingleChildMoi singleChildMoi = new SingleChildMoi(rootMoi, MimEquipment.MOTYPENAME, "1");
            String[] stringArray = this.getAllRbsSubracks(singleChildMoi);
            for (int i = 0; i < stringArray.length; ++i) {
                bemMo = this.getMoHandler().getMo(stringArray[i]);
                if (!this.findAllMos(bemMo)) continue;
                string = stringArray[i];
                if (this.searchForDefaultRdn && !string.endsWith(this.defaultRdnId)) {
                    string = null;
                    continue;
                }
                return string;
            }
            String string2 = singleChildMoi.getLdn() + "," + MimRbsSubrack.MOTYPENAME + "=" + this.defaultRdnId;
            bemMo = this.getMoHandler().getMo(string2);
            string = this.getMoHandler().isExisting(bemMo) ? string2 : this.generateDefaultLdn(singleChildMoi.getLdn(), MimRbsSubrack.MOTYPENAME, this.defaultRdnId);
        }
        catch (BemException bemException) {
            throw bemException;
        }
        catch (Exception exception) {
            throw new BemException(exception.toString(), (Throwable)exception);
        }
        return string;
    }

    private boolean findAllMos(BemMo bemMo) throws Exception {
        BemMo[] bemMoArray = null;
        for (int i = 0; i < this.requiredMos.length; ++i) {
            bemMoArray = this.getMoHandler().getChildren(bemMo, 3, this.requiredMos[i], "");
            if (bemMoArray.length != 0) continue;
            return false;
        }
        return true;
    }

    private String[] getAllRbsSubracks(MoInstance moInstance) throws Exception {
        String[] stringArray = null;
        MoHandler moHandler = this.getMoHandler();
        String string = moInstance.getLdn();
        BemMo[] bemMoArray = moHandler.getChildren(moHandler.getMo(string), 1, MimRbsSubrack.MOTYPENAME, "");
        stringArray = new String[bemMoArray.length];
        for (int i = 0; i < bemMoArray.length; ++i) {
            stringArray[i] = bemMoArray[i].getDN();
        }
        return stringArray;
    }
}

