/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.nal.impl.backend;

import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmNotificationConsumer;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmSubscription;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalMo;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalTransaction;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.backend.NalMoBackend;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.backend.NalMoMsg;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.backend.NalTransactionDefault;

public class NalMoTransactionDefault
extends NalMoBackend
implements NalMo,
Comparable {
    private static final int LEV_HIGHER = 4;
    private static final int LEV_LOWER = 5;
    private static final boolean WRITE_OP = true;
    private static final boolean READ_OP = false;
    private final NalMo delegate;

    public NalMoTransactionDefault(NalMo nalMo) {
        super(nalMo.getLdn());
        this.delegate = nalMo;
    }

    public Object getNative() {
        return this.delegate.getNative();
    }

    public Object action(String string, NalNameValue[] nalNameValueArray, NalTransaction nalTransaction) {
        nalTransaction = new NalTransactionDefault(true, nalTransaction);
        try {
            NalMoMsg nalMoMsg = NalMoMsg.newLog(4);
            if (nalMoMsg != null) {
                nalMoMsg.addHeader("action", this, string);
                nalMoMsg.addParam("Parameters", nalNameValueArray);
                nalMoMsg.addTail(this, nalTransaction);
                nalMoMsg.logMoOperation();
            }
            Object object = this.delegate.action(string, nalNameValueArray, nalTransaction);
            if (nalMoMsg != null) {
                nalMoMsg.logResult(object);
            }
            NalMoTransactionDefault.assertDecorated(this.delegate.getClass(), "action=" + string, object);
            nalTransaction.commit();
            return object;
        }
        catch (Exception exception) {
            String string2 = "Action " + string + " failed on NalMo " + this;
            nalTransaction.rollback(string2, exception);
            throw new NalCmException(string2, exception);
        }
    }

    public void create(NalTransaction nalTransaction) {
        nalTransaction = new NalTransactionDefault(true, nalTransaction);
        try {
            NalMoMsg nalMoMsg = NalMoMsg.newLog(4);
            if (nalMoMsg != null) {
                nalMoMsg.addHeader("create", this, null);
                nalMoMsg.addTail(this, nalTransaction);
                nalMoMsg.logMoOperation();
            }
            this.delegate.create(nalTransaction);
            nalTransaction.commit();
        }
        catch (Exception exception) {
            String string = "Failed to create NalMo " + this + " on the node!";
            nalTransaction.rollback(string, exception);
            throw new NalCmException(string, exception);
        }
    }

    public void create(NalNameValue[] nalNameValueArray, NalTransaction nalTransaction) {
        nalTransaction = new NalTransactionDefault(true, nalTransaction);
        try {
            NalMoMsg nalMoMsg = NalMoMsg.newLog(4);
            if (nalMoMsg != null) {
                nalMoMsg.addHeader("create", this, null);
                nalMoMsg.addParam("MoAttributes", nalNameValueArray);
                nalMoMsg.addTail(this, nalTransaction);
                nalMoMsg.logMoOperation();
            }
            this.delegate.create(nalNameValueArray, nalTransaction);
            nalTransaction.commit();
        }
        catch (Exception exception) {
            String string = "Failed to create NalMo " + this + " on the node!";
            nalTransaction.rollback(string, exception);
            throw new NalCmException(string, exception);
        }
    }

    public NalMo createChild(String string, String string2, NalNameValue[] nalNameValueArray, NalTransaction nalTransaction) {
        nalTransaction = new NalTransactionDefault(true, nalTransaction);
        try {
            NalMoMsg nalMoMsg = NalMoMsg.newLog(4);
            if (nalMoMsg != null) {
                nalMoMsg.addHeader("createChild", null, null);
                nalMoMsg.addParam("ChildMoType", string2);
                nalMoMsg.addParam("ChildMoId", string);
                nalMoMsg.addParam("MoAttributes", nalNameValueArray);
                nalMoMsg.addTail(this, nalTransaction);
                nalMoMsg.logMoOperation();
            }
            NalMo nalMo = this.delegate.createChild(string, string2, nalNameValueArray, nalTransaction);
            if (nalMoMsg != null) {
                nalMoMsg.logResult(nalMo);
            }
            NalMoTransactionDefault.assertDecorated(this.delegate.getClass(), "getChild", nalMo);
            nalTransaction.commit();
            return nalMo;
        }
        catch (Exception exception) {
            String string3 = "Failed to create child NalMo " + this.getLdn() + "," + string2 + "=" + string + " on the node!";
            nalTransaction.rollback(string3, exception);
            throw new NalCmException(string3, exception);
        }
    }

    public void delete(NalTransaction nalTransaction) {
        nalTransaction = new NalTransactionDefault(true, nalTransaction);
        try {
            NalMoMsg nalMoMsg = NalMoMsg.newLog(4);
            if (nalMoMsg != null) {
                nalMoMsg.addHeader("delete", this, null);
                nalMoMsg.addTail(this, nalTransaction);
                nalMoMsg.logMoOperation();
            }
            this.delegate.delete(nalTransaction);
            nalTransaction.commit();
        }
        catch (Exception exception) {
            String string = "Failed to delete NalMo " + this + " on the node!";
            nalTransaction.rollback(string, exception);
            throw new NalCmException(string, exception);
        }
    }

    public void delete(String string, String string2, int n, NalTransaction nalTransaction) {
        nalTransaction = new NalTransactionDefault(true, nalTransaction);
        try {
            NalMoMsg nalMoMsg = NalMoMsg.newLog(4);
            if (nalMoMsg != null) {
                String string3;
                String string4 = n == 1 ? "" : "..";
                String string5 = string3 = string == null ? "" : string;
                if (string != null && string.length() != 0 && "".equals(string2) && n == 1) {
                    string3 = string;
                }
                nalMoMsg.addHeader("delete", this, string4 + string3);
                nalMoMsg.addParam("moType", "\"" + string + "\"");
                nalMoMsg.addParam("criteria", "\"" + string2 + "\"");
                nalMoMsg.addParam("scope", "" + n);
                nalMoMsg.addTail(this, nalTransaction);
                nalMoMsg.logMoOperation();
            }
            this.delegate.delete(string, string2, n, nalTransaction);
            nalTransaction.commit();
        }
        catch (Exception exception) {
            String string6 = "Failed to delete Mos with type=\"" + string + "\", criteria=\"" + string2 + "\", scope=" + n + " on the node" + " from NalMo " + this + "!";
            nalTransaction.rollback(string6, exception);
            throw new NalCmException(string6, exception);
        }
    }

    public boolean exists() {
        return this.exists(null);
    }

    public boolean exists(NalTransaction nalTransaction) {
        nalTransaction = new NalTransactionDefault(false, nalTransaction);
        try {
            NalMoMsg nalMoMsg = NalMoMsg.newLog(5);
            if (nalMoMsg != null) {
                nalMoMsg.addHeader("exists", this, null);
                nalMoMsg.addTail(this, nalTransaction);
                nalMoMsg.logMoOperation();
            }
            boolean bl = this.delegate.exists(nalTransaction);
            if (nalMoMsg != null) {
                nalMoMsg.logResult(bl);
            }
            nalTransaction.commit();
            return bl;
        }
        catch (Exception exception) {
            String string = "Failed checking 'exists' on NalMo " + this;
            nalTransaction.rollback(string, exception);
            throw new NalCmException(string, exception);
        }
    }

    public NalNameValue getAttribute(String string, NalTransaction nalTransaction) {
        nalTransaction = new NalTransactionDefault(false, nalTransaction);
        try {
            NalMoMsg nalMoMsg = NalMoMsg.newLog(5);
            if (nalMoMsg != null) {
                nalMoMsg.addHeader("getAttribute", this, string);
                nalMoMsg.addTail(this, nalTransaction);
                nalMoMsg.logMoOperation();
            }
            NalNameValue nalNameValue = this.delegate.getAttribute(string, nalTransaction);
            if (nalMoMsg != null) {
                nalMoMsg.logResult(nalNameValue);
            }
            NalMoTransactionDefault.assertDecorated(this.delegate.getClass(), "getAttribute", nalNameValue);
            nalTransaction.commit();
            return nalNameValue;
        }
        catch (Exception exception) {
            String string2 = "Failed to getAttribute with name=" + string + " from NalMo " + this + "!";
            nalTransaction.rollback(string2, exception);
            throw new NalCmException(string2, exception);
        }
    }

    public NalNameValue[] getAttributes(String[] stringArray, NalTransaction nalTransaction) {
        nalTransaction = new NalTransactionDefault(false, nalTransaction);
        try {
            NalMoMsg nalMoMsg = NalMoMsg.newLog(5);
            if (nalMoMsg != null) {
                nalMoMsg.addHeader("getAttributes", this, null);
                nalMoMsg.addAttributeNames(stringArray);
                nalMoMsg.addTail(this, nalTransaction);
                nalMoMsg.logMoOperation();
            }
            NalNameValue[] nalNameValueArray = this.delegate.getAttributes(stringArray, nalTransaction);
            if (nalMoMsg != null) {
                nalMoMsg.logResult(nalNameValueArray);
            }
            NalMoTransactionDefault.assertDecorated(this.delegate.getClass(), "getAttributes", nalNameValueArray);
            nalTransaction.commit();
            return nalNameValueArray;
        }
        catch (Exception exception) {
            String string = "Failed to getAttributes from NalMo " + this + "!";
            nalTransaction.rollback(string, exception);
            throw new NalCmException(string, exception);
        }
    }

    public NalMo[] getChildren(String string, String string2, int n, NalTransaction nalTransaction) {
        nalTransaction = new NalTransactionDefault(false, nalTransaction);
        try {
            NalMo[] nalMoArray;
            NalMoMsg nalMoMsg = NalMoMsg.newLog(5);
            if (nalMoMsg != null) {
                String string3;
                nalMoArray = n == 1 ? "" : "..";
                String string4 = string3 = string == null ? "" : string;
                if (string != null && string.length() != 0 && "".equals(string2) && n == 1) {
                    string3 = string;
                }
                nalMoMsg.addHeader("getChildren", this, (String)nalMoArray + string3);
                nalMoMsg.addParam("moType", "\"" + string + "\"");
                nalMoMsg.addParam("criteria", "\"" + string2 + "\"");
                nalMoMsg.addParam("scope", "" + n);
                nalMoMsg.addTail(this, nalTransaction);
                nalMoMsg.logMoOperation();
            }
            nalMoArray = this.delegate.getChildren(string, string2, n, nalTransaction);
            if (nalMoMsg != null) {
                nalMoMsg.logResult(nalMoArray);
            }
            NalMoTransactionDefault.assertDecorated(this.delegate.getClass(), "getChildren", nalMoArray);
            nalTransaction.commit();
            return nalMoArray;
        }
        catch (Exception exception) {
            String string5 = "Failed to getChildren with type=" + string + ", criteria=" + string2 + ", scope=" + n + " from NalMo " + this + "!";
            nalTransaction.rollback(string5, exception);
            throw new NalCmException(string5, exception);
        }
    }

    public NalMo[] getChildren(NalTransaction nalTransaction) {
        nalTransaction = new NalTransactionDefault(false, nalTransaction);
        try {
            NalMoMsg nalMoMsg = NalMoMsg.newLog(5);
            if (nalMoMsg != null) {
                nalMoMsg.addHeader("getChildren", this, null);
                nalMoMsg.addTail(this, nalTransaction);
                nalMoMsg.logMoOperation();
            }
            NalMo[] nalMoArray = this.delegate.getChildren(nalTransaction);
            if (nalMoMsg != null) {
                nalMoMsg.logResult(nalMoArray);
            }
            NalMoTransactionDefault.assertDecorated(this.delegate.getClass(), "getChildren", nalMoArray);
            nalTransaction.commit();
            return nalMoArray;
        }
        catch (Exception exception) {
            String string = "Failed to getChildren from NalMo " + this + "!";
            nalTransaction.rollback(string, exception);
            throw new NalCmException(string, exception);
        }
    }

    public String getLdn() {
        String string = this.delegate.getLdn();
        return string;
    }

    public String getId() {
        String string = this.delegate.getId();
        return string;
    }

    public NalMo getParent() {
        NalMo nalMo = this.delegate.getParent();
        NalMoTransactionDefault.assertDecorated(this.delegate.getClass(), "getParent", nalMo);
        return nalMo;
    }

    public String getType() {
        String string = this.delegate.getType();
        return string;
    }

    public void setAttribute(String string, Object object, NalTransaction nalTransaction) {
        nalTransaction = new NalTransactionDefault(true, nalTransaction);
        try {
            NalMoMsg nalMoMsg = NalMoMsg.newLog(4);
            if (nalMoMsg != null) {
                nalMoMsg.addHeader("setAttribute", this, string);
                nalMoMsg.addValue(object);
                nalMoMsg.addTail(this, nalTransaction);
                nalMoMsg.logMoOperation();
            }
            this.delegate.setAttribute(string, object, nalTransaction);
            nalTransaction.commit();
        }
        catch (Exception exception) {
            String string2 = "Failed to setAttribute with name=" + string + ", value=" + object + " for NalMo " + this + "!";
            nalTransaction.rollback(string2, exception);
            throw new NalCmException(string2, exception);
        }
    }

    public void setAttribute(NalNameValue nalNameValue, NalTransaction nalTransaction) {
        nalTransaction = new NalTransactionDefault(true, nalTransaction);
        try {
            NalMoMsg nalMoMsg = NalMoMsg.newLog(4);
            if (nalMoMsg != null) {
                nalMoMsg.addHeader("setAttribute", this, nalNameValue.getName());
                nalMoMsg.addValue(nalNameValue.getValue());
                nalMoMsg.addTail(this, nalTransaction);
                nalMoMsg.logMoOperation();
            }
            this.delegate.setAttribute(nalNameValue, nalTransaction);
            nalTransaction.commit();
        }
        catch (Exception exception) {
            String string = "Failed to setAttribute=" + nalNameValue + " for NalMo " + this + "!";
            nalTransaction.rollback(string, exception);
            throw new NalCmException(string, exception);
        }
    }

    public void setAttributes(NalNameValue[] nalNameValueArray, NalTransaction nalTransaction) {
        nalTransaction = new NalTransactionDefault(true, nalTransaction);
        try {
            NalMoMsg nalMoMsg = NalMoMsg.newLog(4);
            if (nalMoMsg != null) {
                nalMoMsg.addHeader("setAttributes", this, null);
                nalMoMsg.addParam("Attributes", nalNameValueArray);
                nalMoMsg.addTail(this, nalTransaction);
                nalMoMsg.logMoOperation();
            }
            this.delegate.setAttributes(nalNameValueArray, nalTransaction);
            nalTransaction.commit();
        }
        catch (Exception exception) {
            String string = "Failed to setAttributes for NalMo " + this + "!";
            nalTransaction.rollback(string, exception);
            throw new NalCmException(string, exception);
        }
    }

    public NalCmSubscription subscribe(NalCmNotificationConsumer nalCmNotificationConsumer) {
        NalMoMsg nalMoMsg = NalMoMsg.newLog(4);
        if (nalMoMsg != null) {
            nalMoMsg.addHeader("subscribe", this, null);
            nalMoMsg.addParam("Consumer", String.valueOf(nalCmNotificationConsumer));
            nalMoMsg.addTail(this, null);
            nalMoMsg.logMoOperation();
        }
        NalCmSubscription nalCmSubscription = this.delegate.subscribe(nalCmNotificationConsumer);
        if (nalMoMsg != null) {
            nalMoMsg.logResult(nalCmSubscription);
        }
        NalMoTransactionDefault.assertDecorated(this.delegate.getClass(), "subscribe", nalCmSubscription);
        return nalCmSubscription;
    }

    public NalCmSubscription subscribe(int n, NalCmNotificationConsumer nalCmNotificationConsumer) {
        NalMoMsg nalMoMsg = NalMoMsg.newLog(4);
        if (nalMoMsg != null) {
            nalMoMsg.addHeader("subscribe", this, null);
            nalMoMsg.addParam("Scope", String.valueOf(n));
            nalMoMsg.addParam("Consumer", String.valueOf(nalCmNotificationConsumer));
            nalMoMsg.addTail(this, null);
            nalMoMsg.logMoOperation();
        }
        NalCmSubscription nalCmSubscription = this.delegate.subscribe(n, nalCmNotificationConsumer);
        if (nalMoMsg != null) {
            nalMoMsg.logResult(nalCmSubscription);
        }
        NalMoTransactionDefault.assertDecorated(this.delegate.getClass(), "subscribe", nalCmSubscription);
        return nalCmSubscription;
    }

    public NalCmSubscription subscribe(int n, String[] stringArray, NalCmNotificationConsumer nalCmNotificationConsumer) {
        NalMoMsg nalMoMsg = NalMoMsg.newLog(4);
        if (nalMoMsg != null) {
            nalMoMsg.addHeader("subscribe", this, null);
            nalMoMsg.addParam("Scope", String.valueOf(n));
            nalMoMsg.addParam("MoTypes", stringArray);
            nalMoMsg.addParam("Consumer", String.valueOf(nalCmNotificationConsumer));
            nalMoMsg.addTail(this, null);
            nalMoMsg.logMoOperation();
        }
        NalCmSubscription nalCmSubscription = this.delegate.subscribe(n, stringArray, nalCmNotificationConsumer);
        if (nalMoMsg != null) {
            nalMoMsg.logResult(nalCmSubscription);
        }
        NalMoTransactionDefault.assertDecorated(this.delegate.getClass(), "subscribe", nalCmSubscription);
        return nalCmSubscription;
    }
}

