/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.nal.impl.neal;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ConnectException;
import java.net.NoRouteToHostException;
import org.omg.CORBA.NO_IMPLEMENT;
import org.omg.CORBA.NO_PERMISSION;
import org.omg.CORBA.SystemException;
import org.omg.CORBA.UserException;
import se.ericsson.cello.neal.Node;
import se.ericsson.cello.neal.NodeConnectionListener;
import se.ericsson.cello.neal.cm.CmNotificationConsumer;
import se.ericsson.cello.neal.cm.CmService;
import se.ericsson.cello.neal.cm.CmSubscription;
import se.ericsson.cello.neal.cm.Mo;
import se.ericsson.cello.neal.cm.NameValue;
import se.ericsson.cello.neal.cm.NameValueFactory;
import se.ericsson.cello.neal.cm.OfflineCmUtil;
import se.ericsson.cello.neal.cm.Scope;
import se.ericsson.cello.neal.cm.Struct;
import se.ericsson.cello.neal.cm.Transaction;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.Nal;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmNotificationConsumer;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalCmSubscription;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalMo;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalProgress;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalStruct;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalTransaction;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.backend.NalBackend;
import se.ericsson.wcdma.rbs.bem.common.nal.impl.neal.NalConnectionListenerNeal;

public class NalBackendNeal
extends NalBackend {
    private static final int NORMAL_JVM_RESTART_DURATION_MS = 30000;
    private static final int NORMAL_NODE_RESTART_DURATION_MS = 180000;
    private static final int RETRY_INTERVAL_MS = 3000;
    private static final int INITIAL_RECONNECT_WAIT_MS = 20000;
    private static final int JVM_RESTART_WAIT_MS = 120000;
    private static final int NODE_RESTART_WAIT_MS = 720000;
    private static String hostname = null;
    private static Node theNode = null;
    private static CmService theCmService = null;
    private static boolean isNodeStubbed = false;
    private static int currentConnectionIndex = 0;
    private static final NalConnectionListenerNeal ncListener = new NalConnectionListenerNeal(NalBackend.theConnectionListeners, false);
    private static long startOfConnect = System.currentTimeMillis();
    private static long durationOfConnect = System.currentTimeMillis();
    private static final NalProgress DEFAULT_PROGGRESS_LOGGER = new NalProgress(){

        public void reportProgress(int n, String string) {
            long l = System.currentTimeMillis() - startOfConnect;
            System.out.println("\n\n" + string + ".  Waited " + l / 1000L + " of " + durationOfConnect / 1000L + " sec (" + n + "%)\n\n");
        }
    };
    private static final String NEAL_CLASS_NODE_ACCESS = "se.ericsson.cello.neal.NodeAccess";
    private static final String NEAL_CLASS_NODE_FACTORY = "se.ericsson.cello.neal.NodeFactory";

    public static synchronized void disconnectFromNode() {
        if (theNode != null) {
            theNode.free();
            theNode = null;
            theCmService = null;
        }
        hostname = null;
    }

    public static synchronized void connectToNode(String string) {
        startOfConnect = System.currentTimeMillis();
        durationOfConnect = 120000L;
        long l = startOfConnect + durationOfConnect;
        ++currentConnectionIndex;
        NalProgress nalProgress = DEFAULT_PROGGRESS_LOGGER;
        Exception exception = NalBackendNeal.tryConnectToNode(string, nalProgress, l, 0L);
        if (exception != null) {
            String string2 = "Failed connecting to node " + string + "!";
            nalProgress.reportProgress(NalBackendNeal.getPercentDone(), string2);
            NalCmException nalCmException = new NalCmException(string2, exception);
            throw nalCmException;
        }
        theNode.addConnectionListener((NodeConnectionListener)ncListener);
        ncListener.setIsForwardingOn(true);
    }

    public static synchronized void reconnectNode(String string, NalProgress nalProgress) {
        Exception exception;
        boolean bl = ncListener.setIsForwardingOn(false);
        ++currentConnectionIndex;
        startOfConnect = System.currentTimeMillis();
        durationOfConnect = 720000L;
        long l = System.currentTimeMillis() + 720000L;
        if (theCmService != null) {
            NalBackendNeal.disconnectFromNode();
        }
        if (nalProgress == null) {
            nalProgress = DEFAULT_PROGGRESS_LOGGER;
        }
        if ((exception = NalBackendNeal.tryConnectToNode(string, nalProgress, l, 20000L)) != null) {
            String string2 = "Failed connecting to node " + string + "!";
            nalProgress.reportProgress(NalBackendNeal.getPercentDone(), string2 + " : " + exception);
            NalCmException nalCmException = new NalCmException(string2, exception);
            throw nalCmException;
        }
        ncListener.setIsForwardingOn(bl);
    }

    public static synchronized int getConnectionIndex() {
        return currentConnectionIndex;
    }

    public static synchronized void incConnectionIndex() {
        ++currentConnectionIndex;
    }

    public static Object getConnectionSynchronizer() {
        return NalBackendNeal.class;
    }

    private static synchronized Exception tryConnectToNode(String string, NalProgress nalProgress, long l, long l2) {
        if (theNode != null) {
            NalBackendNeal.disconnectFromNode();
        }
        try {
            Nal.getFactory().sleep(l2);
        }
        catch (InterruptedException interruptedException) {
            String string2 = "Interrupted before trying to connect to " + string + " : " + interruptedException.toString();
            nalProgress.reportProgress(NalBackendNeal.getPercentDone(), string2);
            return interruptedException;
        }
        Exception exception = null;
        while (theCmService == null) {
            String string3;
            long l3 = l - System.currentTimeMillis();
            if (l3 < 3000L) {
                string3 = "Timed out while trying to connect to " + string;
                if (exception == null) {
                    exception = new InterruptedException(string3);
                } else {
                    string3 = string3 + " : " + exception;
                }
                nalProgress.reportProgress(100, string3);
                return exception;
            }
            NalBackendNeal.reportConnectionProgress(string, nalProgress, l, exception);
            try {
                Nal.getFactory().sleep(3000L);
            }
            catch (InterruptedException interruptedException) {
                String string4 = "Interrupted while trying to connect to " + string + " : " + interruptedException;
                nalProgress.reportProgress(NalBackendNeal.getPercentDone(), string4);
                return interruptedException;
            }
            exception = null;
            try {
                NalBackendNeal.disconnectFromNode();
                string3 = NalBackendNeal.getNealNode(string);
                NalBackendNeal.setNode(string, (Node)string3);
            }
            catch (Exception exception2) {
                exception = exception2;
                if (NalBackendNeal.isCausedByNodeRestarting(exception)) continue;
                String string5 = "Exception occured while connecting to node " + string;
                nalProgress.reportProgress(NalBackendNeal.getPercentDone(), string5 + " : " + exception);
                return exception;
            }
        }
        String string6 = "Done connecting to " + string;
        nalProgress.reportProgress(NalBackendNeal.getPercentDone(), string6);
        ++currentConnectionIndex;
        return null;
    }

    public static synchronized void setNode(String string, Node node) {
        hostname = string;
        theNode = node;
        theCmService = theNode.getCmService();
        String string2 = node.getClass().getName();
        isNodeStubbed = string2.endsWith(".NodeStub");
        ++currentConnectionIndex;
    }

    public static synchronized void setHostName(String string) {
        hostname = string;
    }

    public static String getHostname() {
        return hostname;
    }

    public static Node unprotectedGetNode() {
        return theNode;
    }

    public static Node getNode() {
        if (theNode == null) {
            throw new NullPointerException("PROGRAMMING ERROR! Attempted to access Neal Node object before connecting to remote node!");
        }
        return theNode;
    }

    public static boolean isNodeStubbed() {
        return isNodeStubbed;
    }

    public static CmService unprotectedGetCmService() {
        return theCmService;
    }

    public static CmService getCmService() {
        if (theCmService == null) {
            throw new NullPointerException("PROGRAMMING ERROR! Attempted to access Neal CmService before connecting to remote node!");
        }
        return theCmService;
    }

    public static Transaction toNeal(NalTransaction nalTransaction) {
        Transaction transaction = (Transaction)nalTransaction.getNative();
        return transaction;
    }

    public static CmSubscription toNeal(NalCmSubscription nalCmSubscription) {
        CmSubscription cmSubscription = (CmSubscription)nalCmSubscription.getNative();
        return cmSubscription;
    }

    public static CmNotificationConsumer toNeal(NalCmNotificationConsumer nalCmNotificationConsumer) {
        CmNotificationConsumer cmNotificationConsumer = (CmNotificationConsumer)nalCmNotificationConsumer.getNative();
        return cmNotificationConsumer;
    }

    public static Scope toNeal(int n) {
        if (n > 5) {
            n = -1;
        }
        switch (n) {
            case 0: {
                return Scope.BASE_ONLY;
            }
            case 1: {
                return Scope.ONE_LEVEL;
            }
            case 2: {
                return Scope.TWO_LEVELS;
            }
            case 3: {
                return Scope.THREE_LEVELS;
            }
            case 4: {
                return Scope.FOUR_LEVELS;
            }
            case 5: {
                return Scope.FIVE_LEVELS;
            }
            case -1: {
                return Scope.ALL_LEVELS;
            }
        }
        throw new NalCmException("Can't convert " + n + " levels to a Neal Scope! Expected 0..5 or -1 !");
    }

    public static Mo[] toNeal(NalMo[] nalMoArray) {
        Mo[] moArray = (Mo[])NalBackendNeal.toNative(nalMoArray);
        return moArray;
    }

    public static Mo toNeal(NalMo nalMo) {
        Mo mo = (Mo)nalMo.getNative();
        return mo;
    }

    public static Struct[] toNeal(NalStruct[] nalStructArray) {
        Struct[] structArray = (Struct[])NalBackendNeal.toNative(nalStructArray);
        return structArray;
    }

    public static Struct toNeal(NalStruct nalStruct) {
        Struct struct = (Struct)nalStruct.getNative();
        return struct;
    }

    public static NameValue[] toNeal(NalNameValue[] nalNameValueArray) {
        if (nalNameValueArray != null) {
            NameValue[] nameValueArray = (NameValue[])NalBackendNeal.toNative(nalNameValueArray);
            return nameValueArray;
        }
        return null;
    }

    public static NameValue toNeal(NalNameValue nalNameValue) {
        if (nalNameValue == null) {
            return null;
        }
        String string = nalNameValue.getName();
        Object object = nalNameValue.getValue();
        NameValue nameValue = NalBackendNeal.getNealNameValue(string, object);
        return nameValue;
    }

    public static NameValue getNealNameValue(String string, Object object) {
        object = NalBackendNeal.toNative(object);
        NameValueFactory nameValueFactory = OfflineCmUtil.getNameValueFactory();
        NameValue nameValue = null;
        if (object == null) {
            nameValue = nameValueFactory.create(string);
        } else if (object instanceof Boolean) {
            nameValue = nameValueFactory.create(string, ((Boolean)object).booleanValue());
        } else if (object instanceof boolean[]) {
            nameValue = nameValueFactory.create(string, (boolean[])object);
        } else if (object instanceof Float) {
            nameValue = nameValueFactory.create(string, ((Float)object).floatValue());
        } else if (object instanceof float[]) {
            nameValue = nameValueFactory.create(string, (float[])object);
        } else if (object instanceof Integer) {
            nameValue = nameValueFactory.create(string, ((Integer)object).intValue());
        } else if (object instanceof Integer[]) {
            Integer[] integerArray = (Integer[])object;
            int[] nArray = new int[integerArray.length];
            for (int i = 0; i < integerArray.length; ++i) {
                if (integerArray[i] == null) continue;
                nArray[i] = integerArray[i];
            }
            nameValue = nameValueFactory.create(string, nArray);
        } else if (object instanceof int[]) {
            nameValue = nameValueFactory.create(string, (int[])object);
        } else if (object instanceof Long) {
            nameValue = nameValueFactory.create(string, ((Long)object).longValue());
        } else if (object instanceof long[]) {
            nameValue = nameValueFactory.create(string, (long[])object);
        } else if (object instanceof Mo) {
            nameValue = nameValueFactory.create(string, (Mo)object);
        } else if (object instanceof Mo[]) {
            nameValue = nameValueFactory.create(string, (Mo[])object);
        } else if (object instanceof String) {
            nameValue = nameValueFactory.create(string, (String)object);
        } else if (object instanceof String[]) {
            nameValue = nameValueFactory.create(string, (String[])object);
        } else if (object instanceof Struct) {
            nameValue = nameValueFactory.create(string, (Struct)object);
        } else if (object instanceof Struct[]) {
            nameValue = nameValueFactory.create(string, (Struct[])object);
        } else if (object instanceof NameValue[]) {
            NameValue[] nameValueArray = (NameValue[])object;
            Struct struct = new Struct(nameValueArray);
            nameValue = nameValueFactory.create(string, struct);
        } else {
            if (object instanceof NameValue) {
                throw new ClassCastException("PROGRAMMING ERROR! Can't use a Neal NameValue as value to another Neal NameValue!\n   Tried to set value of name=" + string + " to nv=" + object + "!");
            }
            throw new ClassCastException("Don't know how to convert to Neal NameValue value from " + object.getClass().getName() + "!");
        }
        return nameValue;
    }

    private static boolean isCausedByNodeRestarting(Throwable throwable) {
        while (throwable != null) {
            if (throwable instanceof NoRouteToHostException) {
                return false;
            }
            if (throwable instanceof ConnectException) {
                return false;
            }
            if (throwable instanceof NO_IMPLEMENT) {
                return false;
            }
            if (throwable instanceof NO_PERMISSION) {
                return false;
            }
            if (throwable instanceof SystemException) {
                return true;
            }
            if (throwable instanceof UserException) {
                return true;
            }
            if (throwable instanceof IOException) {
                return true;
            }
            throwable = throwable.getCause();
        }
        return false;
    }

    private static void reportConnectionProgress(String string, NalProgress nalProgress, long l, Throwable throwable) {
        StringBuffer stringBuffer = new StringBuffer("Trying to connect to ");
        stringBuffer.append(string);
        if (throwable != null) {
            int n;
            String string2 = throwable.getMessage();
            if (string2 == null || string2.length() == 0) {
                string2 = throwable.toString();
            }
            if (string2.startsWith("se.ericsson.cello.neal.internal.jvm_version.NealRuntimeException: ")) {
                string2 = string2.substring("se.ericsson.cello.neal.internal.jvm_version.NealRuntimeException: ".length());
            }
            if ((n = (string2 = string2.trim()).indexOf(10)) > 0) {
                string2 = string2.substring(0, n - 1);
            }
            stringBuffer.append(". Current stopper : ").append(string2);
        }
        int n = NalBackendNeal.getPercentDone();
        nalProgress.reportProgress(n, stringBuffer.toString());
    }

    private static int getPercentDone() {
        long l = System.currentTimeMillis() - startOfConnect;
        long l2 = 100L * l / durationOfConnect;
        if (l2 > 100L) {
            l2 = 100L;
        }
        return (int)l2;
    }

    protected static Node getNealNode(String string) throws Exception {
        Node node;
        if (Nal.isClassPresent(NEAL_CLASS_NODE_ACCESS)) {
            try {
                Class<?> clazz = Class.forName(NEAL_CLASS_NODE_ACCESS);
                Method method = clazz.getMethod("getNode", String.class);
                Object object = method.invoke(null, string);
                node = (Node)object;
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable == null) {
                    throw new IllegalStateException("Got InvocationTargetException when invoking static method getNode(" + string + ") in class " + NEAL_CLASS_NODE_ACCESS + ", but the cause is null.");
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw invocationTargetException;
            }
        }
        if (Nal.isClassPresent(NEAL_CLASS_NODE_FACTORY)) {
            try {
                Method method;
                Class<?> clazz = Class.forName(NEAL_CLASS_NODE_FACTORY);
                Class[] classArray = new Class[]{null};
                String string2 = "getNode";
                try {
                    method = clazz.getMethod(string2, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    classArray = null;
                    method = clazz.getMethod(string2, classArray);
                }
                Object object = method.invoke(null, (Object[])classArray);
                node = (Node)object;
            }
            catch (InvocationTargetException invocationTargetException) {
                Throwable throwable = invocationTargetException.getCause();
                if (throwable == null) {
                    throw new IllegalStateException("Got InvocationTargetException when invoking static method getNode in class se.ericsson.cello.neal.NodeFactory, but the cause is null.");
                }
                if (throwable instanceof RuntimeException) {
                    throw (RuntimeException)throwable;
                }
                if (throwable instanceof Exception) {
                    throw (Exception)throwable;
                }
                throw invocationTargetException;
            }
        }
        Exception exception = new Exception("FATAL ERROR! Could not find node object using reflection, both se.ericsson.cello.neal.NodeAccess and se.ericsson.cello.neal.NodeFactory are missing on the classpath!");
        throw exception;
        return node;
    }
}

