/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.common.service;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.SectorUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerRange;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.AuUnitType;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.definitions.RbsInfo;
import se.ericsson.wcdma.rbs.bem.common.exception.BemXmlException;
import se.ericsson.wcdma.rbs.bem.common.io.xml.XmlSource;
import se.ericsson.wcdma.rbs.bem.common.service.BemServiceValue;
import se.ericsson.wcdma.rbs.bem.common.service.PrefixUtil;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceCommon;
import se.ericsson.wcdma.rbs.bem.common.service.ServiceNameValue;
import se.ericsson.wcdma.rbs.bem.common.service.Source;
import se.ericsson.wcdma.rbs.bem.common.service.gen.RBSPseudoDef;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;

public class DeprecationConverter {
    private String aDtdFilePathName;

    public DeprecationConverter() {
    }

    public DeprecationConverter(String string) {
        this.aDtdFilePathName = string;
    }

    public void convert(BemServiceValue bemServiceValue) throws BemXmlException {
        int n;
        Object object;
        ServiceNameValue serviceNameValue;
        Enumeration enumeration;
        Object object2;
        Object object3;
        Object object4;
        String[] stringArray;
        Object object5;
        Object object6;
        Object object7;
        Object object8;
        int n2;
        ServiceNameValue serviceNameValue2;
        Object object9;
        Object object10;
        Object object11;
        ServiceNameValue[] serviceNameValueArray;
        Object object12;
        Object object13;
        int n3;
        Object object142;
        ServiceNameValue serviceNameValue3;
        ServiceNameValue serviceNameValue4;
        ServiceNameValue serviceNameValue5;
        ServiceNameValue serviceNameValue6;
        Object object15;
        if (null != bemServiceValue.getValue("auHubType")) {
            object15 = this.getSourceLineInfo(bemServiceValue.getAttribute("auHubType"));
            bemServiceValue.addDeprecationWarning((Integer)object15, "auHubType=\"" + bemServiceValue.getValue("auHubType") + "\"" + " is ignored");
        }
        if ((object15 = bemServiceValue.getAttribute("ethernetIpAddress")) != null) {
            this.convertIpOverEtherNetIpAdressInOam(bemServiceValue, (ServiceNameValue)object15);
        }
        if ((serviceNameValue6 = bemServiceValue.getAttribute(PrefixUtil.getFirstCabinetPrefix() + "supportSystemControl")) != null) {
            this.convertSupportSystemControl(bemServiceValue, serviceNameValue6);
        }
        if ((serviceNameValue5 = bemServiceValue.getAttribute("slotsForETMFX")) != null) {
            this.convertSlotsForEtmfx(bemServiceValue, serviceNameValue5);
        }
        if ((serviceNameValue4 = bemServiceValue.getAttribute("ethernetSubnetMask")) != null) {
            this.convertIpOverEtherNetSubnetMaskInOam(bemServiceValue, serviceNameValue4);
        }
        if ((serviceNameValue3 = bemServiceValue.getAttribute(RBSPseudoDef.getPseudoName("slotsForHsdpa"))) != null) {
            this.convertHsdpa(bemServiceValue, serviceNameValue3);
        }
        this.convertFreqBandHiAndLoEdge(bemServiceValue);
        Vector vector = bemServiceValue.getAllAttributesWithSimpleName(RBSPseudoDef.getPseudoName("radioBuildingBlock"));
        for (Object object142 : vector) {
            if (object142 == null) continue;
            this.convertRadioBuildingBlock(bemServiceValue, (ServiceNameValue)object142);
        }
        object142 = bemServiceValue.getAllAttributesWithSimpleName("operatingBand");
        Vector vector2 = bemServiceValue.getAllAttributesWithSimpleName("cellIdentity");
        Vector vector3 = bemServiceValue.getAllAttributesWithSimpleName(RBSPseudoDef.getPseudoName("band"));
        this.convertOperatingBandAndBand(bemServiceValue, (List)object142, vector2, vector3);
        Vector vector4 = bemServiceValue.getAllAttributesWithSimpleName(RBSPseudoDef.getPseudoName("band"));
        for (ServiceNameValue serviceNameValue7 : vector4) {
            if (serviceNameValue7 == null) continue;
            this.convertBand(bemServiceValue, serviceNameValue7);
        }
        int n4 = 2;
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < ServiceCommon.BRANCH_NAMES.length; ++i) {
            arrayList.addAll(bemServiceValue.getAllAttributesWithSimpleName("fqBandHighEdgeBranch" + ServiceCommon.BRANCH_NAMES[i]));
            arrayList.addAll(bemServiceValue.getAllAttributesWithSimpleName("fqBandLowEdgeBranch" + ServiceCommon.BRANCH_NAMES[i]));
        }
        ArrayList<String> arrayList2 = new ArrayList<String>();
        for (n3 = 0; n3 < object142.size(); ++n3) {
            object13 = SectorUtil.getSectorPrefix((ServiceNameValue)object142.get(n3));
            if (arrayList2.contains(object13)) continue;
            arrayList2.add((String)object13);
        }
        for (n3 = 0; n3 < arrayList2.size(); ++n3) {
            object13 = (String)arrayList2.get(n3);
            object12 = this.getEdgeListForSector(arrayList, (String)object13);
            for (int i = 0; i < object12.size(); ++i) {
                serviceNameValueArray = (ServiceNameValue[])object12.get(i);
                if (this.getOperatingBandSizeForSector((List)object142, (String)object13) != n4) continue;
                bemServiceValue.addDeprecationWarning(this.getSourceLineInfo((ServiceNameValue)serviceNameValueArray), serviceNameValueArray + "\n is no longer used and will be ignored for dual band. ");
            }
        }
        ServiceNameValue serviceNameValue8 = bemServiceValue.getAttribute(RBSPseudoDef.getPseudoName("numberOfSectors"));
        if (serviceNameValue8 != null) {
            this.ignoreAttribute(bemServiceValue, serviceNameValue8);
        }
        object13 = bemServiceValue.getAttribute(RBSPseudoDef.getPseudoName("redundantTiming"));
        object12 = bemServiceValue.getAttribute(RBSPseudoDef.getPseudoName("redundantSwitching"));
        ServiceNameValue serviceNameValue9 = bemServiceValue.getAttribute(RBSPseudoDef.getPseudoName("redundantMP"));
        serviceNameValueArray = new ServiceNameValue[]{serviceNameValue9, object13, object12};
        ServiceNameValue serviceNameValue10 = this.findFirstSetTo(serviceNameValueArray, "YES");
        if (serviceNameValue10 != null) {
            object11 = RBSPseudoDef.getPseudoName("redundantControlSystem");
            this.convertTo(bemServiceValue, serviceNameValue10, (String)object11, "YES");
        } else {
            object11 = this.findFirstSetTo(serviceNameValueArray, "NO");
            if (object11 != null) {
                object10 = RBSPseudoDef.getPseudoName("redundantControlSystem");
                this.convertTo(bemServiceValue, (ServiceNameValue)object11, (String)object10, "NO");
            }
        }
        object11 = bemServiceValue.getAttribute(RBSPseudoDef.getPseudoName("useInternalPower"));
        if (object11 != null) {
            this.convertTo(bemServiceValue, (ServiceNameValue)object11, "configurePowerSupply", ((ServiceNameValue)object11).getValueAsString());
        }
        if ((object10 = bemServiceValue.getAttribute(PrefixUtil.getFirstCabinetPrefix() + RBSPseudoDef.getPseudoName("typeOfPowerSupply"))) != null) {
            object9 = "YES";
            if (((ServiceNameValue)object10).getValue().equals("MINUS_48VDC")) {
                object9 = "NO";
            }
            this.convertTo(bemServiceValue, (ServiceNameValue)object10, "configurePowerSupply", (String)object9);
        }
        if ((object9 = bemServiceValue.getAttribute(PrefixUtil.getFirstCabinetPrefix() + RBSPseudoDef.getPseudoName("batteryBackup"))) != null) {
            this.convertTo(bemServiceValue, (ServiceNameValue)object9, "configureBatteryBackup", ((ServiceNameValue)object9).getValueAsString());
        }
        if ((serviceNameValue2 = bemServiceValue.getAttribute(PrefixUtil.getFirstCabinetPrefix() + RBSPseudoDef.getPseudoName("isXalmInstalled"))) != null) {
            this.convertTo(bemServiceValue, serviceNameValue2, "configureXalm", serviceNameValue2.getValueAsString());
        }
        Vector vector5 = bemServiceValue.getAllAttributesWithSimpleName("cabinetType");
        for (n2 = 0; n2 < vector5.size(); ++n2) {
            ServiceNameValue serviceNameValue11 = (ServiceNameValue)vector5.get(n2);
            if (null == serviceNameValue11 || !serviceNameValue11.getValueAsString().equals(RbsInfo.RBS_6601W.NAME)) continue;
            this.convertTo(bemServiceValue, serviceNameValue11, "cabinetType", BemUtil.getCabinetType(serviceNameValue11.getValueAsString()));
        }
        for (n2 = 1; n2 < 7; ++n2) {
            int n5 = n2 + 1;
            object8 = PrefixUtil.getCabinetPrefix(String.valueOf(n5));
            object7 = bemServiceValue.getAttribute((String)object8 + RBSPseudoDef.getPseudoName("useExternalPowerSupply"));
            if (object7 != null) {
                this.convertTo(bemServiceValue, (ServiceNameValue)object7, "configurePowerSupply", ((ServiceNameValue)object7).getValueAsString());
            }
            if ((object6 = bemServiceValue.getAttribute((String)object8 + RBSPseudoDef.getPseudoName("useExternalBatteryBackup"))) == null) continue;
            this.convertTo(bemServiceValue, (ServiceNameValue)object6, "configureBatteryBackup", ((ServiceNameValue)object6).getValueAsString());
        }
        Vector vector6 = bemServiceValue.getAllAttributesWithSimpleName("bandsOfAtma");
        Enumeration enumeration2 = vector6.elements();
        while (enumeration2.hasMoreElements()) {
            object8 = (ServiceNameValue)enumeration2.nextElement();
            object7 = ((ServiceNameValue)object8).getPrefix();
            object6 = this.convertToArray((ServiceNameValue)object8);
            boolean bl = true;
            for (int i = 0; i < ((Object)object6).length; ++i) {
                if (object6[i] != false) {
                    bl = false;
                    break;
                }
                bl = true;
            }
            if (bl) {
                object5 = bemServiceValue.getAllAttributesWithSimpleName("dlAttenuationPerBand");
                stringArray = object5.elements();
                while (stringArray.hasMoreElements()) {
                    object4 = (ServiceNameValue)stringArray.nextElement();
                    if (!((ServiceNameValue)object4).getPrefix().equals(object7)) continue;
                    bemServiceValue.addDeprecationWarning(this.getSourceLineInfo((ServiceNameValue)object4), "dlAttenuationPerBand is ignored, and dlAttenuation_ATMA is used.");
                }
                object4 = bemServiceValue.getAllAttributesWithSimpleName("dlTrafficDelayPerBand");
                object3 = ((Vector)object4).elements();
                while (object3.hasMoreElements()) {
                    object2 = (ServiceNameValue)object3.nextElement();
                    if (!((ServiceNameValue)object2).getPrefix().equals(object7)) continue;
                    bemServiceValue.addDeprecationWarning(this.getSourceLineInfo((ServiceNameValue)object2), "dlTrafficDelayPerBand is ignored, and dlTrafficDelay is used.");
                }
                object2 = bemServiceValue.getAllAttributesWithSimpleName("ulTrafficDelayPerBand");
                enumeration = ((Vector)object2).elements();
                while (enumeration.hasMoreElements()) {
                    serviceNameValue = (ServiceNameValue)enumeration.nextElement();
                    if (!serviceNameValue.getPrefix().equals(object7)) continue;
                    bemServiceValue.addDeprecationWarning(this.getSourceLineInfo(serviceNameValue), "ulTrafficDelayPerBand is ignored, and ulTrafficDelay is used.");
                }
                continue;
            }
            object5 = bemServiceValue.getAllAttributesWithSimpleName("dlAttenuation_ATMA");
            stringArray = object5.elements();
            while (stringArray.hasMoreElements()) {
                object4 = (ServiceNameValue)stringArray.nextElement();
                if (!((ServiceNameValue)object4).getPrefix().equals(object7)) continue;
                bemServiceValue.addDeprecationWarning(this.getSourceLineInfo((ServiceNameValue)object4), "dlAttenuation_ATMA is ignored, and dlAttenuationPerBand is used.");
            }
            object4 = bemServiceValue.getAllAttributesWithSimpleName("dlTrafficDelay");
            object3 = ((Vector)object4).elements();
            while (object3.hasMoreElements()) {
                object2 = (ServiceNameValue)object3.nextElement();
                if (!((ServiceNameValue)object2).getPrefix().equals(object7)) continue;
                bemServiceValue.addDeprecationWarning(this.getSourceLineInfo((ServiceNameValue)object2), "dlTrafficDelay is ignored, and dlTrafficDelayPerBand is used.");
            }
            object2 = bemServiceValue.getAllAttributesWithSimpleName("ulTrafficDelay");
            enumeration = ((Vector)object2).elements();
            while (enumeration.hasMoreElements()) {
                serviceNameValue = (ServiceNameValue)enumeration.nextElement();
                if (!serviceNameValue.getPrefix().equals(object7)) continue;
                bemServiceValue.addDeprecationWarning(this.getSourceLineInfo(serviceNameValue), "ulTrafficDelay is ignored, and ulTrafficDelayPerBand is used.");
            }
        }
        object8 = bemServiceValue.getAllAttributesWithSimpleName("tmaType");
        object7 = ((Vector)object8).elements();
        while (object7.hasMoreElements()) {
            object6 = (ServiceNameValue)object7.nextElement();
            if (!((ServiceNameValue)object6).getValue().equals("RET")) continue;
            this.convertTo(bemServiceValue, (ServiceNameValue)object6, "tmaType", "ASC");
            this.convertTo(bemServiceValue, (ServiceNameValue)object6, "configureRet", "YES");
        }
        object6 = bemServiceValue.getAllAttributesWithSimpleName("configureRet");
        Enumeration enumeration3 = ((Vector)object6).elements();
        block17: while (enumeration3.hasMoreElements()) {
            object5 = (ServiceNameValue)enumeration3.nextElement();
            if (!object5.getValue().equals("YES")) continue;
            stringArray = bemServiceValue.getAllAttributesWithSimpleName("typeOfRet");
            object4 = stringArray.elements();
            object3 = null;
            while (object4.hasMoreElements()) {
                object3 = (ServiceNameValue)object4.nextElement();
                if (!((ServiceNameValue)object3).getPrefix().equals(object5.getPrefix())) continue;
                if (((ServiceNameValue)object3).getValueAsString().equals("ARETU")) {
                    this.convertTo(bemServiceValue, (ServiceNameValue)object5, "typeOfRet", "ARETU");
                    continue block17;
                }
                this.convertTo(bemServiceValue, (ServiceNameValue)object5, "typeOfRet", "RETU");
                continue block17;
            }
        }
        object5 = new String[]{"dlJumperAttenuationBranchA", "ulJumperAttenuationBranchA", "dlJumperDelayBranchA", "ulJumperDelayBranchA", "dlJumperAttenuationBranchB", "ulJumperAttenuationBranchB", "dlJumperDelayBranchB", "ulJumperDelayBranchB"};
        stringArray = new String[]{"dlFeederAttenuationBranchA", "ulFeederAttenuationBranchA", "dlFeederDelayBranchA", "ulFeederDelayBranchA", "dlFeederAttenuationBranchB", "ulFeederAttenuationBranchB", "dlFeederDelayBranchB", "ulFeederDelayBranchB"};
        for (int i = 0; i < ((String[])object5).length; ++i) {
            this.convertJumperCableParam(bemServiceValue, object5[i], stringArray[i]);
        }
        Vector vector7 = bemServiceValue.getAllAttributesWithSimpleName("frequencyPlanes");
        object3 = vector7.elements();
        while (object3.hasMoreElements()) {
            object2 = (ServiceNameValue)object3.nextElement();
            if (object2 == null) continue;
            this.ignoreAttribute(bemServiceValue, (ServiceNameValue)object2);
        }
        object2 = bemServiceValue.getAllAttributesWithSimpleName("frequencyPlane");
        enumeration = ((Vector)object2).elements();
        while (enumeration.hasMoreElements()) {
            serviceNameValue = (ServiceNameValue)enumeration.nextElement();
            if (serviceNameValue == null) continue;
            this.ignoreAttribute(bemServiceValue, serviceNameValue);
        }
        for (int i = 1; i <= 6; ++i) {
            String string = MessageFormat.format("S{0}_", new Integer(i));
            object = bemServiceValue.getAttribute(string + "numberOfRu");
            ServiceNameValue serviceNameValue12 = bemServiceValue.getAttribute(string + "numberOfCarriers");
            ServiceNameValue serviceNameValue13 = bemServiceValue.getAttribute("radioIfType");
            if (object == null || serviceNameValue12 == null) continue;
            if (serviceNameValue13 != null && serviceNameValue13.getValue().equals("OBIF")) {
                bemServiceValue.addDeprecationWarning(this.getSourceLineInfo((ServiceNameValue)object), object + " and " + serviceNameValue12 + " are ignored");
                continue;
            }
            this.convertNoOfRusAndCarriers(bemServiceValue, (ServiceNameValue)object, serviceNameValue12);
        }
        String[] stringArray2 = new String[]{"productName", "productNumber", "productRevision", "productionDate", "serialNumber"};
        for (n = 0; n < stringArray2.length; ++n) {
            object = bemServiceValue.getAttribute(stringArray2[n]);
            if (object == null) continue;
            this.ignoreAttribute(bemServiceValue, (ServiceNameValue)object);
        }
        for (n = 1; n <= 12; ++n) {
            ServiceNameValue serviceNameValue14;
            String string;
            int n6;
            object = MessageFormat.format("S{0}_", new Integer(n));
            boolean bl = false;
            boolean bl2 = false;
            ServiceNameValue serviceNameValue15 = bemServiceValue.getAttribute((String)object + "mixedModeRadio");
            for (n6 = 1; n6 <= 3; ++n6) {
                string = MessageFormat.format("AUX{0}_", new Integer(n6));
                serviceNameValue14 = bemServiceValue.getAttribute((String)object + string + "isSharedWithExternalMe");
                if (serviceNameValue14 == null) continue;
                bl = true;
                if (!"TRUE".equalsIgnoreCase(serviceNameValue14.getValueAsString())) continue;
                bl2 = true;
                ServiceNameValue serviceNameValue16 = new ServiceNameValue(serviceNameValue14.getServiceName(), (String)object, "mixedModeRadio", "TRUE", serviceNameValue14.getInputSource());
                if (serviceNameValue15 != null && "FALSE".equals(serviceNameValue15.getValueAsString())) {
                    bemServiceValue.addDeprecationWarning(this.getSourceLineInfo(serviceNameValue15), serviceNameValue15 + "\nwas converted to " + serviceNameValue16);
                }
                bemServiceValue.addAttribute(serviceNameValue14.getServiceName(), serviceNameValue16);
            }
            if (!bl && serviceNameValue15 != null && "TRUE".equalsIgnoreCase(serviceNameValue15.getValueAsString())) {
                for (n6 = 1; n6 <= 3; ++n6) {
                    string = MessageFormat.format("AUX{0}_", new Integer(n6));
                    serviceNameValue14 = new ServiceNameValue(serviceNameValue15.getServiceName(), (String)object + string, "isSharedWithExternalMe", "TRUE", serviceNameValue15.getInputSource());
                    bemServiceValue.addDeprecationWarning(this.getSourceLineInfo(serviceNameValue15), serviceNameValue15 + "\nwas converted to " + serviceNameValue14);
                    bemServiceValue.addAttribute(serviceNameValue15.getServiceName(), serviceNameValue14);
                }
            }
            if (!bl || bl2 || serviceNameValue15 == null || !"TRUE".equalsIgnoreCase(serviceNameValue15.getValueAsString())) continue;
            ServiceNameValue serviceNameValue17 = new ServiceNameValue(serviceNameValue15.getServiceName(), (String)object, "mixedModeRadio", "FALSE", serviceNameValue15.getInputSource());
            bemServiceValue.addDeprecationWarning(this.getSourceLineInfo(serviceNameValue15), serviceNameValue15 + "\nwas converted to " + serviceNameValue17);
            bemServiceValue.addAttribute(serviceNameValue15.getServiceName(), serviceNameValue17);
        }
        this.convertRruInstalledParam(bemServiceValue);
        this.convertCpriLineRateParam(bemServiceValue);
        this.convertNeedRuPositionAllocationParam(bemServiceValue);
        this.convertGpsAttrs2TimingUnitConf(bemServiceValue);
        this.convertSwitchComSupSysAtrrs2ConfigPowerBattery(bemServiceValue);
        this.updateNeedRuPositionAllocation(bemServiceValue);
    }

    private int[] convertToArray(ServiceNameValue serviceNameValue) {
        int[] nArray = null;
        if (serviceNameValue != null) {
            String string = serviceNameValue.getValueAsString();
            String[] stringArray = BemUtil.getStringArray(string);
            nArray = BemUtil.convertStringArrayToIntArray(stringArray);
        }
        return nArray;
    }

    private List getEdgeListForSector(List list, String string) {
        ArrayList<ServiceNameValue> arrayList = new ArrayList<ServiceNameValue>();
        for (int i = 0; i < list.size(); ++i) {
            ServiceNameValue serviceNameValue = (ServiceNameValue)list.get(i);
            if (!serviceNameValue.getPrefix().startsWith(string)) continue;
            arrayList.add(serviceNameValue);
        }
        return arrayList;
    }

    private int getOperatingBandSizeForSector(List list, String string) {
        HashSet<Object> hashSet = new HashSet<Object>();
        for (int i = 0; i < list.size(); ++i) {
            ServiceNameValue serviceNameValue = (ServiceNameValue)list.get(i);
            if (!serviceNameValue.getPrefix().startsWith(string)) continue;
            hashSet.add(serviceNameValue.getValue());
        }
        return hashSet.size();
    }

    private void convertNoOfRusAndCarriers(BemServiceValue bemServiceValue, ServiceNameValue serviceNameValue, ServiceNameValue serviceNameValue2) {
        String string = serviceNameValue.getValueAsString();
        String string2 = serviceNameValue2.getValueAsString();
        String string3 = serviceNameValue.getServiceName();
        String string4 = serviceNameValue.getPrefix();
        Source source = serviceNameValue.getInputSource();
        String string5 = "radioBuildingBlock";
        String string6 = this.getRadioBuildingBlock(string, string2);
        ServiceNameValue serviceNameValue3 = new ServiceNameValue(string3, string4, string5, string6, source);
        bemServiceValue.addDeprecationWarning(this.getSourceLineInfo(serviceNameValue), serviceNameValue + " and " + serviceNameValue2 + "\nwas converted to " + serviceNameValue3);
        bemServiceValue.addAttribute(string3, serviceNameValue3);
    }

    private String getRadioBuildingBlock(String string, String string2) {
        Integer n = new Integer(string);
        switch (n) {
            case 1: {
                if (string2.equals("1")) {
                    return "RB1";
                }
                if (string2.equals("2")) {
                    return "RB4";
                }
            }
            case 2: {
                if (!string2.equals("2")) break;
                return "RB3";
            }
        }
        return null;
    }

    private void convertHsdpa(BemServiceValue bemServiceValue, ServiceNameValue serviceNameValue) {
        ServiceNameValue serviceNameValue2 = serviceNameValue;
        String string = serviceNameValue.getValueAsString();
        ArrayList<String> arrayList = new ArrayList<String>();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        String[] stringArray = arrayList.toArray(new String[0]);
        String string2 = serviceNameValue.getServiceName();
        String string3 = "numHsCodeResources";
        String string4 = "1";
        Source source = serviceNameValue.getInputSource();
        String string5 = "";
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals("0")) continue;
            string5 = MessageFormat.format("hsSlot{0}_", stringArray[i]);
            ServiceNameValue serviceNameValue3 = new ServiceNameValue(string2, string5, string3, string4, source);
            bemServiceValue.addDeprecationWarning(this.getSourceLineInfo(serviceNameValue2), serviceNameValue2 + "\nwas converted to " + serviceNameValue3);
            bemServiceValue.addAttribute(string2, serviceNameValue3);
        }
    }

    private void convertSlotsForEtmfx(BemServiceValue bemServiceValue, ServiceNameValue serviceNameValue) {
        String string = serviceNameValue.getValueAsString();
        if (!string.equals("0")) {
            String string2 = serviceNameValue.getServiceName();
            String string3 = "slotsForETMFX11";
            String string4 = string;
            Source source = serviceNameValue.getInputSource();
            ServiceNameValue serviceNameValue2 = new ServiceNameValue(string2, "", string3, string4, source);
            bemServiceValue.addAttribute(string2, serviceNameValue2);
        }
    }

    private void convertIpOverEtherNetIpAdressInOam(BemServiceValue bemServiceValue, ServiceNameValue serviceNameValue) {
        String string = serviceNameValue.getValueAsString();
        String string2 = serviceNameValue.getServiceName();
        String string3 = "ipAddress";
        String string4 = string;
        Source source = serviceNameValue.getInputSource();
        ServiceNameValue serviceNameValue2 = new ServiceNameValue(string2, "", string3, string4, source);
        bemServiceValue.addAttribute(string2, serviceNameValue2);
    }

    private void convertSupportSystemControl(BemServiceValue bemServiceValue, ServiceNameValue serviceNameValue) {
        String string = serviceNameValue.getValueAsString();
        String string2 = serviceNameValue.getServiceName();
        String string3 = "supportSystemControl";
        String string4 = string;
        Source source = serviceNameValue.getInputSource();
        ServiceNameValue serviceNameValue2 = new ServiceNameValue(string2, "", string3, string4, source);
        bemServiceValue.addAttribute(string2, serviceNameValue2);
    }

    private void convertIpOverEtherNetSubnetMaskInOam(BemServiceValue bemServiceValue, ServiceNameValue serviceNameValue) {
        String string = serviceNameValue.getValueAsString();
        String string2 = serviceNameValue.getServiceName();
        String string3 = "subnetMask";
        String string4 = string;
        Source source = serviceNameValue.getInputSource();
        ServiceNameValue serviceNameValue2 = new ServiceNameValue(string2, "", string3, string4, source);
        bemServiceValue.addAttribute(string2, serviceNameValue2);
    }

    private void convertRadioBuildingBlock(BemServiceValue bemServiceValue, ServiceNameValue serviceNameValue) {
        String string = serviceNameValue.getValueAsString();
        if (string.equals("RBB12_2A")) {
            this.convertTo(bemServiceValue, serviceNameValue, serviceNameValue.getSimpleName(), "RBB12_1A");
            this.setMixedModeRadio(bemServiceValue, serviceNameValue);
        } else if (string.equals("RBB22_2C")) {
            this.convertTo(bemServiceValue, serviceNameValue, serviceNameValue.getSimpleName(), "RBB22_1B");
            this.setMixedModeRadio(bemServiceValue, serviceNameValue);
        } else if (string.equals("RBB22_4B")) {
            this.convertTo(bemServiceValue, serviceNameValue, serviceNameValue.getSimpleName(), "RBB22_2B");
            this.setMixedModeRadio(bemServiceValue, serviceNameValue);
        } else if (string.equals("RBB42_4A")) {
            this.convertTo(bemServiceValue, serviceNameValue, serviceNameValue.getSimpleName(), "RBB42_2D");
            this.setMixedModeRadio(bemServiceValue, serviceNameValue);
        }
    }

    private void setMixedModeRadio(BemServiceValue bemServiceValue, ServiceNameValue serviceNameValue) {
        String string = "SectorData";
        String string2 = serviceNameValue.getPrefix();
        Source source = serviceNameValue.getInputSource();
        ServiceNameValue serviceNameValue2 = new ServiceNameValue(string, string2, "mixedModeRadio", "TRUE", source);
        bemServiceValue.addAttribute(string, serviceNameValue2);
    }

    private void convertBand(BemServiceValue bemServiceValue, ServiceNameValue serviceNameValue) {
        String string = serviceNameValue.getValueAsString();
        if (string.equals("0")) {
            IntegerRange integerRange = new IntegerRange(21100, 21650);
            IntegerRange integerRange2 = new IntegerRange(19300, 19850);
            IntegerRange integerRange3 = new IntegerRange(8690, 8890);
            IntegerRange integerRange4 = new IntegerRange(21150, 21700);
            IntegerRange integerRange5 = new IntegerRange(19350, 19900);
            IntegerRange integerRange6 = new IntegerRange(8740, 8940);
            IntegerRange[] integerRangeArray = new IntegerRange[]{integerRange, integerRange2, integerRange3};
            IntegerRange[] integerRangeArray2 = new IntegerRange[]{integerRange4, integerRange5, integerRange6};
            String[] stringArray = new String[]{"1", "2", "5"};
            ServiceNameValue serviceNameValue2 = bemServiceValue.getAttribute(serviceNameValue.getPrefix(), "fqBandHighEdgeBranchA");
            if (serviceNameValue2 != null) {
                String string2 = serviceNameValue2.getValueAsString();
                ServiceNameValue serviceNameValue3 = bemServiceValue.getAttribute(serviceNameValue.getPrefix(), "fqBandLowEdgeBranchA");
                if (serviceNameValue3 != null) {
                    String string3 = serviceNameValue3.getValueAsString();
                    for (int i = 0; i < integerRangeArray.length; ++i) {
                        boolean bl = integerRangeArray2[i].isValueInRange(string2);
                        boolean bl2 = integerRangeArray[i].isValueInRange(string3);
                        if (!bl2 || !bl) continue;
                        this.convertTo(bemServiceValue, serviceNameValue, serviceNameValue.getSimpleName(), stringArray[i]);
                        this.convertEdgeToOperatingBand(bemServiceValue, serviceNameValue, stringArray[i]);
                        break;
                    }
                }
            }
        }
    }

    private void convertEdgeToOperatingBand(BemServiceValue bemServiceValue, ServiceNameValue serviceNameValue, String string) {
        Vector vector = bemServiceValue.getAllAttributesWithSimpleName("cellIdentity");
        String string2 = serviceNameValue.getPrefix();
        for (ServiceNameValue serviceNameValue2 : vector) {
            String string3 = serviceNameValue2.getPrefix();
            if (!string3.startsWith(string2)) continue;
            String string4 = serviceNameValue.getServiceName();
            String string5 = "operatingBand";
            Source source = serviceNameValue.getInputSource();
            ServiceNameValue serviceNameValue3 = new ServiceNameValue(string4, string3, string5, string, source);
            bemServiceValue.addAttribute(string4, serviceNameValue3);
            bemServiceValue.addDeprecationWarning(this.getSourceLineInfo(serviceNameValue), "\nwas converted to " + serviceNameValue3);
        }
    }

    private void convertBandToOperatingBand(BemServiceValue bemServiceValue, ServiceNameValue serviceNameValue, List list) {
        String string = serviceNameValue.getValueAsString();
        String string2 = serviceNameValue.getPrefix();
        for (ServiceNameValue serviceNameValue2 : list) {
            String string3 = serviceNameValue2.getPrefix();
            if (string.equals("0") || !string3.startsWith(string2)) continue;
            String string4 = serviceNameValue.getServiceName();
            String string5 = "operatingBand";
            String string6 = string;
            Source source = serviceNameValue.getInputSource();
            ServiceNameValue serviceNameValue3 = new ServiceNameValue(string4, string3, string5, string6, source);
            bemServiceValue.addAttribute(string4, serviceNameValue3);
            bemServiceValue.addDeprecationWarning(this.getSourceLineInfo(serviceNameValue), serviceNameValue + "\nwas converted to " + serviceNameValue3);
        }
    }

    private void convertOperatingBandToBand(BemServiceValue bemServiceValue, List list, ServiceNameValue serviceNameValue, List list2) {
        String string = serviceNameValue.getPrefix();
        String string2 = serviceNameValue.getValueAsString();
        for (int i = 0; i < list.size(); ++i) {
            ServiceNameValue serviceNameValue2 = (ServiceNameValue)list.get(i);
            String string3 = serviceNameValue2.getPrefix();
            String string4 = serviceNameValue2.getValueAsString();
            if (!string3.startsWith(string) || string2.equals(string4) || list2.contains(string) || string4.equals("0")) continue;
            String string5 = serviceNameValue.getServiceName();
            String string6 = serviceNameValue.getSimpleName();
            String string7 = serviceNameValue2.getValueAsString();
            Source source = serviceNameValue.getInputSource();
            ServiceNameValue serviceNameValue3 = new ServiceNameValue(string5, string, string6, string7, source);
            bemServiceValue.addAttribute(string5, serviceNameValue3);
        }
    }

    public List getConfiguredOperatingBand(List list) {
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < list.size(); ++i) {
            String string = (String)((ServiceNameValue)list.get(i)).getValue();
            if (string.equals("0")) continue;
            arrayList.add(list.get(i));
        }
        return arrayList;
    }

    public List getCellNotConfiguredOperatingBand(List list, List list2) {
        String string;
        int n;
        ArrayList<String> arrayList = new ArrayList<String>();
        ArrayList arrayList2 = new ArrayList();
        for (n = 0; n < list.size(); ++n) {
            string = SectorUtil.getCellPrefix((ServiceNameValue)list.get(n));
            arrayList.add(string);
        }
        for (n = 0; n < list2.size(); ++n) {
            string = SectorUtil.getCellPrefix((ServiceNameValue)list2.get(n));
            if (arrayList.contains(string)) continue;
            arrayList2.add(list2.get(n));
        }
        return arrayList2;
    }

    public List getSectorPrefixForNotConfiguredOperatingBand(List list, List list2) {
        HashSet<String> hashSet = new HashSet<String>();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            String string = SectorUtil.getSectorPrefix((ServiceNameValue)list.get(i));
            hashSet.add(string);
        }
        for (String string : hashSet) {
            int n = 0;
            for (int i = 0; i < list2.size(); ++i) {
                String string2 = SectorUtil.getSectorPrefix((ServiceNameValue)list2.get(i));
                String string3 = (String)((ServiceNameValue)list2.get(i)).getValue();
                if (string3.equals("0") || !string.equals(string2)) continue;
                ++n;
            }
            if (n != 0) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    private void checkSectorAllOperatingBandIsConfigured(List list, List list2) throws BemXmlException {
        String string;
        int n;
        HashSet<String> hashSet = new HashSet<String>();
        for (n = 0; n < list.size(); ++n) {
            string = SectorUtil.getSectorPrefix((ServiceNameValue)list.get(n));
            hashSet.add(string);
        }
        for (n = 0; n < list2.size(); ++n) {
            string = SectorUtil.getSectorPrefix((ServiceNameValue)list2.get(n));
            if (!hashSet.contains(string)) continue;
            String string2 = string.substring(1, string.indexOf("_"));
            throw new BemXmlException("The operatingBand parameter must be configured for all cells in Sector " + string2);
        }
    }

    private void convertOperatingBandAndBand(BemServiceValue bemServiceValue, List list, List list2, List list3) throws BemXmlException {
        List list4 = this.getConfiguredOperatingBand(list);
        List list5 = this.getCellNotConfiguredOperatingBand(list4, list2);
        List list6 = this.getSectorPrefixForNotConfiguredOperatingBand(list2, list);
        this.checkSectorAllOperatingBandIsConfigured(list4, list5);
        for (ServiceNameValue serviceNameValue : list3) {
            if (serviceNameValue == null) continue;
            String string = serviceNameValue.getPrefix();
            if (list6.contains(string)) {
                this.convertBandToOperatingBand(bemServiceValue, serviceNameValue, list5);
                continue;
            }
            this.convertOperatingBandToBand(bemServiceValue, list4, serviceNameValue, list6);
        }
    }

    private void convertFreqBandHiAndLoEdge(BemServiceValue bemServiceValue) {
        String[][] stringArrayArray = new String[][]{{"freqBandHiEdge", "fqBandHighEdgeBranch"}, {"freqBandLoEdge", "fqBandLowEdgeBranch"}};
        for (int i = 0; i < stringArrayArray.length; ++i) {
            String string = stringArrayArray[i][0];
            String string2 = stringArrayArray[i][1];
            Vector vector = bemServiceValue.getAttributesStartingWith(string);
            for (ServiceNameValue serviceNameValue : vector) {
                String string3;
                StringTokenizer stringTokenizer = new StringTokenizer(serviceNameValue.getName(), "_");
                if (stringTokenizer.countTokens() != 3) continue;
                String string4 = stringTokenizer.nextToken() + "_";
                String string5 = stringTokenizer.nextToken();
                String string6 = serviceNameValue.getServiceName();
                String string7 = string3 = serviceNameValue.getValueAsString();
                if (string3 != null && !string3.equals("")) {
                    try {
                        int n = Integer.parseInt(string3) * 2;
                        string7 = String.valueOf(n);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                bemServiceValue.addAttribute(string6, new ServiceNameValue(string6, string4, string2 + string5, string7, serviceNameValue.getInputSource()));
            }
        }
        String[][] stringArrayArray2 = new String[][]{{"freqBandHiEdgeBranchA", "fqBandHighEdgeBranchA"}, {"freqBandLoEdgeBranchA", "fqBandLowEdgeBranchA"}, {"freqBandHiEdgeBranchB", "fqBandHighEdgeBranchB"}, {"freqBandLoEdgeBranchB", "fqBandLowEdgeBranchB"}, {"freqBandHiEdgeBranchC", "fqBandHighEdgeBranchC"}, {"freqBandLoEdgeBranchC", "fqBandLowEdgeBranchC"}, {"freqBandHiEdgeBranchD", "fqBandHighEdgeBranchD"}, {"freqBandLoEdgeBranchD", "fqBandLowEdgeBranchD"}, {"freqBandHiEdgeBranchE", "fqBandHighEdgeBranchE"}, {"freqBandLoEdgeBranchE", "fqBandLowEdgeBranchE"}, {"freqBandHiEdgeBranchF", "fqBandHighEdgeBranchF"}, {"freqBandLoEdgeBranchF", "fqBandLowEdgeBranchF"}};
        for (int i = 0; i < stringArrayArray2.length; ++i) {
            this.convertFqBandEgdeWithSimpleName(bemServiceValue, stringArrayArray2[i][0], stringArrayArray2[i][1]);
        }
    }

    private void convertFqBandEgdeWithSimpleName(BemServiceValue bemServiceValue, String string, String string2) {
        Vector vector = bemServiceValue.getAllAttributesWithSimpleName(string);
        for (ServiceNameValue serviceNameValue : vector) {
            String string3;
            String string4 = string3 = (String)serviceNameValue.getValue();
            if (string3 != null && !string3.equals("")) {
                try {
                    int n = Integer.parseInt(string3) * 2;
                    string4 = String.valueOf(n);
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.convertTo(bemServiceValue, serviceNameValue, string2, string4);
        }
    }

    private void convertJumperCableParam(BemServiceValue bemServiceValue, String string, String string2) {
        Vector vector = bemServiceValue.getAllAttributesWithSimpleName(string);
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            ServiceNameValue serviceNameValue = (ServiceNameValue)enumeration.nextElement();
            if (serviceNameValue == null) continue;
            this.addToListParamater(bemServiceValue, serviceNameValue, string2);
        }
    }

    private void convertRruInstalledParam(BemServiceValue bemServiceValue) {
        this.convertRruInstalledWithSimpleName(bemServiceValue);
    }

    private void convertRruInstalledWithSimpleName(BemServiceValue bemServiceValue) {
        Vector vector = bemServiceValue.getAllAttributesWithSimpleName("rruInstalled");
        for (ServiceNameValue serviceNameValue : vector) {
            String string = serviceNameValue.getValueAsString();
            if (!string.equals("YES")) continue;
            this.convertTo(bemServiceValue, serviceNameValue, "auUnitType", "RRU22");
        }
    }

    private void convertGpsAttrs2TimingUnitConf(BemServiceValue bemServiceValue) {
        if (this.getaDtdFilePathName().indexOf("SiteEquipment.dtd") != -1) {
            ServiceNameValue serviceNameValue = bemServiceValue.getAttribute(PrefixUtil.getFirstCabinetPrefix() + "gpsOutEnabled");
            ServiceNameValue serviceNameValue2 = bemServiceValue.getAttribute(PrefixUtil.getFirstCabinetPrefix() + "gpsOutEnabledOnSlot2");
            ServiceNameValue serviceNameValue3 = bemServiceValue.getAttribute(PrefixUtil.getFirstCabinetPrefix() + "absoluteTimeSynchEnabled");
            if (serviceNameValue != null) {
                this.convertToGpsAttr(bemServiceValue, serviceNameValue, "gpsOutEnabled", serviceNameValue.getValueAsString());
            }
            if (serviceNameValue2 != null) {
                this.convertToGpsAttr(bemServiceValue, serviceNameValue2, "gpsOutEnabledOnSlot2", serviceNameValue2.getValueAsString());
            }
            if (serviceNameValue3 != null) {
                this.convertToGpsAttr(bemServiceValue, serviceNameValue3, "absoluteTimeSynchEnabled", serviceNameValue3.getValueAsString());
            }
        }
    }

    private void convertSwitchComSupSysAtrrs2ConfigPowerBattery(BemServiceValue bemServiceValue) {
        if (this.getaDtdFilePathName().indexOf("ExpandAndModifyRbs.dtd") != -1) {
            String string = "CAB1s_";
            String string2 = PrefixUtil.getFirstCabinetPrefix();
            Vector vector = bemServiceValue.getAttributesStartingWith("CAB1s_");
            if (vector.size() > 0) {
                for (int i = 0; i < vector.size(); ++i) {
                    ServiceNameValue serviceNameValue;
                    ServiceNameValue serviceNameValue2 = (ServiceNameValue)vector.get(i);
                    String string3 = serviceNameValue2.getPrefix();
                    int n = string3.indexOf(string);
                    String string4 = string2 + string3.substring(n + string.length());
                    if ("supportSystemControl".equals(serviceNameValue2.getSimpleName())) {
                        serviceNameValue = new ServiceNameValue(serviceNameValue2.getServiceName(), "", serviceNameValue2.getSimpleName(), (String)serviceNameValue2.getValue());
                        bemServiceValue.addAttribute(serviceNameValue2.getServiceName(), serviceNameValue);
                        continue;
                    }
                    if (null != bemServiceValue.getAttribute(string4, serviceNameValue2.getSimpleName())) continue;
                    serviceNameValue = new ServiceNameValue(serviceNameValue2.getServiceName(), string4, serviceNameValue2.getSimpleName(), (String)serviceNameValue2.getValue());
                    bemServiceValue.addAttribute(serviceNameValue2.getServiceName(), serviceNameValue);
                    bemServiceValue.addDeprecationWarning(this.getSourceLineInfo(serviceNameValue2), serviceNameValue2 + "\nwas converted to " + serviceNameValue);
                }
            }
        }
    }

    private void ignoreAttribute(BemServiceValue bemServiceValue, ServiceNameValue serviceNameValue) {
        bemServiceValue.addDeprecationWarning(this.getSourceLineInfo(serviceNameValue), serviceNameValue + "\n is no longer used and will be ignored. ");
    }

    private void convertTo(BemServiceValue bemServiceValue, ServiceNameValue serviceNameValue, String string, String string2) {
        if (null != serviceNameValue) {
            String string3 = serviceNameValue.getServiceName();
            String string4 = serviceNameValue.getPrefix();
            Source source = serviceNameValue.getInputSource();
            ServiceNameValue serviceNameValue2 = new ServiceNameValue(string3, string4, string, string2, source);
            bemServiceValue.addAttribute(string3, serviceNameValue2);
            if (!string.equalsIgnoreCase("band")) {
                bemServiceValue.addDeprecationWarning(this.getSourceLineInfo(serviceNameValue), serviceNameValue + "\nwas converted to " + serviceNameValue2);
            }
        }
    }

    private void convertToGpsAttr(BemServiceValue bemServiceValue, ServiceNameValue serviceNameValue, String string, String string2) {
        if (null != serviceNameValue) {
            String string3 = "TimingUnitConfig";
            String string4 = "";
            Source source = serviceNameValue.getInputSource();
            ServiceNameValue serviceNameValue2 = new ServiceNameValue(string3, string4, string, string2, source);
            bemServiceValue.addAttribute(string3, serviceNameValue2);
            bemServiceValue.addDeprecationWarning(this.getSourceLineInfo(serviceNameValue), serviceNameValue + "\nwas converted to " + serviceNameValue2 + ". " + "You should use <TimingUnitConfig> to configure Sync related attributes");
        }
    }

    private void addToListParamater(BemServiceValue bemServiceValue, ServiceNameValue serviceNameValue, String string) {
        String string2 = serviceNameValue.getPrefix();
        String string3 = serviceNameValue.getServiceName();
        Source source = serviceNameValue.getInputSource();
        ServiceNameValue serviceNameValue2 = bemServiceValue.getAttribute(string2, string);
        if (serviceNameValue2 == null) {
            String string4 = serviceNameValue.getValueAsString();
            serviceNameValue2 = new ServiceNameValue(string3, string2, string, string4, source);
            bemServiceValue.addDeprecationWarning(this.getSourceLineInfo(serviceNameValue), serviceNameValue + "\nwas converted to " + serviceNameValue2);
        } else {
            int n = Integer.parseInt(serviceNameValue.getValueAsString());
            String string5 = serviceNameValue2.getValueAsString();
            String[] stringArray = BemUtil.getStringArray(string5);
            int[] nArray = BemUtil.convertStringArrayToIntArray(stringArray);
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == -1) continue;
                nArray[i] = nArray[i] + n;
            }
            string5 = BemUtil.getCommaSeparatedValueString(nArray);
            serviceNameValue2 = new ServiceNameValue(string3, string2, string, string5, source);
            bemServiceValue.addDeprecationWarning(this.getSourceLineInfo(serviceNameValue), serviceNameValue + "\n was merged to " + serviceNameValue2);
        }
    }

    private ServiceNameValue findFirstSetTo(ServiceNameValue[] serviceNameValueArray, String string) {
        for (int i = 0; i < serviceNameValueArray.length; ++i) {
            if (!(serviceNameValueArray[i] == null ? string == null : serviceNameValueArray[i].getValue().equals(string))) continue;
            return serviceNameValueArray[i];
        }
        return null;
    }

    private Integer getSourceLineInfo(ServiceNameValue serviceNameValue) {
        Source source = serviceNameValue.getInputSource();
        if (source instanceof XmlSource) {
            XmlSource xmlSource = (XmlSource)source;
            Integer n = xmlSource.getLine();
            return n;
        }
        return new Integer(-1);
    }

    private void convertCpriLineRateParam(BemServiceValue bemServiceValue) {
        Vector vector = bemServiceValue.getAllAttributesWithSimpleName("cpriLineRate");
        for (int i = 0; i < vector.size(); ++i) {
            String string;
            ServiceNameValue serviceNameValue = (ServiceNameValue)vector.get(i);
            if (serviceNameValue == null || "".equals(string = serviceNameValue.getValueAsString()) || !string.startsWith("E") && !string.startsWith("O")) continue;
            this.convertTo(bemServiceValue, serviceNameValue, serviceNameValue.getSimpleName(), string.substring(1).toUpperCase());
            ServiceNameValue serviceNameValue2 = bemServiceValue.getAttribute(serviceNameValue.getPrefix(), "auUnitType");
            if (null != serviceNameValue2 && (null == serviceNameValue2 || !"".equals(serviceNameValue2.getValueAsString()))) continue;
            String string2 = string.startsWith("E") ? "RUWRUS" : "RRUWRRUS";
            this.convertTo(bemServiceValue, serviceNameValue, "auUnitType", string2);
        }
    }

    private void convertNeedRuPositionAllocationParam(BemServiceValue bemServiceValue) throws BemXmlException {
        Vector vector = bemServiceValue.getAllAttributesWithSimpleName("auUnitType");
        for (ServiceNameValue serviceNameValue : vector) {
            ServiceNameValue serviceNameValue2;
            if (!AuUnitType.isMacroAuUnitType(serviceNameValue.getValueAsString()) || !this.isModifyWizard(bemServiceValue)) continue;
            String string = serviceNameValue.getPrefix();
            ServiceNameValue serviceNameValue3 = bemServiceValue.getAttribute(string, "primaryPortId");
            ServiceNameValue serviceNameValue4 = bemServiceValue.getAttribute(string, "secondaryPortId");
            ServiceNameValue serviceNameValue5 = bemServiceValue.getAttribute(string, "cabinetNumber");
            if (serviceNameValue.getServiceName().equals("AddSector")) {
                if (null != serviceNameValue3) continue;
                if (null == serviceNameValue4 && null == serviceNameValue5) {
                    serviceNameValue2 = new ServiceNameValue(serviceNameValue.getServiceName(), serviceNameValue.getPrefix(), "needRuPositionAllocation", "YES");
                    bemServiceValue.addAttribute(serviceNameValue.getServiceName(), serviceNameValue2);
                    continue;
                }
                throw new BemXmlException("add " + string + "Sector, cabinetNumber and secordaryProtId " + "must be null when primary is null ");
            }
            if (!serviceNameValue.getServiceName().equals("ModifySector")) continue;
            serviceNameValue2 = null;
            serviceNameValue2 = null == serviceNameValue3 && null == serviceNameValue4 && null == serviceNameValue5 ? new ServiceNameValue(serviceNameValue.getServiceName(), serviceNameValue.getPrefix(), "needRuPositionAllocation", "YES") : new ServiceNameValue(serviceNameValue.getServiceName(), serviceNameValue.getPrefix(), "needRuPositionAllocation", "NO");
            bemServiceValue.addAttribute(serviceNameValue.getServiceName(), serviceNameValue2);
        }
    }

    private void updateNeedRuPositionAllocation(BemServiceValue bemServiceValue) {
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(bemServiceValue.getAllAttributesWithSimpleName("primaryPortId"));
        arrayList.addAll(bemServiceValue.getAllAttributesWithSimpleName("secondaryPortId"));
        arrayList.addAll(bemServiceValue.getAllAttributesWithSimpleName("cabinetNumber"));
        arrayList.addAll(bemServiceValue.getAllAttributesWithSimpleName("auUnitType"));
        for (ServiceNameValue serviceNameValue : arrayList) {
            if (!serviceNameValue.getServiceName().equals("ModifySector") || serviceNameValue.getSimpleName().equals("auUnitType") && AuUnitType.isMacroAuUnitType(serviceNameValue.getValueAsString())) continue;
            ServiceNameValue serviceNameValue2 = new ServiceNameValue(serviceNameValue.getServiceName(), serviceNameValue.getPrefix(), "needRuPositionAllocation", "NO");
            bemServiceValue.addAttribute(serviceNameValue.getServiceName(), serviceNameValue2);
        }
    }

    private boolean isModifyWizard(BemServiceValue bemServiceValue) {
        Enumeration enumeration = bemServiceValue.getAllServices();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            if (!"AddSector".equals(string) && !"ModifySector".equals(string)) continue;
            return true;
        }
        return false;
    }

    public String getaDtdFilePathName() {
        return this.aDtdFilePathName;
    }
}

