/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.control;

import java.text.MessageFormat;
import java.util.Vector;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.RadioEquipmentProvider;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterServer;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IpAddressParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.nal.ifc.NalNameValue;
import se.ericsson.wcdma.rbs.bem.common.util.BemUtil;
import se.ericsson.wcdma.support.gui.guilib.infra.AbstractController;

public abstract class GuiCheckAndShowWarning {
    public static boolean checkIPAddressAndShowWarning(Rbs rbs, AbstractController abstractController) throws BemException {
        IpAddressParameter ipAddressParameter = (IpAddressParameter)rbs.getCustomerParameterObject("ipAddress");
        String string = ipAddressParameter.getValue();
        String string2 = ipAddressParameter.getLoadedValue();
        String string3 = "\nIP address is changed.\nPlease double check the IP address configuration.\n\nDo you want to change IP address?";
        StringBuffer stringBuffer = new StringBuffer(string3);
        if (string2.equals("##UNDEFINED") || string.equals(string2)) {
            return true;
        }
        stringBuffer.append("\nThe previous IP Address is: ").append(string2).append(", The new configured IP Address is: ").append(string);
        String string4 = stringBuffer.toString();
        return abstractController.getEasyPopUp().displayWarningMessageWithYesNoConfirm(string4 + ".");
    }

    public static boolean checkDcVoltageAndShowWarning(Rbs rbs, AbstractController abstractController) {
        int n;
        RadioEquipmentProvider radioEquipmentProvider = (RadioEquipmentProvider)rbs.getProvider(RadioEquipmentProvider.class);
        int[] nArray = radioEquipmentProvider.getEquippedSectors();
        int n2 = nArray.length;
        boolean bl = false;
        String string = "\nDC_17V_OR_DC_30V means that 17V/30V will be supplied to TMA. \nRBS system decides the value depending on the frequency band.\nIf a low voltage (e.g. 12V) TMA is mounted it might be damaged.\nPlease double check the DC voltage specification of the TMA.\n\nDo you want to set DC voltage to DC_17V_OR_DC_30V for sectorAntenna ";
        StringBuffer stringBuffer = new StringBuffer(string);
        for (int i = 0; i < n2; ++i) {
            n = i + 1;
            try {
                int n3 = 0;
                if (rbs.isPantherHybridRbs() && n >= 7) {
                    n3 = 1;
                }
                String string2 = MessageFormat.format("S{0}_", new Integer(n));
                for (int j = 0; j < rbs.getAntennaSystemProvider(n3).getNumOfSectorAntennas(n); ++j) {
                    CustomerParameter customerParameter;
                    String string3 = rbs.getCustomerParameterObject(BemUtil.getCustomerParameterName(string2, "tmaType", j + 1)).getValue();
                    CustomerParameterServer customerParameterServer = rbs.getCustomerParameterServerObject(BemUtil.getCustomerParameterName(string2, "internalPower", j + 1));
                    Integer n4 = (Integer)customerParameterServer.getValueMom();
                    if (!string3.equals("TMA") && !string3.equals("ATMA_AND_TMA") || n4 == 0 || !(customerParameter = rbs.getCustomerParameterObject(BemUtil.getCustomerParameterName(string2, "dcVoltage", j + 1))).getValue().equalsIgnoreCase("DC_17V_OR_DC_30V")) continue;
                    bl = true;
                    stringBuffer.append(", ").append(n).append("-").append(j + 1);
                }
                continue;
            }
            catch (BemException bemException) {
                BemLog.exceptionRaised(bemException);
            }
        }
        if (!bl) {
            return true;
        }
        String string4 = stringBuffer.toString();
        string4 = string4.replace(string + ",", string + ":");
        n = abstractController.getEasyPopUp().displayWarningMessageWithYesNoConfirm(string4 + "?") ? 1 : 0;
        return n != 0;
    }

    public static boolean checkDcVoltageAndShowWarning(Rbs rbs, AbstractController abstractController, Vector[] vectorArray) {
        int n;
        RadioEquipmentProvider radioEquipmentProvider = (RadioEquipmentProvider)rbs.getProvider(RadioEquipmentProvider.class);
        int[] nArray = radioEquipmentProvider.getEquippedSectors();
        int n2 = nArray.length;
        boolean bl = false;
        String string = "\nDC_17V_OR_DC_30V means that 17V/30V will be supplied to TMA. \nRBS system decides the value depending on the frequency band.\nIf a low voltage (e.g. 12V) TMA is mounted it might be damaged.\nPlease double check the DC voltage specification of the TMA.\n\nDo you want to set DC voltage to DC_17V_OR_DC_30V for sectorAntenna ";
        StringBuffer stringBuffer = new StringBuffer(string);
        NalNameValue nalNameValue = null;
        try {
            for (int i = 0; i < n2; ++i) {
                n = i + 1;
                int n3 = 0;
                if (rbs.isPantherHybridRbs() && n >= 7) {
                    n3 = 1;
                }
                if (vectorArray[i] == null) continue;
                for (int j = 0; j < vectorArray[i].size(); ++j) {
                    nalNameValue = (NalNameValue)vectorArray[i].get(j);
                    for (int k = 0; k < rbs.getAntennaSystemProvider(n3).getNumOfSectorAntennas(n); ++k) {
                        if (!nalNameValue.getName().equalsIgnoreCase(BemUtil.getCustomerParameterName("", "dcVoltage", k + 1)) || !nalNameValue.getValue().toString().equalsIgnoreCase("DC_17V_OR_DC_30V")) continue;
                        bl = true;
                        stringBuffer.append(", ").append(n).append("-").append(k + 1);
                    }
                }
            }
        }
        catch (BemException bemException) {
            BemLog.exceptionRaised(bemException);
        }
        if (!bl) {
            return true;
        }
        String string2 = stringBuffer.toString();
        string2 = string2.replace(string + ",", string + ":");
        n = abstractController.getEasyPopUp().displayWarningMessageWithYesNoConfirm(string2 + "?") ? 1 : 0;
        return n != 0;
    }
}

