/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.precontrol;

import java.util.Collection;
import java.util.Iterator;
import java.util.Properties;
import javax.swing.JOptionPane;
import se.ericsson.cello.emt.sshsftpservice.EmSftp;
import se.ericsson.cello.emt.sshsftpservice.FileAttributes;
import se.ericsson.cello.emt.sshsftpservice.FileTransferProgress;
import se.ericsson.cello.emt.sshsftpservice.FileType;
import se.ericsson.cello.emt.sshsftpservice.SshSftpService;
import se.ericsson.security.launcher.Launcher;
import se.ericsson.security.launcher.LauncherException;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.wizard.model.AbstractWizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.util.Installer;
import se.ericsson.wcdma.rbs.bem.wizard.util.SubInstaller;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardHelper;

public abstract class AbstractTmfFilesPreController
implements SubInstaller {
    private static final String TMF_DATA_PATH = "/c/systemfiles/rbs/antenna_system_config/";
    private static final String FILE_SEPARATOR = "file.separator";
    private static final String FILENAME_DELIM = "\n";
    private Installer installer = null;
    private AbstractWizardCIModel model = null;
    protected String name = "";
    protected String description = "";
    protected WizardHelper wizardHelp = null;
    SshSftpService service = null;
    private int totalReports = 3;

    public AbstractTmfFilesPreController(Installer installer, AbstractWizardCIModel abstractWizardCIModel, WizardHelper wizardHelper) {
        this.installer = installer;
        this.model = abstractWizardCIModel;
        String string = this.getClass().getName();
        int n = string.lastIndexOf(".");
        this.name = string.substring(n + 1);
        this.wizardHelp = wizardHelper;
    }

    public boolean install() throws BemException {
        boolean bl = true;
        this.installer.reportProgress(this.name, this.description);
        if (!this.model.getTmfFilesToAdd()) {
            while (this.totalReports > 0) {
                this.installer.reportProgress(this.name, this.description);
                --this.totalReports;
            }
            return true;
        }
        if (this.wizardHelp.getSshSftpServiceLauncher().getLauncher() instanceof Launcher) {
            try {
                this.service = this.wizardHelp.startSshSftpServiceLauncher();
            }
            catch (LauncherException launcherException) {
                launcherException.printStackTrace();
                this.displayWarningMessage("get stfp service failed!");
            }
        } else {
            BemLog.log(5, "wizard is running in stubbed envorinment");
            while (this.totalReports > 0) {
                this.installer.reportProgress(this.name, this.description);
                --this.totalReports;
            }
            return true;
        }
        EmSftp emSftp = this.service.getSftp("Element Manager");
        String[] stringArray = this.model.getTmfFiles().split(FILENAME_DELIM);
        Properties properties = System.getProperties();
        String string = (String)properties.get(FILE_SEPARATOR);
        if (stringArray.length > 0) {
            if (!this.isDirectoryExist(emSftp, "/c/systemfiles/", "rbs")) {
                emSftp.mkdir("/c/systemfiles/rbs");
            }
            if (!this.isDirectoryExist(emSftp, "/c/systemfiles/rbs", "antenna_system_config")) {
                emSftp.mkdir("/c/systemfiles/rbs/antenna_system_config");
            }
        }
        for (int i = 0; i < stringArray.length; ++i) {
            String string2 = TMF_DATA_PATH + stringArray[i].substring(stringArray[i].lastIndexOf(string) + 1);
            FileTransferProgressListener fileTransferProgressListener = new FileTransferProgressListener();
            emSftp.put(stringArray[i], string2, (FileTransferProgress)fileTransferProgressListener);
            if (!fileTransferProgressListener.isOK()) {
                bl = false;
                this.displayWarningMessage("TMF file" + string2 + "FTP failed!");
                break;
            }
            this.installer.reportProgress(this.name, this.description);
            --this.totalReports;
        }
        emSftp.bye();
        while (this.totalReports > 0) {
            this.installer.reportProgress(this.name, this.description);
            --this.totalReports;
        }
        return bl;
    }

    private boolean isDirectoryExist(EmSftp emSftp, String string, String string2) {
        Collection collection = emSftp.ls(string);
        Iterator iterator = collection.iterator();
        FileAttributes fileAttributes = null;
        boolean bl = false;
        while (iterator.hasNext()) {
            fileAttributes = (FileAttributes)iterator.next();
            if (!fileAttributes.getName().equals(string2) || !fileAttributes.getType().equals((Object)FileType.DIRECTORY)) continue;
            bl = true;
            break;
        }
        return bl;
    }

    protected void displayWarningMessage(String string) {
        JOptionPane.showMessageDialog(null, string, "warning", 0);
    }

    public int getTotalNoOfProgressReports() {
        return this.totalReports;
    }

    public String getTheDescription() {
        return this.description;
    }

    public String getTheName() {
        return this.name;
    }

    private static class FileTransferProgressListener
    implements FileTransferProgress {
        private boolean isOK = false;

        private FileTransferProgressListener() {
        }

        public boolean isOK() {
            return this.isOK;
        }

        public void completed() {
            this.isOK = true;
        }

        public boolean isCancelled() {
            return false;
        }

        public void progressed(long l) {
        }

        public void started(long l, String string) {
        }
    }
}

