/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.util;

import java.lang.reflect.Constructor;
import se.ericsson.cello.emt.sshsftpservice.exception.EmSshLoginException;
import se.ericsson.wcdma.rbs.bem.common.BemLog;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.gui.ProgressReporter;
import se.ericsson.wcdma.rbs.bem.common.log.BemLogAndScriptUtil;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.util.Installer;
import se.ericsson.wcdma.rbs.bem.wizard.util.SubInstaller;

public class InstallController
extends Thread
implements Installer {
    private boolean interrupted = false;
    private final ProgressReporter theProgressReporter;
    private StringBuffer theInstallReport = null;
    private SubInstaller[] subControllers = null;
    private final Class[] constructorParamTypes = new Class[]{Installer.class};
    private final Object[] initArgs = new Object[]{this};
    private final Class[] subControllerClasses;
    private final String threadName;

    public InstallController(ProgressReporter progressReporter, Class[] classArray) {
        this.theProgressReporter = progressReporter;
        this.subControllerClasses = classArray;
        this.threadName = "BEM-" + this.getClass().getSimpleName() + " for " + progressReporter.getClass().getSimpleName();
        super.setName(this.threadName);
    }

    public void start() {
        super.start();
    }

    public void run() {
        block2: {
            try {
                this.run_subcontrollers();
            }
            catch (BemException bemException) {
                if (this.isInterrupted()) break block2;
                BemLog.exceptionRaised("Error has occurred", bemException);
                this.theProgressReporter.reportError(bemException);
            }
        }
    }

    public void run_subcontrollers() throws BemException {
        String string = null;
        String string2 = "";
        int n = this.subControllers.length;
        string2 = "InstallController.run_subcontrollers() noOfSubControllers=" + n + "  ";
        for (int i = 0; i < n; ++i) {
            try {
                string2 = "InstallController.run_subcontrollers() noOfSubControllers=" + n + " index=" + i;
                if (i > 0) {
                    string2 = string2 + " , previous subController was " + string;
                }
                if (this.isInterrupted()) {
                    return;
                }
                string = this.subControllers[i].getTheName();
                String string3 = this.extractClassName(this.subControllers[i].getTheName());
                BemLogAndScriptUtil.getInstance().logStartConfigurationStep(string3);
                this.subControllers[i].install();
                BemLogAndScriptUtil.getInstance().logEndConfigurationStep();
                continue;
            }
            catch (BemException bemException) {
                String string4 = bemException.getTheFunction();
                try {
                    String string5 = this.subControllers[i].getTheDescription();
                    string5 = string4 != null ? string + ", " + string5 + " " + string4 : string + ", " + string5;
                    bemException.setTheFunction(string);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                throw bemException;
            }
            catch (Exception exception) {
                int n2;
                Throwable throwable;
                String string6 = "Current subcontroller=null";
                String string7 = null;
                try {
                    string6 = "Current subcontroller=" + string;
                    string7 = "Current description=" + this.subControllers[i].getTheDescription();
                }
                catch (Exception exception2) {
                    throw new BemException("InstallController-executing subcontroller", string7, null, string, exception2);
                }
                if (exception instanceof EmSshLoginException && (throwable = exception.getCause()) != null && (n2 = throwable.toString().indexOf(":")) > -1) {
                    String string8 = throwable.toString().substring(n2 + 2);
                    string6 = string6 + "\nFailed to upload TMF file because : \n" + string8;
                }
                throw new WizardException(string2, string7, null, string6, exception);
            }
        }
        if (this.isInterrupted()) {
            return;
        }
        BemLogAndScriptUtil.getInstance().logEndConfigurationProcedure();
        this.theProgressReporter.reportComplete(this.theInstallReport);
    }

    public boolean isInterrupted() {
        return this.interrupted;
    }

    public void reportProgress(String string, String string2) {
        this.theProgressReporter.reportProgress(string, string2);
    }

    public void reportProgress(String string, String string2, int n) {
        this.theProgressReporter.reportProgress(string, string2, n);
    }

    public String getReportedProgress() {
        return this.theProgressReporter.getReportedProgress();
    }

    public synchronized void stopExecution() {
        this.interrupted = true;
        this.interrupt();
        try {
            this.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public int initiate() throws WizardException {
        int n = this.subControllerClasses.length;
        this.subControllers = new SubInstaller[n];
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            try {
                Constructor constructor = this.subControllerClasses[i].getConstructor(this.constructorParamTypes);
                this.subControllers[i] = (SubInstaller)constructor.newInstance(this.initArgs);
                n3 = this.subControllers[i].getTotalNoOfProgressReports();
                n2 += n3;
                continue;
            }
            catch (Exception exception) {
                throw new WizardException("InstallController", "Create/Run a subcontroller", null, null, exception);
            }
        }
        return n2;
    }

    public void extendInstallReport(StringBuffer stringBuffer) {
        String string;
        if (this.theInstallReport == null) {
            this.theInstallReport = new StringBuffer();
        }
        if (stringBuffer != null && !(string = stringBuffer.toString().trim()).equals("") && !string.equals("\n")) {
            this.theInstallReport.append("\n");
            this.theInstallReport.append(stringBuffer);
        }
    }

    public void reportComplete() {
        this.theProgressReporter.reportComplete(this.theInstallReport);
        this.theInstallReport = new StringBuffer();
        this.theInstallReport.append("The line above will not be shown in target env.");
    }

    private String extractClassName(String string) {
        int n = string.lastIndexOf(".");
        if (n > 0) {
            return string.substring(n + 1);
        }
        return string;
    }

    public String toString() {
        return this.threadName;
    }
}

