/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.custparam.AbsoluteTimeSynchEnabledParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.custparam.GpsOutEnabledParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.cabinetbasic.custparam.GpsOutEnabledParameterOnSlot2;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.AbstractPowerSystemCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.ClimateRegulationSystem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.commonpowersystem.custparam.ClimateSystem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.powersupply.rbs4.AbstractPowerSupplyCI;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.PowerSupplyProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.RadioIfTypeParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.custparam.CarrierAllocationModeParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.radioequipment.custparam.DigitalBuildingBlockParameter;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.TrueFalseCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.api.OpenCIs;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.api.RbsFactory;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterComboBox;
import se.ericsson.wcdma.rbs.bem.common.service.PrefixUtil;
import se.ericsson.wcdma.rbs.bem.wizard.control.BemWizardGuiController;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.model.CabinetFlexModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.view.DataFlexView;

public class DataFlexController
extends BemWizardGuiController {
    private static final int MAX_NUMBER_OF_BASE_BANDS_POOLS = 2;
    private DataFlexView view;
    private boolean isListenerEnabled;
    protected Rbs rbs;
    private final List customerParameterNames = new ArrayList();
    private RadioIfTypeParameter[] radioIfTypeParameters = null;
    private RadioIfTypeListener[] radioIfTypeListeners = null;
    private TrueFalseCustomerParameter supportSystemControl = null;
    private AbsoluteTimeSynchEnabledParameter absoluteTimeSynchEnabled = null;
    private Enumeration[] radioBuildingBlockParameters;
    private Enumeration[] lineRateParameters = null;
    private Enumeration[] auUnitTypeParameters = null;
    private Enumeration[] sectorSequenceParameters = null;
    private Enumeration[] primaryPortIdParameters = null;
    private GpsOutEnabledParameter gpsOutEnabled = null;
    private GpsOutEnabledParameterOnSlot2 gpsOutEnabledOnSlot2 = null;
    private DigitalBuildingBlockParameter digitalBuildingBlockParameter;

    protected void init() {
        this.view = (DataFlexView)this.getView();
        this.wizardHelp = WizardHelp.getTheInstance();
        this.rbs = CabinetFlexModel.getInstance().getRbs();
        this.isListenerEnabled = false;
        this.updateCustomerParameters();
    }

    private void updateCustomerParameters() {
        Enumeration[] enumerationArray = null;
        Enumeration[] enumerationArray2 = null;
        Enumeration[] enumerationArray3 = null;
        YesNoCustomerParameter[] yesNoCustomerParameterArray = null;
        this.customerParameterNames.clear();
        try {
            if (this.rbs.isParameterSupported("carrierAllocationMode")) {
                this.view.setCarrierAllocationMode((CarrierAllocationModeParameter)this.rbs.getCustomerParameterObject("carrierAllocationMode"));
            }
            YesNoCustomerParameter yesNoCustomerParameter = null;
            if (this.rbs.isParameterSupported("redundantControlSystem")) {
                yesNoCustomerParameter = (YesNoCustomerParameter)this.rbs.getCustomerParameterObject("redundantControlSystem");
                this.customerParameterNames.add("redundantControlSystem");
            }
            this.view.setRedundantControlSystem(yesNoCustomerParameter);
            this.view.setRbs6000(this.rbs.getRbsData().isRbs6000());
            PowerSupplyProvider powerSupplyProvider = (PowerSupplyProvider)((Object)this.rbs.getConfigItem("PowerSystemCI"));
            if (powerSupplyProvider != null) {
                if (powerSupplyProvider.isSupportSystemAvailable()) {
                    if (this.rbs.isParameterSupported("supportSystemControl")) {
                        this.supportSystemControl = (TrueFalseCustomerParameter)this.rbs.getCustomerParameterObject("supportSystemControl");
                        this.customerParameterNames.add("supportSystemControl");
                    }
                    this.view.setSupportSystemControl(this.supportSystemControl);
                    this.view.setSupportSystemAvailable(true);
                    if (DuwUtil.hasDuw() && this.rbs.getRbsData().isRbs6000()) {
                        this.absoluteTimeSynchEnabled = (AbsoluteTimeSynchEnabledParameter)this.rbs.getCustomerParameterObject("absoluteTimeSynchEnabled");
                        this.view.setAbsoluteTimeSynchronization(this.absoluteTimeSynchEnabled);
                        this.customerParameterNames.add("absoluteTimeSynchEnabled");
                        this.gpsOutEnabled = (GpsOutEnabledParameter)this.rbs.getCustomerParameterObject("gpsOutEnabled");
                        this.view.setGpsOutEnabled(this.gpsOutEnabled);
                        this.customerParameterNames.add("gpsOutEnabled");
                        if (DuwUtil.hasDualDuws()) {
                            this.gpsOutEnabledOnSlot2 = (GpsOutEnabledParameterOnSlot2)this.rbs.getCustomerParameterObject("gpsOutEnabledOnSlot2");
                            this.view.setGpsOutEnabledOnSlot2(this.gpsOutEnabledOnSlot2);
                            this.customerParameterNames.add("gpsOutEnabledOnSlot2");
                        }
                    }
                } else {
                    this.supportSystemControl = null;
                    this.view.setSupportSystemAvailable(false);
                }
            }
            ClimateSystem climateSystem = null;
            ClimateRegulationSystem climateRegulationSystem = null;
            if (powerSupplyProvider != null) {
                if (powerSupplyProvider.hasSupportControlUnit()) {
                    climateSystem = (ClimateSystem)this.rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "climateSystem");
                    this.customerParameterNames.add(PrefixUtil.getFirstCabinetPrefix() + "climateSystem");
                    climateRegulationSystem = (ClimateRegulationSystem)this.rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "climateRegulationSystem");
                    this.customerParameterNames.add(PrefixUtil.getFirstCabinetPrefix() + "climateRegulationSystem");
                }
                this.view.setConfigureClimateSystem(climateSystem);
                this.view.setConfigureClimateRegulationSystem(climateRegulationSystem);
            }
            if (DuwUtil.hasDualDuws() && this.rbs.getRbsData().isRbs6000()) {
                this.digitalBuildingBlockParameter = (DigitalBuildingBlockParameter)this.rbs.getCustomerParameterObject("digitalBuildingBlock");
                this.customerParameterNames.add("digitalBuildingBlock");
                this.view.setDbbParameter(this.digitalBuildingBlockParameter);
            }
            this.view.setRadioIfTypes(this.getRadioIfTypeParameters());
            int n = this.rbs.getMaxNumberOfSectors();
            this.radioBuildingBlockParameters = new Enumeration[n];
            enumerationArray = new Enumeration[n];
            enumerationArray2 = new Enumeration[n];
            enumerationArray3 = new Enumeration[n];
            yesNoCustomerParameterArray = new YesNoCustomerParameter[n];
            this.lineRateParameters = new Enumeration[n];
            this.auUnitTypeParameters = new Enumeration[n];
            this.primaryPortIdParameters = new Enumeration[n];
            this.sectorSequenceParameters = new Enumeration[n];
            for (int i = 1; i <= n; ++i) {
                String string;
                String string2;
                String string3;
                String string4;
                String string5;
                String string6;
                String string7;
                String string8;
                String string9 = this.getRadioBuildingBlockName(i);
                if (this.rbs.isParameterSupported(string9)) {
                    this.radioBuildingBlockParameters[i - 1] = (Enumeration)this.rbs.getCustomerParameterObject(string9);
                }
                if (this.rbs.isParameterSupported(string8 = this.getNoOfRusName(i))) {
                    enumerationArray[i - 1] = (Enumeration)this.rbs.getCustomerParameterObject(string8);
                }
                if (this.rbs.isParameterSupported(string7 = this.getNoOfCarriersName(i))) {
                    enumerationArray2[i - 1] = (Enumeration)this.rbs.getCustomerParameterObject(string7);
                }
                if (this.rbs.isParameterSupported(string6 = this.getOutputPowerName(i))) {
                    enumerationArray3[i - 1] = (Enumeration)this.rbs.getCustomerParameterObject(string6);
                }
                if (this.rbs.isParameterSupported(string5 = this.getCreateSectorName(i))) {
                    yesNoCustomerParameterArray[i - 1] = (YesNoCustomerParameter)this.rbs.getCustomerParameterObject(string5);
                }
                if (this.rbs.isParameterSupported(string4 = this.getLineRateName(i))) {
                    this.lineRateParameters[i - 1] = (Enumeration)this.rbs.getCustomerParameterObject(string4);
                }
                if (this.rbs.isParameterSupported(string3 = this.getAuUnitTypeName(i))) {
                    this.auUnitTypeParameters[i - 1] = (Enumeration)this.rbs.getCustomerParameterObject(string3);
                }
                if (this.rbs.isParameterSupported(string2 = this.getSectorSequenceName(i))) {
                    this.sectorSequenceParameters[i - 1] = (Enumeration)this.rbs.getCustomerParameterObject(string2);
                }
                if (!this.rbs.isParameterSupported(string = this.getPrimaryPortIdName(i))) continue;
                this.primaryPortIdParameters[i - 1] = (Enumeration)this.rbs.getCustomerParameterObject(string);
            }
            this.view.setRadioBuildingBlock(this.radioBuildingBlockParameters);
            this.view.setNoOfCarriers(enumerationArray2);
            this.view.setNumberOfSectors(n);
            this.view.setOutputPowers(enumerationArray3);
            this.view.setCreateSector(yesNoCustomerParameterArray);
            this.view.setRbsTypes(this.getRbsTypes());
            this.view.setLineRate(this.lineRateParameters);
            this.view.setAuUnitType(this.auUnitTypeParameters);
            this.view.setSectorSequence(this.sectorSequenceParameters);
            this.view.setPrimaryPortId(this.primaryPortIdParameters);
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException(this.getClass().getName(), "updateCustomerParameters()", null, "Setting up window for input", exception);
            System.out.println(wizardException.getMessage());
            super.displayError(wizardException);
            return;
        }
    }

    private String getNoOfCarriersName(int n) {
        String string = MessageFormat.format("S{0}_", n);
        return string + "numberOfCarriers";
    }

    private String getCreateSectorName(int n) {
        String string = MessageFormat.format("S{0}_", n);
        return string + "createSector";
    }

    private String getRadioBuildingBlockName(int n) {
        String string = MessageFormat.format("S{0}_", n);
        return string + "radioBuildingBlock";
    }

    private String getLineRateName(int n) {
        String string = MessageFormat.format("S{0}_", n);
        return string + "cpriLineRate";
    }

    private String getAuUnitTypeName(int n) {
        String string = MessageFormat.format("S{0}_", n);
        return string + "auUnitType";
    }

    private String getSectorSequenceName(int n) {
        String string = MessageFormat.format("S{0}_", n);
        return string + "sectorSequenceNumber";
    }

    private String getPrimaryPortIdName(int n) {
        String string = MessageFormat.format("S{0}_", n);
        return string + "primaryPortId";
    }

    private String getNoOfRusName(int n) {
        String string = MessageFormat.format("S{0}_", n);
        return string + "numberOfRu";
    }

    private String getOutputPowerName(int n) {
        String string = MessageFormat.format("S{0}_", n);
        return string + "outputPower";
    }

    protected void beforeVisible() {
        this.isListenerEnabled = false;
        super.setPreviousEnabled(false);
        super.setPreviousVisible(false);
        this.setWindowTitle();
        this.view.setChoiceOfRadioIfTypeSupported(this.rbs.isChoiceOfRadioIfTypeSupported());
        this.view.updateGui();
        this.view.setInitialRbsType(this.rbs.getRbsType());
        this.view.setRbsTypeListener(new RbsTypeListener());
        this.setRadioIfTypeListeners();
        this.isListenerEnabled = true;
        this.getWizardPresenter().sniff(this.view);
    }

    private void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string3 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.view.setHeaderText(MessageFormat.format("Cabinet Equipment Configuration page {0}({1})", string2, string3));
    }

    public void updateRbsType(String string) throws BemException {
        if (string == null) {
            return;
        }
        try {
            this.view.removeRbsTypeListener();
            this.view.removeRadioIfTypeListeners();
            this.rbs = this.view.getRadioIfTypes() != null && this.view.getRadioIfTypes()[1].equals("DUI_O") ? RbsFactory.getRbs(string, this.rbs.getMoHandler(), this.rbs.getRbsStep(), true, null) : RbsFactory.getRbs(string, this.rbs.getMoHandler(), this.rbs.getRbsStep());
            OpenCIs.openCabinetCIs(this.rbs);
            CabinetFlexModel.getInstance().setRbs(this.rbs);
            this.updateCustomerParameters();
            this.view.setChoiceOfRadioIfTypeSupported(this.rbs.isChoiceOfRadioIfTypeSupported());
            this.view.setSelectedRbsType(string);
            this.view.updateGui();
            this.view.setRbsTypeListener(new RbsTypeListener());
            this.setRadioIfTypeListeners();
        }
        catch (Exception exception) {
            throw new BemException("Setting RBS product name failed");
        }
    }

    private RadioIfTypeParameter[] getRadioIfTypeParameters() throws Exception {
        this.radioIfTypeParameters = null;
        for (int i = 2; i > 0; --i) {
            String string = String.valueOf(i) + "radioIfType";
            if (!this.rbs.isParameterSupported(string)) continue;
            if (this.radioIfTypeParameters == null) {
                this.radioIfTypeParameters = new RadioIfTypeParameter[i];
            }
            this.radioIfTypeParameters[i - 1] = (RadioIfTypeParameter)this.rbs.getCustomerParameterObject(string);
            this.customerParameterNames.add(string);
        }
        return this.radioIfTypeParameters;
    }

    private String[] getRbsTypes() {
        String[] stringArray;
        try {
            stringArray = RbsFactory.getRbsTypes();
        }
        catch (BemException bemException) {
            stringArray = null;
        }
        return stringArray;
    }

    public void updateRadioIfTypes(String[] stringArray) throws BemException {
        if (stringArray == null) {
            return;
        }
        try {
            this.view.removeRbsTypeListener();
            this.view.removeRadioIfTypeListeners();
            this.view.updateGui();
            this.view.setRbsTypeListener(new RbsTypeListener());
            this.setRadioIfTypeListeners();
        }
        catch (Exception exception) {
            throw new BemException("Setting Radio Interface Type failed");
        }
    }

    private void skipPowerSupplySlide() {
        this.wizardHelp.excludeSlide("PowerSupplyFlexController");
    }

    protected boolean next() {
        boolean bl = true;
        this.wizardHelp.restoreSlideOrder();
        boolean bl2 = true;
        if (this.rbs.isConfigurationItemSupported("PowerSystemCI")) {
            ConfigurationItem configurationItem = this.rbs.getConfigItem("PowerSystemCI");
            if (configurationItem instanceof AbstractPowerSupplyCI) {
                AbstractPowerSupplyCI abstractPowerSupplyCI = (AbstractPowerSupplyCI)configurationItem;
                bl2 = abstractPowerSupplyCI.isConfPowerSupplySupported();
            } else if (configurationItem instanceof AbstractPowerSystemCI) {
                if (this.supportSystemControl.getValue().equalsIgnoreCase("FALSE")) {
                    bl2 = false;
                } else if (!this.validClimateSystemConfiguration()) {
                    bl = false;
                }
            }
        } else {
            bl2 = false;
        }
        if (!bl2) {
            this.skipPowerSupplySlide();
        }
        if (!this.configureEcBus()) {
            this.wizardHelp.excludeSlide("EcPortController");
        }
        try {
            this.rbs.checkConsistency("CabinetBasicCI", this.customerParameterNames);
            this.rbs.checkConsistency("RadioEquipmentCI");
        }
        catch (Exception exception) {
            this.displayNextError(this.view, exception);
            bl = false;
        }
        if (bl) {
            this.removeListeners();
        }
        return bl;
    }

    public boolean validClimateSystemConfiguration() {
        try {
            ClimateRegulationSystem climateRegulationSystem = (ClimateRegulationSystem)this.rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "climateRegulationSystem");
            ClimateSystem climateSystem = (ClimateSystem)this.rbs.getCustomerParameterObject(PrefixUtil.getFirstCabinetPrefix() + "climateSystem");
            if ("TS".equalsIgnoreCase(climateRegulationSystem.getValue()) && !"Extended".equalsIgnoreCase(climateSystem.getValue())) {
                this.displayNextError(this.view, new BemException("The Value Of Climate System Must Be 'Extended' for  Climate Regulation System 'TS'!"));
                return false;
            }
        }
        catch (BemException bemException) {
            this.displayNextError(this.view, bemException);
            return false;
        }
        return true;
    }

    private void removeListeners() {
        this.isListenerEnabled = false;
        this.view.removeRbsTypeListener();
        this.view.removeRadioIfTypeListeners();
    }

    protected boolean previous() {
        return false;
    }

    private boolean configureEcBus() {
        boolean bl = false;
        try {
            if (this.rbs.getRbsData().isRbs6000()) {
                bl = true;
            }
        }
        catch (BemException bemException) {
            this.displayError(bemException);
        }
        return bl;
    }

    private void setRadioIfTypeListeners() {
        this.radioIfTypeListeners = null;
        for (int i = 2; i > 0; --i) {
            String string = String.valueOf(i) + "radioIfType";
            if (!this.rbs.isParameterSupported(string)) continue;
            if (this.radioIfTypeListeners == null) {
                this.radioIfTypeListeners = new RadioIfTypeListener[i];
                this.view.createRadioIfTypeListeners(this.radioIfTypeListeners);
            }
            this.view.setRadioIfTypeListener(new RadioIfTypeListener(i), i);
        }
    }

    private class RadioIfTypeListener
    implements ActionListener {
        private final int baseBandPool;

        public RadioIfTypeListener(int n) {
            this.baseBandPool = n;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (DataFlexController.this.isListenerEnabled) {
                CustomerParameterComboBox customerParameterComboBox = (CustomerParameterComboBox)actionEvent.getSource();
                try {
                    String string = (String)customerParameterComboBox.getSelectedItem();
                    if (string != null && !string.equals("-") && DataFlexController.this.radioIfTypeParameters != null && !string.equals(DataFlexController.this.radioIfTypeParameters[this.baseBandPool - 1].getValue())) {
                        DataFlexController.this.radioIfTypeParameters[this.baseBandPool - 1].setValue(string);
                    }
                    if (string != null && (string.equals("DUI_O") || string.equals("DUI_E"))) {
                        DataFlexController.this.updateRbsType(DataFlexController.this.view.getRbsType());
                    } else {
                        DataFlexController.this.updateRadioIfTypes(DataFlexController.this.view.getRadioIfTypes());
                    }
                    DataFlexController.this.setWindowTitle();
                }
                catch (BemException bemException) {
                    WizardException wizardException = new WizardException("", bemException.toString(), (Throwable)bemException);
                    DataFlexController.this.displayError(wizardException);
                }
                catch (Exception exception) {
                    WizardException wizardException = new WizardException(exception.toString(), (String)null, (Throwable)exception);
                    DataFlexController.this.displayError(wizardException);
                }
                catch (Error error) {
                    WizardException wizardException = new WizardException(error.toString(), (String)null, (Throwable)error);
                    DataFlexController.this.displayError(wizardException);
                }
            }
        }
    }

    private class RbsTypeListener
    implements ActionListener {
        private RbsTypeListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (DataFlexController.this.isListenerEnabled) {
                try {
                    DataFlexController.this.updateRbsType(DataFlexController.this.view.getRbsType());
                    DataFlexController.this.setWindowTitle();
                }
                catch (BemException bemException) {
                    WizardException wizardException = new WizardException("", bemException.toString(), (Throwable)bemException);
                    DataFlexController.this.displayError(wizardException);
                }
                catch (Exception exception) {
                    WizardException wizardException = new WizardException(exception.toString(), (String)null, (Throwable)exception);
                    DataFlexController.this.displayError(wizardException);
                }
                catch (Error error) {
                    WizardException wizardException = new WizardException(error.toString(), (String)null, (Throwable)error);
                    DataFlexController.this.displayError(wizardException);
                }
            }
        }
    }
}

