/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.control;

import java.text.MessageFormat;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.wizard.control.BemWizardGuiController;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.control.EtmParameterAdaptor;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.model.CabinetFlexModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.view.EtmView;

public class EtmController
extends BemWizardGuiController {
    private Rbs rbs;
    private EtmView view;
    private EtmParameterAdaptor etmAdaptor;

    protected void init() {
        this.view = (EtmView)this.getView();
        this.wizardHelp = WizardHelp.getTheInstance();
    }

    protected void beforeVisible() {
        try {
            this.rbs = CabinetFlexModel.getInstance().getRbs();
            this.updateCustomerParameter();
            this.setWindowTitle();
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException(this.currentClassName, "", null, "Opening ETM slide", exception);
            this.displayError(wizardException);
        }
    }

    private void updateCustomerParameter() {
        this.etmAdaptor = new EtmParameterAdaptor(this.rbs);
        this.view.setEtmSlots(this.etmAdaptor.getSlots());
        this.view.updateGui();
    }

    private void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string3 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.view.setHeaderText(MessageFormat.format("Cabinet Equipment Configuration page {0}({1})", string2, string3));
        this.view.setSubHeaderText("ETM configuration");
    }

    protected boolean next() {
        boolean bl = true;
        try {
            this.rbs.checkConsistency("EtmBoardCI");
        }
        catch (Exception exception) {
            this.displayNextError(this.view, exception);
            bl = false;
        }
        if (bl) {
            this.removeListeners();
        }
        return bl;
    }

    protected boolean previous() {
        this.removeListeners();
        return true;
    }

    private void removeListeners() {
        this.etmAdaptor.removeListeners();
    }
}

