/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.cabinet.flex.view;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.Enumeration;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.IntegerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.TrueFalseCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterCheckbox;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterComboBox;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterPanel;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTextField;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterViewer;
import se.ericsson.wcdma.rbs.bem.common.util.BemLanguageHelp;
import se.ericsson.wcdma.rbs.bem.wizard.view.BemWizardGuiView;

public class PowerSupplyFlexView
extends BemWizardGuiView
implements CustomerParameterViewer {
    private YesNoCustomerParameter configurePsParameter;
    private IntegerParameter noOfPsuParameter;
    private IntegerParameter noOfPduParameter;
    private IntegerParameter noOfBfuParameter;
    private IntegerParameter noOfBpaParameter;
    private YesNoCustomerParameter configureBatteryParameter;
    private TrueFalseCustomerParameter multiplePowerSystemParameter;
    private CustomerParameterCheckbox multiplePowerSystemCheckBox;
    private IntegerParameter batteryCapacityParameter;
    private CustomerParameterCheckbox configurePsCheckBox;
    private CustomerParameterPanel noOfPsuPanel;
    private CustomerParameterPanel noOfPduPanel;
    private CustomerParameterPanel noOfBfuPanel;
    private CustomerParameterPanel noOfBpaPanel;
    private CustomerParameterPanel batteryCapacityPanel;
    private CustomerParameterCheckbox batteryCheckBox;
    private Enumeration batteryTypeParameter;
    private CustomerParameterPanel batteryTypePanel;
    private CustomerParameterComboBox batteryTypeDropDown;
    private boolean supportSystemAvailable = false;

    protected void init() {
        super.init();
    }

    public void updateGui() {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)this.createPsuPanel(), "North");
        this.addMainPanel(jPanel);
    }

    private JPanel createPsuPanel() {
        CustomerParameterTextField customerParameterTextField;
        CustomerParameterTextField customerParameterTextField2;
        JPanel jPanel = new JPanel(new GridBagLayout());
        jPanel.setBorder(new TitledBorder("Power supply"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(5, 5, 0, 5);
        gridBagConstraints.gridy = 1;
        if (this.supportSystemAvailable) {
            customerParameterTextField2 = new CustomerParameterTextField(this.noOfPduParameter);
            customerParameterTextField2.setColumns(3);
            this.noOfPduPanel = new CustomerParameterPanel("No. of PDU:", customerParameterTextField2);
            jPanel.add((Component)this.noOfPduPanel, gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        this.configurePsCheckBox = new CustomerParameterCheckbox("Configure power supply", this.configurePsParameter);
        jPanel.add((Component)this.configurePsCheckBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        customerParameterTextField2 = new CustomerParameterTextField(this.noOfPsuParameter);
        customerParameterTextField2.setColumns(3);
        this.noOfPsuPanel = new CustomerParameterPanel("No. of PSU:", customerParameterTextField2);
        jPanel.add((Component)this.noOfPsuPanel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.batteryCheckBox = new CustomerParameterCheckbox("Configure battery backup", this.configureBatteryParameter);
        jPanel.add((Component)this.batteryCheckBox, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        if (this.supportSystemAvailable) {
            customerParameterTextField = new CustomerParameterTextField(this.noOfBfuParameter);
            customerParameterTextField.setColumns(3);
            this.noOfBfuPanel = new CustomerParameterPanel("No. of BFU:", customerParameterTextField);
            jPanel.add((Component)this.noOfBfuPanel, gridBagConstraints);
            ++gridBagConstraints.gridy;
            CustomerParameterTextField customerParameterTextField3 = new CustomerParameterTextField(this.noOfBpaParameter);
            customerParameterTextField3.setColumns(3);
            this.noOfBpaPanel = new CustomerParameterPanel("No. of BPA:", customerParameterTextField3);
            jPanel.add((Component)this.noOfBpaPanel, gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        if (this.supportSystemAvailable) {
            this.multiplePowerSystemCheckBox = new CustomerParameterCheckbox("Multiple Power System", this.multiplePowerSystemParameter);
            jPanel.add((Component)this.multiplePowerSystemCheckBox, gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        if (this.supportSystemAvailable) {
            this.batteryTypeDropDown = new CustomerParameterComboBox(this.batteryTypeParameter);
            this.batteryTypePanel = new CustomerParameterPanel("Battery type:", this.batteryTypeDropDown);
            jPanel.add((Component)this.batteryTypePanel, gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        if (!this.supportSystemAvailable) {
            customerParameterTextField = new CustomerParameterTextField(this.batteryCapacityParameter);
            customerParameterTextField.setColumns(5);
            this.batteryCapacityPanel = new CustomerParameterPanel("Battery capacity:", customerParameterTextField);
            jPanel.add((Component)this.batteryCapacityPanel, gridBagConstraints);
        }
        return jPanel;
    }

    public void setSupportSystemAvailable(boolean bl) {
        this.supportSystemAvailable = bl;
    }

    public void setNoOfPsu(IntegerParameter integerParameter) {
        this.noOfPsuParameter = integerParameter;
    }

    public void setNoOfPdu(IntegerParameter integerParameter) {
        this.noOfPduParameter = integerParameter;
    }

    public void setNoOfBfu(IntegerParameter integerParameter) {
        this.noOfBfuParameter = integerParameter;
    }

    public void setNoOfBpa(IntegerParameter integerParameter) {
        this.noOfBpaParameter = integerParameter;
    }

    public void setConfigurePowerSupply(YesNoCustomerParameter yesNoCustomerParameter) {
        this.configurePsParameter = yesNoCustomerParameter;
    }

    public void setConfigureBattery(YesNoCustomerParameter yesNoCustomerParameter) {
        this.configureBatteryParameter = yesNoCustomerParameter;
    }

    public void setMultiplePowerSystem(TrueFalseCustomerParameter trueFalseCustomerParameter) {
        this.multiplePowerSystemParameter = trueFalseCustomerParameter;
    }

    public void setBatteryType(Enumeration enumeration) {
        this.batteryTypeParameter = enumeration;
    }

    public void setBatteryCapacity(IntegerParameter integerParameter) {
        this.batteryCapacityParameter = integerParameter;
    }

    public String getGuiNameForCustomerParameter(String string) {
        if (this.configurePsParameter.getName().equals(string)) {
            return this.configurePsCheckBox.getText();
        }
        if (this.noOfPsuParameter.getName().equals(string)) {
            return this.noOfPsuPanel.getLabel().getText();
        }
        if (this.supportSystemAvailable && this.noOfPduParameter.getName().equals(string)) {
            return this.noOfPduPanel.getLabel().getText();
        }
        if (this.configureBatteryParameter.getName().equals(string)) {
            return this.batteryCheckBox.getText();
        }
        if (this.multiplePowerSystemParameter.getName().equals(string)) {
            return this.multiplePowerSystemCheckBox.getText();
        }
        if (this.supportSystemAvailable && this.batteryTypeParameter.getName().equals(string)) {
            return this.batteryTypeParameter.getName();
        }
        if (!this.supportSystemAvailable && this.batteryCapacityParameter.getName().equals(string)) {
            return this.batteryCapacityPanel.getLabel().getText();
        }
        if (this.supportSystemAvailable && this.noOfBfuParameter.getName().equals(string)) {
            return this.noOfBfuPanel.getLabel().getText();
        }
        if (this.supportSystemAvailable && this.noOfBpaParameter.getName().equals(string)) {
            return this.noOfBpaPanel.getLabel().getText();
        }
        return "";
    }

    public void setFocusOnCustomerParameterComponent(String string) {
        if (this.configurePsParameter.getName().equals(string)) {
            this.configurePsCheckBox.requestFocus();
        } else if (this.noOfPsuParameter.getName().equals(string)) {
            this.noOfPsuPanel.requestFocus();
        } else if (this.supportSystemAvailable && this.noOfPduParameter.getName().equals(string)) {
            this.noOfPduPanel.requestFocus();
        } else if (this.configureBatteryParameter.getName().equals(string)) {
            this.noOfPsuPanel.requestFocus();
        } else if (this.supportSystemAvailable && this.batteryTypeParameter.getName().equals(string)) {
            this.batteryTypePanel.requestFocus();
        } else if (!this.supportSystemAvailable && this.batteryCapacityParameter.getName().equals(string)) {
            this.batteryCapacityPanel.requestFocus();
        } else if (!this.supportSystemAvailable && this.noOfBfuParameter.getName().equals(string)) {
            this.noOfBfuPanel.requestFocus();
        } else if (!this.supportSystemAvailable && this.noOfBpaParameter.getName().equals(string)) {
            this.noOfBpaPanel.requestFocus();
        }
    }

    protected String getSubHeading() {
        return BemLanguageHelp.getTranslation("NCONF_CABINET_SUBHEADER");
    }
}

