/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.control;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.custparam.TerminationParameterList;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.atmandpt.provider.AtmPortProvider;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.DynamicCustomerParameterProvider;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.wizard.control.BemWizardGuiController;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.model.WizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.util.WizardLanguageHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.control.AddAtmPortDialogController;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.model.OamCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.view.AddAtmPortDialogView;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.view.AtmPortViewer;

public class AtmPortController
extends BemWizardGuiController {
    private static String NCONF_OAM_PAGE_HEADER = "O&M Access Configuration page {0}({1})";
    private static String NCONF_OAM_DELETE_ATM_PORT = "Are you sure that the selected ATM port(s) shall be deleted?";
    private static String NCONF_OAM_NO_MORE_AVAILABLE_SLOTS = "Cannot add ATM port. No more available slots";
    private static String[] ATM_PORT_COL_NAMES = new String[]{"ETB Slot", "Termination Type", "ETB Lines", "Required no. of Links", "Time Slots", "IP ATM Link", "Exists on Node"};
    private AtmPortViewer myView = null;
    private JButton addButton = null;
    private JButton deleteButton = null;
    private AddButtonActionListener addButtonActionListener = null;
    private DeleteButtonActionListener deleteButtonActionListener = null;
    private WizardCIModel wizardCiModel;
    private DynamicCustomerParameterProvider dynamicCPProvider = null;
    private AtmPortProvider atmPortProvider = null;
    private Rbs rbs = null;
    private List listOfCP = null;
    private boolean areGUIComponentsCreated = false;

    protected void init() {
        this.myView = (AtmPortViewer)((Object)this.getView());
        this.wizardHelp = WizardHelp.getTheInstance();
        this.wizardCiModel = OamCIModel.getInstance();
        this.rbs = this.wizardCiModel.getRbs();
        this.dynamicCPProvider = (DynamicCustomerParameterProvider)((Object)this.rbs.getConfigItem("AtmAndPtCI"));
        this.atmPortProvider = (AtmPortProvider)((Object)this.rbs.getConfigItem("AtmAndPtCI"));
        this.setWindowTitle();
        this.listOfCP = this.atmPortProvider.getConfiguredAtmPorts();
    }

    private void initializeAtmPortTableWithData() {
        Object[][] objectArray = this.getMatrixOfCP(this.listOfCP);
        this.myView.setAtmPortTableParameters(objectArray, ATM_PORT_COL_NAMES);
    }

    private Object[][] getMatrixOfCP(List list) {
        Object[][] objectArray = new Object[list.size()][7];
        for (int i = 0; i < list.size(); ++i) {
            TerminationParameterList terminationParameterList = (TerminationParameterList)list.get(i);
            objectArray[i][0] = terminationParameterList.getSlotParameter();
            objectArray[i][1] = terminationParameterList.getTerminationTypeParameter();
            objectArray[i][2] = terminationParameterList.getLineParameter();
            objectArray[i][3] = terminationParameterList.getRequiredNumberOfLinksParameter();
            objectArray[i][4] = terminationParameterList.getTimeSlotsInFractionParameter();
            objectArray[i][5] = terminationParameterList.getIpOverAtmLinkParameter();
            objectArray[i][6] = terminationParameterList.getExistOnNodeParameter();
        }
        return objectArray;
    }

    protected void afterVisible() {
        if (this.areGUIComponentsCreated) {
            this.addActionListeners();
            this.myView.deleteAllRows();
            this.listOfCP = this.atmPortProvider.getConfiguredAtmPorts();
            this.updateAtmPorts(this.listOfCP);
            return;
        }
        this.addButton = this.myView.getAddButton();
        this.deleteButton = this.myView.getDeleteButton();
        this.addButtonActionListener = new AddButtonActionListener();
        this.deleteButtonActionListener = new DeleteButtonActionListener();
        this.areGUIComponentsCreated = true;
        this.addActionListeners();
        this.initializeAtmPortTableWithData();
    }

    private void addActionListeners() {
        this.addButton.addActionListener(this.addButtonActionListener);
        this.deleteButton.addActionListener(this.deleteButtonActionListener);
    }

    private void removeActionListeners() {
        this.addButton.removeActionListener(this.addButtonActionListener);
        this.deleteButton.removeActionListener(this.deleteButtonActionListener);
    }

    private void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = NCONF_OAM_PAGE_HEADER;
        String string3 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string4 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.myView.setHeaderText(MessageFormat.format(string2, string3, string4));
    }

    protected boolean previous() {
        this.removeActionListeners();
        return true;
    }

    protected boolean next() {
        boolean bl = true;
        try {
            this.myView.editingStopped();
            ConfigurationItem configurationItem = this.rbs.getConfigItem("AtmAndPtCI");
            configurationItem.checkConsistency();
        }
        catch (BemException bemException) {
            bl = false;
            this.displayError(bemException);
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException(this.currentClassName, "next()", null, "verifying user input for scrolling", exception);
            this.displayError(wizardException);
            bl = false;
        }
        if (bl) {
            this.removeActionListeners();
        }
        return bl;
    }

    private void updateAtmPorts(List list) {
        this.myView.deleteAllRows();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Vector<CustomerParameterImpl> vector = new Vector<CustomerParameterImpl>();
            Object e = iterator.next();
            TerminationParameterList terminationParameterList = (TerminationParameterList)e;
            vector.add(terminationParameterList.getSlotParameter());
            vector.add(terminationParameterList.getTerminationTypeParameter());
            vector.add(terminationParameterList.getLineParameter());
            vector.add(terminationParameterList.getRequiredNumberOfLinksParameter());
            vector.add(terminationParameterList.getTimeSlotsInFractionParameter());
            vector.add(terminationParameterList.getIpOverAtmLinkParameter());
            vector.add(terminationParameterList.getExistOnNodeParameter());
            this.myView.addRow(vector);
        }
    }

    public void addOneAtmPort(List list) {
        Vector<CustomerParameterImpl> vector = new Vector<CustomerParameterImpl>();
        if (list.size() != 1) {
            return;
        }
        Object e = list.get(0);
        TerminationParameterList terminationParameterList = (TerminationParameterList)e;
        vector.add(terminationParameterList.getSlotParameter());
        vector.add(terminationParameterList.getTerminationTypeParameter());
        vector.add(terminationParameterList.getLineParameter());
        vector.add(terminationParameterList.getRequiredNumberOfLinksParameter());
        vector.add(terminationParameterList.getTimeSlotsInFractionParameter());
        vector.add(terminationParameterList.getIpOverAtmLinkParameter());
        vector.add(terminationParameterList.getExistOnNodeParameter());
        this.listOfCP.add(terminationParameterList);
        this.myView.addRow(vector);
    }

    private boolean isOkToAddAtmPort() throws BemException {
        boolean bl = false;
        String[] stringArray = this.atmPortProvider.getAvailableSlots();
        if (stringArray != null && stringArray.length > 0) {
            bl = true;
        }
        return bl;
    }

    private void deleteSelectedAtmPorts() throws BemException {
        int[] nArray = this.myView.getAtmPortTable().getSelectedRows();
        for (int i = nArray.length - 1; i >= 0; --i) {
            ArrayList arrayList = new ArrayList();
            arrayList.add(this.listOfCP.get(nArray[i]));
            String string = this.dynamicCPProvider.removeCP(arrayList);
            if (!string.equals("")) {
                JOptionPane.showMessageDialog(null, string, "", 0);
                continue;
            }
            this.listOfCP.remove(nArray[i]);
            this.myView.deleteRow(nArray[i]);
        }
    }

    class DeleteButtonActionListener
    implements ActionListener {
        DeleteButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = AtmPortController.this.displayConfirmDialog(NCONF_OAM_DELETE_ATM_PORT);
            if (bl) {
                try {
                    AtmPortController.this.deleteSelectedAtmPorts();
                }
                catch (BemException bemException) {
                    WizardException wizardException = new WizardException(AtmPortController.this.getClass().getName(), "tableChanged", null, "", bemException);
                    AtmPortController.this.displayError(wizardException);
                }
            }
        }
    }

    class AddButtonActionListener
    implements ActionListener {
        AddButtonActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = false;
            try {
                bl = AtmPortController.this.isOkToAddAtmPort();
            }
            catch (WizardException wizardException) {
                AtmPortController.this.displayError(wizardException);
            }
            catch (BemException bemException) {
                WizardException wizardException = new WizardException(this.getClass().getName(), "actionPerformed", null, "", bemException);
                AtmPortController.this.displayError(wizardException);
            }
            if (bl) {
                AtmPortController.this.startDialog(true, WizardLanguageHelp.getTranslation("NCONF_OAM_ADDATMPORT_WINDOW_TITLE"), null, AddAtmPortDialogView.class, AddAtmPortDialogController.class);
            } else {
                AtmPortController.this.displayInfoMessage(NCONF_OAM_NO_MORE_AVAILABLE_SLOTS);
            }
        }
    }
}

