/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.control;

import java.text.MessageFormat;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.ConfigurationItem;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.provider.EthernetSwitchProvider;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.wizard.control.BemWizardGuiController;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.control.LagManager;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.control.VlanMembershipManager;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.model.OamCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.view.EthernetSwitchViewer;

public class EthernetSwitchController
extends BemWizardGuiController {
    private static String NCONF_OAM_PAGE_HEADER = "O&M Access Configuration page {0}({1})";
    private Rbs rbs;
    private EthernetSwitchViewer myView;
    private boolean guiInitiated = false;

    protected void init() {
        this.myView = (EthernetSwitchViewer)((Object)this.getView());
        this.wizardHelp = WizardHelp.getTheInstance();
        OamCIModel oamCIModel = OamCIModel.getInstance();
        this.rbs = oamCIModel.getRbs();
        this.setWindowTitle();
    }

    protected void beforeVisible() {
        super.setPreviousEnabled(false);
        super.setPreviousVisible(false);
    }

    protected void afterVisible() {
        if (!this.guiInitiated) {
            try {
                CustomerParameter customerParameter = this.rbs.getCustomerParameterObject("EthernetSwitchvlan");
                CustomerParameter[] customerParameterArray = new CustomerParameter[]{customerParameter};
                this.myView.setCustomerParameters(customerParameterArray);
                Object[][] objectArray = new Object[1][2];
                String[] stringArray = new String[]{"VLAN Membership", "Link Aggregation Groups"};
                VlanMembershipManager vlanMembershipManager = new VlanMembershipManager(this.rbs, "EthernetSwitchVlanMembership");
                objectArray[0][0] = vlanMembershipManager;
                LagManager lagManager = new LagManager(this.rbs, "linkAggregationGroup");
                objectArray[0][1] = lagManager;
                this.myView.setEthernetSwitchTableParameters(objectArray, stringArray);
                Object[][] objectArray2 = new Object[7][7];
                String[] stringArray2 = new String[]{"1", "2", "3", "4", "5", "6", "7"};
                String[] stringArray3 = new String[]{"Port", "Adm State", "System Port", "LAG Id", "VLAN membership", "Untagged VID", "Untagged Priority"};
                for (int i = 0; i < 7; ++i) {
                    String string = MessageFormat.format("EthernetSwitchPort_{0}_administrativeState", i + 1);
                    objectArray2[i][0] = this.rbs.getCustomerParameterObject(string);
                    string = MessageFormat.format("EthernetSwitchPort_{0}_systemPort", i + 1);
                    objectArray2[i][1] = this.rbs.getCustomerParameterObject(string);
                    string = MessageFormat.format("EthernetSwitchPort_{0}_lagId", i + 1);
                    objectArray2[i][2] = this.rbs.getCustomerParameterObject(string);
                    string = MessageFormat.format("EthernetSwitchPort_{0}_VlanMembership", i + 1);
                    objectArray2[i][3] = new VlanMembershipManager(this.rbs, string);
                    string = MessageFormat.format("EthernetSwitchPort_{0}_untaggedIngressVid", i + 1);
                    objectArray2[i][4] = this.rbs.getCustomerParameterObject(string);
                    string = MessageFormat.format("EthernetSwitchPort_{0}_untaggedIngressPriority", i + 1);
                    objectArray2[i][5] = this.rbs.getCustomerParameterObject(string);
                }
                this.myView.setEthernetSwitchPortTableParameters(objectArray2, stringArray2, stringArray3);
                this.guiInitiated = true;
            }
            catch (Exception exception) {
                WizardException wizardException = new WizardException(this.getClass().getName(), "afterVisible()", null, "Setting up window for input", exception);
                wizardException.setProperty("Problem, Low Level", "An error has occurred while reading from the model");
                super.displayError(wizardException);
            }
        }
    }

    private void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = NCONF_OAM_PAGE_HEADER;
        String string3 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string4 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.myView.setHeaderText(MessageFormat.format(string2, string3, string4));
    }

    protected boolean previous() {
        return true;
    }

    protected boolean next() {
        boolean bl = true;
        try {
            ConfigurationItem configurationItem = (ConfigurationItem)this.rbs.getProvider(EthernetSwitchProvider.class);
            configurationItem.checkConsistency();
        }
        catch (BemException bemException) {
            this.displayNextError(this.myView, bemException);
            bl = false;
        }
        return bl;
    }
}

