/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.control;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import se.ericsson.wcdma.rbs.bem.common.config.configitem.util.DuwUtil;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterImpl;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterListener;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.ParameterEvent;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.PtpDomainParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.wizard.control.BemWizardGuiController;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.model.WizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.model.OamCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.view.IpSyncConfigurationViewer;

public class IpSyncConfigurationController
extends BemWizardGuiController
implements CustomerParameterListener {
    private static String NCONF_OAM_PAGE_HEADER = "O&M Access Configuration page {0}({1})";
    private static int[] DUW_IPSYNCHREF_SYNCH_PORT = new int[]{7, 8};
    private static int[] CBU_IPSYNCHREF_SYNCH_PORT = new int[]{1, 2};
    private WizardCIModel wizardCiModel;
    private Rbs rbs = null;
    private IpSyncConfigurationViewer myView = null;
    private final List<CustomerParameter> cpsToValidateOnNext = new ArrayList<CustomerParameter>();
    private Object[][] model = new Object[2][3];
    private String[] columnNames = new String[]{"ID", "Sync Server Type", "IP Address", "Domain"};
    private String[] rowNames = null;
    private CustomerParameter ipsecEnable = null;

    protected void init() {
        this.myView = (IpSyncConfigurationViewer)((Object)this.getView());
        this.wizardHelp = WizardHelp.getTheInstance();
        this.wizardCiModel = OamCIModel.getInstance();
        this.rbs = this.wizardCiModel.getRbs();
        this.setWindowTitle();
    }

    /*
     * WARNING - void declaration
     */
    protected void afterVisible() {
        try {
            void var2_10;
            CustomerParameter customerParameter;
            Object object;
            int n;
            int n2;
            Object[] objectArray;
            this.cpsToValidateOnNext.clear();
            this.ipsecEnable = this.rbs.getCustomerParameterObject("IpSec_configType");
            if (this.ipsecEnable.getValue().equals("NON_IPSEC")) {
                Object[] objectArray2 = objectArray = new String[]{"IPoverGigabitEthernet_syncIpAddress", "IPoverGigabitEthernet_syncSubnetMask", "IPoverGigabitEthernet_defaultRouter0", "IPoverGigabitEthernet_syncVid"};
                n2 = objectArray2.length;
                for (n = 0; n < n2; ++n) {
                    object = objectArray2[n];
                    customerParameter = this.rbs.getCustomerParameterObject((String)object);
                    this.cpsToValidateOnNext.add(customerParameter);
                }
            } else if (this.ipsecEnable.getValue().equals("IPSEC_SINGLE_LINK")) {
                Object[] wizardException = objectArray = new String[]{"Iub_ipAddressHostEt", "OamIpHost_oamSubnetMask", "OamIpHost_oamDefaultRouter0", "OamIpHost_oamVid", "OamIpHost_outerOamIpAddressHostEt"};
                n2 = wizardException.length;
                for (n = 0; n < n2; ++n) {
                    object = wizardException[n];
                    customerParameter = this.rbs.getCustomerParameterObject((String)object);
                    this.cpsToValidateOnNext.add(customerParameter);
                }
            } else if (this.ipsecEnable.getValue().equals("IPSEC_DUAL_LINK")) {
                Object[] objectArray2 = objectArray = new String[]{"Iub_ipAddressHostEt", "IPoverGigabitEthernet_syncSubnetMask", "IPoverGigabitEthernet_defaultRouter0", "IPoverGigabitEthernet_syncVid", "IPoverGigabitEthernet_syncIpAddress"};
                n2 = objectArray2.length;
                for (n = 0; n < n2; ++n) {
                    object = objectArray2[n];
                    customerParameter = this.rbs.getCustomerParameterObject((String)object);
                    this.cpsToValidateOnNext.add(customerParameter);
                }
            }
            objectArray = new CustomerParameter[this.cpsToValidateOnNext.size()];
            objectArray = (CustomerParameter[])this.cpsToValidateOnNext.toArray(objectArray);
            if (this.ipsecEnable.getValue().equals("NON_IPSEC")) {
                this.myView.setCustomerParameters((CustomerParameter[])objectArray, false);
            } else {
                this.myView.setCustomerParameters((CustomerParameter[])objectArray, true);
            }
            Object var2_7 = null;
            if (DuwUtil.hasDuw()) {
                this.rowNames = new String[]{String.valueOf(7), String.valueOf(8)};
                int[] nArray = DUW_IPSYNCHREF_SYNCH_PORT;
            } else {
                this.rowNames = new String[]{"1", "2"};
                int[] nArray = CBU_IPSYNCHREF_SYNCH_PORT;
            }
            for (n2 = 0; n2 < ((void)var2_10).length; ++n2) {
                CustomerParameter customerParameter2;
                if (DuwUtil.hasDuw()) {
                    customerParameter2 = this.getCustomerParameter("IPoverGigabitEthernet_{0}_syncServerType", (int)var2_10[n2]);
                    customerParameter2.addCustomerParameterListener(this);
                    boolean bl = "NTP".equals(customerParameter2.getValue());
                    this.model[n2][0] = customerParameter2;
                    if (bl) {
                        customerParameter = this.getCustomerParameter("IPoverGigabitEthernet_{0}_ntpServerIpAddress", (int)var2_10[n2]);
                        this.model[n2][1] = customerParameter;
                        this.cpsToValidateOnNext.add(customerParameter);
                        continue;
                    }
                    customerParameter = (CustomerParameterImpl)this.getCustomerParameter("IPoverGigabitEthernet_{0}_serverAddress", (int)var2_10[n2]);
                    this.model[n2][1] = customerParameter;
                    if (!((CustomerParameterImpl)customerParameter).isCustomerParameterListenerAdded(this)) {
                        ((CustomerParameterImpl)customerParameter).addCustomerParameterListener(this);
                    }
                    this.cpsToValidateOnNext.add(customerParameter);
                    CustomerParameter customerParameter3 = this.getCustomerParameter("IPoverGigabitEthernet_{0}_ptpDomain", (int)var2_10[n2]);
                    this.model[n2][2] = customerParameter3;
                    this.cpsToValidateOnNext.add(customerParameter3);
                    continue;
                }
                customerParameter2 = this.getCustomerParameter("IPoverGigabitEthernet_{0}_ntpServerIpAddress", (int)var2_10[n2]);
                this.model[n2][1] = customerParameter2;
                this.cpsToValidateOnNext.add(customerParameter2);
            }
            this.myView.setIpSyncRefTableParameters(this.model, this.rowNames, this.columnNames);
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException(this.getClass().getName(), "afterVisible()", null, "Setting up window for input", exception);
            wizardException.setProperty("Problem, Low Level", "An error has occurred while reading from the model");
            super.displayError(wizardException);
        }
    }

    private CustomerParameter getCustomerParameter(String string, int n) throws BemException {
        String string2 = MessageFormat.format(string, new Integer(n));
        return this.rbs.getCustomerParameterObject(string2);
    }

    private void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = NCONF_OAM_PAGE_HEADER;
        String string3 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string4 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.myView.setHeaderText(MessageFormat.format(string2, string3, string4));
    }

    protected boolean previous() {
        return true;
    }

    protected boolean next() {
        try {
            for (CustomerParameter customerParameter : this.cpsToValidateOnNext) {
                if (customerParameter.isValidValue()) continue;
                this.displayNextError(this.myView, new CustomerParameterException(customerParameter));
                return false;
            }
            if (DuwUtil.hasDuw() && !this.isPtpConfigValid()) {
                return false;
            }
        }
        catch (Exception exception) {
            this.displayNextError(this.myView, exception);
            return false;
        }
        return true;
    }

    private boolean isPtpConfigValid() throws BemException {
        CustomerParameterImpl customerParameterImpl = (CustomerParameterImpl)this.getCustomerParameter("IPoverGigabitEthernet_{0}_serverAddress", 7);
        CustomerParameterImpl customerParameterImpl2 = (CustomerParameterImpl)this.getCustomerParameter("IPoverGigabitEthernet_{0}_serverAddress", 8);
        PtpDomainParameter ptpDomainParameter = (PtpDomainParameter)this.getCustomerParameter("IPoverGigabitEthernet_{0}_ptpDomain", 7);
        PtpDomainParameter ptpDomainParameter2 = (PtpDomainParameter)this.getCustomerParameter("IPoverGigabitEthernet_{0}_ptpDomain", 8);
        if (this.isParamConfigured(ptpDomainParameter.getValue()) && ptpDomainParameter.getValue().equals(ptpDomainParameter2.getValue())) {
            this.displayNextError(this.myView, new BemException("The Value Of Domain Must Be Different!"));
            return false;
        }
        if (this.isParamConfigured(customerParameterImpl.getValue()) && !customerParameterImpl.isValidValue()) {
            this.displayNextError(this.myView, new CustomerParameterException(customerParameterImpl));
            return false;
        }
        if (this.isParamConfigured(customerParameterImpl2.getValue()) && !customerParameterImpl2.isValidValue()) {
            this.displayNextError(this.myView, new CustomerParameterException(customerParameterImpl2));
            return false;
        }
        if (this.isParamConfigured(ptpDomainParameter.getValue()) && !ptpDomainParameter.isValidValue()) {
            this.displayNextError(this.myView, new CustomerParameterException(ptpDomainParameter));
            return false;
        }
        if (this.isParamConfigured(ptpDomainParameter2.getValue()) && !ptpDomainParameter2.isValidValue()) {
            this.displayNextError(this.myView, new CustomerParameterException(ptpDomainParameter2));
            return false;
        }
        return !this.hasConfiguredPtpDomainAndAddress(customerParameterImpl, ptpDomainParameter) && !this.hasConfiguredPtpDomainAndAddress(customerParameterImpl2, ptpDomainParameter2);
    }

    private boolean hasConfiguredPtpDomainAndAddress(CustomerParameterImpl customerParameterImpl, PtpDomainParameter ptpDomainParameter) {
        if (this.isParamConfigured(customerParameterImpl.getValue()) && !this.isParamConfigured(ptpDomainParameter.getValue()) || this.isParamConfigured(ptpDomainParameter.getValue()) && !this.isParamConfigured(customerParameterImpl.getValue())) {
            this.displayNextError(this.myView, new BemException("Address And Domain Must Be Both Configured"));
            return true;
        }
        return false;
    }

    public void parameterPropertiesChanged(CustomerParameter customerParameter, ParameterEvent parameterEvent) {
        if (!DuwUtil.hasDuw()) {
            return;
        }
        String string = MessageFormat.format("IPoverGigabitEthernet_{0}_syncServerType", 7);
        String string2 = MessageFormat.format("IPoverGigabitEthernet_{0}_syncServerType", 8);
        String string3 = customerParameter.getName();
        String string4 = customerParameter.getValue();
        try {
            CustomerParameterImpl customerParameterImpl = (CustomerParameterImpl)this.getCustomerParameter("IPoverGigabitEthernet_{0}_ntpServerIpAddress", 7);
            CustomerParameterImpl customerParameterImpl2 = (CustomerParameterImpl)this.getCustomerParameter("IPoverGigabitEthernet_{0}_ntpServerIpAddress", 8);
            CustomerParameterImpl customerParameterImpl3 = (CustomerParameterImpl)this.getCustomerParameter("IPoverGigabitEthernet_{0}_serverAddress", 7);
            CustomerParameterImpl customerParameterImpl4 = (CustomerParameterImpl)this.getCustomerParameter("IPoverGigabitEthernet_{0}_serverAddress", 8);
            CustomerParameterImpl customerParameterImpl5 = (CustomerParameterImpl)this.getCustomerParameter("IPoverGigabitEthernet_{0}_ptpDomain", 7);
            CustomerParameterImpl customerParameterImpl6 = (CustomerParameterImpl)this.getCustomerParameter("IPoverGigabitEthernet_{0}_ptpDomain", 8);
            if (string.equals(string3)) {
                if ("NTP".equals(string4)) {
                    this.model[0][1] = customerParameterImpl;
                    this.model[0][2] = null;
                    customerParameterImpl3.setValue(customerParameterImpl3.getLoadedValue());
                    customerParameterImpl5.setValue(customerParameterImpl5.getLoadedValue());
                    this.myView.udpateIpSyncRefTable(this.model, this.rowNames, this.columnNames);
                } else {
                    this.model[0][1] = customerParameterImpl3;
                    this.model[0][2] = customerParameterImpl5;
                    customerParameterImpl.setValue(customerParameterImpl.getLoadedValue());
                    if (!customerParameterImpl3.isCustomerParameterListenerAdded(this)) {
                        customerParameterImpl3.addCustomerParameterListener(this);
                    }
                    this.myView.udpateIpSyncRefTable(this.model, this.rowNames, this.columnNames);
                }
            } else if (string3.equals(string2)) {
                if ("NTP".equals(string4)) {
                    this.model[1][1] = customerParameterImpl2;
                    this.model[1][2] = null;
                    customerParameterImpl4.setValue(customerParameterImpl4.getLoadedValue());
                    customerParameterImpl6.setValue(customerParameterImpl6.getLoadedValue());
                    this.myView.udpateIpSyncRefTable(this.model, this.rowNames, this.columnNames);
                } else {
                    this.model[1][1] = customerParameterImpl4;
                    this.model[1][2] = customerParameterImpl6;
                    customerParameterImpl2.setValue(customerParameterImpl2.getLoadedValue());
                    if (!customerParameterImpl4.isCustomerParameterListenerAdded(this)) {
                        customerParameterImpl4.addCustomerParameterListener(this);
                    }
                    this.myView.udpateIpSyncRefTable(this.model, this.rowNames, this.columnNames);
                }
            }
        }
        catch (BemException bemException) {
            super.displayError(bemException);
        }
    }

    private boolean isParamConfigured(String string) {
        return string != null && !string.equals("") && !string.equals("##UNDEFINED");
    }
}

