/*
 * Decompiled with CFR 0.152.
 */
package se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.control;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTextField;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.CustomerParameterException;
import se.ericsson.wcdma.rbs.bem.common.config.custparam.YesNoCustomerParameter;
import se.ericsson.wcdma.rbs.bem.common.config.rbs.Rbs;
import se.ericsson.wcdma.rbs.bem.common.exception.BemException;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterCheckbox;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterComponent;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterPanel;
import se.ericsson.wcdma.rbs.bem.common.gui.CustomerParameterTextField;
import se.ericsson.wcdma.rbs.bem.wizard.control.BemWizardGuiController;
import se.ericsson.wcdma.rbs.bem.wizard.exception.WizardException;
import se.ericsson.wcdma.rbs.bem.wizard.model.WizardCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.model.OamCIModel;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.util.WizardHelp;
import se.ericsson.wcdma.rbs.bem.wizard.wizards.oam.view.ServerViewer;

public class ServerController
extends BemWizardGuiController {
    private static String NCONF_OAM_PAGE_HEADER = "O&M Access Configuration page {0}({1})";
    private ServerViewer myView = null;
    private WizardCIModel oamCIModel;
    private Rbs rbs;
    private Hashtable allCPs = null;
    private String[] allCPNames;
    private CustomerParameterPanel[] guiComponents = null;

    protected void init() {
        this.myView = (ServerViewer)((Object)this.getView());
        this.wizardHelp = WizardHelp.getTheInstance();
        this.oamCIModel = OamCIModel.getInstance();
        this.rbs = this.oamCIModel.getRbs();
        this.setWindowTitle();
    }

    protected void afterVisible() {
        try {
            if (super.getPreviousControllerClass() == null) {
                super.setPreviousEnabled(false);
            }
            this.allCPNames = new String[]{"dhcpServerPrimaryIpAddress", "dhcpServerSecondaryIpAddress", "dnsServerIpAddress", "isDefaultDomainName", "defaultDomainName", "singleLogonServer", "documentServerWebAddress", "ossCorbaNameServer", "ossCorbaNameServerPort"};
            this.getAllCPs(this.allCPNames);
            this.guiComponents = this.createGuiComponents();
            this.myView.setBemComponents(this.guiComponents);
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException("ServerController", "afterVisible()", null, "Setting up window for input", exception);
            this.displayError(wizardException);
            return;
        }
    }

    private void getAllCPs(String[] stringArray) throws BemException {
        this.allCPs = new Hashtable();
        for (String string : stringArray) {
            CustomerParameter customerParameter = this.rbs.getCustomerParameterObject(string);
            this.allCPs.put(string, customerParameter);
        }
    }

    private void setWindowTitle() {
        String string = this.getClass().getName();
        String string2 = NCONF_OAM_PAGE_HEADER;
        String string3 = String.valueOf(this.wizardHelp.getPageNumber(string));
        String string4 = String.valueOf(this.wizardHelp.getTotalPageNumbers());
        this.myView.setHeaderText(MessageFormat.format(string2, string3, string4));
    }

    private CustomerParameterPanel[] createGuiComponents() {
        CustomerParameterPanel customerParameterPanel;
        CustomerParameterPanel[] customerParameterPanelArray = new CustomerParameterPanel[9];
        CustomerParameter customerParameter = (CustomerParameter)this.allCPs.get("dhcpServerPrimaryIpAddress");
        JComponent jComponent = new CustomerParameterTextField(customerParameter);
        ((JTextField)jComponent).setColumns(16);
        customerParameterPanelArray[0] = customerParameterPanel = new CustomerParameterPanel("Primary DHCP server:", (CustomerParameterComponent)((Object)jComponent), false);
        customerParameter = (CustomerParameter)this.allCPs.get("dhcpServerSecondaryIpAddress");
        jComponent = new CustomerParameterTextField(customerParameter);
        ((JTextField)jComponent).setColumns(16);
        customerParameterPanelArray[1] = customerParameterPanel = new CustomerParameterPanel("Secondary DHCP server:", (CustomerParameterComponent)((Object)jComponent), false);
        customerParameter = (CustomerParameter)this.allCPs.get("dnsServerIpAddress");
        jComponent = new CustomerParameterTextField(customerParameter);
        ((JTextField)jComponent).setColumns(16);
        customerParameterPanelArray[2] = customerParameterPanel = new CustomerParameterPanel("DNS server:", (CustomerParameterComponent)((Object)jComponent), false);
        customerParameter = (CustomerParameter)this.allCPs.get("isDefaultDomainName");
        jComponent = new CustomerParameterCheckbox("", (YesNoCustomerParameter)customerParameter);
        customerParameterPanelArray[3] = customerParameterPanel = new CustomerParameterPanel("Use default domain name:", (CustomerParameterComponent)((Object)jComponent), false);
        customerParameter = (CustomerParameter)this.allCPs.get("defaultDomainName");
        jComponent = new CustomerParameterTextField(customerParameter);
        ((JTextField)jComponent).setColumns(40);
        customerParameterPanelArray[4] = customerParameterPanel = new CustomerParameterPanel("Default domain name:", (CustomerParameterComponent)((Object)jComponent), false);
        customerParameter = (CustomerParameter)this.allCPs.get("singleLogonServer");
        jComponent = new CustomerParameterTextField(customerParameter);
        ((JTextField)jComponent).setColumns(40);
        customerParameterPanelArray[5] = customerParameterPanel = new CustomerParameterPanel("Logon server (SLS):", (CustomerParameterComponent)((Object)jComponent), false);
        customerParameter = (CustomerParameter)this.allCPs.get("documentServerWebAddress");
        jComponent = new CustomerParameterTextField(customerParameter);
        ((JTextField)jComponent).setColumns(40);
        customerParameterPanelArray[6] = customerParameterPanel = new CustomerParameterPanel("Document server (ALEX):", (CustomerParameterComponent)((Object)jComponent), false);
        customerParameter = (CustomerParameter)this.allCPs.get("ossCorbaNameServer");
        jComponent = new CustomerParameterTextField(customerParameter);
        ((JTextField)jComponent).setColumns(40);
        customerParameterPanelArray[7] = customerParameterPanel = new CustomerParameterPanel("OSS CORBA name server address:", (CustomerParameterComponent)((Object)jComponent), false);
        customerParameter = (CustomerParameter)this.allCPs.get("ossCorbaNameServerPort");
        jComponent = new CustomerParameterTextField(customerParameter);
        ((JTextField)jComponent).setColumns(5);
        customerParameterPanelArray[8] = customerParameterPanel = new CustomerParameterPanel("OSS CORBA name server port:", (CustomerParameterComponent)((Object)jComponent), false);
        return customerParameterPanelArray;
    }

    private List createAllCpNamesList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (String string : this.allCPNames) {
            arrayList.add(string);
        }
        return arrayList;
    }

    protected boolean next() {
        boolean bl = true;
        try {
            List list = this.createAllCpNamesList();
            this.rbs.checkConsistency("ServerConfigCI", list);
        }
        catch (CustomerParameterException customerParameterException) {
            CustomerParameter customerParameter = customerParameterException.getParameter();
            String string = customerParameter.getName();
            this.displayError(customerParameterException);
            this.setFocusOnComponent(string);
            bl = false;
        }
        catch (Exception exception) {
            WizardException wizardException = new WizardException(this.currentClassName, "next()", null, "verifying user input for scrolling", exception);
            this.displayError(wizardException);
            bl = false;
        }
        return bl;
    }

    protected boolean previous() {
        return true;
    }

    private void setFocusOnComponent(String string) {
        for (CustomerParameterPanel customerParameterPanel : this.guiComponents) {
            if (!customerParameterPanel.containCustomerParameter(string)) continue;
            customerParameterPanel.requestFocus();
        }
    }
}

